/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.server.scmgr;

import com.sun.scm.admin.server.event.EventDispatcher;
import com.sun.scm.admin.server.eventq.SCMEventQueue;
import com.sun.scm.admin.server.eventq.SCMEventQueueI;
import com.sun.scm.admin.server.scmgr.ClusterManagerI;
import com.sun.scm.admin.server.syslog.SCMSyslogAdmin;
import com.sun.scm.admin.server.util.SCMRegistry;
import com.sun.scm.admin.server.util.SCMResource;
import com.sun.scm.admin.server.util.SCMResourceI;
import com.sun.scm.admin.util.OBJECT_TYPE;
import com.sun.scm.admin.util.REGISTRY_NAME;
import com.sun.scm.admin.util.SCMEvent;
import java.io.Serializable;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;

public class ClusterManager
extends SCMRegistry
implements ClusterManagerI,
Serializable {
    private SCMResource cluster;
    private EventDispatcher scm_ed;
    private SCMSyslogAdmin scm_syslog;
    private SCMEventQueue scm_eventq;

    public native boolean getClusterResource(int var1);

    public synchronized void initializeCluster() {
        try {
            if (!this.getClusterResource(OBJECT_TYPE.CLUSTER.getId())) {
                System.out.println("SCM:: ClusterManager.initializeCluster - Can't get cluster configuration information; processing terminated.");
                System.exit(-1);
            }
            this.cluster.initialize();
            this.registerServer(this.cluster);
            this.cluster.initAllChildResources();
            this.cluster.initializeMA();
            return;
        }
        catch (Exception exception) {
            System.out.println("SCM:: ClusterManager.initializeCluster - got exception: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void createResource(int n, String string) throws RemoteException {
        OBJECT_TYPE oBJECT_TYPE = OBJECT_TYPE.get(n);
        if (oBJECT_TYPE == null) {
            System.out.println("SCM:: ClusterManager.createResource - Resource name " + string + " of type " + n + " is invalid.");
            return;
        }
        this.cluster = new SCMResource(oBJECT_TYPE, string, this);
    }

    public synchronized void initialize() {
        try {
            this.scm_registry = LocateRegistry.createRegistry(this.registry_port);
            this.scm_registry.bind(REGISTRY_NAME.CM_NAME, this);
            this.scm_eventq = new SCMEventQueue(this);
            this.scm_ed = new EventDispatcher(this);
            Thread thread = new Thread(this.scm_ed);
            thread.start();
            this.scm_syslog = new SCMSyslogAdmin(this);
            Thread thread2 = new Thread(this.scm_syslog);
            thread2.start();
            return;
        }
        catch (Exception exception) {
            System.out.println("SCM:: ClusterManager.initialize - got exception: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void deleteCluster() throws RemoteException {
        this.cluster = null;
    }

    public synchronized SCMResourceI getCluster() throws RemoteException {
        return this.cluster;
    }

    public synchronized void deleteEventQueue() throws RemoteException {
        this.scm_eventq = null;
    }

    public SCMEventQueueI getEventQueue() throws RemoteException {
        return this.scm_eventq;
    }

    public synchronized void dispatchEvent(SCMEvent sCMEvent) throws RemoteException {
        this.scm_eventq.addEvent(sCMEvent);
        super.dispatchEvent(sCMEvent);
    }

    public synchronized void refresh() throws RemoteException {
        super.refresh();
        this.initializeCluster();
        this.updateServerRegistry();
        System.gc();
    }

    public static void main(String[] stringArray) {
        System.setSecurityManager(new RMISecurityManager());
        try {
            ClusterManager clusterManager = new ClusterManager();
            if (stringArray.length == 2 && stringArray[0].compareTo("-registryPort") == 0) {
                clusterManager.setRegistryPort(Integer.parseInt(stringArray[1]));
            }
            clusterManager.initializeCluster();
            clusterManager.initialize();
            return;
        }
        catch (Exception exception) {
            System.out.println("SCM:: ClusterManager.main - got exception: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    static {
        try {
            System.loadLibrary("scmgr");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("SCM:: ClusterManager - can't load libscmgr");
            System.exit(-1);
        }
    }
}

