/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.server.syslog;

import com.sun.scm.admin.server.syslog.SCMSyslogAdminI;
import com.sun.scm.admin.server.syslog.SCMSyslogBuffer;
import com.sun.scm.admin.server.syslog.SCMSyslogBufferI;
import com.sun.scm.admin.server.syslog.SCMSyslogLoader;
import com.sun.scm.admin.server.syslog.SCMSyslogLoaderI;
import com.sun.scm.admin.server.util.SCMRegistry;
import com.sun.scm.admin.util.REGISTRY_NAME;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class SCMSyslogAdmin
extends UnicastRemoteObject
implements SCMSyslogAdminI,
Serializable,
Runnable {
    protected SCMSyslogLoaderI sysloader;
    protected SCMSyslogBufferI current_buffer_;
    protected boolean reached_end = false;
    protected String localhost_;
    private boolean debug = false;
    private Registry hRegistry;
    private SCMRegistry myregistry;
    private boolean isProxy = false;

    public SCMSyslogAdmin(SCMRegistry sCMRegistry) throws RemoteException {
        this.myregistry = sCMRegistry;
        this.hRegistry = this.myregistry.getRegistry();
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.localhost_ = inetAddress.getHostName();
            if (this.debug) {
                System.out.println("SCMSyslogAdmin.SCMSyslogAdmin - localhost:" + this.localhost_);
                System.out.println("SCMSyslogAdmin.SCMSyslogAdmin - address is:" + inetAddress.getHostAddress());
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("SCMSyslogAdmin.SCMSyslogAdmin - couldn't get local host name " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void run() {
        try {
            this.hRegistry.bind(REGISTRY_NAME.SYSLOG_NAME, this);
            return;
        }
        catch (AlreadyBoundException alreadyBoundException) {
            System.out.println("SCMSyslogAdmin.startSyslogServer - " + alreadyBoundException.getMessage());
            alreadyBoundException.printStackTrace();
            return;
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("SCMSyslogAdmin.startSyslogServer - " + unknownHostException.getMessage());
            unknownHostException.printStackTrace();
            return;
        }
        catch (RemoteException remoteException) {
            System.out.println("SCMSylogAdmin.startSyslogServer - " + remoteException.getMessage());
            remoteException.printStackTrace();
            return;
        }
    }

    public void createSCMSyslogLoader(String string) throws RemoteException {
        this.sysloader = null;
        if (string.equals(this.localhost_)) {
            this.isProxy = false;
            if (this.debug) {
                System.out.println(" Try connection as localhost == host");
            }
            this.sysloader = new SCMSyslogLoader(this);
        } else {
            this.isProxy = true;
            String string2 = new String("rmi://" + string + ":" + this.myregistry.getRegistryPort() + "/" + REGISTRY_NAME.SYSLOG_NAME);
            if (this.debug) {
                System.out.println("SCMSyslogAdmin.createSCMSyslogLoader - url: " + string2 + "\n host: " + string);
            }
            try {
                Remote remote = Naming.lookup(string2);
                SCMSyslogAdminI sCMSyslogAdminI = (SCMSyslogAdminI)remote;
                sCMSyslogAdminI.createSCMSyslogLoader(string);
                this.sysloader = sCMSyslogAdminI.getSCMSyslogLoader();
            }
            catch (RemoteException remoteException) {
                System.out.println("SCMSyslogAdmin.createSCMSyslogLoader - " + remoteException.getMessage());
                remoteException.printStackTrace();
            }
            catch (NotBoundException notBoundException) {
                System.out.println("SCMSyslogAdmin.createSCMSyslogLoader - " + notBoundException.getMessage());
                notBoundException.printStackTrace();
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("SCMSyslogAdmin.createSCMSyslogLoader - " + malformedURLException.getMessage());
                malformedURLException.printStackTrace();
            }
        }
        this.current_buffer_ = this.duplicateBuffer(this.sysloader.getSCMSyslogBuffer());
    }

    public synchronized SCMSyslogBufferI getCurrentBuffer() throws RemoteException {
        if (this.current_buffer_ == null) {
            this.current_buffer_ = this.previousBuffer();
        }
        return this.current_buffer_;
    }

    public synchronized SCMSyslogLoaderI getSCMSyslogLoader() throws RemoteException {
        return this.sysloader;
    }

    public synchronized SCMSyslogBufferI lastBuffer() throws RemoteException {
        try {
            this.current_buffer_ = this.sysloader.updateBuffer();
        }
        catch (RemoteException remoteException) {
            System.out.println("SCMSyslogAdmin.lastBuffer - " + remoteException.getMessage());
            remoteException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("SCMSyslogAdmin.lastBuffer - " + fileNotFoundException.getMessage());
            fileNotFoundException.printStackTrace();
        }
        return this.duplicateBuffer(this.current_buffer_);
    }

    public synchronized SCMSyslogBufferI previousBuffer() throws RemoteException {
        this.reached_end = false;
        this.current_buffer_ = this.sysloader.readPrevious();
        return this.duplicateBuffer(this.current_buffer_);
    }

    public synchronized SCMSyslogBufferI nextBuffer() throws RemoteException {
        this.current_buffer_ = this.sysloader.readNext();
        return this.duplicateBuffer(this.current_buffer_);
    }

    public boolean moreData(String string) throws RemoteException {
        return this.sysloader.moreData(string);
    }

    SCMSyslogBufferI duplicateBuffer(SCMSyslogBufferI sCMSyslogBufferI) throws RemoteException {
        if (!this.isProxy) {
            return sCMSyslogBufferI;
        }
        SCMSyslogBuffer sCMSyslogBuffer = new SCMSyslogBuffer(sCMSyslogBufferI);
        return sCMSyslogBuffer;
    }
}

