/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.server.util;

import com.sun.scm.admin.server.util.SCMRegistryI;
import com.sun.scm.admin.server.util.SCMResourceI;
import com.sun.scm.admin.util.EVENT_TYPE;
import com.sun.scm.admin.util.EventObserverI;
import com.sun.scm.admin.util.OBJECT_TYPE;
import com.sun.scm.admin.util.SCMEvent;
import com.sun.scm.admin.util.SCMServerI;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SCMRegistry
extends UnicastRemoteObject
implements SCMRegistryI,
SCMServerI {
    protected int registry_port = 1097;
    protected Registry scm_registry;
    protected Vector client_list = new Vector();
    protected Hashtable servers = new Hashtable(20);
    protected Hashtable factory = new Hashtable(20);

    public synchronized void notifyFactory(SCMEvent sCMEvent) {
        String string = sCMEvent.object_type.toString();
        if (!this.factory.containsKey(string)) {
            return;
        }
        SCMResourceI sCMResourceI = null;
        Vector vector = (Vector)this.factory.get(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            sCMResourceI = (SCMResourceI)enumeration.nextElement();
            try {
                if (!sCMResourceI.isNewChild(sCMEvent.object_name, sCMEvent.object_type)) continue;
                this.notifyClients(sCMEvent, sCMResourceI);
            }
            catch (Exception exception) {
                System.out.println("SCM:: SCMRegistry.notifyFactory - got exception: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public synchronized SCMResourceI notifyServer(SCMEvent sCMEvent) {
        SCMResourceI sCMResourceI = null;
        String string = sCMEvent.object_type.toString();
        try {
            sCMResourceI = this.lookupServer(sCMEvent.object_name, string);
            if (sCMResourceI != null) {
                ((EventObserverI)((Object)sCMResourceI)).receiveEvent(sCMEvent, null);
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("SCM:: SCMRegistry.notifyServer - Couldn't send event to object " + sCMEvent.object_name);
            remoteException.printStackTrace();
            return null;
        }
        return sCMResourceI;
    }

    public synchronized void registerClient(EventObserverI eventObserverI) throws RemoteException {
        if (!this.client_list.contains(eventObserverI)) {
            this.client_list.addElement(eventObserverI);
        }
    }

    public synchronized void unregisterClient(EventObserverI eventObserverI) throws RemoteException {
        this.client_list.removeElement(eventObserverI);
    }

    public synchronized void registerServer(EventObserverI eventObserverI) throws RemoteException {
        SCMResourceI sCMResourceI = (SCMResourceI)((Object)eventObserverI);
        String string = sCMResourceI.getType().toString();
        Vector<EventObserverI> vector = (Vector<EventObserverI>)this.servers.get(string);
        if (vector == null) {
            vector = new Vector<EventObserverI>();
            this.servers.put(string, vector);
        }
        if (!vector.contains(eventObserverI)) {
            vector.addElement(eventObserverI);
        }
    }

    public synchronized void unregisterServer(EventObserverI eventObserverI) throws RemoteException {
        SCMResourceI sCMResourceI = (SCMResourceI)((Object)eventObserverI);
        String string = sCMResourceI.getType().toString();
        Vector vector = (Vector)this.servers.get(string);
        if (vector.contains(eventObserverI)) {
            vector.removeElement(eventObserverI);
        }
    }

    public synchronized void updateServerRegistry() throws RemoteException {
        Enumeration enumeration = this.servers.keys();
        while (enumeration.hasMoreElements()) {
            Vector vector;
            String string = (String)enumeration.nextElement();
            Vector vector2 = (Vector)this.factory.get(string);
            if (vector2 == null || (vector = (Vector)this.servers.get(string)) == null) continue;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                SCMResourceI sCMResourceI = (SCMResourceI)enumeration2.nextElement();
                if (!this.isDeleted(vector2, sCMResourceI)) continue;
                vector.removeElement(sCMResourceI);
            }
        }
    }

    public synchronized void registerFactory(EventObserverI eventObserverI, String string) throws RemoteException {
        Vector<EventObserverI> vector = (Vector<EventObserverI>)this.factory.get(string);
        if (vector == null) {
            vector = new Vector<EventObserverI>();
            this.factory.put(string, vector);
        }
        if (!vector.contains(eventObserverI)) {
            vector.addElement(eventObserverI);
        }
    }

    public synchronized void unregisterFactory(EventObserverI eventObserverI) throws RemoteException {
        Enumeration enumeration = this.factory.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.factory.get(string);
            if (!vector.contains(eventObserverI)) continue;
            vector.removeElement(eventObserverI);
        }
    }

    public synchronized void setRegistryPort(int n) throws RemoteException {
        if (n > 0) {
            this.registry_port = n;
        }
    }

    public int getRegistryPort() throws RemoteException {
        return this.registry_port;
    }

    public synchronized void setRegistry(Registry registry) throws RemoteException {
        this.scm_registry = registry;
    }

    public Registry getRegistry() throws RemoteException {
        return this.scm_registry;
    }

    public synchronized Vector getClientList() throws RemoteException {
        return this.client_list;
    }

    public synchronized Hashtable getServers() throws RemoteException {
        return this.servers;
    }

    public synchronized Hashtable getFactory() throws RemoteException {
        return this.factory;
    }

    public synchronized void dispatchEvent(SCMEvent sCMEvent) throws RemoteException {
        EVENT_TYPE eVENT_TYPE = sCMEvent.event_type;
        SCMResourceI sCMResourceI = null;
        System.out.println("SCMRegistry.dispatchEvent - Received event");
        System.out.println("event type: " + eVENT_TYPE.toString());
        System.out.println("for object: " + sCMEvent.object_name);
        System.out.println("type is: " + sCMEvent.object_type.toString());
        if (sCMEvent.object_state == null) {
            System.out.println("state is null");
        } else {
            System.out.println("state is: " + sCMEvent.object_state.toString());
        }
        if (sCMEvent.state_string == null) {
            System.out.println("state string is null");
        } else {
            System.out.println("state string is: " + sCMEvent.state_string);
        }
        System.out.println("event description is: " + sCMEvent.description);
        if (eVENT_TYPE.equalTo(EVENT_TYPE.ADD)) {
            this.notifyFactory(sCMEvent);
            return;
        }
        sCMResourceI = this.notifyServer(sCMEvent);
        if (sCMResourceI != null) {
            this.notifyClients(sCMEvent, sCMResourceI);
        }
    }

    public synchronized void notifyClients(SCMEvent sCMEvent, SCMResourceI sCMResourceI) throws RemoteException {
        Object object;
        EventObserverI eventObserverI = null;
        try {
            object = null;
            object = sCMResourceI != null && sCMEvent.event_type.equalTo(EVENT_TYPE.ADD) ? sCMResourceI.getChild(sCMEvent.object_type.toString(), sCMEvent.object_name) : sCMResourceI;
            if (object != null) {
                sCMEvent.update(object.getUIName(), object.getStateString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("SCM:: SCMRegistry.notifyClients - Couldn't find event object " + sCMEvent.object_name);
            return;
        }
        object = this.client_list.elements();
        while (object.hasMoreElements()) {
            eventObserverI = (EventObserverI)object.nextElement();
            try {
                eventObserverI.receiveEvent(sCMEvent, sCMResourceI);
            }
            catch (Exception exception) {
                this.client_list.removeElement(eventObserverI);
            }
        }
    }

    public synchronized boolean isDeleted(Vector vector, SCMResourceI sCMResourceI) throws RemoteException {
        try {
            String string = sCMResourceI.getName();
            String string2 = sCMResourceI.getType().toString();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                SCMResourceI sCMResourceI2 = (SCMResourceI)enumeration.nextElement();
                if (sCMResourceI2.getChild(string2, string) == null) continue;
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println("SCM:: SCMRegistry.isDeleted - Error occurred while searching through child resource list.");
            exception.printStackTrace();
        }
        return true;
    }

    public synchronized SCMResourceI lookupServer(String string, String string2) throws RemoteException {
        SCMResourceI sCMResourceI = null;
        Vector vector = (Vector)this.servers.get(string2);
        if (vector == null) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            sCMResourceI = (SCMResourceI)enumeration.nextElement();
            try {
                String string3 = sCMResourceI.getName();
                if (string3.compareTo(string) != 0) continue;
                return sCMResourceI;
            }
            catch (RemoteException remoteException) {
                System.out.println("SCM:: SCMRegistry.lookupServer - Couldn't find server object " + string);
                remoteException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public synchronized Vector getResources(OBJECT_TYPE oBJECT_TYPE) throws RemoteException {
        return (Vector)this.servers.get(oBJECT_TYPE.toString());
    }

    public synchronized Vector getResources(String string) throws RemoteException {
        return (Vector)this.servers.get(string);
    }

    public synchronized void refresh() throws RemoteException {
        Enumeration enumeration = this.servers.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.servers.get(string);
            if (vector == null) continue;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                SCMResourceI sCMResourceI = (SCMResourceI)enumeration2.nextElement();
                sCMResourceI.cleanUp();
            }
        }
        this.factory.clear();
    }

    public void isAlive() throws RemoteException {
    }
}

