/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.server.util;

import com.sun.scm.admin.server.scmgr.ClusterManagerI;
import com.sun.scm.admin.server.util.SCMRegistryI;
import com.sun.scm.admin.server.util.SCMResourceI;
import com.sun.scm.admin.util.EVENT_TYPE;
import com.sun.scm.admin.util.EventObserverI;
import com.sun.scm.admin.util.OBJECT_STATE;
import com.sun.scm.admin.util.OBJECT_TYPE;
import com.sun.scm.admin.util.SCMEvent;
import com.sun.scm.admin.util.SCMProperties;
import com.sun.scm.admin.util.SCMPropertyKey;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SCMResource
extends UnicastRemoteObject
implements SCMResourceI,
EventObserverI,
Serializable {
    protected OBJECT_TYPE type;
    protected String name;
    protected String externalName;
    protected OBJECT_STATE state = OBJECT_STATE.ONLINE;
    protected String stateString = OBJECT_STATE.ONLINE.toString();
    protected String onlineString;
    protected ClusterManagerI cm;
    protected int compDownCount;
    protected SCMResourceI currentPrimary;
    protected Vector propKeyList = new Vector();
    protected Hashtable parent_tbl = new Hashtable(20);
    protected Hashtable child_tbl = new Hashtable(20);
    protected Hashtable primary_tbl = new Hashtable(10);
    protected Hashtable poss_mastered_tbl = new Hashtable(10);
    protected Hashtable affiliate_tbl = new Hashtable(10);
    protected Hashtable properties = new Hashtable(20);

    public native boolean getResourceState(int var1, String var2);

    public native boolean getResourceProperty(int var1, String var2);

    public native boolean getChildTypes(int var1, String var2);

    public native boolean getChildResources(int var1, String var2);

    public native boolean getPrimaries(int var1, String var2);

    public native boolean getPossiblyMastered(int var1, String var2);

    public native boolean getAffiliates(int var1, String var2);

    public native boolean isChildResource(int var1, String var2, int var3, String var4);

    public SCMResource(OBJECT_TYPE oBJECT_TYPE, String string) throws RemoteException {
        this(oBJECT_TYPE, string, string, OBJECT_STATE.ONLINE, null);
    }

    public SCMResource(OBJECT_TYPE oBJECT_TYPE, String string, String string2) throws RemoteException {
        this(oBJECT_TYPE, string, string2, OBJECT_STATE.ONLINE, null);
    }

    public SCMResource(OBJECT_TYPE oBJECT_TYPE, String string, OBJECT_STATE oBJECT_STATE) throws RemoteException {
        this(oBJECT_TYPE, string, string, oBJECT_STATE, null);
    }

    public SCMResource(OBJECT_TYPE oBJECT_TYPE, String string, String string2, OBJECT_STATE oBJECT_STATE) throws RemoteException {
        this(oBJECT_TYPE, string, string2, oBJECT_STATE, null);
    }

    public SCMResource(OBJECT_TYPE oBJECT_TYPE, String string, ClusterManagerI clusterManagerI) throws RemoteException {
        this(oBJECT_TYPE, string, string, OBJECT_STATE.ONLINE, clusterManagerI);
    }

    public SCMResource(OBJECT_TYPE oBJECT_TYPE, String string, String string2, ClusterManagerI clusterManagerI) throws RemoteException {
        this(oBJECT_TYPE, string, string2, OBJECT_STATE.ONLINE, clusterManagerI);
    }

    public SCMResource(OBJECT_TYPE oBJECT_TYPE, String string, String string2, OBJECT_STATE oBJECT_STATE, ClusterManagerI clusterManagerI) throws RemoteException {
        this.type = oBJECT_TYPE;
        this.name = string;
        this.externalName = string2;
        this.state = oBJECT_STATE;
        this.cm = clusterManagerI;
    }

    public synchronized void addToFactoryTable(int n, int[] nArray) throws RemoteException {
        if (n <= 0) {
            return;
        }
        OBJECT_TYPE oBJECT_TYPE = null;
        try {
            SCMRegistryI sCMRegistryI = this.getRegistry();
            int n2 = 0;
            while (n2 < n) {
                oBJECT_TYPE = OBJECT_TYPE.get(nArray[n2]);
                sCMRegistryI.registerFactory(this, oBJECT_TYPE.toString());
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("SCM:: SCMResource.addToFactoryTable - got exception: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void createChildResource(int n, String string) throws RemoteException {
        OBJECT_TYPE oBJECT_TYPE = OBJECT_TYPE.get(n);
        if (oBJECT_TYPE == null) {
            System.out.println("SCM:: SCMResource.createChildResource - Resource name " + string + " of type " + n + " is invalid.");
            return;
        }
        this.createChildResource(oBJECT_TYPE, string, string);
    }

    public synchronized void createChildResource(int n, String string, String string2) throws RemoteException {
        OBJECT_TYPE oBJECT_TYPE = OBJECT_TYPE.get(n);
        if (oBJECT_TYPE == null) {
            System.out.println("SCM:: SCMResource.createChildResource - Resource name " + string + " of type " + n + " is invalid.");
            return;
        }
        this.createChildResource(oBJECT_TYPE, string, string2);
    }

    public synchronized void createChildResource(OBJECT_TYPE oBJECT_TYPE, String string) throws RemoteException {
        this.createChildResource(oBJECT_TYPE, string, string);
    }

    public synchronized void createChildResource(OBJECT_TYPE oBJECT_TYPE, String string, String string2) throws RemoteException {
        SCMResource sCMResource = null;
        if (this.cm != null) {
            sCMResource = (SCMResource)((SCMRegistryI)((Object)this.cm)).lookupServer(string, oBJECT_TYPE.toString());
        }
        if (sCMResource == null) {
            sCMResource = new SCMResource(oBJECT_TYPE, string, string2, this.cm);
        } else {
            sCMResource.cleanUp();
        }
        this.addChild(sCMResource);
        sCMResource.addParent(this);
        this.initChildResource(sCMResource);
        sCMResource.initAllChildResources();
    }

    public synchronized void addChild(SCMResourceI sCMResourceI) throws RemoteException {
        String string = sCMResourceI.getType().toString();
        Vector<SCMResourceI> vector = (Vector<SCMResourceI>)this.child_tbl.get(string);
        if (vector == null) {
            vector = new Vector<SCMResourceI>();
            this.child_tbl.put(string, vector);
        }
        if (!vector.contains(sCMResourceI)) {
            vector.addElement(sCMResourceI);
        }
    }

    public synchronized void addParent(SCMResourceI sCMResourceI) throws RemoteException {
        String string = sCMResourceI.getType().toString();
        Vector<SCMResourceI> vector = (Vector<SCMResourceI>)this.parent_tbl.get(string);
        if (vector == null) {
            vector = new Vector<SCMResourceI>();
            this.parent_tbl.put(string, vector);
        }
        if (!vector.contains(sCMResourceI)) {
            vector.addElement(sCMResourceI);
        }
    }

    public synchronized void initChildResource(SCMResourceI sCMResourceI) {
        try {
            sCMResourceI.initialize();
            SCMRegistryI sCMRegistryI = this.getRegistry();
            sCMRegistryI.registerServer((EventObserverI)((Object)sCMResourceI));
            return;
        }
        catch (Exception exception) {
            System.out.println("SCM:: SCMResource.initChildResource - got exception: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void initializeOwnMA() {
        int n = this.type.getId();
        if (!this.getPrimaries(n, this.name)) {
            System.out.println("SCM:: SCMResource.initializeOwnMA - Error occurred while getting primaries for resource of " + this.name + " with resource type " + this.type.toString() + "; processing terminated.");
        }
        if (!this.getPossiblyMastered(n, this.name)) {
            System.out.println("SCM:: SCMResource.initializeOwnMA - Error occurred while getting resources mastered by resource of " + this.name + " with resource type " + this.type.toString() + "; processing terminated.");
        }
        if (!this.getAffiliates(n, this.name)) {
            System.out.println("SCM:: SCMResource.initializeOwnMA - Error occurred while getting affiliates to resource of " + this.name + " with resource type " + this.type.toString() + "; processing terminated.");
        }
    }

    public synchronized void initializeChildMA() throws RemoteException {
        if (this.child_tbl.isEmpty()) {
            return;
        }
        SCMResourceI sCMResourceI = null;
        Enumeration enumeration = this.child_tbl.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.child_tbl.get(string);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                sCMResourceI = (SCMResourceI)enumeration2.nextElement();
                sCMResourceI.initializeMA();
            }
        }
    }

    public synchronized void setStateString(String string) {
        if (string == null) {
            this.stateString = new String(this.state.toString());
            return;
        }
        this.stateString = new String(string);
    }

    public synchronized void setState(OBJECT_STATE oBJECT_STATE, String string) {
        if (this.state.equalTo(oBJECT_STATE)) {
            this.setStateString(string);
            return;
        }
        if (oBJECT_STATE.equalTo(OBJECT_STATE.ONLINE)) {
            if (this.compDownCount > 0) {
                this.state = OBJECT_STATE.COMPONENT_DOWN;
                this.setStateString(null);
                this.onlineString = new String(string);
                return;
            }
            this.setParentComponentDown(false);
        } else if (this.state.equalTo(OBJECT_STATE.ONLINE)) {
            this.onlineString = new String(this.stateString);
            this.setParentComponentDown(true);
        }
        if (!this.state.equalTo(OBJECT_STATE.ONLINE) && oBJECT_STATE.equalTo(OBJECT_STATE.COMPONENT_DOWN)) {
            return;
        }
        this.state = oBJECT_STATE;
        this.setStateString(string);
    }

    public synchronized void setState(int n, String string) {
        OBJECT_STATE oBJECT_STATE = OBJECT_STATE.get(n);
        this.setState(oBJECT_STATE, string);
    }

    public synchronized void setParentComponentDown(boolean bl) {
        if (this.parent_tbl.isEmpty()) {
            return;
        }
        Vector vector = null;
        SCMResource sCMResource = null;
        Enumeration enumeration = this.parent_tbl.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                sCMResource = (SCMResource)enumeration2.nextElement();
                sCMResource.setComponentDown(bl);
            }
        }
    }

    public synchronized void setComponentDown(boolean bl) {
        if (bl) {
            ++this.compDownCount;
            if (this.compDownCount == 1) {
                this.setState(OBJECT_STATE.COMPONENT_DOWN, null);
            }
            return;
        }
        if (this.compDownCount > 0) {
            --this.compDownCount;
            if (this.compDownCount == 0) {
                this.setState(OBJECT_STATE.ONLINE, this.onlineString);
            }
        }
    }

    public synchronized void setProperty(int n, String string) throws RemoteException {
        SCMPropertyKey sCMPropertyKey = SCMPropertyKey.get(n);
        if (sCMPropertyKey == null) {
            System.out.println("SCM:: SCMResource.setProperty - Property key ID " + n + " is invalid.");
            return;
        }
        this.properties.put(sCMPropertyKey.getKey(), string);
        this.addPropertyKey(sCMPropertyKey.getKey());
    }

    public synchronized void setProperty(String string, String string2, String string3) throws RemoteException {
        SCMPropertyKey sCMPropertyKey = SCMPropertyKey.searchKey(string);
        if (sCMPropertyKey == null) {
            sCMPropertyKey = SCMPropertyKey.createKey(string, string2);
            SCMPropertyKey.setKey(string, sCMPropertyKey);
        }
        this.properties.put(sCMPropertyKey.getKey(), string3);
        this.addPropertyKey(sCMPropertyKey.getKey());
    }

    public synchronized void addPropertyKey(String string) throws RemoteException {
        if (!this.propKeyList.contains(string)) {
            this.propKeyList.addElement(string);
        }
    }

    public synchronized void addProperty(int n, String string) throws RemoteException {
        SCMPropertyKey sCMPropertyKey = SCMPropertyKey.get(n);
        if (sCMPropertyKey == null) {
            System.out.println("SCM:: SCMResource.addProperty - Property key ID " + n + " is invalid.");
            return;
        }
        this.addPropertyValue(sCMPropertyKey.getKey(), string);
    }

    public synchronized void addProperty(String string, String string2, String string3) throws RemoteException {
        SCMPropertyKey sCMPropertyKey = SCMPropertyKey.searchKey(string);
        if (sCMPropertyKey == null) {
            sCMPropertyKey = SCMPropertyKey.createKey(string, string2);
        }
        this.addPropertyValue(string, string3);
    }

    public synchronized void addPropertyValue(String string, String string2) throws RemoteException {
        Vector<String> vector = (Vector<String>)this.properties.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.properties.put(string, vector);
        }
        if (!vector.contains(string2)) {
            vector.addElement(string2);
        }
    }

    public synchronized void setCurrentPrimary(int n, String string) throws RemoteException {
        OBJECT_TYPE oBJECT_TYPE = OBJECT_TYPE.get(n);
        if (oBJECT_TYPE == null) {
            System.out.println("SCM:: SCMResource.setCurrentPrimary - Resource name " + string + " of type " + n + " is invalid.");
            return;
        }
        if (this.currentPrimary != null && string.compareTo(this.currentPrimary.getName()) == 0 && oBJECT_TYPE.equalTo(this.currentPrimary.getType())) {
            return;
        }
        String string2 = oBJECT_TYPE.toString();
        SCMResourceI sCMResourceI = null;
        if (this.cm != null) {
            sCMResourceI = ((SCMRegistryI)((Object)this.cm)).lookupServer(string, string2);
        }
        if (sCMResourceI == null) {
            System.out.println("SCM:: SCMResource.setCurrentPrimary - Resource name " + string + " of type " + oBJECT_TYPE.toString() + " is invalid.");
            return;
        }
        Vector vector = (Vector)this.primary_tbl.get(string2);
        if (vector == null) {
            System.out.println("SCM:: SCMResource.setCurrentPrimary - Resource name " + string + " of type " + oBJECT_TYPE.toString() + " is not a valid primary.");
            return;
        }
        if (!vector.contains(sCMResourceI)) {
            System.out.println("SCM:: SCMResource.setCurrentPrimary - Resource name " + string + " of type " + oBJECT_TYPE.toString() + " is not a valid primary.");
            return;
        }
        this.currentPrimary = sCMResourceI;
    }

    public synchronized void addPrimary(int n, String string) throws RemoteException {
        this.addMATableEntry(n, string, this.primary_tbl);
    }

    public synchronized void addPossMastered(int n, String string) throws RemoteException {
        this.addMATableEntry(n, string, this.poss_mastered_tbl);
    }

    public synchronized void addAffiliate(int n, String string) throws RemoteException {
        this.addMATableEntry(n, string, this.affiliate_tbl);
    }

    public synchronized void addMATableEntry(int n, String string, Hashtable hashtable) throws RemoteException {
        OBJECT_TYPE oBJECT_TYPE = OBJECT_TYPE.get(n);
        if (oBJECT_TYPE == null) {
            System.out.println("SCM:: SCMResource.addMATableEntry - Resource name " + string + " of type " + n + " is invalid.");
            return;
        }
        String string2 = oBJECT_TYPE.toString();
        SCMResourceI sCMResourceI = null;
        if (this.cm != null) {
            sCMResourceI = ((SCMRegistryI)((Object)this.cm)).lookupServer(string, string2);
        }
        if (sCMResourceI == null) {
            System.out.println("SCM:: SCMResource.addMATableEntry - Resource name " + string + " of type " + oBJECT_TYPE.toString() + " is invalid.");
            return;
        }
        Vector<SCMResourceI> vector = (Vector<SCMResourceI>)hashtable.get(string2);
        if (vector == null) {
            vector = new Vector<SCMResourceI>();
            hashtable.put(string2, vector);
        }
        if (!vector.contains(sCMResourceI)) {
            vector.addElement(sCMResourceI);
        }
    }

    public synchronized void deleteParent(SCMResourceI sCMResourceI) throws RemoteException {
        this.deleteTableEntry(this.parent_tbl, sCMResourceI);
    }

    public synchronized void deleteChild(SCMResourceI sCMResourceI) throws RemoteException {
        this.deleteTableEntry(this.child_tbl, sCMResourceI);
    }

    public synchronized void deletePrimary(SCMResourceI sCMResourceI) throws RemoteException {
        this.deleteTableEntry(this.primary_tbl, sCMResourceI);
    }

    public synchronized void deletePossMastered(SCMResourceI sCMResourceI) throws RemoteException {
        this.deleteTableEntry(this.poss_mastered_tbl, sCMResourceI);
    }

    public synchronized void deleteAffiliate(SCMResourceI sCMResourceI) throws RemoteException {
        this.deleteTableEntry(this.affiliate_tbl, sCMResourceI);
    }

    public synchronized void deleteTableEntry(Hashtable hashtable, SCMResourceI sCMResourceI) throws RemoteException {
        try {
            String string = sCMResourceI.getType().toString();
            Vector vector = (Vector)hashtable.get(string);
            if (vector == null) {
                hashtable.remove(string);
                return;
            }
            vector.removeElement(sCMResourceI);
            if (vector.isEmpty()) {
                hashtable.remove(string);
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("SCM:: SCMResource.deleteTableEntry - got exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public synchronized void processDeleteEvent(SCMEvent sCMEvent) throws RemoteException {
        Enumeration enumeration;
        Vector vector = null;
        SCMResourceI sCMResourceI = null;
        Enumeration enumeration2 = this.parent_tbl.elements();
        while (enumeration2.hasMoreElements()) {
            vector = (Vector)enumeration2.nextElement();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                sCMResourceI = (SCMResourceI)enumeration.nextElement();
                sCMResourceI.deleteChild(this);
            }
        }
        enumeration2 = this.child_tbl.elements();
        while (enumeration2.hasMoreElements()) {
            vector = (Vector)enumeration2.nextElement();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                sCMResourceI = (SCMResourceI)enumeration.nextElement();
                sCMResourceI.deleteParent(this);
            }
        }
        if (!this.state.equalTo(OBJECT_STATE.ONLINE)) {
            this.setParentComponentDown(false);
        }
        try {
            SCMRegistryI sCMRegistryI = (SCMRegistryI)((Object)this.cm);
            sCMRegistryI.unregisterServer(this);
            sCMRegistryI.unregisterFactory(this);
            return;
        }
        catch (Exception exception) {
            System.out.println("SCM:: SCMResource.processDeleteEvent - got exception: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void processModifyEvent(SCMEvent sCMEvent) throws RemoteException {
        this.propKeyList.removeAllElements();
        this.properties.clear();
        if (!this.getResourceProperty(this.type.getId(), this.name)) {
            System.out.println("SCM:: SCMResource.processModifyEvent - Error occurred while getting resource properties of " + this.name + " with resource type " + this.type.toString() + "; processing terminated.");
            return;
        }
        this.primary_tbl.clear();
        this.poss_mastered_tbl.clear();
        this.affiliate_tbl.clear();
        this.initializeOwnMA();
    }

    public synchronized void processOwnershipChangeEvent(SCMEvent sCMEvent) throws RemoteException {
        this.primary_tbl.clear();
        this.currentPrimary = null;
        int n = this.type.getId();
        if (!this.getPrimaries(n, this.name)) {
            System.out.println("SCM:: SCMResource.processOwnershipChangeEvent - Error occurred while getting primaries for resource of " + this.name + " with resource type " + this.type.toString() + "; processing terminated.");
            return;
        }
        this.poss_mastered_tbl.clear();
        if (!this.getPossiblyMastered(n, this.name)) {
            System.out.println("SCM:: SCMResource.processOwnershipChangeEvent - Error occurred while getting resources mastered by resource of " + this.name + " with resource type " + this.type.toString() + "; processing terminated.");
        }
        if (!this.getResourceState(n, this.name)) {
            System.out.println("SCM:: SCMResource.processOwnershipChangeEvent - Error occurred while getting resource state of " + this.name + " with resource type " + this.type.toString() + "; processing terminated.");
            return;
        }
        sCMEvent.object_state = this.state;
    }

    public synchronized void initialize() throws RemoteException {
        if (!this.getResourceState(this.type.getId(), this.name)) {
            System.out.println("SCM:: SCMResource.initialize - Error occurred while getting resource state of " + this.name + " with resource type " + this.type.toString() + "; processing terminated.");
            return;
        }
        if (!this.getResourceProperty(this.type.getId(), this.name)) {
            System.out.println("SCM:: SCMResource.initialize - Error occurred while getting resource properties of " + this.name + " with resource type " + this.type.toString() + "; processing terminated.");
        }
    }

    public synchronized void initAllChildResources() throws RemoteException {
        this.getChildTypes(this.type.getId(), this.name);
        if (!this.getChildResources(this.type.getId(), this.name)) {
            System.out.println("SCM:: SCMResource.initAllChildResources - Error occurred while getting child resources of " + this.name + " with resource type " + this.type.toString() + "; processing terminated.");
            return;
        }
    }

    public synchronized void initializeMA() throws RemoteException {
        this.initializeOwnMA();
        this.initializeChildMA();
    }

    public synchronized void cleanUp() throws RemoteException {
        this.onlineString = null;
        this.compDownCount = 0;
        this.currentPrimary = null;
        this.propKeyList.removeAllElements();
        this.parent_tbl.clear();
        this.child_tbl.clear();
        this.primary_tbl.clear();
        this.poss_mastered_tbl.clear();
        this.affiliate_tbl.clear();
        this.properties.clear();
    }

    public synchronized ClusterManagerI getClusterManager() throws RemoteException {
        return this.cm;
    }

    public synchronized SCMRegistryI getRegistry() throws RemoteException {
        return (SCMRegistryI)((Object)this.cm);
    }

    public synchronized String getName() throws RemoteException {
        return this.name;
    }

    public synchronized String getUIName() throws RemoteException {
        return this.externalName;
    }

    public synchronized OBJECT_TYPE getType() throws RemoteException {
        return this.type;
    }

    public synchronized OBJECT_STATE getState() throws RemoteException {
        return this.state;
    }

    public synchronized String getStateString() throws RemoteException {
        return this.stateString;
    }

    public synchronized Hashtable getAllParents() throws RemoteException {
        return this.parent_tbl;
    }

    public synchronized int getChildCount(String string) throws RemoteException {
        Vector vector = (Vector)this.child_tbl.get(string);
        if (vector == null) {
            return 0;
        }
        return vector.size();
    }

    public synchronized SCMResourceI getChild(String string, int n) throws RemoteException {
        Vector vector = (Vector)this.child_tbl.get(string);
        if (vector == null) {
            return null;
        }
        return (SCMResourceI)vector.elementAt(n);
    }

    public synchronized SCMResourceI getChild(String string, String string2) throws RemoteException {
        Vector vector = (Vector)this.child_tbl.get(string);
        if (vector == null) {
            return null;
        }
        SCMResourceI sCMResourceI = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            sCMResourceI = (SCMResourceI)enumeration.nextElement();
            if (string2.compareTo(sCMResourceI.getName()) != 0) continue;
            return sCMResourceI;
        }
        return null;
    }

    public synchronized Vector getChildList(String string) throws RemoteException {
        return (Vector)this.child_tbl.get(string);
    }

    public synchronized Hashtable getAllChildren() throws RemoteException {
        return this.child_tbl;
    }

    public synchronized String getObjectTypeLB(String string) throws RemoteException {
        OBJECT_TYPE oBJECT_TYPE = SCMProperties.getObjectType(string);
        if (oBJECT_TYPE != null) {
            return oBJECT_TYPE.getLabel();
        }
        return null;
    }

    public synchronized Vector getChildTypeList() throws RemoteException {
        String string = null;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.child_tbl.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            vector.addElement(string);
        }
        return vector;
    }

    public synchronized OBJECT_STATE getChildTypeState(String string) throws RemoteException {
        SCMResourceI sCMResourceI = null;
        OBJECT_STATE oBJECT_STATE = OBJECT_STATE.ONLINE;
        try {
            Vector vector = this.getChildList(string);
            if (vector == null) {
                return OBJECT_STATE.ONLINE;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                sCMResourceI = (SCMResourceI)enumeration.nextElement();
                oBJECT_STATE = sCMResourceI.getState();
                if (oBJECT_STATE.equalTo(OBJECT_STATE.ONLINE)) continue;
                return OBJECT_STATE.COMPONENT_DOWN;
            }
        }
        catch (Exception exception) {
            System.out.println("SCM:: SCMResource.getChildTypeState - got exception: " + exception.getMessage());
            exception.printStackTrace();
            return OBJECT_STATE.ONLINE;
        }
        return OBJECT_STATE.ONLINE;
    }

    public synchronized boolean hasChildren() throws RemoteException {
        return !this.child_tbl.isEmpty();
    }

    public synchronized boolean isNewChild(String string, OBJECT_TYPE oBJECT_TYPE) throws RemoteException {
        SCMResourceI sCMResourceI;
        if (this.isChildResource(this.type.getId(), this.name, oBJECT_TYPE.getId(), string) && (sCMResourceI = this.getChild(oBJECT_TYPE.toString(), string)) != null) {
            sCMResourceI.initializeMA();
            return true;
        }
        return false;
    }

    public synchronized boolean isComponentDown() throws RemoteException {
        return this.compDownCount > 0;
    }

    public synchronized Object getProperty(String string) throws RemoteException {
        return this.properties.get(string);
    }

    public synchronized String getPropertyKeyLB(String string) throws RemoteException {
        SCMPropertyKey sCMPropertyKey = SCMProperties.getPropertyKey(string);
        if (sCMPropertyKey != null) {
            return sCMPropertyKey.getLabel();
        }
        return null;
    }

    public synchronized Vector getPropertyKeys() throws RemoteException {
        return this.propKeyList;
    }

    public synchronized SCMResourceI getCurrentPrimary() throws RemoteException {
        return this.currentPrimary;
    }

    public synchronized int getPrimaryCount(String string) throws RemoteException {
        Vector vector = (Vector)this.primary_tbl.get(string);
        if (vector == null) {
            return 0;
        }
        return vector.size();
    }

    public synchronized Vector getPrimaryList(String string) throws RemoteException {
        return (Vector)this.primary_tbl.get(string);
    }

    public synchronized int getPossMasteredCount(String string) throws RemoteException {
        Vector vector = (Vector)this.poss_mastered_tbl.get(string);
        if (vector == null) {
            return 0;
        }
        return vector.size();
    }

    public synchronized Vector getPossMasteredList(String string) throws RemoteException {
        return (Vector)this.poss_mastered_tbl.get(string);
    }

    public synchronized int getAffiliateCount(String string) throws RemoteException {
        Vector vector = (Vector)this.affiliate_tbl.get(string);
        if (vector == null) {
            return 0;
        }
        return vector.size();
    }

    public synchronized Vector getAffiliateList(String string) throws RemoteException {
        return (Vector)this.affiliate_tbl.get(string);
    }

    public synchronized void receiveEvent(SCMEvent sCMEvent, SCMResourceI sCMResourceI) throws RemoteException {
        EVENT_TYPE eVENT_TYPE = sCMEvent.event_type;
        if (eVENT_TYPE.equalTo(EVENT_TYPE.STATE_UPDATE)) {
            this.setState(sCMEvent.object_state, sCMEvent.state_string);
            if (this.currentPrimary == null) {
                return;
            }
            if (!sCMEvent.object_state.equalTo(OBJECT_STATE.ONLINE) && !sCMEvent.object_state.equalTo(OBJECT_STATE.COMPONENT_DOWN)) {
                this.currentPrimary = null;
            }
            return;
        }
        if (eVENT_TYPE.equalTo(EVENT_TYPE.DELETE)) {
            this.processDeleteEvent(sCMEvent);
            return;
        }
        if (eVENT_TYPE.equalTo(EVENT_TYPE.MODIFY)) {
            this.processModifyEvent(sCMEvent);
            return;
        }
        if (eVENT_TYPE.equalTo(EVENT_TYPE.OWNERSHIP_CHANGE)) {
            this.processOwnershipChangeEvent(sCMEvent);
            return;
        }
        System.out.println("SCM:: SCMResource.receiveEvent - Received event with invalid event type id " + eVENT_TYPE.getId());
    }
}

