/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.IPacl;

import com.sun.jaw.impl.adaptor.IPacl.internal.AclEntryImpl;
import com.sun.jaw.impl.adaptor.IPacl.internal.AclImpl;
import com.sun.jaw.impl.adaptor.IPacl.internal.ParseException;
import com.sun.jaw.impl.adaptor.IPacl.internal.Parser;
import com.sun.jaw.impl.adaptor.IPacl.internal.PermissionImpl;
import com.sun.jaw.impl.adaptor.IPacl.internal.PrincipalImpl;
import com.sun.jaw.impl.adaptor.IPacl.internal.SimpleNode;
import com.sun.jaw.impl.common.DefaultPaths;
import com.sun.jaw.reference.agent.services.IPAclSrvIf;
import com.sun.jaw.reference.common.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Jawacl
implements IPAclSrvIf,
Serializable {
    static final PermissionImpl READ = new PermissionImpl("READ");
    static final PermissionImpl WRITE = new PermissionImpl("WRITE");
    private AclImpl acl = null;
    private boolean alwaysAuthorized = false;
    private String authorizedListFile = null;
    private Hashtable destList = new Hashtable();
    private PrincipalImpl owner = new PrincipalImpl();

    public Jawacl(String string) throws UnknownHostException {
        try {
            this.acl = new AclImpl(this.owner, string);
            AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
            aclEntryImpl.addPermission(READ);
            aclEntryImpl.addPermission(WRITE);
            this.acl.addEntry(this.owner, aclEntryImpl);
        }
        catch (NotOwnerException notOwnerException) {
            Debug.print((int)2, (Object)"Jawacl::Jawacl: Should never get NotOwnerException as the owner is built in this constructor");
        }
        this.setDefautFileName();
        this.readAuthorisedListFile();
    }

    public boolean checkCommunity(String string) {
        return this.acl.checkCommunity(string);
    }

    public boolean checkReadPermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, READ);
    }

    public boolean checkReadPermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, READ);
    }

    public boolean checkWritePermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, WRITE);
    }

    public boolean checkWritePermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, WRITE);
    }

    public Enumeration entries() {
        return this.acl.entries();
    }

    public String getAuthorizedListFile() {
        return this.authorizedListFile;
    }

    public String getName() {
        return this.acl.getName();
    }

    public static PermissionImpl getREAD() {
        return READ;
    }

    public Enumeration getTrapCommunities(InetAddress inetAddress) {
        Vector vector = null;
        vector = (Vector)this.destList.get(inetAddress);
        if (vector != null) {
            Debug.print((int)2, (Object)("Jawacl::getTrapCommunities: [" + inetAddress.toString() + "] is in list"));
            return vector.elements();
        }
        vector = new Vector();
        Debug.print((int)2, (Object)("Jawacl::getTrapCommunities: [" + inetAddress.toString() + "] is not in list"));
        return vector.elements();
    }

    public Enumeration getTrapDestinations() {
        return this.destList.keys();
    }

    public static PermissionImpl getWRITE() {
        return WRITE;
    }

    private void readAuthorisedListFile() {
        this.alwaysAuthorized = false;
        if (this.authorizedListFile == null) {
            Debug.print((int)2, (Object)"Jawacl::readAuthorisedListFile: alwaysAuthorized set to true");
            this.alwaysAuthorized = true;
        } else {
            Object object;
            Parser parser = null;
            try {
                parser = new Parser(new FileInputStream(this.getAuthorizedListFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Debug.print((int)2, (Object)"Jawacl::readAuthorisedListFile: The specified file was not found, authorize everybody");
                this.alwaysAuthorized = true;
                return;
            }
            try {
                object = parser.SecurityDefs();
                ((SimpleNode)object).buildAclEntries(this.owner, this.acl);
                ((SimpleNode)object).buildTrapEntries(this.destList);
            }
            catch (ParseException parseException) {
                Debug.print((int)2, (Object)("Jawacl::readAuthorisedListFile: Parsing exception " + parseException));
            }
            catch (Error error) {
                Debug.print((int)2, (Object)"Jawacl::readAuthorisedListFile: Error exception");
            }
            object = this.acl.entries();
            while (object.hasMoreElements()) {
                AclEntryImpl aclEntryImpl = (AclEntryImpl)object.nextElement();
                Debug.print((int)2, (Object)("Jawacl::readAuthorisedListFile: ===> " + aclEntryImpl.getPrincipal().toString()));
                Enumeration enumeration = aclEntryImpl.permissions();
                while (enumeration.hasMoreElements()) {
                    Debug.print((int)2, (Object)("Jawacl::readAuthorisedListFile:      perm = " + (Permission)enumeration.nextElement()));
                }
            }
        }
    }

    public void rereadTheFile() throws NotOwnerException, UnknownHostException {
        this.alwaysAuthorized = false;
        this.acl.removeAll(this.owner);
        this.destList.clear();
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
        aclEntryImpl.addPermission(READ);
        aclEntryImpl.addPermission(WRITE);
        this.acl.addEntry(this.owner, aclEntryImpl);
        this.readAuthorisedListFile();
    }

    public void setAuthorizedListFile(String string) {
        Debug.print((int)2, (Object)("Jawacl::setAuthorizedListFile: Default file set to " + string));
        this.authorizedListFile = string;
    }

    private void setDefautFileName() {
        File file;
        String string = System.getProperty("jaw.acl.file");
        if (string == null) {
            string = DefaultPaths.getEtcDir((String)("conf" + File.separator + "jaw.acl"));
        }
        if ((file = new File(string)).exists()) {
            Debug.print((int)2, (Object)("Jawacl::setDefautFileName: ACL file found in " + string));
        } else {
            Debug.print((int)2, (Object)"Jawacl::setDefautFileName: ACL file not found");
        }
        this.setAuthorizedListFile(string);
    }
}

