/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.IPacl.internal;

import com.sun.jaw.impl.adaptor.IPacl.internal.AclEntryImpl;
import com.sun.jaw.impl.adaptor.IPacl.internal.AclImpl;
import com.sun.jaw.impl.adaptor.IPacl.internal.JDMAccess;
import com.sun.jaw.impl.adaptor.IPacl.internal.JDMAclItem;
import com.sun.jaw.impl.adaptor.IPacl.internal.JDMCommunities;
import com.sun.jaw.impl.adaptor.IPacl.internal.JDMHost;
import com.sun.jaw.impl.adaptor.IPacl.internal.JDMHostTrap;
import com.sun.jaw.impl.adaptor.IPacl.internal.JDMManagers;
import com.sun.jaw.impl.adaptor.IPacl.internal.JDMTrapCommunity;
import com.sun.jaw.impl.adaptor.IPacl.internal.JDMTrapInterestedHost;
import com.sun.jaw.impl.adaptor.IPacl.internal.JDMTrapItem;
import com.sun.jaw.impl.adaptor.IPacl.internal.Parser;
import com.sun.jaw.impl.adaptor.IPacl.internal.PrincipalImpl;
import com.sun.jaw.impl.adaptor.IPacl.internal.SimpleNode;
import com.sun.jaw.reference.common.Debug;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Host
extends SimpleNode
implements Serializable {
    public Host(int n) {
        super(n);
    }

    public Host(Parser parser, int n) {
        super(parser, n);
    }

    public void buildAclEntries(PrincipalImpl principalImpl, AclImpl aclImpl) {
        PrincipalImpl principalImpl2 = null;
        try {
            principalImpl2 = this.createAssociatedPrincipal();
        }
        catch (UnknownHostException unknownHostException) {
            Debug.print((Object)("Error: Cannot create ACL entry for " + unknownHostException.getMessage()));
            return;
        }
        AclEntryImpl aclEntryImpl = null;
        try {
            aclEntryImpl = new AclEntryImpl(principalImpl2);
            this.registerPermission(aclEntryImpl);
            aclImpl.addEntry(principalImpl, aclEntryImpl);
        }
        catch (UnknownHostException unknownHostException) {
            Debug.print((Object)("Error: Cannot create ACL entry for " + unknownHostException.getMessage()));
            return;
        }
        catch (NotOwnerException notOwnerException) {
            Debug.print((Object)("Error: Not owner of ACL " + notOwnerException.getMessage()));
            return;
        }
    }

    public void buildTrapEntries(Hashtable hashtable) {
        JDMHostTrap jDMHostTrap = (JDMHostTrap)this.jjtGetParent();
        JDMTrapInterestedHost jDMTrapInterestedHost = (JDMTrapInterestedHost)jDMHostTrap.jjtGetParent();
        JDMTrapItem jDMTrapItem = (JDMTrapItem)jDMTrapInterestedHost.jjtGetParent();
        JDMTrapCommunity jDMTrapCommunity = jDMTrapItem.getCommunity();
        String string = jDMTrapCommunity.getCommunity();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.getHname());
        }
        catch (UnknownHostException unknownHostException) {
            Debug.print((Object)("Error: Cannot create TRAP entry for " + unknownHostException.getMessage()));
            return;
        }
        Vector vector = null;
        if (hashtable.containsKey(inetAddress)) {
            vector = (Vector)hashtable.get(inetAddress);
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
        } else {
            vector = new Vector();
            vector.addElement(string);
            hashtable.put(inetAddress, vector);
        }
    }

    protected abstract PrincipalImpl createAssociatedPrincipal() throws UnknownHostException;

    protected abstract String getHname();

    private void registerPermission(AclEntryImpl aclEntryImpl) {
        JDMHost jDMHost = (JDMHost)this.jjtGetParent();
        JDMManagers jDMManagers = (JDMManagers)jDMHost.jjtGetParent();
        JDMAclItem jDMAclItem = (JDMAclItem)jDMManagers.jjtGetParent();
        JDMAccess jDMAccess = jDMAclItem.getAccess();
        jDMAccess.putPermission(aclEntryImpl);
        JDMCommunities jDMCommunities = jDMAclItem.getCommunities();
        jDMCommunities.buildCommunities(aclEntryImpl);
    }
}

