/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.comm;

import com.sun.jaw.impl.adaptor.comm.AdaptorSocket;
import com.sun.jaw.impl.adaptor.comm.internal.RequestHandler;
import com.sun.jaw.impl.adaptor.generic.AdaptorServer;
import com.sun.jaw.impl.adaptor.security.AuthInfo;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AdaptorServerImpl
extends AdaptorServer {
    private static final String sccs_id = "@(#)AdaptorServerImpl.java 3.5 02/04/99 SMI";
    protected transient AdaptorSocket sockListen = null;
    protected InetAddress addrLastClient = null;
    protected Vector authInfo = new Vector();
    protected int index = 0;
    protected final int MAX_CHALLENGES = 100;
    protected String[] challengeList = new String[100];
    private static final String PORT = "port";
    private static final String PROTOCOL = "protocol";
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public AdaptorServerImpl() {
        this.maxActiveClientCount = 10;
    }

    public AdaptorServerImpl(int n) {
        this.port = n;
        this.maxActiveClientCount = 10;
    }

    /*
     * Unable to fully structure code
     */
    private String HMAC_MD5(byte[] var1_1, byte[] var2_2) {
        var3_3 = 64;
        var4_4 = null;
        try {
            var4_4 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException v0) {}
        if (var2_2.length > 64) {
            var2_2 = var4_4.digest(var2_2);
        }
        var5_5 = new byte[64];
        var6_6 = new byte[64];
        var8_7 = 0;
        ** GOTO lbl21
        {
            var5_5[var8_7] = var2_2[var8_7];
            var6_6[var8_7] = var2_2[var8_7];
            ++var8_7;
            do {
                if (var8_7 < var2_2.length) continue block2;
                var5_5[var8_7] = 0;
                var6_6[var8_7] = 0;
                ++var8_7;
lbl21:
                // 2 sources

            } while (var8_7 < 64);
        }
        var8_7 = 0;
        while (var8_7 < 64) {
            v1 = var8_7;
            var5_5[v1] = (byte)(var5_5[v1] ^ 54);
            v2 = var8_7++;
            var6_6[v2] = (byte)(var6_6[v2] ^ 92);
        }
        var4_4.update(var5_5);
        var4_4.update(var1_1);
        var7_8 = var4_4.digest();
        var4_4.update(var6_6);
        var4_4.update(var7_8);
        var7_8 = var4_4.digest();
        var9_9 = new StringBuffer();
        var8_7 = 0;
        while (var8_7 < var7_8.length) {
            if ((var7_8[var8_7] & 255) < 16) {
                var9_9.append("0" + Integer.toHexString(var7_8[var8_7] & 255));
            } else {
                var9_9.append(Integer.toHexString(var7_8[var8_7] & 255));
            }
            ++var8_7;
        }
        return var9_9.toString();
    }

    public synchronized void addUserAuthenticationInfo(AuthInfo authInfo) {
        if (authInfo != null) {
            String string = authInfo.getLogin();
            Enumeration enumeration = this.authInfo.elements();
            while (enumeration.hasMoreElements()) {
                AuthInfo authInfo2 = (AuthInfo)enumeration.nextElement();
                if (!authInfo2.getLogin().equals(string)) continue;
                this.authInfo.removeElement(authInfo2);
                break;
            }
            this.authInfo.addElement(authInfo);
        }
    }

    public synchronized boolean checkChallengeResponse(String string) {
        if (string == null) {
            return false;
        }
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        try {
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        String string4 = null;
        boolean bl = false;
        Enumeration enumeration = this.authInfo.elements();
        while (enumeration.hasMoreElements()) {
            AuthInfo authInfo = (AuthInfo)enumeration.nextElement();
            if (!authInfo.getLogin().equals(string3)) continue;
            string4 = authInfo.getPassword();
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        int n = 0;
        while (n < 100) {
            String string5;
            String string6 = this.challengeList[n];
            if (string6 != null && string2.equals(string5 = this.HMAC_MD5(string6.getBytes(), string4.getBytes()))) {
                this.challengeList[n] = null;
                return true;
            }
            ++n;
        }
        return false;
    }

    protected abstract AdaptorSocket createSocket();

    protected void doBind() throws InterruptedException, CommunicationException {
        try {
            this.sockListen = this.createSocket().createServerSocket(this.port);
            this.sockListen.doBind();
            Debug.print((Object)("comm.AdaptorServerImpl::run: " + this.sockListen.toString() + " bound to " + this.sockListen.getLocalAddress() + " port " + this.sockListen.getLocalPort()));
        }
        catch (SocketException socketException) {
            Debug.printException((Exception)socketException);
            Debug.print((Object)("EXCEPTION MSG = '" + socketException.getMessage() + "'"));
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException.toString());
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException.getMessage());
        }
    }

    protected void doProcess() throws InterruptedException, CommunicationException {
        Debug.print((int)2, (Object)("comm.AdaptorServerImpl::doProcess: address of last connected client [" + this.addrLastClient + "]"));
        RequestHandler requestHandler = new RequestHandler(this, this.getServedClientCount(), (AdaptorSocket)this.sockListen.clone(), this.cmf, this.objectName, false, true, true);
    }

    protected void doReceive() throws InterruptedException, CommunicationException {
        try {
            this.sockListen.doReceive();
            this.addrLastClient = this.sockListen.getRemoteAddress();
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException.toString());
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(iOException.toString());
            }
            throw new CommunicationException(iOException.toString());
        }
        catch (Exception exception) {
            Debug.print((int)2, (Object)"comm.AdaptorServerImpl::doReceive: got exception");
            throw new InterruptedException();
        }
    }

    protected void doUnbind() throws InterruptedException, CommunicationException {
        try {
            if (this.sockListen != null) {
                Debug.print((int)2, (Object)("comm.AdaptorServerImpl::doUnbind: port[" + this.port + "] has been definitively closed"));
                this.sockListen.doUnbind();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException.getMessage());
        }
    }

    public synchronized String generateChallengeResponse() {
        Object object;
        String string = null;
        try {
            object = InetAddress.getLocalHost();
            string = ((InetAddress)object).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "UnknownHost";
        }
        object = "<" + System.currentTimeMillis() + "@" + string + ">";
        if (this.index == 100) {
            this.index = 0;
        }
        this.challengeList[this.index] = object;
        ++this.index;
        return object;
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public String getLastConnectedClient() {
        if (this.addrLastClient == null) {
            return new String("unknown");
        }
        return this.addrLastClient.toString();
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException {
        Debug.print((int)2, (Object)("comm.AdaptorServerImpl::initCmf: Register " + objectName + " in framework"));
        Hashtable hashtable = this.parseName(objectName);
        this.port = (Integer)hashtable.get(PORT);
        super.initCmf(framework, objectName, bl, modificationList);
    }

    public boolean isAuthenticationOn() {
        return this.authInfo.isEmpty() ^ true;
    }

    private Hashtable parseName(ObjectName objectName) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(PROTOCOL, new String(this.getProtocol()));
        Integer n = (Integer)objectName.getProperty(PORT);
        if (n == null) {
            n = new Integer(this.port);
        }
        hashtable.put(PORT, n);
        return hashtable;
    }

    public void performStop() {
        block2: {
            if (!this.isActive()) break block2;
            super.performStop();
            try {
                AdaptorSocket adaptorSocket = this.sockListen.createClientSocket();
                adaptorSocket.doConnect(InetAddress.getLocalHost().getHostAddress(), this.port);
                adaptorSocket.doSend("", null);
                adaptorSocket.doDisconnect();
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized void removeUserAuthenticationInfo(AuthInfo authInfo) {
        if (authInfo != null) {
            String string = authInfo.getLogin();
            Enumeration enumeration = this.authInfo.elements();
            while (enumeration.hasMoreElements()) {
                AuthInfo authInfo2 = (AuthInfo)enumeration.nextElement();
                if (!authInfo2.getLogin().equals(string)) continue;
                this.authInfo.removeElement(authInfo2);
                break;
            }
        }
    }
}

