/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.comm.internal;

import com.sun.jaw.impl.adaptor.comm.AdaptorSocket;
import com.sun.jaw.impl.adaptor.generic.AdaptorListener;
import com.sun.jaw.impl.adaptor.generic.AdaptorServer;
import com.sun.jaw.impl.adaptor.generic.AdaptorStateChangeEvent;
import com.sun.jaw.impl.adaptor.generic.internal.EventHandlers;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.cmf.FrameworkEvent;
import com.sun.jaw.reference.agent.cmf.FrameworkListener;
import com.sun.jaw.reference.agent.services.EventHandlerIf;
import com.sun.jaw.reference.agent.services.EventObjectIfAgt;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.InvalidPropertyValueException;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.common.PropertyNotFoundException;
import com.sun.jaw.reference.common.ServiceNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;

public class EventListenerHandler
implements EventHandlerIf,
FrameworkListener,
AdaptorListener {
    private static final String sccs_id = "@(#)EventListenerHandler.java 3.1 09/29/98 SMI";
    private ObjectName masterName;
    private transient AdaptorServer master;
    private ObjectName name;
    private Framework cmf = null;
    private transient Object source;
    private ObjectName mo;
    private transient Object listener;
    private transient Class ifClass;
    private String loName;
    private String eventReceiver;
    private int httpPort;
    private String httpServer;
    private final String CRLF = "\r\n";
    private transient AdaptorSocket socket = null;
    private static final Integer DELETE_EVT = new Integer(2);

    public EventListenerHandler(String string, ObjectName objectName, ObjectName objectName2, Object object, Object object2, String string2, Class clazz, Framework framework, AdaptorSocket adaptorSocket) throws CommunicationException, ServiceNotFoundException, IllegalAccessException {
        Object object3;
        this.source = object2;
        this.listener = object;
        this.mo = objectName2;
        this.cmf = framework;
        this.loName = string2;
        this.ifClass = clazz;
        this.socket = adaptorSocket;
        this.masterName = objectName;
        try {
            this.eventReceiver = string;
            if (this.eventReceiver == null) {
                Debug.print((int)2, (Object)"comm.EventListenerHandler.handleEvent; receiver is null");
            } else {
                object3 = new URL(this.eventReceiver);
                this.httpServer = ((URL)object3).getHost();
                this.httpPort = ((URL)object3).getPort();
            }
        }
        catch (Exception exception) {
            throw new CommunicationException("Can't contact remote management event server at " + string);
        }
        object3 = framework.getDomain();
        try {
            this.name = new ObjectName(String.valueOf(object3) + ":" + "com.sun.jaw.reference.agent.services.EventHandlerIfMO" + ".counter=" + EventHandlers.getCounter());
        }
        catch (Exception exception) {}
        this.master = (AdaptorServer)framework.getMoRepSrvIf().retrieve(this.masterName);
        if (this.master == null) {
            throw new ServiceNotFoundException("Invalid adaptor.");
        }
        this.master.addAdaptorListener(this);
        framework.addFrameworkListener(this);
    }

    public synchronized void deleteCmf() {
        try {
            this.cmf.removeListener(this.source, this.listener, this.loName, this.ifClass);
            this.cmf.removeFrameworkListener(this);
            if (this.master == null) {
                this.master = (AdaptorServer)this.cmf.getMoRepSrvIf().retrieve(this.masterName);
                if (this.master == null) {
                    return;
                }
            }
            this.master.removeAdaptorListener(this);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
        }
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public ObjectName getEmitter() {
        return this.mo;
    }

    public String getListener() {
        return this.eventReceiver;
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    public synchronized void handleAdaptorStateChange(AdaptorStateChangeEvent adaptorStateChangeEvent) {
        int n = adaptorStateChangeEvent.getNewState();
        if (n != 1) {
            return;
        }
        Debug.print((int)2, (Object)("comm.EventListenerHandler::handleAdaptorStateChange: delete " + this.name));
        try {
            this.cmf.delObject(this.name);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
        }
    }

    public void handleEvent(EventObject eventObject, ObjectName objectName) throws CommunicationException {
        Debug.print((int)2, (Object)("comm.EventListenerHandler.handleEvent [" + this.name + "] = " + objectName));
        if (eventObject.getSource() != this.listener) {
            return;
        }
        if (!(eventObject instanceof EventObjectIfAgt)) {
            Debug.print((int)2, (Object)"comm.EventListenerHandler.handleEvent: event is not a EventObjectIfMO");
            return;
        }
        try {
            this.postEvent(eventObject);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            throw new CommunicationException(exception.getMessage());
        }
    }

    public void handleFrameworkEvent(FrameworkEvent frameworkEvent) {
        if (!frameworkEvent.getEventType().equals(DELETE_EVT)) {
            return;
        }
        Vector vector = frameworkEvent.getEventObjectNames();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ObjectName objectName = (ObjectName)enumeration.nextElement();
            if (!objectName.equals((Object)this.mo)) continue;
            Debug.print((int)2, (Object)("comm.EventListenerHandler::handleFrameworkEvent: delete " + this.name));
            try {
                this.cmf.delObject(this.name);
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
            }
        }
    }

    public void postEvent(EventObject eventObject) throws CommunicationException {
        String string = ((EventObjectIfAgt)eventObject).getMethodName();
        EventListenerHandler eventListenerHandler = this;
        synchronized (eventListenerHandler) {
            Debug.print((int)2, (Object)("comm.EventListenerHandler.handleEvent= about to send event to\n\t" + this.eventReceiver));
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject("EventObject");
                objectOutputStream.writeObject(eventObject);
                objectOutputStream.writeObject("ObjectName");
                objectOutputStream.writeObject(this.mo);
                objectOutputStream.writeObject("Method");
                objectOutputStream.writeObject(string);
                objectOutputStream.writeObject("EventListener");
                objectOutputStream.writeObject(this.name);
                this.sendHttpPost("sendEvent?EventObject&ObjectName&Method&EventListener", byteArrayOutputStream);
            }
            catch (Exception exception) {}
        }
    }

    private byte[] sendHttp(String string, byte[] byArray) throws CommunicationException, IllegalAccessException, ClassNotFoundException, InstanceNotFoundException, ServiceNotFoundException, InstantiationException, InstanceAlreadyExistException, PropertyNotFoundException, SecurityException, InvalidPropertyValueException, NoSuchMethodException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(string) + " " + "HTTP/1.0" + "\r\n" + "User-Agent: " + "JDMK/3.2" + "\r\n" + "Accept: text/html, */*" + "\r\n");
        if (byArray != null) {
            stringBuffer.append("Content-Length: " + byArray.length + "\r\n");
        }
        stringBuffer.append("Connection: Keep-Alive\r\n");
        stringBuffer.append("\r\n");
        try {
            Debug.print((int)2, (Object)("comm.EventListenerHandler::sendHttp [" + this.name + " ] : Open socket with remote server [" + this.httpServer + ":" + this.httpPort + "]"));
            this.socket.doConnect(this.httpServer, this.httpPort);
            this.socket.doSend(stringBuffer.toString(), byArray);
            this.socket.doDisconnect();
        }
        catch (Exception exception) {
            Debug.print((int)2, (Object)"comm.EventListenerHandler::sendHttp: Exception");
            throw new CommunicationException("HTTP Event Listener Handler cannot connect");
        }
        return null;
    }

    private byte[] sendHttpPost(String string, ByteArrayOutputStream byteArrayOutputStream) throws CommunicationException, IllegalAccessException, ClassNotFoundException, InstanceNotFoundException, ServiceNotFoundException, InstantiationException, InstanceAlreadyExistException, PropertyNotFoundException, SecurityException, InvalidPropertyValueException, NoSuchMethodException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("POST ");
        stringBuffer.append("/Request/" + string);
        if (byteArrayOutputStream == null) {
            return this.sendHttp(stringBuffer.toString(), null);
        }
        return this.sendHttp(stringBuffer.toString(), byteArrayOutputStream.toByteArray());
    }
}

