/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.generic;

import com.sun.jaw.impl.adaptor.generic.AdaptorListener;
import com.sun.jaw.impl.adaptor.generic.AdaptorStateChangeEvent;
import com.sun.jaw.impl.adaptor.generic.internal.ClientHandler;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.ActivatableIf;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AdaptorServer
implements Runnable,
Serializable,
ActivatableIf {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    protected transient int state = 1;
    protected ObjectName objectName;
    protected Framework cmf;
    protected transient String dbgTag = null;
    protected int maxActiveClientCount = 1;
    protected transient int servedClientCount = 0;
    protected int port = -1;
    protected transient Vector listeners;
    private transient Thread fatherThread = Thread.currentThread();
    private transient Thread mainThread = null;
    private transient Vector clientHandlerVector = new Vector();
    private transient boolean stopRequested = false;

    public AdaptorServer() {
        this.listeners = new Vector();
        this.dbgTag = this.makeDebugTag();
    }

    public synchronized void addAdaptorListener(AdaptorListener adaptorListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(adaptorListener);
    }

    protected synchronized void changeState(int n) {
        if (this.state == n) {
            return;
        }
        int n2 = this.state;
        this.state = n;
        this.emitStateChangeEvent(n2, n);
        this.notifyAll();
    }

    public void deleteCmf() throws InstanceNotFoundException, InvocationTargetException {
        this.cmf = null;
        this.objectName = null;
        if (this.state == 0 || this.state == 3) {
            this.performStop();
        }
    }

    protected abstract void doBind() throws CommunicationException, InterruptedException;

    protected abstract void doProcess() throws CommunicationException, InterruptedException;

    protected abstract void doReceive() throws CommunicationException, InterruptedException;

    protected abstract void doUnbind() throws CommunicationException, InterruptedException;

    private void emitStateChangeEvent(int n, int n2) {
        if (this.listeners == null) {
            return;
        }
        Vector vector = (Vector)this.listeners.clone();
        AdaptorStateChangeEvent adaptorStateChangeEvent = new AdaptorStateChangeEvent(this, n, n2);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AdaptorListener adaptorListener = (AdaptorListener)enumeration.nextElement();
            adaptorListener.handleAdaptorStateChange(adaptorStateChangeEvent);
        }
    }

    public Integer getActiveClientCount() {
        int n = this.clientHandlerVector.size();
        return new Integer(n);
    }

    protected Framework getFramework() {
        return this.cmf;
    }

    public Integer getMaxActiveClientCount() {
        return new Integer(this.maxActiveClientCount);
    }

    protected ObjectName getObjectName() {
        return this.objectName;
    }

    public Integer getPort() {
        return new Integer(this.port);
    }

    public abstract String getProtocol();

    public Integer getServedClientCount() {
        return new Integer(this.servedClientCount);
    }

    public Integer getState() {
        return new Integer(this.state);
    }

    public String getStateString() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "ONLINE";
                break;
            }
            case 3: {
                string = "STARTING";
                break;
            }
            case 1: {
                string = "OFFLINE";
                break;
            }
            case 2: {
                string = "STOPPING";
                break;
            }
        }
        return string;
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException {
        this.cmf = framework;
        this.objectName = objectName;
        this.dbgTag = this.makeDebugTag();
        if (bl) {
            framework.addDBObject(this, objectName);
        } else {
            framework.addObject(this, objectName);
        }
        if (this.state == 1) {
            this.performStart();
        }
    }

    public boolean isActive() {
        return this.state == 0;
    }

    protected String makeDebugTag() {
        return "generic.AdaptorServer[" + this.getProtocol() + ":" + this.getPort() + "]:";
    }

    protected String makeThreadName() {
        String string = this.objectName == null ? "AdaptorServer" : this.objectName.toString();
        return string;
    }

    public void notifyClientHandlerCreated(ClientHandler clientHandler) {
        this.clientHandlerVector.addElement(clientHandler);
    }

    public synchronized void notifyClientHandlerDeleted(ClientHandler clientHandler) {
        this.clientHandlerVector.removeElement(clientHandler);
    }

    public synchronized void performStart() {
        if (this.state == 1 && this.state != 3) {
            this.changeState(3);
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "performStart: --> Start adaptor "));
            this.stopRequested = false;
            this.mainThread = this.cmf == null ? new Thread((Runnable)this, this.makeThreadName()) : this.cmf.getThreadAllocatorSrvIf().obtainThread((Object)this.objectName, this, this.makeThreadName());
            this.mainThread.start();
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "performStart: adaptor started."));
        } else {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "performStart: adaptor is not OFFLINE"));
        }
    }

    public void performStop() {
        if (this.state == 0 || this.state == 3) {
            this.changeState(2);
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "performStop: interrupt main Thread"));
            this.stopRequested = true;
            this.mainThread.interrupt();
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "performStop: terminateAllClient"));
            this.terminateAllClient();
            this.changeState(1);
        } else {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "performStop: adaptor is not ONLINE"));
        }
    }

    public boolean performWaitState(int n, long l) {
        Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "performWaitState: " + n + "(0on,1off,2st) TO=" + l + " ; current state = " + this.getStateString()));
        if (l < 0L) {
            return this.state == n;
        }
        boolean bl = this.state == n;
        long l2 = -1L;
        Date date = new Date(new Date().getTime() + l);
        while (!bl) {
            if (l != 0L && (l2 = date.getTime() - new Date().getTime()) <= 0L) {
                bl = true;
                break;
            }
            try {
                AdaptorServer adaptorServer = this;
                synchronized (adaptorServer) {
                    if (l == 0L) {
                        Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "performWaitState: Start waiting infinit, current state = " + this.state));
                        bl = this.state == n;
                        while (!bl) {
                            bl = this.state == n;
                            try {
                                this.wait(1000L);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "performWaitState: Start waiting " + l2 + " current state = " + this.state));
                        this.wait(l2);
                    }
                }
                bl = this.state == n;
            }
            catch (InterruptedException interruptedException) {
                boolean bl2 = bl = this.state == n;
            }
        }
        Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "performWaitState: end, TO=" + l2));
        return this.state == n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.changeState(1);
        this.servedClientCount = 0;
        this.clientHandlerVector = new Vector();
        this.stopRequested = false;
    }

    public synchronized void removeAdaptorListener(AdaptorListener adaptorListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
            return;
        }
        if (adaptorListener == null) {
            return;
        }
        this.listeners.removeElement(adaptorListener);
    }

    public void run() {
        try {
            this.doBind();
        }
        catch (Exception exception) {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "run: unexpected exception"));
            Debug.printException((Exception)exception);
            this.changeState(1);
            return;
        }
        this.changeState(0);
        Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "run: state is ONLINE"));
        ThreadDeath threadDeath = null;
        try {
            while (!this.stopRequested) {
                this.doReceive();
                ++this.servedClientCount;
                this.waitIfTooManyClients();
                this.doProcess();
            }
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "run: stop has been requested"));
        }
        catch (InterruptedException interruptedException) {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "run: interrupt caught"));
            this.changeState(2);
        }
        catch (Exception exception) {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "run: unexpected exception"));
            Debug.printException((Exception)exception);
            this.changeState(2);
        }
        catch (ThreadDeath threadDeath2) {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "run: ThreadDeath caught"));
            threadDeath = threadDeath2;
            this.changeState(2);
        }
        try {
            this.waitClientTermination();
            this.doUnbind();
            this.changeState(1);
        }
        catch (Exception exception) {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "run: unexpected exception"));
            Debug.printException((Exception)exception);
            this.changeState(1);
        }
        if (threadDeath != null) {
            throw threadDeath;
        }
    }

    public void setMaxActiveClientCount(Integer n) {
        this.maxActiveClientCount = n;
    }

    private void terminateAllClient() {
        int n = this.clientHandlerVector.size();
        if (n >= 1) {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "terminateAllClient: interrupting " + n + " clients"));
        }
        Enumeration enumeration = this.clientHandlerVector.elements();
        while (enumeration.hasMoreElements()) {
            ClientHandler clientHandler = (ClientHandler)enumeration.nextElement();
            clientHandler.interrupt();
        }
    }

    private void waitClientTermination() {
        int n = this.clientHandlerVector.size();
        if (n >= 1) {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "waitClientTermination: waiting for " + n + " clients to terminate"));
        }
        Enumeration enumeration = this.clientHandlerVector.elements();
        while (enumeration.hasMoreElements()) {
            ClientHandler clientHandler = (ClientHandler)enumeration.nextElement();
            clientHandler.join();
        }
        if (n >= 1) {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "waitClientTermination: ok, let's go..."));
        }
    }

    private synchronized void waitIfTooManyClients() throws InterruptedException {
        while (this.getActiveClientCount() >= this.maxActiveClientCount) {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "waitIfTooManyClients: waiting for a client to terminate"));
            this.wait(5000L);
        }
    }
}

