/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.generic.internal;

import com.sun.jaw.impl.adaptor.generic.AdaptorServer;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.ObjectName;

public abstract class ClientHandler
implements Runnable {
    protected AdaptorServer adaptorServer = null;
    protected int requestId = -1;
    protected Framework cmf = null;
    protected ObjectName objectName = null;
    protected Thread thread = null;
    protected boolean interruptCalled = false;
    protected String dbgTag = null;

    public ClientHandler(AdaptorServer adaptorServer, int n, Framework framework, ObjectName objectName) {
        this.adaptorServer = adaptorServer;
        this.requestId = n;
        this.cmf = framework;
        this.objectName = objectName;
        this.interruptCalled = false;
        this.dbgTag = this.makeDebugTag();
        this.thread = this.cmf == null ? new Thread(this) : this.cmf.getThreadAllocatorSrvIf().obtainThread((Object)this.objectName, this);
    }

    public abstract void doRun();

    public void interrupt() {
        Debug.print((Object)(String.valueOf(this.dbgTag) + "interrupt: start"));
        this.interruptCalled = true;
        this.thread.interrupt();
        Debug.print((Object)(String.valueOf(this.dbgTag) + "interrupt: end"));
    }

    public void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    protected String makeDebugTag() {
        return String.valueOf(this.adaptorServer.getProtocol()) + ":" + this.adaptorServer.getPort() + ":" + this.requestId + ":";
    }

    public void run() {
        try {
            this.adaptorServer.notifyClientHandlerCreated(this);
            this.doRun();
        }
        finally {
            Object var2_1 = null;
            this.adaptorServer.notifyClientHandlerDeleted(this);
        }
    }
}

