/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.html;

import com.sun.jaw.impl.adaptor.generic.AdaptorServer;
import com.sun.jaw.impl.adaptor.html.internal.RequestHandler;
import com.sun.jaw.impl.adaptor.security.AuthInfo;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class AdaptorServerImpl
extends AdaptorServer {
    private final String sccs_id = "@(#)AdaptorServerImpl.java 3.9 99/03/18 SMI";
    private transient ServerSocket sockListen = null;
    private transient Socket sock = null;
    private InetAddress addrLastClient = null;
    private boolean registerClient = false;
    private Vector authInfo = new Vector();
    private boolean flatten = true;
    private boolean sortAtt = true;
    private String bgColor = null;
    private static final String PORT = "port";
    private static final String PROTOCOL = "protocol";
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public AdaptorServerImpl() {
        this.port = 8082;
        this.maxActiveClientCount = 10;
        this.dbgTag = this.makeDebugTag();
    }

    public AdaptorServerImpl(int n) {
        this.port = n;
        this.maxActiveClientCount = 10;
        this.dbgTag = this.makeDebugTag();
    }

    public synchronized void addUserAuthenticationInfo(AuthInfo authInfo) {
        if (authInfo != null) {
            String string = authInfo.getLogin();
            Enumeration enumeration = this.authInfo.elements();
            while (enumeration.hasMoreElements()) {
                AuthInfo authInfo2 = (AuthInfo)enumeration.nextElement();
                if (!authInfo2.getLogin().equals(string)) continue;
                this.authInfo.removeElement(authInfo2);
                break;
            }
            this.authInfo.addElement(authInfo);
        }
    }

    public synchronized boolean checkChallengeResponse(String string) {
        if (string == null) {
            return false;
        }
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        Enumeration enumeration = this.authInfo.elements();
        while (enumeration.hasMoreElements()) {
            AuthInfo authInfo = (AuthInfo)enumeration.nextElement();
            if (!authInfo.getLogin().equals(string2) || !authInfo.getPassword().equals(string3)) continue;
            return true;
        }
        return false;
    }

    protected void doBind() throws CommunicationException, InterruptedException {
        Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "doBind: start"));
        try {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "doBind: maxActiveClientCount = " + this.maxActiveClientCount));
            this.sockListen = new ServerSocket(this.port, 2 * this.maxActiveClientCount);
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "doBind: " + this.sockListen.toString() + " bound to " + this.sockListen.getInetAddress() + " port " + this.sockListen.getLocalPort()));
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException.toString());
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.toString());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException.toString());
        }
        Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "doBind: end"));
    }

    protected void doProcess() throws CommunicationException, InterruptedException {
        this.addrLastClient = this.sock.getInetAddress();
        RequestHandler requestHandler = new RequestHandler(this.sock, this, this.cmf, this.objectName, this.servedClientCount++);
        this.sock = null;
    }

    protected void doReceive() throws CommunicationException, InterruptedException {
        try {
            this.sock = this.sockListen.accept();
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException.toString());
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.toString());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException.toString());
        }
    }

    protected void doUnbind() throws CommunicationException, InterruptedException {
        try {
            Debug.print((int)2, (Object)(String.valueOf(this.dbgTag) + "doUnbind: finally the port [" + this.port + "] has been closed"));
            this.sockListen.close();
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException.toString());
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.toString());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException.toString());
        }
    }

    public String getClassVersion() {
        return "@(#)AdaptorServerImpl.java 3.9 99/03/18 SMI";
    }

    public Boolean getFlattenView() {
        return new Boolean(this.flatten);
    }

    public String getLastConnectedClient() {
        if (this.addrLastClient == null) {
            return new String("unknown");
        }
        return this.addrLastClient.toString();
    }

    public String getPageBodyOption() {
        return this.bgColor;
    }

    public String getProtocol() {
        return "html";
    }

    public Boolean giveSortMbeanProperties() {
        return new Boolean(this.sortAtt);
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException {
        Hashtable hashtable = this.parseName(objectName);
        this.port = (Integer)hashtable.get(PORT);
        super.initCmf(framework, objectName, bl, modificationList);
    }

    public boolean isAuthenticationOn() {
        return this.authInfo.isEmpty() ^ true;
    }

    private Hashtable parseName(ObjectName objectName) throws IllegalArgumentException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(PROTOCOL, new String("html"));
        Integer n = (Integer)objectName.getProperty(PORT);
        if (n == null) {
            n = new Integer(this.port);
        }
        hashtable.put(PORT, n);
        return hashtable;
    }

    public void performStop() {
        block2: {
            if (!this.isActive()) break block2;
            super.performStop();
            try {
                Socket socket = new Socket(InetAddress.getLocalHost(), this.port);
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void removeUserAuthenticationInfo(AuthInfo authInfo) {
        if (authInfo != null) {
            String string = authInfo.getLogin();
            Enumeration enumeration = this.authInfo.elements();
            while (enumeration.hasMoreElements()) {
                AuthInfo authInfo2 = (AuthInfo)enumeration.nextElement();
                if (!authInfo2.getLogin().equals(string)) continue;
                this.authInfo.removeElement(authInfo2);
                break;
            }
        }
    }

    public void setFlattenView(Boolean bl) {
        if (bl != null) {
            this.flatten = bl;
        }
    }

    public void setPageBodyOption(String string) {
        this.bgColor = string == null || string.equals("") ? null : string;
    }

    public void setPort(Integer n) {
        this.port = n;
    }
}

