/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.html.internal;

import com.sun.jaw.impl.adaptor.generic.internal.ClientHandler;
import com.sun.jaw.impl.adaptor.generic.internal.HtmlBody;
import com.sun.jaw.impl.adaptor.generic.internal.HttpRequest;
import com.sun.jaw.impl.adaptor.generic.internal.HttpResponse;
import com.sun.jaw.impl.adaptor.generic.internal.MalformedHttpException;
import com.sun.jaw.impl.adaptor.html.AdaptorServerImpl;
import com.sun.jaw.impl.adaptor.html.internal.AdminPage;
import com.sun.jaw.impl.adaptor.html.internal.ArrayPage;
import com.sun.jaw.impl.adaptor.html.internal.InvokePage;
import com.sun.jaw.impl.adaptor.html.internal.MasterPage;
import com.sun.jaw.impl.adaptor.html.internal.ObjectPage;
import com.sun.jaw.impl.adaptor.security.internal.BASE64Decoder;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.ObjectName;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;

public class RequestHandler
extends ClientHandler {
    private final String sccs_id = new String("@(#)RequestHandler.java 3.3 99/03/18 SMI");
    private Socket sockClient = null;
    private String bgPageColor = null;
    private static final String dbgTag = "html.RequestHandler::";
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public RequestHandler(Socket socket, AdaptorServerImpl adaptorServerImpl, Framework framework, ObjectName objectName, int n) {
        super(adaptorServerImpl, n, framework, objectName);
        this.sockClient = socket;
        this.thread.start();
    }

    protected boolean authenticateRequest(HttpRequest httpRequest) throws IOException {
        boolean bl = true;
        AdaptorServerImpl adaptorServerImpl = (AdaptorServerImpl)this.adaptorServer;
        if (adaptorServerImpl.isAuthenticationOn()) {
            if (httpRequest.authorization == null || !httpRequest.authorization.startsWith("Basic ")) {
                bl = false;
            } else {
                String string = httpRequest.authorization.substring(6);
                byte[] byArray = new BASE64Decoder().decodeBuffer(string);
                String string2 = new String(byArray);
                bl = adaptorServerImpl.checkChallengeResponse(string2);
            }
        }
        return bl;
    }

    public void doRun() {
        Debug.print((int)2, (Object)"html.RequestHandler::doRun: start");
        try {
            try {
                HttpRequest httpRequest = new HttpRequest(new HtmlBody());
                boolean bl = true;
                while (bl) {
                    HttpResponse httpResponse = null;
                    try {
                        httpRequest.readFrom(this.sockClient.getInputStream());
                        httpResponse = this.processRequest(httpRequest);
                    }
                    catch (MalformedHttpException malformedHttpException) {
                        Debug.print((int)2, (Object)"html.RequestHandler::doRun: malformed request rejected");
                        httpResponse = this.makeErrorResponse(400);
                    }
                    httpResponse.writeTo(this.sockClient.getOutputStream());
                    boolean bl2 = bl = httpRequest.hasKeepAliveFlag() && httpResponse.statusCode == 200 && !this.interruptCalled;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                Debug.print((int)2, (Object)"html.RequestHandler::doRun: interrupted");
            }
            catch (EOFException eOFException) {
                Debug.print((int)2, (Object)"html.RequestHandler::doRun: connection closed by peer");
            }
            catch (SocketException socketException) {
                if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                    Debug.print((int)2, (Object)"html.RequestHandler::doRun: interrupted");
                } else {
                    Debug.print((int)2, (Object)"html.RequestHandler::doRun: i/o exception");
                    Debug.printException((Exception)socketException);
                }
            }
            catch (IOException iOException) {
                Debug.print((int)2, (Object)"html.RequestHandler::doRun: i/o exception");
                Debug.printException((Exception)iOException);
            }
            Object var2_6 = null;
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            try {
                this.sockClient.close();
                Debug.print((int)2, (Object)"html.RequestHandler::doRun: socket is now closed");
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            this.sockClient.close();
            Debug.print((int)2, (Object)"html.RequestHandler::doRun: socket is now closed");
        }
        catch (IOException iOException) {}
    }

    protected HttpResponse makeErrorResponse(int n) {
        return this.makeErrorResponse(n, null);
    }

    protected HttpResponse makeErrorResponse(int n, String string) {
        String string2 = new String("<HTML>\r\n<BODY>\r\n<P>" + string + "</P>" + "\r\n" + "<HR>" + "\r\n" + "<H1>" + n + "</H1>" + "\r\n" + "</BODY>" + "\r\n" + "</HTML>" + "\r\n");
        HttpResponse httpResponse = new HttpResponse(new HtmlBody(string2));
        httpResponse.statusCode = n;
        httpResponse.contentType = "text/html";
        httpResponse.date = new Date().toString();
        httpResponse.server = "JDMK/3.2";
        httpResponse.wwwAuthenticate = n == 401 ? "Basic realm=\"JDMK\"" : null;
        return httpResponse;
    }

    protected HttpResponse makeOkResponse(String string) {
        HtmlBody htmlBody = new HtmlBody(string);
        HttpResponse httpResponse = new HttpResponse(htmlBody);
        httpResponse.statusCode = 200;
        httpResponse.contentType = "text/html";
        httpResponse.date = new Date().toString();
        httpResponse.server = "JDMK/3.2";
        return httpResponse;
    }

    protected HttpResponse processGetRequest(HttpRequest httpRequest) throws IOException {
        String string = httpRequest.getURIPath();
        int n = 200;
        String string2 = null;
        AdaptorServerImpl adaptorServerImpl = (AdaptorServerImpl)this.adaptorServer;
        if (string.startsWith("/Request/")) {
            String string3 = string.substring(9);
            if (string3.equals("getDomain")) {
                string2 = String.valueOf(this.cmf.getDomain()) + ":";
            } else {
                n = 400;
            }
        } else if (string.startsWith("/ViewObjectRes")) {
            String string4 = string.substring("/ViewObjectRes".length());
            ObjectPage objectPage = new ObjectPage(this.cmf, true, true, adaptorServerImpl);
            objectPage.buildPage(string4);
            string2 = objectPage.getPage();
        } else if (string.startsWith("/AutoRefresh")) {
            String string5 = string.substring("/AutoRefresh".length());
            ObjectPage objectPage = new ObjectPage(this.cmf, true, true, adaptorServerImpl);
            objectPage.buildMeta(string5);
            objectPage.buildPage(string5.substring(0, string5.indexOf("?period=")));
            string2 = objectPage.getPage();
        } else if (string.startsWith("/ViewProperty")) {
            String string6 = string.substring("/ViewProperty".length());
            ArrayPage arrayPage = new ArrayPage(this.cmf, true, true, adaptorServerImpl);
            arrayPage.buildPage(string6);
            string2 = arrayPage.getPage();
        } else if (string.startsWith("/SetForm")) {
            String string7 = string.substring("/SetForm".length());
            int n2 = string7.indexOf(47, 1);
            int n3 = string7.indexOf(63);
            if (n2 < 0 || n3 < 0) {
                n = 400;
            } else {
                String string8 = string7.substring(n3);
                string7 = string7.substring(0, n3);
                ObjectPage objectPage = new ObjectPage(this.cmf, true, true, adaptorServerImpl);
                Debug.println((Object)("html.RequestHandler::doRun: SetForm for objName = [" + string7 + "] " + "request = [" + string8 + "]"));
                if (!objectPage.setObjectValue(string7, string8)) {
                    string2 = objectPage.getPage();
                } else {
                    objectPage.buildPage(string7);
                    string2 = objectPage.getPage();
                }
            }
        } else if (string.startsWith("/Admin")) {
            String string9 = string.substring("/Admin".length());
            string9 = string9.trim();
            AdminPage adminPage = new AdminPage(this.cmf, true, true, adaptorServerImpl.getPageBodyOption());
            adminPage.buildPage(string9);
            string2 = adminPage.getPage();
        } else if (string.startsWith("/InvokeAction")) {
            String string10 = string.substring("/InvokeAction".length());
            string10 = string10.trim();
            InvokePage invokePage = new InvokePage(this.cmf, true, true, adaptorServerImpl.getPageBodyOption());
            invokePage.buildPage(string10);
            string2 = invokePage.getPage();
        } else if (string.equals("/")) {
            MasterPage masterPage = new MasterPage(this.cmf, true, true, adaptorServerImpl.getPageBodyOption());
            masterPage.buildPage(string);
            string2 = masterPage.getPage();
        } else {
            n = 400;
        }
        HttpResponse httpResponse = n == 200 ? this.makeOkResponse(string2) : this.makeErrorResponse(n);
        return httpResponse;
    }

    protected HttpResponse processRequest(HttpRequest httpRequest) throws IOException {
        HttpResponse httpResponse = null;
        httpResponse = !this.authenticateRequest(httpRequest) ? this.makeErrorResponse(401) : (httpRequest.method == 1 ? this.processGetRequest(httpRequest) : this.makeErrorResponse(400));
        httpResponse.connection = httpRequest.connection;
        return httpResponse;
    }
}

