/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.rmi.internal;

import com.sun.jaw.impl.adaptor.rmi.AdaptorServerRmi;
import com.sun.jaw.impl.adaptor.rmi.internal.EventListenerHandlerRmi;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.InvalidPropertyValueException;
import com.sun.jaw.reference.common.LoaderRepository;
import com.sun.jaw.reference.common.Modification;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.NamedObject;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.common.PropertyList;
import com.sun.jaw.reference.common.PropertyNotFoundException;
import com.sun.jaw.reference.common.ServiceNotFoundException;
import com.sun.jaw.reference.query.QueryExp;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Vector;

public class AdaptorServerRmiImpl
extends UnicastRemoteObject
implements AdaptorServerRmi {
    private static final String sccs_id = "@(#)AdaptorServerRmiImpl.java 3.4 03/10/99 SMI";
    private Framework cmf = null;
    private String host = "localhost";
    private String serviceName = "com.sun.jaw.impl.adaptor.rmi.AdaptorServer";
    private int port = 1099;
    private boolean needRmiLoader;
    private boolean isActive = false;
    private static final String PORT = "port";
    private static final String SERVICE = "service";
    private static final String PROTOCOL = "protocol";
    private ObjectName masterName;
    private static String prefix = "rmi.internal.AdaptorServerRmiImpl::";

    public AdaptorServerRmiImpl(Framework framework, ObjectName objectName) throws RemoteException {
        this.masterName = objectName;
        this.needRmiLoader = true;
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
        }
        this.cmf = framework;
        Hashtable hashtable = this.parseName(objectName);
        this.serviceName = (String)hashtable.get(SERVICE);
        this.port = (Integer)hashtable.get(PORT);
        this.serviceName = AdaptorServerRmiImpl.makeManagedObjFactoryName(this.host, this.port, this.serviceName);
    }

    public Object SetIndexedValue(ObjectName objectName, String string, Object object, String string2, int n) throws InstanceNotFoundException, RemoteException, InvocationTargetException, IllegalAccessException, ServiceNotFoundException, PropertyNotFoundException, InvalidPropertyValueException, ClassNotFoundException, InstantiationException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        if (object != null) {
            this.updateRmiClassLoader(object);
        }
        return this.cmf.setIndexedValue(objectName, string, object, string2, n);
    }

    public Object SetValue(ObjectName objectName, String string, Object object, String string2) throws InstanceNotFoundException, RemoteException, InvocationTargetException, IllegalAccessException, ServiceNotFoundException, PropertyNotFoundException, InvalidPropertyValueException, ClassNotFoundException, InstantiationException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        if (object != null) {
            this.updateRmiClassLoader(object);
        }
        return this.cmf.setValue(objectName, string, object, string2);
    }

    public ObjectName addListener(ObjectName objectName, String string, String string2) throws InstanceNotFoundException, RemoteException, IllegalAccessException, ServiceNotFoundException, ClassNotFoundException, InstantiationException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        Object object = this.cmf.getMoRepSrvIf().retrieve(objectName);
        if (object == null) {
            Debug.print((int)2, (Object)(String.valueOf(prefix) + "addListener: Can't find object " + objectName.toString()));
            throw new InstanceNotFoundException(objectName.toString());
        }
        Vector vector = null;
        Object var6_6 = null;
        try {
            vector = this.cmf.addListener(objectName, object, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Debug.printException((Exception)invocationTargetException);
            throw new InstantiationException(invocationTargetException.getMessage());
        }
        var6_6 = vector.firstElement();
        EventListenerHandlerRmi eventListenerHandlerRmi = new EventListenerHandlerRmi(string2, this.masterName, objectName, var6_6, object, (String)vector.elementAt(1), (Class)vector.elementAt(2), this.cmf);
        Debug.print((int)2, (Object)(String.valueOf(prefix) + "addListener: instantiated EventListenerHandlerRmi"));
        ObjectName objectName2 = eventListenerHandlerRmi.getObjectName();
        Debug.print((int)2, (Object)("\twith name= " + objectName2.toString()));
        try {
            this.cmf.addObject(eventListenerHandlerRmi, objectName2);
        }
        catch (InstanceAlreadyExistException instanceAlreadyExistException) {
            Debug.printException((Exception)((Object)instanceAlreadyExistException));
            throw new RemoteException(instanceAlreadyExistException.getMessage());
        }
        return objectName2;
    }

    public void addObject(Object object, ObjectName objectName) throws ServiceNotFoundException, InstanceAlreadyExistException, RemoteException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        this.cmf.addObject(object, objectName);
    }

    public void bind() throws CommunicationException, RemoteException {
        Registry registry = null;
        Debug.print((int)2, (Object)(String.valueOf(prefix) + "bind: Register RMI object" + "\n\tBind with name " + this.serviceName));
        try {
            Naming.bind(this.serviceName, this);
        }
        catch (AlreadyBoundException alreadyBoundException) {
            Debug.print((int)2, (Object)(String.valueOf(prefix) + "bind: Attempt was made to bind an object in the registry to a name that already had an associated binding."));
            throw new ServiceNotFoundException("Fails to register " + this.serviceName);
        }
        catch (MalformedURLException malformedURLException) {
            Debug.print((int)2, (Object)(String.valueOf(prefix) + "bind: " + this.serviceName + " is not an appropriately formatted URL."));
            throw new ServiceNotFoundException("Fails to register " + this.serviceName);
        }
        catch (AccessException accessException) {
            Debug.print((int)2, (Object)(String.valueOf(prefix) + "bind: Permission to perform a binding in the registry has been denied."));
            throw new ServiceNotFoundException("Fails to register " + this.serviceName);
        }
        catch (RemoteException remoteException) {
            Debug.print((int)2, (Object)(String.valueOf(prefix) + "bind: Try to start a local registry on port " + this.port));
            registry = LocateRegistry.createRegistry(this.port);
            try {
                Naming.bind(this.serviceName, this);
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
                throw new ServiceNotFoundException("Fails to register " + this.serviceName);
            }
        }
        this.isActive = true;
    }

    public void deleteMO(ObjectName objectName) throws RemoteException, InvocationTargetException, ServiceNotFoundException, InstanceNotFoundException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        this.cmf.delObject(objectName);
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public String getDomain() throws RemoteException {
        return this.cmf.getDomain();
    }

    public Object getIndexedValue(ObjectName objectName, String string, int n) throws InstanceNotFoundException, RemoteException, PropertyNotFoundException, ServiceNotFoundException, InvocationTargetException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        return this.cmf.getIndexedValue(objectName, string, n);
    }

    public Vector getObject(ObjectName objectName, QueryExp queryExp) throws RemoteException, InstanceNotFoundException, ServiceNotFoundException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        Debug.print((int)2, (Object)(String.valueOf(prefix) + "getObject: \n\tname= " + objectName));
        Vector vector = this.cmf.getObject(objectName, queryExp);
        Debug.print((int)2, (Object)(String.valueOf(prefix) + "getObject: \n\tFound " + vector.size() + " objects"));
        Vector<ObjectName> vector2 = new Vector<ObjectName>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            NamedObject namedObject = (NamedObject)vector.elementAt(n2);
            vector2.addElement(namedObject.getName());
            ++n2;
        }
        return vector2;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return "rmi";
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Object getValue(ObjectName objectName, String string) throws InstanceNotFoundException, RemoteException, PropertyNotFoundException, ServiceNotFoundException, InvocationTargetException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        return this.cmf.getValue(objectName, string);
    }

    public PropertyList getValues(ObjectName objectName, Vector vector) throws InstanceNotFoundException, RemoteException, ServiceNotFoundException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        return this.cmf.getValues(objectName, vector);
    }

    public Object invokePerform(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, RemoteException, InvocationTargetException, ServiceNotFoundException, NoSuchMethodException, IllegalAccessException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        if (objectArray != null && this.needRmiLoader) {
            int n = 0;
            while (n < objectArray.length) {
                this.updateRmiClassLoader(objectArray[n]);
                ++n;
            }
        }
        return this.cmf.invokePerform(objectName, string, objectArray, stringArray);
    }

    static String makeManagedObjFactoryName(String string, int n, String string2) {
        return "rmi://" + string + ":" + n + "/" + string2;
    }

    public Vector newDBMO(String string, ObjectName objectName, ModificationList modificationList) throws RemoteException, IllegalAccessException, ClassNotFoundException, ServiceNotFoundException, InstanceAlreadyExistException, InstantiationException, InvocationTargetException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        return this.newMO(string, objectName, modificationList, true, null);
    }

    public Vector newDBMO(String string, ObjectName objectName, ModificationList modificationList, ObjectName objectName2) throws RemoteException, IllegalAccessException, ClassNotFoundException, ServiceNotFoundException, InstanceAlreadyExistException, InstantiationException, InvocationTargetException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        return this.newMO(string, objectName, modificationList, true, objectName2);
    }

    public Vector newMO(String string, ObjectName objectName, ModificationList modificationList) throws RemoteException, IllegalAccessException, ClassNotFoundException, ServiceNotFoundException, InstanceAlreadyExistException, InstantiationException, InvocationTargetException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        return this.newMO(string, objectName, modificationList, false, null);
    }

    public Vector newMO(String string, ObjectName objectName, ModificationList modificationList, ObjectName objectName2) throws RemoteException, IllegalAccessException, ClassNotFoundException, ServiceNotFoundException, InstanceAlreadyExistException, InstantiationException, InvocationTargetException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        return this.newMO(string, objectName, modificationList, false, objectName2);
    }

    private Vector newMO(String string, ObjectName objectName, ModificationList modificationList, boolean bl, ObjectName objectName2) throws RemoteException, IllegalAccessException, ClassNotFoundException, ServiceNotFoundException, InstanceAlreadyExistException, InstantiationException, InvocationTargetException {
        boolean bl2 = string == null || string.length() == 0;
        Object object = null;
        object = bl ? this.cmf.newDBObject(string, objectName, objectName2, modificationList) : this.cmf.newObject(string, objectName, objectName2, modificationList);
        Vector<ObjectName> vector = new Vector<ObjectName>(2);
        vector.addElement(objectName);
        return vector;
    }

    public void newObj(String string) throws RemoteException, IllegalAccessException, InstantiationException, ClassNotFoundException, ServiceNotFoundException, InvocationTargetException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        this.cmf.newObj(string);
    }

    public void newObj(String string, ObjectName objectName) throws RemoteException, IllegalAccessException, InstantiationException, ClassNotFoundException, ServiceNotFoundException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        this.cmf.newObj(string, objectName);
    }

    private Hashtable parseName(ObjectName objectName) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(PROTOCOL, new String("rmi"));
        Integer n = (Integer)objectName.getProperty(PORT);
        if (n == null) {
            n = new Integer(this.port);
        }
        hashtable.put(PORT, n);
        String string = (String)objectName.getProperty(SERVICE);
        if (string == null) {
            string = this.serviceName;
        }
        hashtable.put(SERVICE, string);
        return hashtable;
    }

    public void removeListener(ObjectName objectName) throws RemoteException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        Debug.print((int)2, (Object)(String.valueOf(prefix) + "removeListener: name= " + objectName));
        try {
            this.cmf.delObject(objectName);
        }
        catch (RuntimeException runtimeException) {
            Debug.printException((Exception)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
        }
    }

    public PropertyList setValues(ObjectName objectName, ModificationList modificationList) throws InstanceNotFoundException, RemoteException, ServiceNotFoundException {
        if (!this.isActive) {
            throw new RemoteException("Adaptor is stopped.");
        }
        if (modificationList != null && this.needRmiLoader) {
            int n = modificationList.size();
            int n2 = 0;
            while (n2 < n) {
                Modification modification = (Modification)modificationList.elementAt(n2);
                this.updateRmiClassLoader(modification.getValue());
                ++n2;
            }
        }
        return this.cmf.setValues(objectName, modificationList);
    }

    public void unbind() {
        Debug.print((int)2, (Object)(String.valueOf(prefix) + "unbind: Remove object in registry with name :"));
        Debug.print((int)2, (Object)("\t'" + this.serviceName + "'"));
        try {
            Naming.unbind(this.serviceName);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
        }
        this.isActive = false;
    }

    private synchronized void updateRmiClassLoader(Object object) {
        if (!this.needRmiLoader) {
            return;
        }
        if (object == null) {
            return;
        }
        ClassLoader classLoader = object.getClass().getClassLoader();
        if (classLoader != null) {
            this.needRmiLoader = false;
            LoaderRepository.addClassLoader((ClassLoader)classLoader);
        }
    }
}

