/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.rmi.internal;

import com.sun.jaw.impl.adaptor.generic.AdaptorListener;
import com.sun.jaw.impl.adaptor.generic.AdaptorServer;
import com.sun.jaw.impl.adaptor.generic.AdaptorStateChangeEvent;
import com.sun.jaw.impl.adaptor.generic.internal.EventHandlers;
import com.sun.jaw.impl.adaptor.rmi.internal.EvtRcvClient;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.cmf.FrameworkEvent;
import com.sun.jaw.reference.agent.cmf.FrameworkListener;
import com.sun.jaw.reference.agent.services.EventHandlerIf;
import com.sun.jaw.reference.agent.services.EventObjectIfAgt;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.common.ServiceNotFoundException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;

public class EventListenerHandlerRmi
implements EventHandlerIf,
FrameworkListener,
AdaptorListener {
    private static final String sccs_id = "@(#)EventListenerHandlerRmi.java 3.1 09/29/98 SMI";
    private ObjectName name;
    private ObjectName masterName;
    private transient AdaptorServer master;
    private Framework cmf = null;
    private transient Object source;
    private ObjectName mo;
    private transient Object listener;
    private transient Class ifClass;
    private String loName;
    private transient EvtRcvClient eventReceiver;
    private transient String receiver;
    private static final Integer DELETE_EVT = new Integer(2);

    public EventListenerHandlerRmi(String string, ObjectName objectName, ObjectName objectName2, Object object, Object object2, String string2, Class clazz, Framework framework) throws RemoteException, ServiceNotFoundException, IllegalAccessException {
        this.receiver = string;
        this.source = object2;
        this.listener = object;
        this.mo = objectName2;
        this.cmf = framework;
        this.loName = string2;
        this.ifClass = clazz;
        this.masterName = objectName;
        try {
            this.eventReceiver = (EvtRcvClient)Naming.lookup(string);
            if (this.eventReceiver == null) {
                Debug.print((int)2, (Object)"EventListenerHandlerRmi::handleEvent: receiver is null");
            }
        }
        catch (Exception exception) {
            throw new RemoteException("Can't contact RMI management event server at " + string);
        }
        String string3 = framework.getDomain();
        try {
            this.name = new ObjectName(String.valueOf(string3) + ":" + "com.sun.jaw.reference.agent.services.EventHandlerIfMO" + ".counter=" + EventHandlers.getCounter());
        }
        catch (Exception exception) {}
        this.master = (AdaptorServer)framework.getMoRepSrvIf().retrieve(this.masterName);
        if (this.master == null) {
            throw new ServiceNotFoundException("Invalid adaptor.");
        }
        this.master.addAdaptorListener(this);
        framework.addFrameworkListener(this);
    }

    public synchronized void deleteCmf() {
        Debug.print((int)2, (Object)("EventListenerHandlerRmi::deleteCmf: delete " + this.name));
        try {
            this.cmf.removeListener(this.source, this.listener, this.loName, this.ifClass);
            this.cmf.removeFrameworkListener(this);
            if (this.master == null) {
                this.master = (AdaptorServer)this.cmf.getMoRepSrvIf().retrieve(this.masterName);
                if (this.master == null) {
                    return;
                }
            }
            this.master.removeAdaptorListener(this);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
        }
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public ObjectName getEmitter() {
        return this.mo;
    }

    public String getListener() {
        return this.receiver;
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    public synchronized void handleAdaptorStateChange(AdaptorStateChangeEvent adaptorStateChangeEvent) {
        int n = adaptorStateChangeEvent.getNewState();
        if (n != 1) {
            return;
        }
        Debug.print((int)2, (Object)("EventListenerHandlerRmi::handleAdaptorStateChange: delete " + this.name));
        try {
            this.cmf.delObject(this.name);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
        }
    }

    public void handleEvent(EventObject eventObject, ObjectName objectName) throws CommunicationException {
        Debug.print((int)2, (Object)("EventListenerHandlerRmi::handleEvent: " + eventObject.toString()));
        if (eventObject.getSource() != this.listener) {
            return;
        }
        if (!(eventObject instanceof EventObjectIfAgt)) {
            Debug.print((int)2, (Object)"EventListenerHandlerRmi.handleEvent: event is not a EventObjectIfMO");
            return;
        }
        try {
            String string = ((EventObjectIfAgt)eventObject).getMethodName();
            EventListenerHandlerRmi eventListenerHandlerRmi = this;
            synchronized (eventListenerHandlerRmi) {
                Debug.print((int)2, (Object)("EventListenerHandlerRmi::handleEvent: about to send event to\n\t" + this.eventReceiver));
                this.eventReceiver.handleEvent(eventObject, this.mo, string, this.name);
            }
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            throw new CommunicationException(exception.getMessage());
        }
    }

    public void handleFrameworkEvent(FrameworkEvent frameworkEvent) {
        if (!frameworkEvent.getEventType().equals(DELETE_EVT)) {
            return;
        }
        Vector vector = frameworkEvent.getEventObjectNames();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ObjectName objectName = (ObjectName)enumeration.nextElement();
            if (!objectName.equals((Object)this.mo)) continue;
            Debug.print((int)2, (Object)("EventListenerHandlerRmi::handleFrameworkEvent: delete " + this.name));
            try {
                this.cmf.delObject(this.name);
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
            }
        }
    }
}

