/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.snmp;

import com.sun.jaw.impl.adaptor.IPacl.Jawacl;
import com.sun.jaw.impl.adaptor.generic.AdaptorServer;
import com.sun.jaw.impl.adaptor.snmp.internal.MibTree;
import com.sun.jaw.impl.adaptor.snmp.internal.RequestHandler;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.IPAclSrvIf;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.snmp.agent.SnmpMibAgent;
import com.sun.jaw.snmp.agent.SnmpMibHandlerSrvIf;
import com.sun.jaw.snmp.common.SnmpDefinitions;
import com.sun.jaw.snmp.common.SnmpIpAddress;
import com.sun.jaw.snmp.common.SnmpMessage;
import com.sun.jaw.snmp.common.SnmpOid;
import com.sun.jaw.snmp.common.SnmpPduFactory;
import com.sun.jaw.snmp.common.SnmpPduFactoryIf;
import com.sun.jaw.snmp.common.SnmpPduPacket;
import com.sun.jaw.snmp.common.SnmpPduRequest;
import com.sun.jaw.snmp.common.SnmpPduTrap;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.common.SnmpTimeticks;
import com.sun.jaw.snmp.common.SnmpTooBigException;
import com.sun.jaw.snmp.common.SnmpValue;
import com.sun.jaw.snmp.common.SnmpVarBind;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class AdaptorServerImpl
extends AdaptorServer
implements SnmpDefinitions,
SnmpMibHandlerSrvIf {
    private int port = 161;
    private int trapPort = 162;
    private transient DatagramSocket socket = null;
    private transient DatagramSocket trapSocket = null;
    private transient DatagramPacket packet = null;
    private transient Vector mibs = new Vector();
    private transient MibTree root;
    private IPAclSrvIf ipacl = null;
    private SnmpPduFactoryIf pduFactory = null;
    private boolean authRespEnabled = true;
    private boolean authTrapEnabled = true;
    private SnmpOid enterpriseOid = new SnmpOid("1.3.6.1.4.1.42");
    private transient long startUpTime = 0L;
    private final String sccs_id = "@(#)AdaptorServerImpl.java 3.12 03/18/99 SMI";
    private static final String PORT = "port";
    private int snmpOutTraps = 0;
    private int snmpOutGetResponses = 0;
    private int snmpOutGenErrs = 0;
    private int snmpOutBadValues = 0;
    private int snmpOutNoSuchNames = 0;
    private int snmpOutTooBigs = 0;
    private int snmpOutPkts = 0;
    private int snmpInASNParseErrs = 0;
    private int snmpInBadCommunityUses = 0;
    private int snmpInBadCommunityNames = 0;
    private int snmpInBadVersions = 0;
    private int snmpInGetRequests = 0;
    private int snmpInGetNexts = 0;
    private int snmpInSetRequests = 0;
    private int snmpInPkts = 0;
    private int snmpInTotalReqVars = 0;
    private int snmpInTotalSetVars = 0;
    private int bufferSize = 1024;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    private static final SnmpOid sysUpTimeOid = new SnmpOid("1.3.6.1.2.1.1.3.0");
    private static final SnmpOid snmpTrapOidOid = new SnmpOid("1.3.6.1.6.3.1.1.4.1.0");

    public AdaptorServerImpl() {
        this(161);
        this.root = new MibTree();
    }

    public AdaptorServerImpl(int n) {
        try {
            Jawacl jawacl = new Jawacl("SNMP adaptor IP ACL");
            this.init(jawacl, n);
        }
        catch (UnknownHostException unknownHostException) {
            Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "ctor: UnknowHostException when creating ACL"));
        }
    }

    public AdaptorServerImpl(IPAclSrvIf iPAclSrvIf) {
        this.init(iPAclSrvIf, 161);
    }

    public AdaptorServerImpl(IPAclSrvIf iPAclSrvIf, int n) {
        this.init(iPAclSrvIf, n);
    }

    public void addMib(SnmpMibAgent snmpMibAgent) throws IllegalArgumentException {
        if (snmpMibAgent == null) {
            throw new IllegalArgumentException();
        }
        this.mibs.addElement(snmpMibAgent);
        this.root.register(snmpMibAgent);
        this.root.setDefaultAgent(snmpMibAgent);
        System.out.println("Adding mib : " + snmpMibAgent.getMibName());
    }

    private synchronized void closeTrapSocketIfNeeded() {
        if (this.trapSocket != null && this.state != 0) {
            this.trapSocket.close();
            this.trapSocket = null;
        }
    }

    protected void doBind() throws CommunicationException, InterruptedException {
        try {
            this.socket = new DatagramSocket(this.port);
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "doBind: cannot bind on port " + this.port));
            throw new CommunicationException((Throwable)socketException);
        }
    }

    protected void doProcess() throws CommunicationException, InterruptedException {
    }

    protected void doReceive() throws CommunicationException, InterruptedException {
        try {
            this.packet = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
            this.socket.receive(this.packet);
            new RequestHandler(this, this.servedClientCount++, this.socket, this.packet, this.root, this.mibs, this.ipacl, this.pduFactory, this.cmf, this.objectName);
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException((Throwable)socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.toString());
        }
        catch (Exception exception) {
            throw new CommunicationException((Throwable)exception);
        }
        if (Debug.isLevelSet((int)2048)) {
            Debug.printFormatted((Object)(String.valueOf(this.dbgTag) + "doReceive: received a message"));
        }
    }

    protected void doUnbind() throws CommunicationException, InterruptedException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.closeTrapSocketIfNeeded();
    }

    protected void finalize() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public boolean getAuthRespEnabled() {
        return this.authRespEnabled;
    }

    public boolean getAuthTrapEnabled() {
        return this.authTrapEnabled;
    }

    public Integer getBufferSize() {
        return new Integer(this.bufferSize);
    }

    public String getClassVersion() {
        return "@(#)AdaptorServerImpl.java 3.12 03/18/99 SMI";
    }

    public String getEnterpriseOid() {
        return this.enterpriseOid.toString();
    }

    public String[] getMibs() {
        String[] stringArray = new String[this.mibs.size()];
        int n = 0;
        Enumeration enumeration = this.mibs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpMibAgent snmpMibAgent = (SnmpMibAgent)enumeration.nextElement();
            stringArray[n++] = snmpMibAgent.getMibName();
        }
        return stringArray;
    }

    public Integer getPort() {
        return new Integer(this.port);
    }

    public String getProtocol() {
        return "snmp";
    }

    public Long getSnmpInASNParseErrs() {
        return new Long(this.snmpInASNParseErrs);
    }

    public Long getSnmpInBadCommunityNames() {
        return new Long(this.snmpInBadCommunityNames);
    }

    public Long getSnmpInBadCommunityUses() {
        return new Long(this.snmpInBadCommunityUses);
    }

    public Long getSnmpInBadVersions() {
        return new Long(this.snmpInBadVersions);
    }

    public Long getSnmpInGetNexts() {
        return new Long(this.snmpInGetNexts);
    }

    public Long getSnmpInGetRequests() {
        return new Long(this.snmpInGetRequests);
    }

    public Long getSnmpInPkts() {
        return new Long(this.snmpInPkts);
    }

    public Long getSnmpInSetRequests() {
        return new Long(this.snmpInSetRequests);
    }

    public Long getSnmpInTotalReqVars() {
        return new Long(this.snmpInTotalReqVars);
    }

    public Long getSnmpInTotalSetVars() {
        return new Long(this.snmpInTotalSetVars);
    }

    public Long getSnmpOutBadValues() {
        return new Long(this.snmpOutBadValues);
    }

    public Long getSnmpOutGenErrs() {
        return new Long(this.snmpOutGenErrs);
    }

    public Long getSnmpOutGetResponses() {
        return new Long(this.snmpOutGetResponses);
    }

    public Long getSnmpOutNoSuchNames() {
        return new Long(this.snmpOutNoSuchNames);
    }

    public Long getSnmpOutPkts() {
        return new Long(this.snmpOutPkts);
    }

    public Long getSnmpOutTooBigs() {
        return new Long(this.snmpOutTooBigs);
    }

    public Long getSnmpOutTraps() {
        return new Long(this.snmpOutTraps);
    }

    private long getSysUpTime() {
        return (System.currentTimeMillis() - this.startUpTime) / 10L;
    }

    public Integer getTrapPort() {
        return new Integer(this.trapPort);
    }

    public void incSnmpInASNParseErrs(int n) {
        this.snmpInASNParseErrs += n;
    }

    public void incSnmpInBadCommunityNames(int n) {
        this.snmpInBadCommunityNames += n;
    }

    public void incSnmpInBadCommunityUses(int n) {
        this.snmpInBadCommunityUses += n;
    }

    public void incSnmpInBadVersions(int n) {
        this.snmpInBadVersions += n;
    }

    private void init(IPAclSrvIf iPAclSrvIf, int n) {
        this.root = new MibTree();
        this.startUpTime = System.currentTimeMillis();
        this.maxActiveClientCount = 10;
        this.pduFactory = new SnmpPduFactory();
        this.port = n;
        this.ipacl = iPAclSrvIf;
        if (this.ipacl == null) {
            throw new IllegalArgumentException("ACL object cannot be null");
        }
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException {
        Integer n = (Integer)objectName.getProperty(PORT);
        if (n != null) {
            this.port = n;
        }
        super.initCmf(framework, objectName, bl, modificationList);
    }

    public boolean isAuthRespEnabled() {
        return this.authRespEnabled;
    }

    public boolean isAuthTrapEnabled() {
        return this.authTrapEnabled;
    }

    private synchronized void openTrapSocketIfNeeded() throws SocketException {
        if (this.trapSocket == null) {
            this.trapSocket = new DatagramSocket();
            Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "openTrapSocketIfNeeded: using port " + this.trapSocket.getLocalPort() + " to send traps"));
        }
    }

    public void performStop() {
        block2: {
            Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "Stopping: using port " + this.port + " \n"));
            if (!this.isActive()) break block2;
            super.performStop();
            try {
                DatagramSocket datagramSocket = new DatagramSocket(0);
                byte[] byArray = new byte[1];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 1, InetAddress.getLocalHost(), this.port);
                Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "Sending: using port " + this.port + " \n"));
                datagramSocket.send(datagramPacket);
                datagramSocket.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.mibs = new Vector();
    }

    public Boolean removeMib(SnmpMibAgent snmpMibAgent) {
        this.root.unregister(snmpMibAgent);
        return new Boolean(this.mibs.removeElement(snmpMibAgent));
    }

    public void sendTrap(int n, int n2, Vector vector) throws IOException, SnmpStatusException {
        Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendTrap: generic=" + n + " specific=" + n2));
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.address = null;
        snmpPduTrap.port = this.trapPort;
        snmpPduTrap.type = 164;
        snmpPduTrap.version = 0;
        snmpPduTrap.community = null;
        snmpPduTrap.enterprise = this.enterpriseOid;
        snmpPduTrap.genericTrap = n;
        snmpPduTrap.specificTrap = n2;
        snmpPduTrap.timeStamp = this.getSysUpTime();
        if (vector != null) {
            snmpPduTrap.varBindList = new SnmpVarBind[vector.size()];
            vector.copyInto(snmpPduTrap.varBindList);
        } else {
            snmpPduTrap.varBindList = null;
        }
        try {
            snmpPduTrap.agentAddr = new SnmpIpAddress(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            snmpPduTrap.agentAddr = new SnmpIpAddress("0.0.0.0");
        }
        this.sendTrapPdu((SnmpPduPacket)snmpPduTrap);
    }

    private void sendTrapMessage(SnmpMessage snmpMessage) throws IOException, SnmpTooBigException {
        byte[] byArray = new byte[this.bufferSize];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        int n = snmpMessage.encodeMessage(byArray);
        datagramPacket.setLength(n);
        datagramPacket.setAddress(snmpMessage.address);
        datagramPacket.setPort(snmpMessage.port);
        Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendTrapMessage: sending trap to " + snmpMessage.address + ":" + snmpMessage.port));
        this.trapSocket.send(datagramPacket);
        Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendTrapMessage: sent to " + snmpMessage.address + ":" + snmpMessage.port));
        ++this.snmpOutTraps;
        ++this.snmpOutPkts;
    }

    private void sendTrapPdu(SnmpPduPacket snmpPduPacket) throws SnmpStatusException, IOException {
        SnmpMessage snmpMessage = null;
        try {
            snmpMessage = this.pduFactory.encodePdu(snmpPduPacket, this.bufferSize);
            if (snmpMessage == null) {
                throw new SnmpStatusException(16);
            }
        }
        catch (SnmpTooBigException snmpTooBigException) {
            Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendTrapPdu: trap pdu is too big"));
            Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendTrapPdu: trap hasn't been sent to anyone"));
            throw new SnmpStatusException(1);
        }
        int n = 0;
        this.openTrapSocketIfNeeded();
        Enumeration enumeration = this.ipacl.getTrapDestinations();
        while (enumeration.hasMoreElements()) {
            snmpMessage.address = (InetAddress)enumeration.nextElement();
            Enumeration enumeration2 = this.ipacl.getTrapCommunities(snmpMessage.address);
            while (enumeration2.hasMoreElements()) {
                snmpMessage.community = ((String)enumeration2.nextElement()).getBytes();
                try {
                    this.sendTrapMessage(snmpMessage);
                    ++n;
                }
                catch (SnmpTooBigException snmpTooBigException) {
                    Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendTrapPdu: trap pdu is too big"));
                    Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendTrapPdu: trap hasn't been sent to " + snmpMessage.address));
                }
            }
        }
        if (n == 0) {
            try {
                snmpMessage.address = InetAddress.getLocalHost();
                this.sendTrapMessage(snmpMessage);
            }
            catch (SnmpTooBigException snmpTooBigException) {
                Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendTrapPdu: trap pdu is too big"));
                Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendTrapPdu: trap has not been sent"));
            }
            catch (UnknownHostException unknownHostException) {
                Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendTrapPdu: cannot get the local host"));
                Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendTrapPdu: trap has not been sent"));
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    public void sendV2Trap(SnmpOid snmpOid, Vector vector) throws IOException, SnmpStatusException {
        Debug.print((int)2048, (Object)(String.valueOf(this.dbgTag) + "sendV2Trap: trapOid=" + snmpOid));
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.address = null;
        snmpPduRequest.port = this.trapPort;
        snmpPduRequest.type = 167;
        snmpPduRequest.version = 1;
        snmpPduRequest.community = null;
        Vector<SnmpVarBind> vector2 = vector != null ? (Vector<SnmpVarBind>)vector.clone() : new Vector<SnmpVarBind>(2);
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        vector2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, (SnmpValue)snmpOid), 0);
        vector2.insertElementAt(new SnmpVarBind(sysUpTimeOid, (SnmpValue)snmpTimeticks), 0);
        snmpPduRequest.varBindList = new SnmpVarBind[vector2.size()];
        vector2.copyInto(snmpPduRequest.varBindList);
        this.sendTrapPdu((SnmpPduPacket)snmpPduRequest);
    }

    public void setAuthRespEnabled(boolean bl) {
        this.authRespEnabled = bl;
    }

    public void setAuthTrapEnabled(boolean bl) {
        this.authTrapEnabled = bl;
    }

    public void setBufferSize(Integer n) {
        this.bufferSize = n;
    }

    public void setEnterpriseOid(String string) throws IllegalArgumentException {
        this.enterpriseOid = new SnmpOid(string);
    }

    public void setTrapPort(Integer n) {
        int n2 = n;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.trapPort = n2;
    }

    public void updateErrorCounters(int n) {
        switch (n) {
            case 0: {
                ++this.snmpOutGetResponses;
                break;
            }
            case 5: {
                ++this.snmpOutGenErrs;
                break;
            }
            case 3: {
                ++this.snmpOutBadValues;
                break;
            }
            case 2: {
                ++this.snmpOutNoSuchNames;
                break;
            }
            case 1: {
                ++this.snmpOutTooBigs;
                break;
            }
        }
        ++this.snmpOutPkts;
    }

    public void updateRequestCounters(int n) {
        switch (n) {
            case 160: {
                ++this.snmpInGetRequests;
                break;
            }
            case 161: {
                ++this.snmpInGetNexts;
                break;
            }
            case 163: {
                ++this.snmpInSetRequests;
                break;
            }
        }
        ++this.snmpInPkts;
    }

    public void updateVarCounters(int n, int n2) {
        switch (n) {
            case 160: 
            case 161: 
            case 165: {
                this.snmpInTotalReqVars += n2;
                break;
            }
            case 163: {
                this.snmpInTotalSetVars += n2;
                break;
            }
        }
    }

    public void usePduFactory(SnmpPduFactoryIf snmpPduFactoryIf) {
        this.pduFactory = snmpPduFactoryIf == null ? new SnmpPduFactory() : snmpPduFactoryIf;
    }
}

