/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.snmp.internal;

import com.sun.jaw.impl.adaptor.snmp.internal.MibTree;
import com.sun.jaw.snmp.agent.SnmpMibAgent;
import com.sun.jaw.snmp.common.SnmpOid;
import java.util.Enumeration;
import java.util.Vector;

public final class MibTree {
    private SnmpMibAgent defaultAgent = null;
    private TreeNode root = new TreeNode(null, -1L, null, null);

    public MibTree() {
    }

    public SnmpMibAgent getAgentMib(SnmpOid snmpOid) {
        TreeNode treeNode = this.root.retrieveMatchingBranch(snmpOid.longValue(), 0);
        if (treeNode == null) {
            return this.defaultAgent;
        }
        return treeNode.getAgentMib();
    }

    public SnmpMibAgent getDefaultAgent() {
        return this.defaultAgent;
    }

    public void printTree() {
        this.root.printTree(">");
    }

    public void register(SnmpMibAgent snmpMibAgent) {
        this.root.registerNode(snmpMibAgent);
    }

    public void setDefaultAgent(SnmpMibAgent snmpMibAgent) {
        this.defaultAgent = snmpMibAgent;
        this.root.agent = snmpMibAgent;
    }

    public void unregister(SnmpMibAgent snmpMibAgent) {
        long[] lArray = snmpMibAgent.getRootOid();
        TreeNode treeNode = this.root.retrieveMatchingBranch(lArray, 0);
        if (treeNode == null) {
            return;
        }
        treeNode.removeAgent(snmpMibAgent);
    }

    final class TreeNode {
        private Vector children = new Vector();
        private Vector agents = new Vector();
        private long nodeValue;
        protected SnmpMibAgent agent;
        private TreeNode parent;

        private TreeNode(long l, SnmpMibAgent snmpMibAgent, TreeNode treeNode) {
            this.nodeValue = l;
            this.agent = snmpMibAgent;
            this.parent = treeNode;
            this.agents.addElement(snmpMibAgent);
        }

        /* synthetic */ TreeNode(1 var2_2, long l, SnmpMibAgent snmpMibAgent, TreeNode treeNode) {
            this(l, snmpMibAgent, treeNode);
        }

        SnmpMibAgent getAgentMib() {
            return this.agent;
        }

        private final boolean match(long l) {
            return this.nodeValue == l;
        }

        public void printTree(String string) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.agents == null) {
                System.out.println(String.valueOf(string) + "node= " + this.nodeValue + " mibs= no mib");
                return;
            }
            Enumeration enumeration = this.agents.elements();
            while (enumeration.hasMoreElements()) {
                object = (SnmpMibAgent)enumeration.nextElement();
                if (object == null) {
                    stringBuffer.append("empty ");
                    continue;
                }
                stringBuffer.append(String.valueOf(((SnmpMibAgent)object).getMibName()) + " ");
            }
            string = String.valueOf(string) + " ";
            System.out.println(String.valueOf(string) + "node= " + this.nodeValue + " mibs= " + stringBuffer.toString());
            if (this.children == null) {
                return;
            }
            object = this.children.elements();
            while (object.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)object.nextElement();
                treeNode.printTree(string);
            }
        }

        void registerNode(SnmpMibAgent snmpMibAgent) {
            long[] lArray = snmpMibAgent.getRootOid();
            this.registerNode(lArray, 0, snmpMibAgent);
        }

        private void registerNode(long[] lArray, int n, SnmpMibAgent snmpMibAgent) {
            if (n >= lArray.length) {
                return;
            }
            TreeNode treeNode = this.retrieveChild(lArray, n);
            if (treeNode == null) {
                long l = lArray[n];
                treeNode = new TreeNode(l, snmpMibAgent, this);
                this.children.addElement(treeNode);
            }
            if (!this.agents.contains(snmpMibAgent)) {
                this.agents.addElement(snmpMibAgent);
            }
            treeNode.registerNode(lArray, n + 1, snmpMibAgent);
        }

        private void removeAgent(SnmpMibAgent snmpMibAgent) {
            if (!this.agents.contains(snmpMibAgent)) {
                return;
            }
            this.agents.removeElement(snmpMibAgent);
            if (this.agents.isEmpty()) {
                if (this.parent == null) {
                    return;
                }
                this.parent.children.removeElement(this);
                this.parent.removeAgent(snmpMibAgent);
                return;
            }
            this.agent = (SnmpMibAgent)this.agents.firstElement();
            if (this.parent != null) {
                this.parent.removeAgent(snmpMibAgent);
            }
        }

        private TreeNode retrieveChild(long[] lArray, int n) {
            long l = lArray[n];
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                if (!treeNode.match(l)) continue;
                return treeNode;
            }
            return null;
        }

        TreeNode retrieveMatchingBranch(long[] lArray, int n) {
            TreeNode treeNode = this.retrieveChild(lArray, n);
            if (treeNode == null) {
                return this;
            }
            if (this.children.size() == 0) {
                return treeNode;
            }
            if (n + 1 == lArray.length) {
                return treeNode;
            }
            return treeNode.retrieveMatchingBranch(lArray, n + 1);
        }
    }
}

