/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.snmp.internal;

import com.sun.jaw.impl.adaptor.generic.internal.ClientHandler;
import com.sun.jaw.impl.adaptor.snmp.AdaptorServerImpl;
import com.sun.jaw.impl.adaptor.snmp.internal.MibTree;
import com.sun.jaw.impl.adaptor.snmp.internal.SubBulkRequestHandler;
import com.sun.jaw.impl.adaptor.snmp.internal.SubNextRequestHandler;
import com.sun.jaw.impl.adaptor.snmp.internal.SubRequestHandler;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.IPAclSrvIf;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.snmp.agent.SnmpMibAgent;
import com.sun.jaw.snmp.common.SnmpDefinitions;
import com.sun.jaw.snmp.common.SnmpMessage;
import com.sun.jaw.snmp.common.SnmpPduBulk;
import com.sun.jaw.snmp.common.SnmpPduFactoryIf;
import com.sun.jaw.snmp.common.SnmpPduPacket;
import com.sun.jaw.snmp.common.SnmpPduRequest;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.common.SnmpTooBigException;
import com.sun.jaw.snmp.common.SnmpValue;
import com.sun.jaw.snmp.common.SnmpVarBind;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RequestHandler
extends ClientHandler
implements SnmpDefinitions {
    private final String sccs_id = new String("@(#)RequestHandler.java 3.12 99/03/26 SMI");
    private transient DatagramSocket socket = null;
    private transient DatagramPacket packet = null;
    private transient Vector mibs = null;
    private transient Hashtable subs = null;
    private transient MibTree root;
    private transient IPAclSrvIf ipacl = null;
    private transient SnmpPduFactoryIf pduFactory = null;
    private static final String dbgTag = "snmp.RequestHandler::";
    private static final String InterruptSysCallMsg = "Interrupted system call";
    private static final SnmpStatusException noSuchNameException = new SnmpStatusException(2);

    public RequestHandler(AdaptorServerImpl adaptorServerImpl, int n, DatagramSocket datagramSocket, DatagramPacket datagramPacket, MibTree mibTree, Vector vector, IPAclSrvIf iPAclSrvIf, SnmpPduFactoryIf snmpPduFactoryIf, Framework framework, ObjectName objectName) {
        super(adaptorServerImpl, n, framework, objectName);
        this.socket = datagramSocket;
        this.packet = datagramPacket;
        this.root = mibTree;
        this.mibs = (Vector)vector.clone();
        this.subs = new Hashtable(this.mibs.size());
        this.ipacl = iPAclSrvIf;
        this.pduFactory = snmpPduFactoryIf;
        this.thread.start();
    }

    private SnmpPduPacket checkAcl(SnmpPduPacket snmpPduPacket) {
        SnmpPduRequest snmpPduRequest = null;
        String string = new String(snmpPduPacket.community);
        if (snmpPduPacket.type == 163) {
            if (!this.ipacl.checkWritePermission(snmpPduPacket.address, string)) {
                Debug.print((int)2048, (Object)("snmp.RequestHandler::checkAcl: sender is " + snmpPduPacket.address + " with " + string));
                Debug.print((int)2048, (Object)"snmp.RequestHandler::checkAcl: sender has no write permission");
                snmpPduRequest = this.newErrorResponsePdu(snmpPduPacket, 4, 0);
            }
        } else if (!this.ipacl.checkReadPermission(snmpPduPacket.address, string)) {
            Debug.print((int)2048, (Object)("snmp.RequestHandler::checkAcl: sender is " + snmpPduPacket.address + " with " + string));
            Debug.print((int)2048, (Object)"snmp.RequestHandler::checkAcl: sender has no read permission");
            snmpPduRequest = this.newErrorResponsePdu(snmpPduPacket, 2, 0);
        }
        if (snmpPduRequest != null) {
            AdaptorServerImpl adaptorServerImpl = (AdaptorServerImpl)this.adaptorServer;
            adaptorServerImpl.incSnmpInBadCommunityUses(1);
            if (!this.ipacl.checkCommunity(string)) {
                adaptorServerImpl.incSnmpInBadCommunityNames(1);
            }
        }
        return snmpPduRequest;
    }

    private boolean checkPduType(SnmpPduPacket snmpPduPacket) {
        boolean bl = true;
        switch (snmpPduPacket.type) {
            case 160: 
            case 161: 
            case 163: 
            case 165: {
                bl = true;
                break;
            }
            default: {
                Debug.print((int)2048, (Object)"snmp.RequestHandler::checkPduType: cannot respond to this kind of PDU");
                bl = false;
            }
        }
        return bl;
    }

    public void doRun() {
        block7: {
            if (Debug.isLevelSet((int)4096)) {
                Debug.print((int)2048, (Object)("Packet received:\n" + SnmpMessage.dumpHexBuffer((byte[])this.packet.getData(), (int)0, (int)this.packet.getLength())));
            }
            DatagramPacket datagramPacket = this.makeResponsePacket(this.packet);
            if (Debug.isLevelSet((int)4096) && datagramPacket != null) {
                Debug.print((int)2048, (Object)("Packet to be sent:\n" + SnmpMessage.dumpHexBuffer((byte[])datagramPacket.getData(), (int)0, (int)datagramPacket.getLength())));
            }
            if (datagramPacket == null) break block7;
            try {
                this.socket.send(datagramPacket);
            }
            catch (SocketException socketException) {
                if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                    Debug.print((int)2048, (Object)"snmp.RequestHandler::doRun: interrupted");
                    break block7;
                }
                Debug.print((int)2048, (Object)"snmp.RequestHandler::doRun: i/o exception");
                Debug.printException((Exception)socketException);
            }
            catch (InterruptedIOException interruptedIOException) {
                Debug.print((int)2048, (Object)"snmp.RequestHandler::doRun: interrupted");
            }
            catch (Exception exception) {
                Debug.print((int)2048, (Object)"snmp.RequestHandler::doRun: failure when sending response");
                Debug.printException((Exception)exception);
            }
        }
    }

    private SnmpPduPacket executeSubRequest(SnmpPduPacket snmpPduPacket) {
        SubRequestHandler subRequestHandler;
        Enumeration enumeration;
        Enumeration enumeration2;
        int n;
        int n2 = 0;
        int n3 = this.subs.size();
        Thread[] threadArray = new Thread[n3];
        if (snmpPduPacket.type == 163) {
            n = 0;
            enumeration2 = this.subs.elements();
            while (enumeration2.hasMoreElements()) {
                enumeration = (SubRequestHandler)enumeration2.nextElement();
                ((SubRequestHandler)((Object)enumeration)).type = 253;
                threadArray[n] = this.cmf == null ? new Thread((Runnable)((Object)enumeration)) : this.cmf.getThreadAllocatorSrvIf().obtainThread((Object)this.objectName, (Runnable)((Object)enumeration));
                threadArray[n].start();
                ++n;
            }
            n = 0;
            enumeration = this.subs.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    threadArray[n].join();
                }
                catch (InterruptedException interruptedException) {}
                subRequestHandler = (SubRequestHandler)enumeration.nextElement();
                subRequestHandler.type = 163;
                n2 = subRequestHandler.getErrorStatus();
                if (n2 != 0) {
                    return this.newErrorResponsePdu(snmpPduPacket, n2, subRequestHandler.getErrorIndex() + 1);
                }
                ++n;
            }
        }
        n = 0;
        enumeration2 = this.subs.elements();
        while (enumeration2.hasMoreElements()) {
            enumeration = (SubRequestHandler)enumeration2.nextElement();
            threadArray[n] = this.cmf == null ? new Thread((Runnable)((Object)enumeration)) : this.cmf.getThreadAllocatorSrvIf().obtainThread((Object)this.objectName, (Runnable)((Object)enumeration));
            threadArray[n].start();
            ++n;
        }
        n = 0;
        enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            try {
                threadArray[n].join();
            }
            catch (InterruptedException interruptedException) {}
            subRequestHandler = (SubRequestHandler)enumeration.nextElement();
            n2 = subRequestHandler.getErrorStatus();
            if (n2 != 0) {
                Debug.print((int)2048, (Object)"snmp.RequestHandler::makeGetSetResponsePdu: an error occurs.");
                int n4 = subRequestHandler.getErrorIndex() + 1;
                return this.newErrorResponsePdu(snmpPduPacket, n2, n4);
            }
            ++n;
        }
        return null;
    }

    private SnmpPduPacket makeGetBulkResponsePdu(SnmpPduBulk snmpPduBulk) {
        SnmpVarBind[] snmpVarBindArray = null;
        int n = snmpPduBulk.varBindList.length;
        int n2 = Math.max(Math.min(snmpPduBulk.nonRepeaters, n), 0);
        int n3 = Math.max(snmpPduBulk.maxRepetitions, 0);
        int n4 = n - n2;
        if (snmpPduBulk.varBindList == null) {
            return this.newValidResponsePdu((SnmpPduPacket)snmpPduBulk, null);
        }
        this.splitBulkRequest(snmpPduBulk, n2, n3, n4);
        SnmpPduPacket snmpPduPacket = this.executeSubRequest((SnmpPduPacket)snmpPduBulk);
        if (snmpPduPacket != null) {
            return snmpPduPacket;
        }
        snmpVarBindArray = this.mergeBulkResponses(n2 + n3 * n4);
        int n5 = snmpVarBindArray.length;
        while (n5 > n2 && snmpVarBindArray[n5 - 1].value.equals(SnmpVarBind.endOfMibView)) {
            --n5;
        }
        int n6 = n5 == n2 ? n2 + n4 : n2 + ((n5 - 1 - n2) / n4 + 2) * n4;
        if (n6 < snmpVarBindArray.length) {
            SnmpVarBind[] snmpVarBindArray2 = new SnmpVarBind[n6];
            int n7 = 0;
            while (n7 < n6) {
                snmpVarBindArray2[n7] = snmpVarBindArray[n7];
                ++n7;
            }
            snmpVarBindArray = snmpVarBindArray2;
        }
        return this.newValidResponsePdu((SnmpPduPacket)snmpPduBulk, snmpVarBindArray);
    }

    private SnmpPduPacket makeGetSetResponsePdu(SnmpPduRequest snmpPduRequest) {
        if (snmpPduRequest.varBindList == null) {
            return this.newValidResponsePdu((SnmpPduPacket)snmpPduRequest, null);
        }
        this.splitRequest(snmpPduRequest);
        int n = this.subs.size();
        if (n == 1) {
            return this.turboProcessingGetSet(snmpPduRequest);
        }
        SnmpPduPacket snmpPduPacket = this.executeSubRequest((SnmpPduPacket)snmpPduRequest);
        if (snmpPduPacket != null) {
            return snmpPduPacket;
        }
        Debug.print((int)2048, (Object)("snmp.RequestHandler::makeGetSetResponsePdu: Build the unified response for request " + snmpPduRequest.requestId));
        return this.mergeResponses(snmpPduRequest);
    }

    private SnmpMessage makeResponseMessage(SnmpMessage snmpMessage) {
        SnmpMessage snmpMessage2;
        block18: {
            snmpMessage2 = null;
            SnmpPduPacket snmpPduPacket = null;
            try {
                snmpPduPacket = this.pduFactory.decodePdu(snmpMessage);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpPduPacket = null;
                AdaptorServerImpl adaptorServerImpl = (AdaptorServerImpl)this.adaptorServer;
                adaptorServerImpl.incSnmpInASNParseErrs(1);
                if (snmpStatusException.getStatus() == 243) {
                    adaptorServerImpl.incSnmpInBadVersions(1);
                }
                Debug.print((int)2048, (Object)"snmp.RequestHandler::makeResponseMessage: message decoding failed");
            }
            SnmpPduPacket snmpPduPacket2 = null;
            if (snmpPduPacket != null) {
                snmpPduPacket2 = this.makeResponsePdu(snmpPduPacket);
            }
            if (snmpPduPacket2 == null) break block18;
            try {
                snmpMessage2 = this.pduFactory.encodePdu(snmpPduPacket2, this.packet.getData().length);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMessage2 = null;
                Debug.print((int)2048, (Object)"snmp.RequestHandler::makeResponseMessage: failure when encoding the response message");
                Debug.printException((Exception)((Object)snmpStatusException));
            }
            catch (SnmpTooBigException snmpTooBigException) {
                Debug.print((int)2048, (Object)"snmp.RequestHandler::makeResponseMessage: response message is too big");
                try {
                    if (this.packet.getData().length <= 32) {
                        throw snmpTooBigException;
                    }
                    int n = snmpTooBigException.getVarBindCount();
                    Debug.print((int)2048, (Object)("snmp.RequestHandler::makeResponseMessage: fail on element " + n));
                    int n2 = 0;
                    while (true) {
                        try {
                            snmpPduPacket2 = this.reduceResponsePdu(snmpPduPacket, snmpPduPacket2, n);
                            snmpMessage2 = this.pduFactory.encodePdu(snmpPduPacket2, this.packet.getData().length - 32);
                        }
                        catch (SnmpTooBigException snmpTooBigException2) {
                            Debug.print((int)2048, (Object)"snmp.RequestHandler::makeResponseMessage: response message is still too big");
                            n2 = n;
                            n = snmpTooBigException2.getVarBindCount();
                            Debug.print((int)2048, (Object)("snmp.RequestHandler::makeResponseMessage: fail on element " + n));
                            if (n != n2) continue;
                            throw snmpTooBigException2;
                        }
                        break;
                    }
                }
                catch (SnmpStatusException snmpStatusException) {
                    snmpMessage2 = null;
                    Debug.print((int)2048, (Object)"snmp.RequestHandler::makeResponseMessage: failure when encoding the response message");
                    Debug.printException((Exception)((Object)snmpTooBigException));
                }
                catch (SnmpTooBigException snmpTooBigException3) {
                    try {
                        snmpPduPacket2 = this.newTooBigPdu(snmpPduPacket);
                        snmpMessage2 = this.pduFactory.encodePdu(snmpPduPacket2, this.packet.getData().length);
                    }
                    catch (SnmpTooBigException snmpTooBigException4) {
                        snmpMessage2 = null;
                        Debug.print((int)2048, (Object)"snmp.RequestHandler::makeResponseMessage: 'too big' is 'too big' !!!");
                    }
                    catch (Exception exception) {
                        snmpMessage2 = null;
                    }
                }
                catch (Exception exception) {
                    snmpMessage2 = null;
                }
            }
        }
        return snmpMessage2;
    }

    private DatagramPacket makeResponsePacket(DatagramPacket datagramPacket) {
        DatagramPacket datagramPacket2;
        block7: {
            datagramPacket2 = null;
            SnmpMessage snmpMessage = new SnmpMessage();
            try {
                snmpMessage.decodeMessage(datagramPacket.getData(), datagramPacket.getLength());
                snmpMessage.address = datagramPacket.getAddress();
                snmpMessage.port = datagramPacket.getPort();
            }
            catch (SnmpStatusException snmpStatusException) {
                Debug.print((int)2048, (Object)"snmp.RequestHandler::makeResponsePacket: packet decoding failed");
                snmpMessage = null;
                ((AdaptorServerImpl)this.adaptorServer).incSnmpInASNParseErrs(1);
            }
            SnmpMessage snmpMessage2 = null;
            if (snmpMessage != null) {
                snmpMessage2 = this.makeResponseMessage(snmpMessage);
            }
            if (snmpMessage2 == null) break block7;
            try {
                datagramPacket.setLength(snmpMessage2.encodeMessage(datagramPacket.getData()));
                datagramPacket2 = datagramPacket;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                Debug.print((int)2048, (Object)"snmp.RequestHandler::makeResponsePacket: response message is too big");
                try {
                    snmpMessage2 = this.newTooBigMessage(snmpMessage);
                    datagramPacket.setLength(snmpMessage2.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    Debug.print((int)2048, (Object)"snmp.RequestHandler::makeResponsePacket: 'too big' is 'too big' !!!");
                }
            }
        }
        return datagramPacket2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SnmpPduPacket makeResponsePdu(SnmpPduPacket snmpPduPacket) {
        AdaptorServerImpl adaptorServerImpl = (AdaptorServerImpl)this.adaptorServer;
        SnmpPduPacket snmpPduPacket2 = null;
        adaptorServerImpl.updateRequestCounters(snmpPduPacket.type);
        if (snmpPduPacket.varBindList != null) {
            adaptorServerImpl.updateVarCounters(snmpPduPacket.type, snmpPduPacket.varBindList.length);
        }
        if (!this.checkPduType(snmpPduPacket)) return snmpPduPacket2;
        snmpPduPacket2 = this.checkAcl(snmpPduPacket);
        if (snmpPduPacket2 == null) {
            switch (snmpPduPacket.type) {
                case 160: 
                case 161: 
                case 163: {
                    return this.makeGetSetResponsePdu((SnmpPduRequest)snmpPduPacket);
                }
                case 165: {
                    return this.makeGetBulkResponsePdu((SnmpPduBulk)snmpPduPacket);
                }
                default: {
                    return snmpPduPacket2;
                }
            }
        }
        if (!adaptorServerImpl.getAuthRespEnabled()) {
            snmpPduPacket2 = null;
        }
        if (!adaptorServerImpl.getAuthTrapEnabled()) return snmpPduPacket2;
        try {
            adaptorServerImpl.sendTrap(4, 0, new Vector());
            return snmpPduPacket2;
        }
        catch (Exception exception) {
            Debug.print((int)2048, (Object)"snmp.RequestHandler::makeResponsePdu: failure when sending authentication trap !!!");
            Debug.printException((Exception)exception);
        }
        return snmpPduPacket2;
    }

    private SnmpVarBind[] mergeBulkResponses(int n) {
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            snmpVarBindArray[n2] = new SnmpVarBind();
            snmpVarBindArray[n2].value = SnmpVarBind.endOfMibView;
            --n2;
        }
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SubRequestHandler subRequestHandler = (SubRequestHandler)enumeration.nextElement();
            subRequestHandler.updateResult(snmpVarBindArray);
        }
        return snmpVarBindArray;
    }

    private SnmpPduPacket mergeNextResponses(SnmpPduRequest snmpPduRequest) {
        int n = snmpPduRequest.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SubRequestHandler subRequestHandler = (SubRequestHandler)enumeration.nextElement();
            subRequestHandler.updateResult(snmpVarBindArray);
        }
        if (snmpPduRequest.version == 1) {
            return this.newValidResponsePdu((SnmpPduPacket)snmpPduRequest, snmpVarBindArray);
        }
        int n2 = 0;
        while (n2 < n) {
            SnmpValue snmpValue = snmpVarBindArray[n2].value;
            if (snmpValue == SnmpVarBind.endOfMibView) {
                return this.newErrorResponsePdu((SnmpPduPacket)snmpPduRequest, 2, n2 + 1);
            }
            ++n2;
        }
        return this.newValidResponsePdu((SnmpPduPacket)snmpPduRequest, snmpVarBindArray);
    }

    private SnmpPduPacket mergeResponses(SnmpPduRequest snmpPduRequest) {
        if (snmpPduRequest.type == 161) {
            return this.mergeNextResponses(snmpPduRequest);
        }
        SnmpVarBind[] snmpVarBindArray = snmpPduRequest.varBindList;
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SubRequestHandler subRequestHandler = (SubRequestHandler)enumeration.nextElement();
            subRequestHandler.updateResult(snmpVarBindArray);
        }
        return this.newValidResponsePdu((SnmpPduPacket)snmpPduRequest, snmpVarBindArray);
    }

    private SnmpPduRequest newErrorResponsePdu(SnmpPduPacket snmpPduPacket, int n, int n2) {
        SnmpPduRequest snmpPduRequest = this.newValidResponsePdu(snmpPduPacket, null);
        snmpPduRequest.errorStatus = n;
        snmpPduRequest.errorIndex = n2;
        snmpPduRequest.varBindList = snmpPduPacket.varBindList;
        ((AdaptorServerImpl)this.adaptorServer).updateErrorCounters(snmpPduRequest.errorStatus);
        return snmpPduRequest;
    }

    private SnmpMessage newTooBigMessage(SnmpMessage snmpMessage) throws SnmpTooBigException {
        SnmpMessage snmpMessage2 = null;
        SnmpPduPacket snmpPduPacket = null;
        try {
            snmpPduPacket = this.pduFactory.decodePdu(snmpMessage);
            if (snmpPduPacket != null) {
                SnmpPduPacket snmpPduPacket2 = this.newTooBigPdu(snmpPduPacket);
                snmpMessage2 = this.pduFactory.encodePdu(snmpPduPacket2, this.packet.getData().length);
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            throw new InternalError();
        }
        return snmpMessage2;
    }

    private SnmpPduPacket newTooBigPdu(SnmpPduPacket snmpPduPacket) {
        SnmpPduRequest snmpPduRequest = this.newErrorResponsePdu(snmpPduPacket, 1, 0);
        snmpPduRequest.varBindList = null;
        return snmpPduRequest;
    }

    private SnmpPduRequest newValidResponsePdu(SnmpPduPacket snmpPduPacket, SnmpVarBind[] snmpVarBindArray) {
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.address = snmpPduPacket.address;
        snmpPduRequest.port = snmpPduPacket.port;
        snmpPduRequest.version = snmpPduPacket.version;
        snmpPduRequest.community = snmpPduPacket.community;
        snmpPduRequest.type = 162;
        snmpPduRequest.requestId = snmpPduPacket.requestId;
        snmpPduRequest.errorStatus = 0;
        snmpPduRequest.errorIndex = 0;
        snmpPduRequest.varBindList = snmpVarBindArray;
        ((AdaptorServerImpl)this.adaptorServer).updateErrorCounters(snmpPduRequest.errorStatus);
        return snmpPduRequest;
    }

    private SnmpPduPacket reduceResponsePdu(SnmpPduPacket snmpPduPacket, SnmpPduPacket snmpPduPacket2, int n) throws SnmpTooBigException {
        if (snmpPduPacket.type != 165) {
            Debug.print((int)2048, (Object)"snmp.RequestHandler::reduceResponsePdu: cannot remove anything");
            throw new SnmpTooBigException(n);
        }
        int n2 = snmpPduPacket2.varBindList.length;
        n2 = n >= 3 ? Math.min(n - 1, snmpPduPacket2.varBindList.length) : (n == 1 ? 1 : snmpPduPacket2.varBindList.length / 2);
        if (n2 < 1) {
            Debug.print((int)2048, (Object)"snmp.RequestHandler::reduceResponsePdu: cannot remove anything");
            throw new SnmpTooBigException(n);
        }
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        int n3 = 0;
        while (n3 < n2) {
            snmpVarBindArray[n3] = snmpPduPacket2.varBindList[n3];
            ++n3;
        }
        Debug.print((int)2048, (Object)("snmp.RequestHandler::reduceResponsePdu: " + (snmpPduPacket2.varBindList.length - snmpVarBindArray.length) + " items have been removed"));
        snmpPduPacket2.varBindList = snmpVarBindArray;
        return snmpPduPacket2;
    }

    private void splitBulkRequest(SnmpPduBulk snmpPduBulk, int n, int n2, int n3) {
        SubBulkRequestHandler subBulkRequestHandler;
        int n4 = this.mibs.size();
        SnmpMibAgent snmpMibAgent = (SnmpMibAgent)this.mibs.firstElement();
        if (n4 == 1) {
            this.subs.put(snmpMibAgent, new SubBulkRequestHandler(snmpMibAgent, snmpPduBulk, n, n2, n3, true));
            return;
        }
        int n5 = snmpPduBulk.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = snmpPduBulk.varBindList;
        int n6 = 0;
        while (n6 < n) {
            snmpMibAgent = this.root.getAgentMib(snmpVarBindArray[n6].oid);
            subBulkRequestHandler = (SubBulkRequestHandler)this.subs.get(snmpMibAgent);
            if (subBulkRequestHandler == null) {
                subBulkRequestHandler = new SubBulkRequestHandler(snmpMibAgent, snmpPduBulk, n2, n3);
                this.subs.put(snmpMibAgent, subBulkRequestHandler);
            }
            subBulkRequestHandler.updateRequestNonRepeater(snmpVarBindArray[n6], n6);
            ++n6;
        }
        if (n2 == 0) {
            return;
        }
        int n7 = n;
        while (n7 < n5) {
            snmpMibAgent = this.root.getAgentMib(snmpVarBindArray[n7].oid);
            subBulkRequestHandler = (SubBulkRequestHandler)this.subs.get(snmpMibAgent);
            if (subBulkRequestHandler == null) {
                subBulkRequestHandler = new SubBulkRequestHandler(snmpMibAgent, snmpPduBulk, n2, n3);
                this.subs.put(snmpMibAgent, subBulkRequestHandler);
            }
            subBulkRequestHandler.updateRequest(snmpVarBindArray[n7], n7);
            ++n7;
        }
    }

    private void splitRequest(SnmpPduRequest snmpPduRequest) {
        int n = this.mibs.size();
        SnmpMibAgent snmpMibAgent = (SnmpMibAgent)this.mibs.firstElement();
        if (n == 1) {
            this.subs.put(snmpMibAgent, new SubRequestHandler(snmpMibAgent, (SnmpPduPacket)snmpPduRequest, true));
            return;
        }
        if (snmpPduRequest.type == 161) {
            Enumeration enumeration = this.mibs.elements();
            while (enumeration.hasMoreElements()) {
                SnmpMibAgent snmpMibAgent2 = (SnmpMibAgent)enumeration.nextElement();
                this.subs.put(snmpMibAgent2, new SubNextRequestHandler(snmpMibAgent2, (SnmpPduPacket)snmpPduRequest));
            }
            return;
        }
        int n2 = snmpPduRequest.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = snmpPduRequest.varBindList;
        int n3 = 0;
        while (n3 < n2) {
            snmpMibAgent = this.root.getAgentMib(snmpVarBindArray[n3].oid);
            SubRequestHandler subRequestHandler = (SubRequestHandler)this.subs.get(snmpMibAgent);
            if (subRequestHandler == null) {
                subRequestHandler = new SubRequestHandler(snmpMibAgent, (SnmpPduPacket)snmpPduRequest);
                this.subs.put(snmpMibAgent, subRequestHandler);
            }
            subRequestHandler.updateRequest(snmpVarBindArray[n3], n3);
            ++n3;
        }
    }

    private SnmpPduPacket turboProcessingGetSet(SnmpPduRequest snmpPduRequest) {
        int n = 0;
        SubRequestHandler subRequestHandler = (SubRequestHandler)this.subs.elements().nextElement();
        if (snmpPduRequest.type == 163) {
            subRequestHandler.type = 253;
            subRequestHandler.run();
            subRequestHandler.type = 163;
            n = subRequestHandler.getErrorStatus();
            if (n != 0) {
                return this.newErrorResponsePdu((SnmpPduPacket)snmpPduRequest, n, subRequestHandler.getErrorIndex() + 1);
            }
        }
        subRequestHandler.run();
        n = subRequestHandler.getErrorStatus();
        if (n != 0) {
            Debug.print((int)2048, (Object)"snmp.RequestHandler::turboProcessingGetSet: an error occurs.");
            int n2 = subRequestHandler.getErrorIndex() + 1;
            return this.newErrorResponsePdu((SnmpPduPacket)snmpPduRequest, n, n2);
        }
        if (Debug.isLevelSet((int)2048)) {
            Debug.printFormatted((Object)("snmp.RequestHandler::turboProcessingGetSet: Build the unified response for request " + snmpPduRequest.requestId));
        }
        return this.mergeResponses(snmpPduRequest);
    }
}

