/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.snmp.internal;

import com.sun.jaw.impl.adaptor.snmp.internal.SubRequestHandler;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.agent.SnmpMibAgent;
import com.sun.jaw.snmp.common.SnmpPduBulk;
import com.sun.jaw.snmp.common.SnmpPduPacket;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.common.SnmpVarBind;
import java.util.Enumeration;

class SubBulkRequestHandler
extends SubRequestHandler {
    protected int nonRepeat = 0;
    protected int maxRepeat = 0;
    protected int globalR = 0;
    protected int size = 0;
    private static final String dbgTag = "snmp.SubBulkRequestHandler::";

    protected SubBulkRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPduBulk snmpPduBulk, int n, int n2) {
        super(snmpMibAgent, (SnmpPduPacket)snmpPduBulk);
        this.nonRepeat = 0;
        this.maxRepeat = n;
        this.globalR = n2;
    }

    protected SubBulkRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPduBulk snmpPduBulk, int n, int n2, int n3, boolean bl) {
        super(snmpMibAgent, (SnmpPduPacket)snmpPduBulk, true);
        this.nonRepeat = n;
        this.maxRepeat = n2;
        this.globalR = n3;
    }

    public void run() {
        this.size = this.varBind.size();
        try {
            if (Debug.isLevelSet((int)2048)) {
                Debug.printFormatted((Object)("snmp.SubBulkRequestHandler::run[" + Thread.currentThread() + "]: getBulk operation on " + this.agent.getMibName()));
            }
            this.agent.getBulk(this.varBind, this.nonRepeat, this.maxRepeat, this.version);
        }
        catch (SnmpStatusException snmpStatusException) {
            this.errorStatus = snmpStatusException.getStatus();
            this.errorIndex = snmpStatusException.getErrorIndex();
            Debug.print((int)2048, (Object)("snmp.SubBulkRequestHandler::run[" + Thread.currentThread() + "]:  a Snmp error occured during the operation."));
        }
        catch (Exception exception) {
            this.errorStatus = 5;
            Debug.print((int)2048, (Object)("snmp.SubBulkRequestHandler::run[" + Thread.currentThread() + "]:  a generic error occured during the operation."));
        }
        if (Debug.isLevelSet((int)2048)) {
            Debug.printFormatted((Object)("snmp.SubBulkRequestHandler::run[" + Thread.currentThread() + "]:  operation completed."));
        }
    }

    protected void updateRequestNonRepeater(SnmpVarBind snmpVarBind, int n) {
        this.updateRequest(snmpVarBind, n);
        ++this.nonRepeat;
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        SnmpVarBind snmpVarBind;
        int n;
        Enumeration enumeration = this.varBind.elements();
        int n2 = snmpVarBindArray.length;
        int n3 = 0;
        while (n3 < this.size) {
            if (!enumeration.hasMoreElements()) {
                return;
            }
            n = this.translation[n3];
            if (n >= n2) {
                Debug.print((int)2048, (Object)("snmp.SubBulkRequestHandler::run[" + Thread.currentThread() + "]: updateResult,Position `" + n + "' is out of bound..."));
            } else {
                snmpVarBindArray[n] = snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            }
            ++n3;
        }
        n = this.size - this.nonRepeat;
        int n4 = 2;
        while (n4 <= this.maxRepeat) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = (n4 - 1) * this.globalR + this.translation[this.nonRepeat + n5];
                if (n6 >= n2) {
                    return;
                }
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                snmpVarBindArray[n6] = snmpVarBind = (SnmpVarBind)enumeration.nextElement();
                ++n5;
            }
            ++n4;
        }
    }
}

