/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.snmp.internal;

import com.sun.jaw.impl.adaptor.snmp.internal.SubRequestHandler;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.agent.SnmpMibAgent;
import com.sun.jaw.snmp.common.SnmpPduPacket;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.common.SnmpValue;
import com.sun.jaw.snmp.common.SnmpVarBind;

class SubNextRequestHandler
extends SubRequestHandler {
    private static final String dbgTag = "snmp.SubNextRequestHandler::";

    protected SubNextRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPduPacket snmpPduPacket) {
        super(snmpMibAgent, snmpPduPacket);
        int n = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPduPacket.varBindList;
        int n2 = 0;
        while (n2 < n) {
            this.translation[n2] = n2;
            ((SubRequestHandler.NonSyncVector)this.varBind).addNonSyncElement(new SnmpVarBind(snmpVarBindArray[n2].oid, snmpVarBindArray[n2].value));
            ++n2;
        }
    }

    public void run() {
        try {
            if (Debug.isLevelSet((int)2048)) {
                Debug.printFormatted((Object)("snmp.SubNextRequestHandler::run[" + Thread.currentThread() + "]: getNext operation on " + this.agent.getMibName()));
            }
            this.agent.getNext(this.varBind, 1);
        }
        catch (SnmpStatusException snmpStatusException) {
            this.errorStatus = snmpStatusException.getStatus();
            this.errorIndex = snmpStatusException.getErrorIndex();
            Debug.print((int)2048, (Object)("snmp.SubNextRequestHandler::run[" + Thread.currentThread() + "]:  a Snmp error occured during the operation."));
        }
        catch (Exception exception) {
            this.errorStatus = 5;
            Debug.print((int)2048, (Object)("snmp.SubNextRequestHandler::run[" + Thread.currentThread() + "]:  a generic error occured during the operation."));
        }
        if (Debug.isLevelSet((int)2048)) {
            Debug.printFormatted((Object)("snmp.SubNextRequestHandler::run[" + Thread.currentThread() + "]:  operation completed."));
        }
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        int n = this.varBind.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.translation[n2];
            SnmpVarBind snmpVarBind = (SnmpVarBind)((SubRequestHandler.NonSyncVector)this.varBind).elementAtNonSync(n2);
            SnmpVarBind snmpVarBind2 = snmpVarBindArray[n3];
            if (snmpVarBind2 == null) {
                snmpVarBindArray[n3] = snmpVarBind;
            } else {
                SnmpValue snmpValue = snmpVarBind2.value;
                if (snmpValue == null || snmpValue == SnmpVarBind.endOfMibView) {
                    snmpVarBindArray[n3] = snmpVarBind;
                } else if (snmpVarBind.value != SnmpVarBind.endOfMibView && snmpVarBind.oid.compareTo(snmpVarBind2.oid) <= 0) {
                    snmpVarBindArray[n3] = snmpVarBind;
                }
            }
            ++n2;
        }
    }
}

