/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.snmp.internal;

import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.snmp.agent.SnmpMibAgent;
import com.sun.jaw.snmp.common.SnmpDefinitions;
import com.sun.jaw.snmp.common.SnmpPduPacket;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.common.SnmpVarBind;
import java.util.Vector;

class SubRequestHandler
implements SnmpDefinitions,
Runnable {
    protected int version = 0;
    protected int type = 0;
    protected SnmpMibAgent agent;
    protected int errorStatus = 0;
    protected int errorIndex = -1;
    protected Vector varBind;
    protected int[] translation;
    private static final String dbgTag = "snmp.SubRequestHandler::";

    protected SubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPduPacket snmpPduPacket) {
        if (Debug.isLevelSet((int)2048)) {
            Debug.printFormatted((Object)("snmp.SubRequestHandler::SubRequestHandler: creating instance for request " + String.valueOf(snmpPduPacket.requestId)));
        }
        this.version = snmpPduPacket.version;
        this.type = snmpPduPacket.type;
        this.agent = snmpMibAgent;
        int n = snmpPduPacket.varBindList.length;
        this.translation = new int[n];
        this.varBind = new NonSyncVector(n);
    }

    protected SubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPduPacket snmpPduPacket, boolean bl) {
        this(snmpMibAgent, snmpPduPacket);
        int n = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPduPacket.varBindList;
        int n2 = 0;
        while (n2 < n) {
            this.translation[n2] = n2;
            ((NonSyncVector)this.varBind).addNonSyncElement(snmpVarBindArray[n2]);
            ++n2;
        }
    }

    protected int getErrorIndex() {
        if (this.errorStatus == 0) {
            return -1;
        }
        if (this.errorIndex == 0 || this.errorIndex == -1) {
            this.errorIndex = 1;
        }
        return this.translation[this.errorIndex - 1];
    }

    protected int getErrorStatus() {
        if (this.errorStatus == 0) {
            return 0;
        }
        if (this.version == 0 && (this.errorStatus == 224 || this.errorStatus == 225)) {
            return 2;
        }
        return this.errorStatus;
    }

    public void run() {
        try {
            switch (this.type) {
                case 160: {
                    if (Debug.isLevelSet((int)2048)) {
                        Debug.printFormatted((Object)("snmp.SubRequestHandler::run[" + Thread.currentThread() + "]: get operation on " + this.agent.getMibName()));
                    }
                    this.agent.get(this.varBind, this.version);
                    break;
                }
                case 161: {
                    if (Debug.isLevelSet((int)2048)) {
                        Debug.printFormatted((Object)("snmp.SubRequestHandler::run[" + Thread.currentThread() + "]: getNext operation on " + this.agent.getMibName()));
                    }
                    this.agent.getNext(this.varBind, this.version);
                    break;
                }
                case 163: {
                    if (Debug.isLevelSet((int)2048)) {
                        Debug.printFormatted((Object)("snmp.SubRequestHandler::run[" + Thread.currentThread() + "]: set operation on " + this.agent.getMibName()));
                    }
                    this.agent.set(this.varBind, this.version);
                    break;
                }
                case 253: {
                    if (Debug.isLevelSet((int)2048)) {
                        Debug.printFormatted((Object)("snmp.SubRequestHandler::run[" + Thread.currentThread() + "]: check operation on " + this.agent.getMibName()));
                    }
                    this.agent.check(this.varBind);
                    break;
                }
                default: {
                    if (Debug.isLevelSet((int)2048)) {
                        Debug.printFormatted((Object)("snmp.SubRequestHandler::run[" + Thread.currentThread() + "]: unknown operation (" + this.type + ") on " + this.agent.getMibName()));
                    }
                    this.errorStatus = 5;
                    this.errorIndex = 1;
                    break;
                }
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            this.errorStatus = snmpStatusException.getStatus();
            this.errorIndex = snmpStatusException.getErrorIndex();
            Debug.print((int)2048, (Object)("snmp.SubRequestHandler::run[" + Thread.currentThread() + "]:  a Snmp error occured during the operation."));
        }
        catch (Exception exception) {
            this.errorStatus = 5;
            Debug.print((int)2048, (Object)("snmp.SubRequestHandler::run[" + Thread.currentThread() + "]:  a generic error occured during the operation."));
        }
        if (Debug.isLevelSet((int)2048)) {
            Debug.printFormatted((Object)("snmp.SubRequestHandler::run[" + Thread.currentThread() + "]:  operation completed."));
        }
    }

    protected void updateRequest(SnmpVarBind snmpVarBind, int n) {
        int n2 = this.varBind.size();
        this.translation[n2] = n;
        this.varBind.addElement(snmpVarBind);
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        if (snmpVarBindArray == null) {
            return;
        }
        int n = this.varBind.size();
        int n2 = snmpVarBindArray.length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.translation[n3];
            if (n4 < n2) {
                snmpVarBindArray[n4] = (SnmpVarBind)((NonSyncVector)this.varBind).elementAtNonSync(n3);
            } else {
                Debug.print((int)2048, (Object)("snmp.SubRequestHandler::run[" + Thread.currentThread() + "]:  updateResult, Position `" + n4 + "' is out of bound..."));
            }
            ++n3;
        }
    }

    class NonSyncVector
    extends Vector {
        public NonSyncVector(int n) {
            super(n);
        }

        final void addNonSyncElement(Object object) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = object;
        }

        final Object elementAtNonSync(int n) {
            return this.elementData[n];
        }
    }
}

