/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.bootstrap;

import com.sun.jaw.impl.agent.services.bootstrap.internal.BootstrapClassLoader;
import com.sun.jaw.impl.agent.services.bootstrap.internal.BootstrapMLet;
import com.sun.jaw.impl.agent.services.bootstrap.internal.BootstrapParser;
import com.sun.jaw.impl.common.DefaultPaths;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class BootstrapSrv
implements Serializable {
    private static Vector mletList = new Vector();
    private static BootstrapParser parser = new BootstrapParser();
    private static Hashtable classloaders = new Hashtable();
    private static String libraryDirectory = null;
    private boolean secureMode = false;
    private static final String sccs_id = "@(#)BootstrapSrv.java 1.5 03/18/99 SMI";

    public BootstrapSrv(Boolean bl) {
        if (bl != null) {
            this.secureMode = bl;
        }
        if ((libraryDirectory = System.getProperty("jaw.bootstrap.library.dir")) == null) {
            libraryDirectory = DefaultPaths.getTmpDir();
        }
    }

    public static String getClassVersion() {
        return sccs_id;
    }

    public String getLibraryDirectory() {
        return libraryDirectory;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 2) {
            BootstrapSrv bootstrapSrv = new BootstrapSrv(new Boolean(stringArray[0]));
            if (stringArray.length >= 3) {
                bootstrapSrv.setLibraryDirectory(stringArray[2]);
            }
            bootstrapSrv.performLoadURL(stringArray[1]);
        } else {
            System.err.println("                                                                                                          ");
            System.err.println("Usage:                                                                                                    ");
            System.err.println("       % java com.sun.jaw.impl.agent.services.bootstrap.BootstrapSrv <secure> <agent-URL> [<local-libdir>]");
            System.err.println("                                                                                                          ");
            System.err.println("           secure = true | false (needs to be specified but is never used in JDK 1.2)                     ");
            System.err.println("           agent-URL = URL specifying the m-let document file.                                            ");
            System.err.println("           local-libdir = Local directory for storing native libraries.                                   ");
            System.err.println("                                                                                                          ");
            System.exit(1);
        }
    }

    public void performLoadURL(String string) {
        if (string == null) {
            System.err.println("BootstrapSrv::performLoadURL: URL is null");
            System.exit(1);
        } else {
            string = string.replace(File.separatorChar, '/');
        }
        mletList = parser.parseURL(string);
        if (mletList == null) {
            System.err.println("BootstrapSrv::performLoadURL: Problems while parsing URL " + string);
            System.exit(1);
        }
        if (mletList.size() == 0) {
            System.err.println("BootstrapSrv::performLoadURL: File " + string + " not found or MLET tag not defined in file");
            System.exit(1);
        }
        Enumeration enumeration = mletList.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            BootstrapMLet bootstrapMLet = (BootstrapMLet)enumeration.nextElement();
            String string3 = bootstrapMLet.getCode();
            if (string3.endsWith(".class")) {
                string3 = string3.substring(0, string3.length() - 6);
            }
            URL uRL = bootstrapMLet.getCodeBase();
            String string4 = bootstrapMLet.getJarFiles();
            BootstrapClassLoader bootstrapClassLoader = (BootstrapClassLoader)classloaders.get(uRL);
            if (bootstrapClassLoader == null) {
                bootstrapClassLoader = new BootstrapClassLoader(uRL);
                classloaders.put(uRL, bootstrapClassLoader);
            }
            if (bootstrapClassLoader != null) {
                bootstrapClassLoader.setLibraryDirectory(libraryDirectory);
            } else {
                System.err.println("BootstrapSrv::performLoadURL: Unable to create BootstrapClassLoader with codebase = " + uRL);
                System.exit(1);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                bootstrapClassLoader.addJarFileURL(String.valueOf(String.valueOf(uRL)) + string2);
            }
            string2 = null;
            if (string3 == null) {
                System.err.println("BootstrapSrv::performLoadURL: CODE parameter is mandatory in MLet tag for Bootstrap service.");
                System.exit(1);
            }
            try {
                string2 = bootstrapClassLoader.loadClass(string3).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("BootstrapSrv::performLoadURL: ClassNotFoundException: Class " + string3 + " not found.");
                classNotFoundException.printStackTrace();
                System.exit(1);
            }
            catch (InstantiationException instantiationException) {
                System.err.println("BootstrapSrv::performLoadURL: InstantiationException: Unable to instantiate class " + string3);
                instantiationException.printStackTrace();
                System.exit(1);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("BootstrapSrv::performLoadURL: IllegalAccessException: Class " + string3);
                illegalAccessException.printStackTrace();
                System.exit(1);
            }
            catch (SecurityException securityException) {
                System.err.println("BootstrapSrv::performLoadURL: SecurityException: " + securityException.getMessage());
                securityException.printStackTrace();
                System.exit(1);
            }
            catch (Exception exception) {
                System.err.println("BootstrapSrv::performLoadURL: Exception: " + exception.getMessage());
                exception.printStackTrace();
                System.exit(1);
            }
            catch (Error error) {
                System.err.println("BootstrapSrv::performLoadURL: Error: " + error.getMessage());
                error.printStackTrace();
                System.exit(1);
            }
            boolean bl = false;
            Class<?>[] classArray = string2.getClass().getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n].toString().equals("interface java.lang.Runnable")) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                new Thread((Runnable)((Object)string2)).start();
                continue;
            }
            System.err.println("BootstrapSrv::performLoadURL: Agent specified in CODE does not implement java.lang.Runnable interface.");
            System.err.println("BootstrapSrv::performLoadURL: So the Bootstrap service is unable to start it, application aborted.");
        }
    }

    public void setLibraryDirectory(String string) {
        libraryDirectory = string;
    }
}

