/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.bootstrap.internal;

import com.sun.jaw.reference.common.LoaderRepository;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class BootstrapClassLoader
extends URLClassLoader {
    private URL codebase = null;
    private String libraryDirectory = null;

    public BootstrapClassLoader(URL uRL) {
        super(new URL[0]);
        LoaderRepository.addClassLoader((ClassLoader)this);
        this.codebase = uRL;
    }

    public void addJarFileURL(String string) {
        try {
            this.addURL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {}
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class clazz = null;
        try {
            clazz = super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (clazz == null) {
            try {
                clazz = LoaderRepository.loadClassWithout((ClassLoader)this, (String)string);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    protected String findLibrary(String string) {
        String string2 = System.mapLibraryName(string);
        String string3 = this.loadLibraryAsResource(string2);
        if (string3 != null) {
            return string3;
        }
        string2 = String.valueOf(this.removeSpace(System.getProperty("os.name"))) + File.separator + this.removeSpace(System.getProperty("os.arch")) + File.separator + this.removeSpace(System.getProperty("os.version")) + File.separator + "lib" + File.separator + string2;
        string3 = this.loadLibraryAsResource(string2);
        if (string3 != null) {
            return string3;
        }
        return null;
    }

    public URL getCodeBase() {
        return this.codebase;
    }

    public String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    private synchronized String loadLibraryAsResource(String string) {
        try {
            InputStream inputStream = ((ClassLoader)this).getResourceAsStream(string.replace(File.separatorChar, '/'));
            if (inputStream != null) {
                int n;
                File file = new File(this.libraryDirectory, string);
                file.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                inputStream.close();
                fileOutputStream.close();
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private String removeSpace(String string) {
        int n = (string = string.trim()).indexOf(32);
        if (n == -1) {
            return string;
        }
        String string2 = new String();
        int n2 = 0;
        while (n != -1) {
            n = (string = string.substring(n2)).indexOf(32);
            string2 = n != -1 ? String.valueOf(string2) + string.substring(0, n) : String.valueOf(string2) + string.substring(0);
            n2 = n + 1;
        }
        return string2;
    }

    public void setLibraryDirectory(String string) {
        this.libraryDirectory = string;
    }
}

