/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.cascading;

import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.ActivatableIf;
import com.sun.jaw.reference.client.adaptor.AdaptorMO;
import com.sun.jaw.reference.client.mo.FrameworkListenerMO;
import com.sun.jaw.reference.client.mo.FrameworkMO;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.FrameworkEventMO;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.LocalException;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.common.ServiceNotFoundException;
import com.sun.jaw.reference.mapper.MappingException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RemoteAgent
implements Serializable,
FrameworkListenerMO,
ActivatableIf {
    private Framework framework = null;
    private String host = "localhost";
    private String protocol = "rmi";
    private String adpName = null;
    private int port = 1099;
    private transient boolean isActive = false;
    private transient AdaptorMO adpClient = null;
    private transient Vector registeredRemoteObjs = new Vector();
    private transient Object SetupObject = null;
    private transient FrameworkMO cmfMO = null;
    private static final String sccs_id = "@(#)RemoteAgent.java 3.3 04/02/99 SMI";
    private transient String ServerAdpName = null;
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String PROTOCOL = "protocol";

    public RemoteAgent() {
    }

    public RemoteAgent(String string, String string2, String string3, int n) {
        this.host = string;
        this.protocol = string3;
        this.adpName = string2;
        this.port = n;
    }

    public void deleteCmf() {
        try {
            this.performStop();
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
        }
    }

    public String getAdpName() {
        if (this.adpName != null) {
            return this.adpName;
        }
        return "com.sun.jaw.impl.adaptor." + this.protocol + ".AdaptorClient";
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public Boolean getConnected() {
        Boolean bl = this.adpClient == null ? new Boolean(false) : this.adpClient.isConnected();
        return bl;
    }

    public String getHost() {
        return this.host;
    }

    public AdaptorMO getMOFactory() {
        return this.adpClient;
    }

    public Integer getNbOfRemoteObjects() {
        int n = -1;
        if (this.isActive && this.getConnected().booleanValue()) {
            try {
                n = this.adpClient.getOnlyNames(new ObjectName(":"), null).size();
            }
            catch (Exception exception) {}
        }
        return new Integer(n);
    }

    public Integer getPort() {
        return new Integer(this.port);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getServerAdpName() {
        if (this.ServerAdpName != null) {
            return this.ServerAdpName;
        }
        return "com.sun.jaw.impl.adaptor." + this.protocol + ".AdaptorServerImpl";
    }

    public void handleFrameworkEvent(FrameworkEventMO frameworkEventMO) {
        switch (frameworkEventMO.getEventType()) {
            case 1: {
                Enumeration enumeration = frameworkEventMO.getEventObjectNames().elements();
                while (enumeration.hasMoreElements()) {
                    ObjectName objectName = (ObjectName)enumeration.nextElement();
                    if (!this.registrable(objectName)) continue;
                    Vector vector = null;
                    try {
                        Debug.print((int)128, (Object)("RemoteAgent::handleFrameworkEvent(creation): Get newly created object " + objectName));
                        vector = this.adpClient.getObject(objectName, null);
                        Debug.print((int)128, (Object)("RemoteAgent::handleFrameworkEvent(creation): Register newly created object " + objectName));
                        this.register(vector.firstElement(), objectName);
                    }
                    catch (Exception exception) {
                        Debug.print((int)128, (Object)("RemoteAgent::handleFrameworkEvent(creation): Could not register object " + objectName));
                        Debug.print((int)128, (Object)exception.getMessage());
                    }
                }
                break;
            }
            case 2: {
                Enumeration enumeration = frameworkEventMO.getEventObjectNames().elements();
                while (enumeration.hasMoreElements()) {
                    ObjectName objectName = (ObjectName)enumeration.nextElement();
                    try {
                        Debug.print((int)128, (Object)("RemoteAgent::handleFrameworkEvent(deletion): Remove deleted object" + objectName));
                        this.unregister(objectName);
                    }
                    catch (Exception exception) {
                        Debug.print((int)128, (Object)("RemoteAgent::handleFrameworkEvent(deletion): Could not remove object " + objectName));
                    }
                }
                break;
            }
        }
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException {
        Serializable serializable;
        this.framework = framework;
        Debug.print((int)2, (Object)"RemoteAgent::initCmf: Register in framework");
        try {
            serializable = this.parseName(objectName);
            this.host = (String)((Hashtable)serializable).get(HOST);
            this.protocol = (String)((Hashtable)serializable).get(PROTOCOL);
            this.port = (Integer)((Hashtable)serializable).get(PORT);
            if (bl) {
                this.framework.addDBObject(this, objectName);
            } else {
                this.framework.addObject(this, objectName);
            }
        }
        catch (InstanceAlreadyExistException instanceAlreadyExistException) {
            Debug.print((int)128, (Object)"RemoteAgent::initCmf: already in Framework");
            throw instanceAlreadyExistException;
        }
        if (this.adpClient == null) {
            serializable = null;
            try {
                serializable = Class.forName(this.getAdpName());
                this.adpClient = (AdaptorMO)((Class)serializable).newInstance();
            }
            catch (Exception exception) {
                throw new ServiceNotFoundException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void loadRemoteObjects() throws ServiceNotFoundException, CommunicationException, IllegalAccessException {
        Vector vector = null;
        try {
            vector = this.adpClient.getOnlyNames(new ObjectName(":"), null);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Debug.print((int)128, (Object)instanceNotFoundException.getMessage());
        }
        Debug.print((int)128, (Object)("RemoteAgent::loadRemoteObjects:Found " + vector.size() + " names"));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ObjectName objectName = (ObjectName)enumeration.nextElement();
            if (!this.registrable(objectName)) continue;
            Vector vector2 = null;
            try {
                vector2 = this.adpClient.getObject(objectName, null);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                Debug.print((int)128, (Object)instanceNotFoundException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                Debug.print((int)128, (Object)invocationTargetException.getMessage());
            }
            catch (LocalException localException) {
                Throwable throwable = localException.getTargetException();
                if (throwable instanceof ClassNotFoundException) {
                    Debug.print((int)128, (Object)("RemoteAgent::loadRemoteObjects:Ignoring CBean " + objectName));
                    Debug.print((int)128, (Object)localException.getMessage());
                }
                if (throwable instanceof MappingException) {
                    Debug.print((int)128, (Object)("RemoteAgent::loadRemoteObjects:Mapping failed for " + objectName));
                    Debug.print((int)128, (Object)localException.getMessage());
                }
                Debug.print((int)128, (Object)localException.getMessage());
            }
            if (vector2 == null || vector2.size() == 0) continue;
            try {
                this.register(vector2.firstElement(), objectName);
            }
            catch (InstanceAlreadyExistException instanceAlreadyExistException) {
                Debug.print((int)128, (Object)instanceAlreadyExistException.getMessage());
            }
            Debug.print((int)128, (Object)("RemoteAgent::loadRemoteObjects:CBean " + objectName + " has been registered"));
        }
    }

    private Hashtable parseName(ObjectName objectName) throws IllegalArgumentException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string = (String)objectName.getProperty(HOST);
        if (string != null) {
            this.host = string;
        }
        hashtable.put(HOST, this.host);
        String string2 = (String)objectName.getProperty(PROTOCOL);
        if (string2 != null) {
            this.protocol = string2;
        }
        hashtable.put(PROTOCOL, this.protocol);
        Integer n = (Integer)objectName.getProperty(PORT);
        if (n != null) {
            this.port = n;
        }
        hashtable.put(PORT, new Integer(this.port));
        return hashtable;
    }

    public void performSetup(Object object) {
        this.SetupObject = object;
    }

    public synchronized void performStart() {
        Debug.print((int)128, (Object)"RemoteAgent::performStart: Start the RemoteAgent.");
        if (!this.isActive) {
            Serializable serializable;
            if (this.adpClient == null) {
                serializable = null;
                try {
                    serializable = Class.forName(this.getAdpName());
                    this.adpClient = (AdaptorMO)((Class)serializable).newInstance();
                }
                catch (Exception exception) {
                    throw new ServiceNotFoundException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
                }
            }
            this.adpClient.setup(this.SetupObject);
            if (this.ServerAdpName == null) {
                this.ServerAdpName = "com.sun.jaw.impl.adaptor." + this.protocol + ".AdaptorServer";
            }
            this.adpClient.connect(null, this.host, this.port, this.ServerAdpName);
            try {
                this.loadRemoteObjects();
            }
            catch (Exception exception) {
                Debug.print((int)128, (Object)exception.getMessage());
                exception.printStackTrace();
            }
            try {
                Debug.print((int)128, (Object)"RemoteAgent::performStart:Get remote Framework CBean");
                serializable = this.adpClient.getObject(new ObjectName(":com.sun.jaw.reference.client.mo.FrameworkMO"), null);
                Enumeration enumeration = ((Vector)serializable).elements();
                while (enumeration.hasMoreElements()) {
                    this.cmfMO = (FrameworkMO)enumeration.nextElement();
                }
                if (((Vector)serializable).size() > 0) {
                    this.cmfMO = (FrameworkMO)((Vector)serializable).firstElement();
                }
            }
            catch (Exception exception) {
                Debug.print((int)128, (Object)"RemoteAgent::performStart:Failed to get remote Framework CBean");
                Debug.print((int)128, (Object)exception.getMessage());
            }
            try {
                Debug.print((int)128, (Object)"RemoteAgent::performStart:Become listener of the remote framework");
                this.cmfMO.addFrameworkListenerMO((FrameworkListenerMO)this);
            }
            catch (Exception exception) {
                Debug.print((int)128, (Object)"RemoteAgent::performStart:Failed to become listener of the remote framework");
                Debug.print((int)128, (Object)exception.getMessage());
            }
            this.isActive = true;
        } else {
            Debug.print((int)128, (Object)"RemoteAgent::performStart: The RemoteAgent is already activated.");
        }
    }

    public synchronized void performStop() {
        Debug.print((int)128, (Object)"RemoteAgent::performStop: Stop the RemoteAgent.");
        if (this.isActive) {
            try {
                this.cmfMO.removeFrameworkListenerMO((FrameworkListenerMO)this);
            }
            catch (Exception exception) {}
            this.cmfMO = null;
            this.adpClient.disconnect();
            while (!this.registeredRemoteObjs.isEmpty()) {
                Object e = this.registeredRemoteObjs.firstElement();
                try {
                    this.unregister((ObjectName)e);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    this.registeredRemoteObjs.removeElement(e);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.registeredRemoteObjs.removeElement(e);
                }
            }
            this.isActive = false;
        } else {
            Debug.print((int)128, (Object)"RemoteAgent::performStop: The RemoteAgent is already deactivated.");
        }
    }

    private void register(Object object, ObjectName objectName) throws InstanceAlreadyExistException, ServiceNotFoundException, IllegalAccessException {
        this.framework.addObject(object, objectName);
        this.registeredRemoteObjs.addElement(objectName);
    }

    private boolean registrable(ObjectName objectName) {
        String string = objectName.getClassName();
        if (string.endsWith("com.sun.jaw.reference.client.mo.FrameworkMO")) {
            return false;
        }
        if (string.endsWith("com.sun.jaw.reference.agent.services.EventHandlerIfMO")) {
            return false;
        }
        return !string.endsWith(".RemoteAgent") && !string.endsWith(".RemoteAgentMO");
    }

    public void setServerAdpName(String string) {
        if (string != null) {
            this.ServerAdpName = string;
        }
    }

    private void unregister(ObjectName objectName) throws InstanceNotFoundException, InvocationTargetException {
        this.registeredRemoteObjs.removeElement(objectName);
        this.framework.fastDelObject(objectName);
    }
}

