/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.jawdiscovery;

import com.sun.jaw.impl.agent.services.jawdiscovery.internal.ActualDiscovery;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.ActivatableIf;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class DiscoveryClient
implements Serializable,
ActivatableIf {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    private static final String sccs_id = "@(#)DiscoveryClient.java 3.5 99/01/26 SMI";
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup = defaultMulticastGroup;
    private byte ttl = 1;
    private boolean pointToPointResponse = true;
    private int timeOut = 1000;
    private static int defaultTimeOut = 1000;
    private transient ActualDiscovery discovery = null;
    private static final String GROUP = "group";
    private static final String PORT = "port";
    protected transient int state = 1;

    public DiscoveryClient() throws IOException {
        this.multicastPort = defaultMulticastPort;
        Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryClient::constructor : Create a new multicast socket");
        this.discovery = new ActualDiscovery(this.multicastGroup, this.multicastPort);
    }

    public void deleteCmf() {
        Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryClient::deleteCmf : stopping ");
        if (this.state == 0) {
            this.performStop();
        }
        System.runFinalization();
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public boolean getPointToPointResponse() {
        return this.pointToPointResponse;
    }

    public Integer getState() {
        return new Integer(this.state);
    }

    public String getStateString() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "ONLINE";
                break;
            }
            case 1: {
                string = "OFFLINE";
                break;
            }
            case 2: {
                string = "STOPPING";
                break;
            }
        }
        return string;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public byte getTimeToLiveByte() {
        return this.ttl;
    }

    public int getTimeToLiveInt() {
        Byte by = new Byte(this.ttl);
        return by.intValue();
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException {
        Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryClient::initCmf : object name   = " + objectName));
        String string = (String)objectName.getProperty(GROUP);
        if (string != null) {
            this.multicastGroup = string;
        }
        Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryClient::initCmf : Set group to '" + this.multicastGroup + "'"));
        Integer n = (Integer)objectName.getProperty(PORT);
        if (n != null) {
            this.multicastPort = n;
        }
        Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryClient::initCmf : Set Port  to '" + this.multicastPort + "'"));
        if (this.state == 1) {
            this.performStart();
        }
        if (bl) {
            framework.addDBObject(this, objectName);
        } else {
            framework.addObject(this, objectName);
        }
    }

    public boolean isActive() {
        return this.state == 0;
    }

    public Vector performFindAdaptors() throws CommunicationException {
        return this.performFindAdaptors(true, null);
    }

    public Vector performFindAdaptors(String string) throws CommunicationException {
        return this.performFindAdaptors(true, string);
    }

    private Vector performFindAdaptors(boolean bl, String string) throws CommunicationException {
        if (this.state != 0) {
            throw new CommunicationException("Not connect  to " + this.multicastGroup + ":" + this.multicastPort);
        }
        try {
            return this.discovery.performFindAdaptors(bl, string);
        }
        catch (IOException iOException) {
            Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryClient::performFindAdaptors : Get IOException exception " + iOException.getMessage()));
            throw new CommunicationException("Unable to join group on " + this.multicastGroup + ":" + this.multicastPort);
        }
    }

    public Vector performFindHosts() throws CommunicationException {
        return this.performFindAdaptors(false, null);
    }

    public Vector performFindHosts(String string) throws CommunicationException {
        return this.performFindAdaptors(false, string);
    }

    public void performStart() {
        if (this.state == 1) {
            try {
                this.discovery = new ActualDiscovery(this.multicastGroup, this.multicastPort);
            }
            catch (IOException iOException) {
                Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryClient::performStart : Can't start discoveryClient: Unable to create multicast socket " + this.multicastGroup + ":" + this.multicastPort));
                Debug.printException((Exception)iOException);
                return;
            }
            try {
                this.discovery.connectToGroup();
                this.discovery.setTimeOut(this.timeOut);
                this.discovery.setTtl(this.ttl);
                this.discovery.setPointToPointResponse(this.pointToPointResponse);
            }
            catch (IOException iOException) {
                Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryClient::performStart : Can't start discoveryClient: Unable to create multicast socket " + this.multicastGroup + ":" + this.multicastPort));
                Debug.printException((Exception)iOException);
                return;
            }
            this.state = 0;
        } else {
            Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryClient::performStart : Client is not OFFLINE");
        }
    }

    public void performStop() {
        if (this.state == 0) {
            Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryClient::deleteCmf : Call leave group");
            try {
                this.discovery.disconnectFromGroup();
            }
            catch (IOException iOException) {
                Debug.printException((Exception)iOException);
            }
            System.runFinalization();
            this.state = 1;
        } else {
            Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryResponder::performStop : Client is not ONLINE");
        }
    }

    public void setMulticastGroup(String string) {
        if (this.state == 1) {
            this.multicastGroup = string;
        }
    }

    public void setMulticastPort(int n) {
        if (this.state == 1) {
            this.multicastPort = n;
        }
    }

    public void setPointToPointResponse(boolean bl) {
        this.pointToPointResponse = bl;
        if (this.state == 0) {
            this.discovery.setPointToPointResponse(bl);
        }
    }

    public void setTimeOut(int n) {
        this.timeOut = n <= 0 ? defaultTimeOut : n;
        if (this.state == 0) {
            this.discovery.setTimeOut(n);
        }
    }

    public void setTimeToLiveByte(byte by) throws IOException {
        if (this.state == 0) {
            this.discovery.setTtl(by);
        }
        this.ttl = by;
    }

    public void setTimeToLiveInt(int n) throws IOException {
        if (n <= 0 || n > 255) {
            throw new IOException("Ttl out of range");
        }
        Integer n2 = new Integer(n);
        byte by = n2.byteValue();
        this.setTimeToLiveByte(by);
    }
}

