/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.jawdiscovery;

import com.sun.jaw.impl.agent.services.jawdiscovery.DiscoveryResponderEvent;
import com.sun.jaw.impl.agent.services.jawdiscovery.DiscoveryResponderListener;
import com.sun.jaw.impl.agent.services.jawdiscovery.internal.ActualMonitor;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class DiscoveryMonitor
implements Serializable {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    private ObjectName monitorObjectName = null;
    private Framework cmf = null;
    private static final String sccs_id = "@(#)DiscoveryMonitor.java 3.4 99/01/26 SMI";
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private transient ActualMonitor monitor = null;
    private transient Thread monitorThread = null;
    private transient int state = 1;
    private transient Vector listeners = new Vector();
    private static final String GROUP = "group";
    private static final String PORT = "port";

    public DiscoveryMonitor() throws IOException {
        Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryMonitor::constructor: initialize multicast socket");
        this.multicastGroup = defaultMulticastGroup;
        this.multicastPort = defaultMulticastPort;
    }

    public synchronized void addDiscoveryResponderListener(DiscoveryResponderListener discoveryResponderListener) {
        this.listeners.addElement(discoveryResponderListener);
    }

    public void deleteCmf() {
        this.performStop();
        System.runFinalization();
    }

    public void deliverEvent(DiscoveryResponderEvent discoveryResponderEvent) {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.listeners.clone();
            int n = vector.size();
            if (n == 0) {
                Object var5_5 = null;
                return;
            }
        }
        serializable = new Vector();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            DiscoveryResponderListener discoveryResponderListener = (DiscoveryResponderListener)vector.elementAt(n2);
            discoveryResponderListener.handleEvent(discoveryResponderEvent);
            ++n2;
        }
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public Integer getState() {
        return new Integer(this.state);
    }

    public String getStateString() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "ONLINE";
                break;
            }
            case 1: {
                string = "OFFLINE";
                break;
            }
            case 2: {
                string = "STOPPING";
                break;
            }
        }
        return string;
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException {
        Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryMonitor::initCmf : object name   = " + objectName));
        String string = (String)objectName.getProperty(GROUP);
        if (string != null) {
            this.multicastGroup = string;
        }
        Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryMonitor::initCmf : Set group to '" + this.multicastGroup + "'"));
        Integer n = (Integer)objectName.getProperty(PORT);
        if (n != null) {
            this.multicastPort = n;
        }
        Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryMonitor::initCmf : Set Port  to '" + this.multicastPort + "'"));
        this.performStart();
        this.monitorObjectName = objectName;
        this.cmf = framework;
        if (bl) {
            framework.addDBObject(this, objectName);
        } else {
            framework.addObject(this, objectName);
        }
    }

    public void performStart() {
        if (this.state == 1) {
            try {
                this.monitor = new ActualMonitor(this.multicastGroup, this.multicastPort, this);
                this.monitorThread = this.cmf == null ? new Thread(this.monitor) : this.cmf.getThreadAllocatorSrvIf().obtainThread((Object)this.monitorObjectName, this.monitor);
                this.monitorThread.setName("Multicast monitor");
            }
            catch (IOException iOException) {
                Debug.printException((Exception)iOException);
                return;
            }
            this.monitorThread.start();
            this.state = 0;
        } else {
            Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryMonitor::performStart: not OFFLINE ");
        }
    }

    public void performStop() {
        if (this.state == 0) {
            this.monitor.stopMonitor();
            this.monitorThread.interrupt();
            this.state = 1;
        } else {
            Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryMonitor::performStart: not ONLINE");
        }
    }

    public synchronized void removeDiscoveryResponderListener(DiscoveryResponderListener discoveryResponderListener) {
        this.listeners.removeElement(discoveryResponderListener);
    }

    public void setMulticastGroup(String string) {
        if (this.state == 1) {
            this.multicastGroup = string;
        }
    }

    public void setMulticastPort(int n) {
        if (this.state == 1) {
            this.multicastPort = n;
        }
    }
}

