/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.jawdiscovery;

import com.sun.jaw.impl.agent.services.jawdiscovery.internal.ActualResponder;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.ActivatableIf;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import java.io.IOException;
import java.io.Serializable;

public class DiscoveryResponder
implements Serializable,
ActivatableIf {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    private static final String sccs_id = "@(#)DiscoveryResponder.java 3.4 99/01/11 SMI";
    private int multicastPort;
    private String multicastGroup = defaultMulticastGroup;
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int ttl = 1;
    private Framework cmf = null;
    private ObjectName responderObjectName = null;
    private transient ActualResponder responder = null;
    private transient Thread responderThread = null;
    private static final String HOST = "host";
    private static final String GROUP = "group";
    private static final String PORT = "port";
    private static final String TTL = "ttl";
    private static final String SPY = "spy";
    private String spy = "";
    private String noEvent = null;
    protected transient int state = 1;

    public DiscoveryResponder() {
        this.multicastPort = defaultMulticastPort;
    }

    public DiscoveryResponder(Framework framework) {
        this.multicastPort = defaultMulticastPort;
        this.cmf = framework;
    }

    public void deleteCmf() {
        if (this.state == 0) {
            this.performStop();
        }
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public Integer getState() {
        return new Integer(this.state);
    }

    public String getStateString() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "ONLINE";
                break;
            }
            case 1: {
                string = "OFFLINE";
                break;
            }
            case 2: {
                string = "STOPPING";
                break;
            }
        }
        return string;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException {
        Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryResponder::initCmf : object name   = " + objectName));
        this.responderObjectName = objectName;
        String string = (String)objectName.getProperty(GROUP);
        if (string != null) {
            this.multicastGroup = string;
        }
        Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryResponder::initCmf : Set group to '" + this.multicastGroup + "'"));
        Integer n = (Integer)objectName.getProperty(PORT);
        if (n != null) {
            this.multicastPort = n;
        }
        Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryResponder::initCmf : Set Port  to '" + this.multicastPort + "'"));
        Integer n2 = (Integer)objectName.getProperty(TTL);
        if (n2 != null) {
            this.ttl = n2;
            if (this.ttl <= 0 || this.ttl > 255) {
                this.ttl = 1;
            }
        }
        Debug.print((int)1024, (Object)("jawdiscovery.DiscoveryResponder::initCmf : Set ttl  to '" + this.ttl + "'"));
        this.spy = (String)objectName.getProperty(SPY);
        this.noEvent = (String)objectName.getProperty("PRIVATE_NO_EVENT");
        this.cmf = framework;
        if (this.state == 1) {
            this.performStart();
        }
        if (bl) {
            framework.addDBObject(this, objectName);
        } else {
            framework.addObject(this, objectName);
        }
    }

    public boolean isActive() {
        return this.state == 0;
    }

    public void performStart() {
        if (this.state == 1) {
            if (this.cmf == null) {
                Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryResponder::performStart : Can't start discoveryResponder: JDMK framework is not set");
                return;
            }
            try {
                Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryResponder::performStart : Create a new responder");
                this.responder = new ActualResponder(this.multicastGroup, this.multicastPort, this.getTimeToLive(), this.cmf, this.spy);
                if (this.noEvent != null) {
                    this.responder.noEvent();
                }
                Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryResponder::performStart : call responder connect");
                this.responder.connectToGroup();
            }
            catch (IOException iOException) {
                Debug.printException((Exception)iOException);
            }
            this.responderThread = this.cmf.getThreadAllocatorSrvIf().obtainThread((Object)this.responderObjectName, this.responder);
            this.responderThread.setName("Multicast responder");
            this.responderThread.start();
            this.state = 0;
        } else {
            Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryResponder::performStart : Responder is not OFFLINE");
        }
    }

    public void performStop() {
        if (this.state == 0) {
            Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryResponder::performStop : Call leave group");
            try {
                this.responder.disconnectFromGroup();
            }
            catch (IOException iOException) {
                Debug.printException((Exception)iOException);
            }
            this.responder.stopRequested = true;
            this.responderThread.interrupt();
            System.runFinalization();
            this.state = 1;
        } else {
            Debug.print((int)1024, (Object)"jawdiscovery.DiscoveryResponder::performStop : Responder is not ONLINE");
        }
    }

    public void setMulticastGroup(String string) {
        if (this.state == 1) {
            this.multicastGroup = string;
        }
    }

    public void setMulticastPort(int n) {
        if (this.state == 1) {
            this.multicastPort = n;
        }
    }

    public void setTimeToLive(int n) {
        if (this.state == 1) {
            if (n <= 0 || n > 255) {
                return;
            }
            this.ttl = n;
        }
    }
}

