/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.jawdiscovery.internal;

import com.sun.jaw.impl.agent.services.jawdiscovery.DiscoveryResponse;
import com.sun.jaw.impl.agent.services.jawdiscovery.internal.DiscoveryCommon;
import com.sun.jaw.impl.agent.services.jawdiscovery.internal.Msg.DiscoveryMsg;
import com.sun.jaw.impl.agent.services.jawdiscovery.internal.Msg.DiscoveryPDU;
import com.sun.jaw.impl.agent.services.jawdiscovery.internal.Msg.ResponsePDU;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.query.QueryExp;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidClassException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Vector;

public class ActualDiscovery
extends DiscoveryCommon {
    private boolean PointToPointResponse = true;
    private int RETURN_PORT_MIN_VAL = 1024;
    private int RETURN_PORT_MAX_VAL = this.RETURN_PORT_MIN_VAL * 10;
    private byte ttl = 1;
    private byte defaultTtl = 1;
    private int timeOut = 1000;
    private String timeStamp = null;
    public Vector returnValue = new Vector();

    public ActualDiscovery(String string, int n) throws IOException {
        super(string, n);
        Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualDiscovery::constructor group = " + string + ", " + "port  = " + n));
    }

    private void formatPdu(DiscoveryPDU discoveryPDU, boolean bl, String string, QueryExp queryExp, String string2, int n) {
        String string3;
        String string4 = new Long(new Date().getTime()).toString();
        try {
            string3 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string3 = "localHost";
        }
        this.timeStamp = String.valueOf(string3) + ":" + string4;
        discoveryPDU.setTimeStamp(String.valueOf(string3) + ":" + string4);
        discoveryPDU.setEmittedGroup(this.multicastGroup);
        if (this.getPointToPointResponse()) {
            Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualDiscovery::formatPdu : set return addr to " + this.localHost + ":" + n));
            discoveryPDU.setReturnaddr(this.localHost, n);
        }
        discoveryPDU.setHost(string2);
        discoveryPDU.setTimeOut(this.getTimeOut());
        discoveryPDU.setTtl(this.getTtl());
        discoveryPDU.setObjectRequired(bl);
        discoveryPDU.setObjectName(string);
        discoveryPDU.setQuery(queryExp);
    }

    public Vector getObject(String string, QueryExp queryExp, String string2) throws IOException {
        return this.getObject(true, string, queryExp, string2);
    }

    private Vector getObject(boolean bl, String string, QueryExp queryExp, String string2) throws IOException {
        DatagramSocket datagramSocket = null;
        int n = this.RETURN_PORT_MIN_VAL;
        InetAddress inetAddress = this.getLocalHostAddr();
        if (this.getPointToPointResponse()) {
            Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualDiscovery::getObject : Create datagram socket for response");
            while (n < this.RETURN_PORT_MAX_VAL) {
                try {
                    datagramSocket = new DatagramSocket(n, inetAddress);
                    datagramSocket.setSoTimeout(this.getTimeOut());
                    break;
                }
                catch (BindException bindException) {
                    Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualDiscovery::getObject : try port " + n));
                    ++n;
                }
            }
            if (n == this.RETURN_PORT_MAX_VAL) {
                throw new IOException("Address already in use");
            }
        } else {
            Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualDiscovery::getObject : Use multicast socket for response");
            datagramSocket = this;
        }
        Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualDiscovery::getObject : Format msg");
        DiscoveryPDU discoveryPDU = new DiscoveryPDU();
        this.formatPdu(discoveryPDU, bl, string, queryExp, string2, n);
        Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualDiscovery::getObject :  Create a thread to get responses");
        ReceivedMsgObj receivedMsgObj = new ReceivedMsgObj(datagramSocket, this);
        Thread thread = new Thread(receivedMsgObj);
        thread.start();
        Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualDiscovery::getObject :  Send the multicast query");
        this.sendMsg(discoveryPDU, this.multicastGroup, this.multicastPort);
        Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualDiscovery::getObject :  Sleep before receiving");
        try {
            Thread.sleep(this.getTimeOut());
        }
        catch (InterruptedException interruptedException) {
            Debug.printException((Exception)interruptedException);
        }
        Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualDiscovery::getObject : Stop receiving");
        receivedMsgObj.stopRequested = true;
        thread.interrupt();
        return this.returnValue;
    }

    public boolean getPointToPointResponse() {
        return this.PointToPointResponse;
    }

    public int getTimeOut() {
        Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualDiscovery::getTimeOut " + this.timeOut));
        return this.timeOut;
    }

    public byte getTtl() {
        return this.ttl;
    }

    public Vector performFindAdaptors(boolean bl, String string) throws IOException {
        String string2 = null;
        if (bl) {
            string2 = new String("com.sun.jaw.reference.client.adaptor.AdaptorMO");
        }
        return this.getObject(bl, string2, null, string);
    }

    public void setPointToPointResponse(boolean bl) {
        Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualDiscovery::setPointToPointResponse to " + bl));
        this.PointToPointResponse = bl;
    }

    public void setReturnValue(Vector vector) {
        this.returnValue = vector;
    }

    public void setTimeOut(int n) {
        Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualDiscovery::setTimeOut to " + n));
        this.timeOut = n;
    }

    public void setTtl(byte by) throws IOException {
        try {
            this.setTTL(by);
        }
        catch (IOException iOException) {
            Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualDiscovery::setTtl : Unable to set ttl to " + by));
            throw iOException;
        }
        Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualDiscovery::setTtl : Set ttl to " + by));
        this.ttl = by;
    }

    class ReceivedMsgObj
    implements Runnable {
        public Vector result = new Vector();
        public boolean stopRequested = false;
        private ActualDiscovery discovery;
        private DatagramSocket socket;

        ReceivedMsgObj(DatagramSocket datagramSocket, ActualDiscovery actualDiscovery2) {
            this.socket = datagramSocket;
            this.discovery = actualDiscovery2;
        }

        private DiscoveryResponse TranslatePDU(ResponsePDU responsePDU) {
            DiscoveryResponse discoveryResponse = new DiscoveryResponse();
            discoveryResponse.host = responsePDU.getHost();
            discoveryResponse.objectList = responsePDU.getObjectList();
            return discoveryResponse;
        }

        public void run() {
            int n = 0;
            while (!this.stopRequested) {
                try {
                    DiscoveryMsg discoveryMsg = ActualDiscovery.this.receiveMsg(this.socket);
                    if (discoveryMsg == null) {
                        Debug.print((int)1024, (Object)"jawdiscovery.internal.ReceivedMsgObj::receivedMsg : Null msg - continue - ");
                        continue;
                    }
                    Debug.print((int)1024, (Object)("jawdiscovery.internal.ReceivedMsgObj::receivedMsg : get msg " + discoveryMsg.printState()));
                    ResponsePDU responsePDU = (ResponsePDU)discoveryMsg;
                    if (this.discovery.timeStamp.compareTo(responsePDU.getTimeStamp()) != 0) {
                        Debug.print((int)1024, (Object)("jawdiscovery.internal.ReceivedMsgObj::receivedMsg :  Msg is not for us : local timeStamp = " + this.discovery.timeStamp + " ; receiced timeStamp =  " + responsePDU.getTimeStamp()));
                        continue;
                    }
                    DiscoveryResponse discoveryResponse = this.TranslatePDU(responsePDU);
                    this.discovery.returnValue.addElement(discoveryResponse);
                    ++n;
                }
                catch (InterruptedIOException interruptedIOException) {
                    Debug.print((int)1024, (Object)"jawdiscovery.internal.ReceivedMsgObj::receivedMsg : timeOut expiration");
                    Debug.print((int)1024, (Object)("jawdiscovery.internal.ReceivedMsgObj::receivedMsg : Got " + n + " responses"));
                }
                catch (InvalidClassException invalidClassException) {
                    Debug.print((int)1024, (Object)"jawdiscovery.internal.ReceivedMsgObj::receivedMsg : Not a response msg - continue ");
                    Debug.printException((Exception)invalidClassException);
                }
                catch (ClassCastException classCastException) {
                    Debug.print((int)1024, (Object)"jawdiscovery.internal.ReceivedMsgObj::receivedMsg : Not a response msg - continue ");
                    Debug.printException((Exception)classCastException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Debug.print((int)1024, (Object)"jawdiscovery.internal.ReceivedMsgObj::receivedMsg : Not a response msg - continue ");
                    Debug.printException((Exception)classNotFoundException);
                }
                catch (IOException iOException) {
                    Debug.print((int)1024, (Object)"jawdiscovery.internal.ReceivedMsgObj::receivedMsg : Not a response msg - continue ");
                    Debug.printException((Exception)iOException);
                }
            }
            Debug.print((int)1024, (Object)"jawdiscovery.internal.ReceivedMsgObj::receivedMsg : timeOut expiration");
            Debug.print((int)1024, (Object)("jawdiscovery.internal.ReceivedMsgObj::receivedMsg : Got " + n + " responses"));
            if (this.discovery.getPointToPointResponse()) {
                Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualDiscovery::getObject : Close datagram socket");
                this.socket.close();
            }
        }
    }
}

