/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.jawdiscovery.internal;

import com.sun.jaw.impl.agent.services.jawdiscovery.DiscoveryMonitor;
import com.sun.jaw.impl.agent.services.jawdiscovery.DiscoveryResponderEvent;
import com.sun.jaw.impl.agent.services.jawdiscovery.DiscoveryResponse;
import com.sun.jaw.impl.agent.services.jawdiscovery.internal.DiscoveryCommon;
import com.sun.jaw.impl.agent.services.jawdiscovery.internal.Msg.ResponsePDU;
import com.sun.jaw.reference.common.Debug;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.Vector;

public class ActualMonitor
extends DiscoveryCommon
implements Serializable {
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private Thread listeningThread = null;
    private transient boolean stopRequested = false;
    private transient int state = 1;
    private transient DiscoveryMonitor monitor = null;
    private Vector listeners = new Vector();

    public ActualMonitor(String string, int n, DiscoveryMonitor discoveryMonitor) throws IOException {
        super(string, n);
        Debug.print((int)1024, (Object)"jawdiscovery.ActualMonitor::constructor: initialize multicast socket");
        this.multicastGroup = string;
        this.multicastPort = n;
        this.monitor = discoveryMonitor;
    }

    private void processMsg(ResponsePDU responsePDU) throws IOException {
        if (responsePDU == null) {
            Debug.print((int)1024, (Object)"jawdiscovery.ActualMonitor::processMsg : received a nul pdu '");
            return;
        }
        Debug.print((int)1024, (Object)("jawdiscovery.ActualMonitor::processMsg : received pdu '" + responsePDU.printState() + "'"));
        if (!responsePDU.getEvent()) {
            Debug.print((int)1024, (Object)"jawdiscovery.ActualMonitor::processMsg : not an event message");
            return;
        }
        DiscoveryResponse discoveryResponse = new DiscoveryResponse();
        discoveryResponse.host = responsePDU.getHost();
        discoveryResponse.objectList = responsePDU.getObjectList();
        DiscoveryResponderEvent discoveryResponderEvent = new DiscoveryResponderEvent(this.monitor, responsePDU.getAgentState(), discoveryResponse);
        this.monitor.deliverEvent(discoveryResponderEvent);
    }

    public void run() {
        Debug.print((int)1024, (Object)"jawdiscovery.ActualMonitor::run: start");
        try {
            this.connectToGroup();
        }
        catch (IOException iOException) {
            this.stopRequested = true;
        }
        while (!this.stopRequested) {
            this.state = 0;
            try {
                Debug.print((int)1024, (Object)"jawdiscovery.ActualMonitor::run : Start Waiting ");
                ResponsePDU responsePDU = (ResponsePDU)this.receiveMsg(this);
                this.processMsg(responsePDU);
            }
            catch (InterruptedIOException interruptedIOException) {
                Debug.print((int)1024, (Object)"jawdiscovery.ActualMonitor::run : Stop execution ");
                this.stopRequested = true;
            }
            catch (IOException iOException) {
                Debug.print((int)1024, (Object)"jawdiscovery.ActualMonitor::run : Not a event msg - continue - ");
            }
            catch (ClassCastException classCastException) {
                Debug.print((int)1024, (Object)"jawdiscovery.ActualMonitor::run : Not a event msg - continue - ");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.print((int)1024, (Object)"jawdiscovery.ActualMonitor::run : Not a event msg - continue - ");
            }
        }
        try {
            this.disconnectFromGroup();
            this.state = 1;
        }
        catch (IOException iOException) {}
    }

    public void stopMonitor() {
        this.stopRequested = true;
    }
}

