/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.jawdiscovery.internal;

import com.sun.jaw.impl.agent.services.jawdiscovery.internal.DiscoveryCommon;
import com.sun.jaw.impl.agent.services.jawdiscovery.internal.Msg.DiscoveryMsg;
import com.sun.jaw.impl.agent.services.jawdiscovery.internal.Msg.DiscoveryPDU;
import com.sun.jaw.impl.agent.services.jawdiscovery.internal.Msg.ResponsePDU;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.NamedObject;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.query.QueryExp;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class ActualResponder
extends DiscoveryCommon {
    public boolean stopRequested = false;
    private Framework cmf = null;
    private int ttl = 1;
    private boolean sendEvent = true;
    private boolean spy = false;

    public ActualResponder(String string, int n, int n2, Framework framework, String string2) throws IOException {
        super(string, n);
        Debug.print((int)1024, (Object)("jawdiscovery.internal.multicastPort::constructor group = " + string + ", " + "port  = " + n));
        this.ttl = n2;
        if (string2 != null) {
            Debug.print((int)1024, (Object)("jawdiscovery.internal.multicastPort::constructor spy = '" + string2 + "'"));
            if (string2.compareTo("act_as_a_spy") == 0) {
                this.spy = true;
            }
        }
        this.cmf = framework;
    }

    private void formatPdu(ResponsePDU responsePDU, DiscoveryPDU discoveryPDU, boolean bl) {
        if (!bl) {
            responsePDU.setTimeStamp(discoveryPDU.getTimeStamp());
        } else {
            responsePDU.setTimeStamp("");
        }
        responsePDU.setEvent(bl);
        if (!bl) {
            responsePDU.setTtl(discoveryPDU.getTtl());
        } else {
            Integer n = new Integer(this.ttl);
            responsePDU.setTtl(n.byteValue());
        }
        if (!bl) {
            responsePDU.setEmittedGroup(discoveryPDU.getEmittedGroup());
        } else {
            responsePDU.setEmittedGroup(this.multicastGroup);
        }
        responsePDU.setHost(this.localHostName);
        boolean bl2 = bl;
        String string = null;
        QueryExp queryExp = null;
        if (discoveryPDU != null) {
            bl2 |= discoveryPDU.getObjectRequired();
            queryExp = discoveryPDU.getQuery();
            string = discoveryPDU.getObjectName();
        } else {
            string = new String("com.sun.jaw.reference.client.adaptor.AdaptorMO");
            queryExp = null;
        }
        if (bl2) {
            Vector vector;
            try {
                ObjectName objectName = new ObjectName(String.valueOf(this.cmf.getDomain()) + ":" + string);
                vector = this.cmf.getObject(objectName, queryExp);
            }
            catch (Exception exception) {
                Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::formatPdu : Unable to get adaptor !");
                Debug.printException((Exception)exception);
                return;
            }
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                NamedObject namedObject = (NamedObject)enumeration.nextElement();
                Debug.print((int)1024, (Object)("\t" + namedObject.getName().getCanonicalName()));
                ++n;
            }
            responsePDU.setObjectList(vector);
        } else {
            responsePDU.setObjectList(null);
        }
    }

    public void noEvent() {
        this.sendEvent = false;
    }

    private void processMsg(DiscoveryPDU discoveryPDU) throws IOException {
        int n;
        InetAddress inetAddress;
        if (discoveryPDU == null) {
            Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::processMsg : received null pdu ");
            return;
        }
        Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualResponder::processMsg : received pdu '" + discoveryPDU.printState() + "'"));
        if (discoveryPDU.getHost() != null) {
            if (this.localHostName.compareTo(discoveryPDU.getHost()) != 0) {
                Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualResponder::processMsg : local host ('" + this.localHostName + "') is not '" + discoveryPDU.getHost() + "' - No answer is required "));
                return;
            }
            Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualResponder::processMsg : Request is for this host ('" + this.localHostName + "')"));
        } else {
            Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::processMsg : Request is for all host");
        }
        Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::processMsg : Format response PDU");
        ResponsePDU responsePDU = new ResponsePDU();
        this.formatPdu(responsePDU, discoveryPDU, false);
        Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::processMsg : Check point to point response");
        if (discoveryPDU.getReturnAddr()) {
            Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualResponder::processMsg : Point to point response using  Port " + discoveryPDU.getReturnPort() + " on Host " + discoveryPDU.getReturnHost()));
            inetAddress = discoveryPDU.getReturnHost();
            n = discoveryPDU.getReturnPort();
        } else {
            Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::processMsg : Use multicast socket for response");
            inetAddress = this.multicastGroup;
            n = this.multicastPort;
        }
        try {
            this.setTTL(responsePDU.getTtl());
            this.sendMsg(responsePDU, inetAddress, n);
        }
        catch (IOException iOException) {
            Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::processMsg : Unable to send response !");
            Debug.printException((Exception)iOException);
            throw iOException;
        }
    }

    public void run() {
        if (!this.spy && this.sendEvent) {
            this.sendEvent(0);
        }
        while (!this.stopRequested) {
            try {
                Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::run : -------------------- Start Waiting -------------------- ");
                if (this.spy) {
                    DiscoveryMsg discoveryMsg = this.receiveMsg(this);
                    Debug.print((int)1024, (Object)("jawdiscovery.internal.ActualResponder::run (SPY) receive : " + discoveryMsg.printState()));
                    continue;
                }
                DiscoveryPDU discoveryPDU = (DiscoveryPDU)this.receiveMsg(this);
                this.processMsg(discoveryPDU);
            }
            catch (InterruptedIOException interruptedIOException) {
                Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::run : Stop execution ");
                this.stopRequested = true;
            }
            catch (IOException iOException) {
                Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::run : Not a discovering msg - continue - ");
                if (!this.spy) continue;
                Debug.printException((Exception)iOException);
            }
            catch (ClassCastException classCastException) {
                Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::run : Not a discovering msg - continue - ");
                if (!this.spy) continue;
                Debug.printException((Exception)classCastException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::run : Not a discovering msg - continue - ");
                if (!this.spy) continue;
                Debug.printException((Exception)classNotFoundException);
            }
        }
        if (this.sendEvent) {
            this.sendEvent(1);
        }
        this.close();
    }

    private void sendEvent(int n) {
        Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::sendEvent : Format Event PDU");
        ResponsePDU responsePDU = new ResponsePDU();
        this.formatPdu(responsePDU, null, true);
        responsePDU.setAgentState(n);
        try {
            this.sendMsg(responsePDU, this.multicastGroup, this.multicastPort);
        }
        catch (IOException iOException) {
            Debug.print((int)1024, (Object)"jawdiscovery.internal.ActualResponder::sendEvent : Unable to send event !");
            Debug.printException((Exception)iOException);
        }
    }
}

