/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.jawdiscovery.internal;

import com.sun.jaw.impl.agent.services.jawdiscovery.internal.Msg.DiscoveryMsg;
import com.sun.jaw.reference.common.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public abstract class DiscoveryCommon
extends MulticastSocket
implements Runnable {
    protected int multicastPort;
    protected InetAddress multicastGroup;
    protected InetAddress localHost;
    protected String localHostName;
    protected InetAddress selectedHost;
    protected String selectedHostName;

    public DiscoveryCommon(String string, int n) throws IOException {
        super(n);
        Debug.print((int)1024, (Object)("jawdiscovery.internal.DiscoveryCommon::constructor group = " + string + ", " + "port  = " + n));
        try {
            this.multicastGroup = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            Debug.printException((Exception)unknownHostException);
        }
        this.multicastPort = n;
        try {
            this.localHost = InetAddress.getLocalHost();
            this.localHostName = InetAddress.getLocalHost().getHostName();
            this.selectedHost = InetAddress.getLocalHost();
            this.selectedHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            Debug.printException((Exception)unknownHostException);
        }
    }

    public void connectToGroup() throws IOException {
        Debug.print((int)1024, (Object)("jawdiscovery.internal.DiscoveryCommon::connectToGroup : join Group " + this.multicastGroup));
        this.joinGroup(this.multicastGroup);
    }

    public void disconnectFromGroup() throws IOException {
        Debug.print((int)1024, (Object)("jawdiscovery.internal.DiscoveryCommon::disconnectFromGroup : leave Group " + this.multicastGroup));
        this.leaveGroup(this.multicastGroup);
    }

    public InetAddress getHostAddr() {
        return this.selectedHost;
    }

    public String getHostName() {
        return this.selectedHostName;
    }

    public InetAddress getLocalHostAddr() {
        return this.localHost;
    }

    public String getLocalHostName() {
        return this.localHostName;
    }

    private Object objectDeserialization(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.printException((Exception)classNotFoundException);
            throw classNotFoundException;
        }
        catch (OptionalDataException optionalDataException) {
            Debug.printException((Exception)optionalDataException);
            throw new IOException(optionalDataException.getMessage());
        }
    }

    private byte[] objectSerialization(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    protected synchronized DiscoveryMsg receiveMsg(DatagramSocket datagramSocket) throws IOException, ClassNotFoundException, InvalidClassException {
        DiscoveryMsg discoveryMsg;
        byte[] byArray = new byte[100000];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        try {
            Debug.print((int)1024, (Object)"jawdiscovery.internal.DiscoveryCommon::receiveMsg : Start waiting");
            datagramSocket.receive(datagramPacket);
            Debug.print((int)1024, (Object)"jawdiscovery.internal.DiscoveryCommon::receiveMsg : We Receive something");
            byte[] byArray2 = datagramPacket.getData();
            discoveryMsg = (DiscoveryMsg)this.objectDeserialization(byArray2);
            InetAddress inetAddress = discoveryMsg.getEmittedGroup();
            if (!inetAddress.equals(this.multicastGroup)) {
                Debug.print((int)1024, (Object)"jawdiscovery.internal.DiscoveryCommon::receiveMsg : Receive a msg for another group");
                throw new IOException();
            }
            Debug.print((int)1024, (Object)"jawdiscovery.internal.DiscoveryCommon::receiveMsg : Receive a msg");
        }
        catch (InterruptedIOException interruptedIOException) {
            return null;
        }
        return discoveryMsg;
    }

    public void run() {
    }

    protected void sendMsg(DiscoveryMsg discoveryMsg, InetAddress inetAddress, int n) throws IOException {
        byte[] byArray = null;
        try {
            byArray = this.objectSerialization(discoveryMsg);
        }
        catch (IOException iOException) {
            Debug.printException((Exception)iOException);
            throw iOException;
        }
        Debug.print((int)1024, (Object)("jawdiscovery.internal.DiscoveryCommon::sendMsg : Send msg '" + discoveryMsg.printState() + "'"));
        Debug.print((int)1024, (Object)("jawdiscovery.internal.DiscoveryCommon::sendMsg : destination address = " + inetAddress + " Port = " + n));
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        this.send(datagramPacket);
    }
}

