/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.loader.rmi;

import com.sun.jaw.impl.agent.services.loader.rmi.NetLibLoader;
import com.sun.jaw.impl.common.ClassDefinition;
import com.sun.jaw.impl.server.rmi.NetClassServer;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.ActivatableIf;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.LoaderRepository;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.common.ServiceNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.security.CodeSource;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureClassLoader;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Hashtable;
import java.util.Vector;

public class NetClassLoader
extends SecureClassLoader
implements Externalizable,
ActivatableIf {
    private Framework cmf = null;
    private ObjectName localName = null;
    private String serverHost = null;
    private String serverName = null;
    private int serverPort;
    private transient NetClassServer classServer = null;
    private NetLibLoader libLoader = null;
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String SERVICE = "service";
    private static final int defaultPort = 1099;
    private static final String defaultService = "NetClassServer";
    private static final String defaultHost = "localhost";
    private static final String sccs_id = "@(#)NetClassLoader.java 1.9 03/11/99 SMI";
    private static final byte TE_NULL = 112;
    private static final byte TE_OBJECT = 113;
    private transient boolean active = false;

    public NetClassLoader() {
        LoaderRepository.addClassLoader((ClassLoader)this);
    }

    public NetClassLoader(ObjectName objectName) {
        this();
        this.initNetClassLoader(objectName);
    }

    private NetClassServer connectToClassLoader(String string, int n, String string2) {
        NetClassServer netClassServer;
        String string3 = new String("rmi://" + string + ":" + n + "/" + string2);
        try {
            netClassServer = (NetClassServer)Naming.lookup(string3);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            throw new ServiceNotFoundException("Can't contact RMI class  server at " + string3);
        }
        return netClassServer;
    }

    public void deleteCmf() {
        LoaderRepository.removeClassLoader((ClassLoader)this);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class clazz = null;
        Debug.print((Object)("NetClassLoader::findClass: findClass(" + string + ")"));
        if (clazz == null) {
            try {
                clazz = this.findRemoteClass(string);
                if (clazz != null) {
                    Debug.print((Object)("NetClassLoader::findClass: Class " + string + " loaded through net classloader"));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            try {
                clazz = LoaderRepository.loadClassWithout((ClassLoader)this, (String)string);
                Debug.print((Object)("NetClassLoader::findClass: Class " + string + " loaded through classloader repository"));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    protected String findLibrary(String string) {
        if (!this.active) {
            this.performStart();
        }
        return this.libLoader.findLibrary(this.classServer, string);
    }

    private synchronized Class findRemoteClass(String string) throws ClassNotFoundException {
        Object object;
        Object object2;
        Object object3;
        ClassDefinition classDefinition;
        if (!this.active) {
            this.performStart();
        }
        try {
            classDefinition = this.classServer.getClass(string);
        }
        catch (RemoteException remoteException) {
            throw new SecurityException(remoteException.detail.getMessage());
        }
        catch (IOException iOException) {
            throw new SecurityException(iOException.getMessage());
        }
        String string2 = classDefinition.getClassName();
        String string3 = classDefinition.getClassPath();
        byte[] byArray = classDefinition.getClassImage();
        byte[] byArray2 = classDefinition.getClassDigest();
        byte[] byArray3 = classDefinition.getDigestSignature();
        byte[] byArray4 = classDefinition.getCertificate();
        Certificate certificate = null;
        if (byArray4 != null) {
            Object object4;
            String string4;
            String string5;
            object3 = null;
            try {
                object3 = CertificateFactory.getInstance("X.509");
                object2 = new ByteArrayInputStream(byArray4);
                while (((ByteArrayInputStream)object2).available() > 0) {
                    certificate = ((CertificateFactory)object3).generateCertificate((InputStream)object2);
                }
            }
            catch (CertificateException certificateException) {
                throw new SecurityException("CertificateException on parsing errors");
            }
            object2 = certificate.getPublicKey();
            try {
                certificate.verify((PublicKey)object2);
            }
            catch (Exception exception) {
                throw new SecurityException("Unable to verify certificate");
            }
            object = object2.getAlgorithm();
            if (((String)object).equals("DSA")) {
                string5 = "SHA";
                string4 = "SHA/DSA";
            } else if (((String)object).equals("RSA")) {
                string5 = "MD5";
                string4 = "MD5/RSA";
            } else {
                throw new SecurityException("Public key is not a DSA or RSA key");
            }
            try {
                object4 = Signature.getInstance(string4);
                ((Signature)object4).initVerify((PublicKey)object2);
                ((Signature)object4).update(byArray2);
                if (!((Signature)object4).verify(byArray3)) {
                    throw new SecurityException("Class not signed with public key in certificate");
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SecurityException("The signature algorithm " + string4 + " is not available");
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SecurityException("Invalid public key");
            }
            catch (SignatureException signatureException) {
                throw new SecurityException("Unable to verify signature for class");
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string5);
                messageDigest.update(byArray);
                object4 = messageDigest.digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SecurityException("The message digest algorithm " + string5 + " is not available");
            }
            if (byArray2.length != ((Object)object4).length) {
                throw new SecurityException("Class has been tampered with");
            }
            int n = 0;
            while (n < byArray2.length) {
                if (byArray2[n] != object4[n]) {
                    throw new SecurityException("Class has been tampered with");
                }
                ++n;
            }
        }
        if (byArray != null) {
            object3 = null;
            try {
                object3 = new URL("rmi://" + this.serverHost + ":" + this.serverPort + "/" + this.serverName);
            }
            catch (MalformedURLException malformedURLException) {}
            object2 = null;
            if (certificate != null) {
                object2 = new Certificate[]{certificate};
            }
        } else {
            throw new ClassNotFoundException();
        }
        object = new CodeSource((URL)object3, (Certificate[])object2);
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length, (CodeSource)object);
        Debug.print((Object)("NetClassLoader::findClass: Get class " + string + " from class server"));
        return clazz;
    }

    public static String getClassVersion() {
        return sccs_id;
    }

    public Vector getLibPaths() {
        return this.libLoader.getLibPaths();
    }

    public ObjectName getLoaderName() {
        return this.localName;
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException {
        Debug.print((Object)"NetClassLoader::initCmf: start initializing loader");
        this.cmf = framework;
        this.initNetClassLoader(objectName);
        if (bl) {
            framework.addDBObject(this, objectName);
        } else {
            framework.addObject(this, objectName);
        }
    }

    private void initNetClassLoader(ObjectName objectName) {
        Hashtable hashtable = this.parseName(objectName);
        this.serverHost = (String)hashtable.get(HOST);
        this.serverName = (String)hashtable.get(SERVICE);
        this.serverPort = (Integer)hashtable.get(PORT);
        this.libLoader = new NetLibLoader(objectName);
        this.localName = objectName;
        if (this.active) {
            this.performStop();
        }
        this.performStart();
    }

    public boolean isActive() {
        return this.active;
    }

    private Hashtable parseName(ObjectName objectName) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string = (String)objectName.getProperty(HOST);
        if (string == null) {
            string = defaultHost;
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {}
        }
        hashtable.put(HOST, string);
        Integer n = (Integer)objectName.getProperty(PORT);
        if (n == null) {
            n = new Integer(1099);
        }
        hashtable.put(PORT, n);
        String string2 = (String)objectName.getProperty(SERVICE);
        if (string2 == null) {
            string2 = defaultService;
        }
        hashtable.put(SERVICE, string2);
        return hashtable;
    }

    public synchronized void performStart() {
        Debug.print((Object)"NetClassLoader::performStart: Start the NetClassLoader service.");
        if (!this.active) {
            this.classServer = this.connectToClassLoader(this.serverHost, this.serverPort, this.serverName);
            this.active = true;
        } else {
            Debug.print((Object)"NetClassLoader::performStart: The NetClassLoader service is already activated.");
        }
    }

    public synchronized void performStop() {
        Debug.print((Object)"NetClassLoader::performStop: Stop the NetClassLoader service.");
        if (this.active) {
            this.classServer = null;
            this.active = false;
        } else {
            Debug.print((Object)"NetClassLoader::performStop: The NetClassLoader service is already deactived.");
        }
    }

    private Object readContents(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by == 113) {
            return objectInput.readObject();
        }
        if (by == 112) {
            return null;
        }
        throw new IOException("Input stream corrupted.");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.cmf = (Framework)this.readContents(objectInput);
        this.localName = (ObjectName)this.readContents(objectInput);
        this.libLoader = (NetLibLoader)this.readContents(objectInput);
        this.serverHost = (String)this.readContents(objectInput);
        this.serverName = (String)this.readContents(objectInput);
        this.serverPort = objectInput.readInt();
        LoaderRepository.addClassLoader((ClassLoader)this);
    }

    public void setLibPaths(Vector vector) throws RemoteException {
        this.libLoader.setLibPaths(vector);
    }

    private void writeContents(ObjectOutput objectOutput, Object object) throws IOException {
        if (object == null) {
            objectOutput.writeByte(112);
        } else {
            objectOutput.writeByte(113);
            objectOutput.writeObject(object);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeContents(objectOutput, this.cmf);
        this.writeContents(objectOutput, this.localName);
        this.writeContents(objectOutput, this.libLoader);
        this.writeContents(objectOutput, this.serverHost);
        this.writeContents(objectOutput, this.serverName);
        objectOutput.writeInt(this.serverPort);
    }
}

