/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.loader.rmi;

import com.sun.jaw.impl.common.DefaultPaths;
import com.sun.jaw.impl.common.Library;
import com.sun.jaw.impl.common.LibraryDefinition;
import com.sun.jaw.impl.server.rmi.NetClassServer;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.ObjectName;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class NetLibLoader
implements Serializable {
    private Vector libPaths = new Vector();
    private static final String LIBPATH = "libpath";
    private static final String sccs_id = "@(#)NetLibLoader.java 1.6 03/31/99 SMI";

    public NetLibLoader(ObjectName objectName) {
        String string = (String)objectName.getProperty(LIBPATH);
        if (string == null && (string = System.getProperty("jaw.net.library.path")) == null) {
            string = DefaultPaths.getTmpDir();
        }
        if (string != null) {
            this.libPaths = this.updatePathFromString(string);
        }
    }

    public String findLibrary(NetClassServer netClassServer, String string) {
        LibraryDefinition libraryDefinition;
        Debug.print((Object)("NetLibLoader::findLibrary: " + string));
        LibraryDefinition libraryDefinition2 = new LibraryDefinition();
        libraryDefinition2.setLibName(string);
        libraryDefinition2.setNativeName(System.mapLibraryName(string));
        libraryDefinition2.setOSName(Library.removeSpace((String)System.getProperty("os.name")));
        libraryDefinition2.setOSArch(System.getProperty("os.arch"));
        libraryDefinition2.setOSVersion(System.getProperty("os.version"));
        try {
            libraryDefinition = netClassServer.getLibrary(libraryDefinition2);
        }
        catch (Exception exception) {
            Debug.print((Object)("NetLibLoader::findLibrary: " + string + " not found in the class server."));
            Debug.print((Object)("NetLibLoader::findLibrary: Search " + string + " along the path specified as the java.library.path property."));
            return null;
        }
        String string2 = null;
        try {
            string2 = (String)this.libPaths.firstElement();
        }
        catch (Exception exception) {
            Debug.print((Object)("NetLibLoader::findLibrary: " + string + " not found in the class server."));
            Debug.print((Object)("NetLibLoader::findLibrary: Search " + string + " along the path specified as the java.library.path property."));
            return null;
        }
        File file = null;
        String string3 = null;
        try {
            String string4 = libraryDefinition.getRelativePath();
            string3 = string4 != null && string4.length() > 0 ? String.valueOf(string2) + File.separator + string4 + File.separator + libraryDefinition.getNativeName() : String.valueOf(string2) + File.separator + libraryDefinition.getNativeName();
            file = new File(string3.substring(0, string3.lastIndexOf(File.separator)));
            file.mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            fileOutputStream.write(libraryDefinition.getImage());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Debug.print((Object)("NetLibLoader::findLibrary: " + string + " not found in the class server."));
            Debug.print((Object)("NetLibLoader::findLibrary: Search " + string + " along the path specified as the java.library.path property."));
            return null;
        }
        Debug.print((Object)("NetLibLoader::findLibrary: " + string + " loaded"));
        return string3;
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public Vector getLibPaths() {
        return this.libPaths;
    }

    public void setLibPaths(Vector vector) {
        this.libPaths = vector;
    }

    private Vector updatePathFromString(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = File.pathSeparator;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = (String)stringTokenizer.nextElement();
            vector.addElement(string3);
            Debug.print((Object)("NetLibLoader::updatePathFromString: Add " + string3 + " to classpath"));
        }
        return vector;
    }
}

