/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.mlet;

import com.sun.jaw.impl.agent.services.mlet.internal.MLetObjectInputStream;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.MoRepSrvIf;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.LoaderRepository;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class MLetClassLoader
extends URLClassLoader
implements Externalizable {
    private URL codebase = null;
    private URL[] data = null;
    private ObjectName name = null;
    private Framework cmf = null;
    private String libraryDirectory = null;
    private static final String sccs_id = "@(#)MLetClassLoader.java 1.8 03/24/99 SMI";
    private static final byte TE_NULL = 112;
    private static final byte TE_OBJECT = 113;

    public MLetClassLoader() {
        super(new URL[0]);
        LoaderRepository.addClassLoader((ClassLoader)this);
    }

    public MLetClassLoader(URL uRL) {
        this();
        this.codebase = uRL;
    }

    public void addJarFileURL(String string) {
        block4: {
            try {
                this.addURL(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {}
            if (this.cmf == null || this.name == null) break block4;
            MoRepSrvIf moRepSrvIf = this.cmf.getMoRepSrvIf();
            try {
                moRepSrvIf.update(this, this.name);
            }
            catch (Exception exception) {}
        }
    }

    public void deleteCmf() {
        LoaderRepository.removeClassLoader((ClassLoader)this);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class clazz = null;
        Debug.print((int)512, (Object)("MLetClassLoader::findClass: findClass(" + string + ")"));
        try {
            clazz = super.findClass(string);
            Debug.print((int)512, (Object)("MLetClassLoader::findClass: Class " + string + " loaded through mlet classloader"));
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (clazz == null) {
            try {
                clazz = LoaderRepository.loadClassWithout((ClassLoader)this, (String)string);
                Debug.print((int)512, (Object)("MLetClassLoader::findClass: Class " + string + " loaded through classloader repository"));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    protected String findLibrary(String string) {
        String string2 = System.mapLibraryName(string);
        Debug.print((int)512, (Object)("MLetClassLoader::findLibrary: Search " + string + " in all JAR files."));
        Debug.print((int)512, (Object)("MLetClassLoader::findLibrary: loadLibraryAsResource(" + string2 + ")"));
        String string3 = this.loadLibraryAsResource(string2);
        if (string3 != null) {
            Debug.print((int)512, (Object)("MLetClassLoader::findLibrary: " + string2 + " loaded"));
            return string3;
        }
        string2 = String.valueOf(this.removeSpace(System.getProperty("os.name"))) + File.separator + this.removeSpace(System.getProperty("os.arch")) + File.separator + this.removeSpace(System.getProperty("os.version")) + File.separator + "lib" + File.separator + string2;
        Debug.print((int)512, (Object)("MLetClassLoader::findLibrary: loadLibraryAsResource(" + string2 + ")"));
        string3 = this.loadLibraryAsResource(string2);
        if (string3 != null) {
            Debug.print((int)512, (Object)("MLetClassLoader::findLibrary: " + string2 + " loaded"));
            return string3;
        }
        Debug.print((int)512, (Object)("MLetClassLoader::findLibrary: " + string + " not found in any JAR file."));
        Debug.print((int)512, (Object)("MLetClassLoader::findLibrary: Search " + string + " along the path specified as the java.library.path property."));
        return null;
    }

    public static String getClassVersion() {
        return sccs_id;
    }

    public URL getCodeBase() {
        return this.codebase;
    }

    String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    public ObjectName getLoaderName() {
        return this.name;
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws IllegalAccessException, InstanceAlreadyExistException {
        this.cmf = framework;
        this.name = objectName;
        try {
            String string = (String)objectName.getProperty("codebase");
            this.codebase = new URL(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Caught exception while creating class loader for MLet: Bad codebase for MLetClassLoader");
        }
        if (bl) {
            framework.addDBObject(this, objectName);
        } else {
            framework.addObject(this, objectName);
        }
    }

    private synchronized String loadLibraryAsResource(String string) {
        try {
            InputStream inputStream = ((ClassLoader)this).getResourceAsStream(string.replace(File.separatorChar, '/'));
            if (inputStream != null) {
                int n;
                File file = new File(this.libraryDirectory, string);
                file.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                inputStream.close();
                fileOutputStream.close();
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public Object loadSerializedObject(URL uRL, String string) throws IOException, ClassNotFoundException {
        if (string != null) {
            string = string.replace(File.separatorChar, '/');
        }
        Debug.print((int)512, (Object)("MLetClassLoader::loadSerializedObject: loadSerializedObject(" + uRL.toString() + string + ")"));
        InputStream inputStream = ((ClassLoader)this).getResourceAsStream(string);
        if (inputStream != null) {
            try {
                MLetObjectInputStream mLetObjectInputStream = new MLetObjectInputStream(inputStream, this);
                Object object = mLetObjectInputStream.readObject();
                mLetObjectInputStream.close();
                return object;
            }
            catch (IOException iOException) {
                System.err.println("Exception while deserializing " + string + ", " + iOException.getMessage());
                throw iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Exception while deserializing " + string + ", " + classNotFoundException.getMessage());
                throw classNotFoundException;
            }
        }
        System.err.println("Error: File " + string + " containing serialized object not found");
        throw new Error("File " + string + " containing serialized object not found");
    }

    private Object readContents(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by == 113) {
            return objectInput.readObject();
        }
        if (by == 112) {
            return null;
        }
        throw new IOException("Input stream corrupted.");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.codebase = (URL)this.readContents(objectInput);
        this.data = (URL[])this.readContents(objectInput);
        if (this.data != null) {
            int n = 0;
            while (n < this.data.length) {
                this.addURL(this.data[n]);
                ++n;
            }
        }
        this.name = (ObjectName)this.readContents(objectInput);
        this.cmf = (Framework)this.readContents(objectInput);
        this.libraryDirectory = (String)this.readContents(objectInput);
        LoaderRepository.addClassLoader((ClassLoader)this);
    }

    private String removeSpace(String string) {
        int n = (string = string.trim()).indexOf(32);
        if (n == -1) {
            return string;
        }
        String string2 = new String();
        int n2 = 0;
        while (n != -1) {
            n = (string = string.substring(n2)).indexOf(32);
            string2 = n != -1 ? String.valueOf(string2) + string.substring(0, n) : String.valueOf(string2) + string.substring(0);
            n2 = n + 1;
        }
        return string2;
    }

    void setLibraryDirectory(String string) {
        this.libraryDirectory = string;
    }

    private void writeContents(ObjectOutput objectOutput, Object object) throws IOException {
        if (object == null) {
            objectOutput.writeByte(112);
        } else {
            objectOutput.writeByte(113);
            objectOutput.writeObject(object);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeContents(objectOutput, this.codebase);
        this.data = this.getURLs();
        this.writeContents(objectOutput, this.data);
        this.writeContents(objectOutput, this.name);
        this.writeContents(objectOutput, this.cmf);
        this.writeContents(objectOutput, this.libraryDirectory);
    }
}

