/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.mlet.internal;

import com.sun.jaw.impl.agent.services.mlet.MLetClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;

public class MLetObjectInputStream
extends ObjectInputStream {
    private MLetClassLoader loader;

    public MLetObjectInputStream(InputStream inputStream, MLetClassLoader mLetClassLoader) throws IOException, StreamCorruptedException {
        super(inputStream);
        if (mLetClassLoader == null) {
            throw new IllegalArgumentException("Illegal null argument to MLetObjectInputStream");
        }
        this.loader = mLetClassLoader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    private Class primitiveType(char c) {
        switch (c) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (string.startsWith("[")) {
            Class<?> clazz;
            int n = 1;
            while (string.charAt(n) == '[') {
                ++n;
            }
            if (string.charAt(n) == 'L') {
                clazz = this.loader.loadClass(string.substring(n + 1, string.length() - 1));
            } else {
                if (string.length() != n + 1) {
                    throw new ClassNotFoundException(string);
                }
                clazz = this.primitiveType(string.charAt(n));
            }
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = 0;
                ++n2;
            }
            return Array.newInstance(clazz, nArray).getClass();
        }
        return this.loader.loadClass(string);
    }
}

