/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.monitor;

import com.sun.jaw.impl.agent.services.alarm.AlarmClockEvent;
import com.sun.jaw.impl.agent.services.alarm.AlarmClockListener;
import com.sun.jaw.impl.agent.services.monitor.Monitor;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.InvalidPropertyValueException;
import com.sun.jaw.reference.common.PropertyNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;

public class CounterMonitor
extends Monitor
implements AlarmClockListener,
Serializable {
    private transient Integer comparisonLevel = new Integer(0);
    private Integer offsetValue = new Integer(0);
    private Boolean notifyOnOff = new Boolean(false);
    private Boolean counterDifferenceOnOff = new Boolean(false);
    private transient Integer previousScanCounter = new Integer(-1);
    private transient Boolean previousScanCounterInitialisedOnOff = new Boolean(false);
    private Integer modulusValue = new Integer(0);
    private int iclv = 0;
    private transient int old_dg_value = -1;
    private transient boolean cl_exceeds_mv = false;
    private transient boolean dg_exceeds_cl_notified = false;
    private static final int COMPARISON_LEVEL_ALREADY_NOTIFIED = 16;
    private static final int OFFSET_VALUE_ALREADY_NOTIFIED = 32;
    private static final int MODULUS_VALUE_ALREADY_NOTIFIED = 64;
    private static final String sccs_id = "@(#)CounterMonitor.java 3.2 01/07/99 SMI";

    public Integer getComparisonLevel() {
        Debug.print((int)128, (Object)("Monitor::getComparisonLevel: ComparisonLevel = " + this.comparisonLevel));
        return this.comparisonLevel;
    }

    public Boolean getCounterDifferenceOnOff() {
        Debug.print((int)128, (Object)("Monitor::getCounterDifferenceOnOff: CounterDifferenceOnOff = " + this.counterDifferenceOnOff));
        return this.counterDifferenceOnOff;
    }

    public Integer getModulusValue() {
        Debug.print((int)128, (Object)("Monitor::getModulusValue: ModulusValue = " + this.modulusValue));
        return this.modulusValue;
    }

    public Boolean getNotifyOnOff() {
        Debug.print((int)128, (Object)("Monitor::getNotifyOnOff: NotifyOnOff = " + this.notifyOnOff));
        return this.notifyOnOff;
    }

    public Integer getOffsetValue() {
        Debug.print((int)128, (Object)("Monitor::getOffsetValue: OffsetValue = " + this.offsetValue));
        return this.offsetValue;
    }

    public Integer getPreviousScanCounter() {
        Debug.print((int)128, (Object)("Monitor::getPreviousScanCounter: PreviousScanCounter = " + this.previousScanCounter));
        return this.previousScanCounter;
    }

    public Boolean getPreviousScanCounterInitialisedOnOff() {
        Debug.print((int)128, (Object)("Monitor::getPreviousScanCounterInitialisedOnOff: PreviousScanCounterInitialisedOnOff = " + this.previousScanCounterInitialisedOnOff));
        return this.previousScanCounterInitialisedOnOff;
    }

    public void handleAlarmClock(AlarmClockEvent alarmClockEvent) {
        block31: {
            Object object = null;
            try {
                if (!this.administrativeStateOnOff.booleanValue()) break block31;
                try {
                    object = this.cmf.getValue(this.observedObject, this.observedProperty);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if ((this.already_notified & 2) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 2;
                    this.already_notified |= 2;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Observed object must be registered in CMF");
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    if ((this.already_notified & 4) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 3;
                    this.already_notified |= 4;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Observed property not found in observed object");
                }
                if (!(object instanceof Integer)) {
                    if ((this.already_notified & 8) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 4;
                    this.already_notified |= 8;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Observed property type must be <Integer>");
                }
                if (this.granularityPeriod <= 0L) {
                    if ((this.already_notified & 1) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 1;
                    this.already_notified |= 1;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Granularity period must be greater than zero");
                }
                if (this.comparisonLevel < 0) {
                    if ((this.already_notified & 0x10) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 5;
                    this.already_notified |= 0x10;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Comparison level must be a non-negative integer");
                }
                if (this.offsetValue < 0) {
                    if ((this.already_notified & 0x20) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 6;
                    this.already_notified |= 0x20;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Offset value must be a non-negative integer");
                }
                if (this.modulusValue < 0) {
                    if ((this.already_notified & 0x40) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 7;
                    this.already_notified |= 0x40;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Modulus value must be a non-negative integer");
                }
                this.event_type = 0;
                this.already_notified = 0;
                if (this.cl_exceeds_mv && this.derivedGauge.intValue() - this.old_dg_value < 0) {
                    this.comparisonLevel = new Integer(this.iclv);
                    this.cl_exceeds_mv = false;
                    this.dg_exceeds_cl_notified = false;
                }
                if (this.counterDifferenceOnOff.booleanValue()) {
                    if (this.previousScanCounterInitialisedOnOff.booleanValue()) {
                        this.derivedGauge = new Integer((Integer)object - this.previousScanCounter);
                        if (this.derivedGauge.intValue() < 0) {
                            if (this.modulusValue > 0) {
                                this.derivedGauge = new Integer((Integer)object - this.previousScanCounter + this.modulusValue);
                            }
                            this.comparisonLevel = new Integer(this.iclv);
                            this.dg_exceeds_cl_notified = false;
                        }
                        this.derivedGaugeTimestamp = new Date();
                        this.previousScanCounter = (Integer)object;
                    } else {
                        this.derivedGauge = new Integer(-1);
                        this.derivedGaugeTimestamp = new Date();
                        this.previousScanCounter = (Integer)object;
                        this.previousScanCounterInitialisedOnOff = new Boolean(true);
                    }
                } else {
                    this.derivedGauge = (Integer)object;
                    this.derivedGaugeTimestamp = new Date();
                }
                Debug.print((int)128, (Object)"");
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: instance = " + this));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: ObservedObject = " + this.observedObject));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: ObservedProperty = " + this.observedProperty));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: GranularityPeriod = " + this.granularityPeriod));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: DerivedGauge = " + this.derivedGauge));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: DerivedGaugeTimestamp = " + this.derivedGaugeTimestamp));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: AdministrativeStateOnOff = " + this.administrativeStateOnOff));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: ComparisonLevel = " + this.comparisonLevel));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: OffsetValue = " + this.offsetValue));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: NotifyOnOff = " + this.notifyOnOff));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: CounterDifferenceOnOff = " + this.counterDifferenceOnOff));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: PreviousScanCounter = " + this.previousScanCounter));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: PreviousScanCounterInitialisedOnOff = " + this.previousScanCounterInitialisedOnOff));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: ModulusValue = " + this.modulusValue));
                Debug.print((int)128, (Object)"");
                if (this.derivedGauge.intValue() >= 0 && this.derivedGauge.intValue() >= this.comparisonLevel) {
                    if (this.notifyOnOff.booleanValue() && !this.dg_exceeds_cl_notified) {
                        this.dg_exceeds_cl_notified = true;
                        this.notifyMonitor(new Integer(8), "MONITOR EVENT: Threshold value reached", this.observedObject, this.observedProperty, this.derivedGauge);
                    }
                    if (this.offsetValue > 0) {
                        int n = this.comparisonLevel;
                        while (this.derivedGauge.intValue() - n >= 0) {
                            n += this.offsetValue.intValue();
                        }
                        if (!this.counterDifferenceOnOff.booleanValue() && this.modulusValue > 0 && n > this.modulusValue) {
                            this.old_dg_value = this.derivedGauge.intValue();
                            this.cl_exceeds_mv = true;
                        }
                        this.comparisonLevel = new Integer(n);
                        this.dg_exceeds_cl_notified = false;
                    } else {
                        this.old_dg_value = this.derivedGauge.intValue();
                        this.cl_exceeds_mv = true;
                    }
                }
                this.alarmClock.performStart();
            }
            catch (InvalidPropertyValueException invalidPropertyValueException) {
                this.notifyMonitor(new Integer(this.event_type), invalidPropertyValueException.getMessage(), this.observedObject, this.observedProperty, this.derivedGauge);
                this.old_dg_value = -1;
                this.cl_exceeds_mv = false;
                this.dg_exceeds_cl_notified = false;
                this.previousScanCounter = new Integer(-1);
                this.previousScanCounterInitialisedOnOff = new Boolean(false);
                this.alarmClock.performStart();
            }
            catch (Exception exception) {
                System.err.println("Monitor::handleAlarmClock: Exception in MONITOR: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public synchronized void performStop() {
        if (this.administrativeStateOnOff.booleanValue()) {
            super.performStop();
            this.comparisonLevel = new Integer(this.iclv);
            this.old_dg_value = -1;
            this.cl_exceeds_mv = false;
            this.dg_exceeds_cl_notified = false;
            this.previousScanCounter = new Integer(-1);
            this.previousScanCounterInitialisedOnOff = new Boolean(false);
        } else {
            Debug.print((int)128, (Object)"Monitor::performStop: The Monitor service is already deactivated.");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.comparisonLevel = new Integer(this.iclv);
        this.old_dg_value = -1;
        this.cl_exceeds_mv = false;
        this.dg_exceeds_cl_notified = false;
        this.previousScanCounter = new Integer(-1);
        this.previousScanCounterInitialisedOnOff = new Boolean(false);
    }

    public void setComparisonLevel(Integer n) {
        Debug.print((int)128, (Object)("Monitor::setComparisonLevel: ComparisonLevel = " + n));
        this.iclv = n;
        this.old_dg_value = -1;
        this.cl_exceeds_mv = false;
        this.comparisonLevel = n;
        this.dg_exceeds_cl_notified = false;
        this.already_notified &= 0xFFFFFFEF;
    }

    public void setCounterDifferenceOnOff(Boolean bl) {
        Debug.print((int)128, (Object)("Monitor::setCounterDifferenceOnOff: CounterDifferenceOnOff = " + bl));
        this.counterDifferenceOnOff = bl;
        if (!this.counterDifferenceOnOff.booleanValue()) {
            this.comparisonLevel = new Integer(this.iclv);
            this.old_dg_value = -1;
            this.cl_exceeds_mv = false;
            this.dg_exceeds_cl_notified = false;
            this.previousScanCounter = new Integer(-1);
            this.previousScanCounterInitialisedOnOff = new Boolean(false);
        }
    }

    public void setModulusValue(Integer n) {
        Debug.print((int)128, (Object)("Monitor::setModulusValue: ModulusValue = " + n));
        this.modulusValue = n;
        this.already_notified &= 0xFFFFFFBF;
    }

    public void setNotifyOnOff(Boolean bl) {
        Debug.print((int)128, (Object)("Monitor::setNotifyOnOff: NotifyOnOff = " + bl));
        this.notifyOnOff = bl;
    }

    public void setOffsetValue(Integer n) {
        Debug.print((int)128, (Object)("Monitor::setOffsetValue: OffsetValue = " + n));
        this.offsetValue = n;
        this.already_notified &= 0xFFFFFFDF;
    }
}

