/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.monitor;

import com.sun.jaw.impl.agent.services.alarm.AlarmClockEvent;
import com.sun.jaw.impl.agent.services.alarm.AlarmClockListener;
import com.sun.jaw.impl.agent.services.monitor.Monitor;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.InvalidPropertyValueException;
import com.sun.jaw.reference.common.PropertyNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;

public class GaugeMonitor
extends Monitor
implements AlarmClockListener,
Serializable {
    private Number thresholdHighValue = new Integer(0);
    private Boolean notifyHighOnOff = new Boolean(false);
    private Number thresholdLowValue = new Integer(0);
    private Boolean notifyLowOnOff = new Boolean(false);
    private Boolean gaugeDifferenceOnOff = new Boolean(false);
    private transient Number previousScanGauge = new Integer(-1);
    private transient Boolean previousScanGaugeInitialisedOnOff = new Boolean(false);
    private static final int RISING = 0;
    private static final int FALLING = 1;
    private static final int RISING_OR_FALLING = 2;
    private int status = 2;
    private static final int FLOAT = 0;
    private static final int INTEGER = 1;
    private int type = 1;
    private boolean derivedGaugeValid = true;
    private static final int THRESHOLD_TYPE_ALREADY_NOTIFIED = 16;
    private static final int THRESHIGH_LOWER_THAN_THRESLOW_ALREADY_NOTIFIED = 32;
    private static final String sccs_id = "@(#)GaugeMonitor.java 3.2 01/07/99 SMI";

    public Boolean getGaugeDifferenceOnOff() {
        Debug.print((int)128, (Object)("Monitor::getGaugeDifferenceOnOff: GaugeDifferenceOnOff = " + this.gaugeDifferenceOnOff));
        return this.gaugeDifferenceOnOff;
    }

    public Boolean getNotifyHighOnOff() {
        Debug.print((int)128, (Object)("Monitor::getNotifyHighOnOff: NotifyHighOnOff = " + this.notifyHighOnOff));
        return this.notifyHighOnOff;
    }

    public Boolean getNotifyLowOnOff() {
        Debug.print((int)128, (Object)("Monitor::getNotifyLowOnOff: NotifyLowOnOff = " + this.notifyLowOnOff));
        return this.notifyLowOnOff;
    }

    public Number getPreviousScanGauge() {
        Debug.print((int)128, (Object)("Monitor::getPreviousScanGauge: PreviousScanGauge = " + this.previousScanGauge));
        return this.previousScanGauge;
    }

    public Boolean getPreviousScanGaugeInitialisedOnOff() {
        Debug.print((int)128, (Object)("Monitor::getPreviousScanGaugeInitialisedOnOff: PreviousScanGaugeInitialisedOnOff = " + this.previousScanGaugeInitialisedOnOff));
        return this.previousScanGaugeInitialisedOnOff;
    }

    public Number getThresholdHighValue() {
        Debug.print((int)128, (Object)("Monitor::getThresholdHighValue: ThresholdHighValue = " + this.thresholdHighValue));
        return this.thresholdHighValue;
    }

    public Number getThresholdLowValue() {
        Debug.print((int)128, (Object)("Monitor::getThresholdLowValue: ThresholdLowValue = " + this.thresholdLowValue));
        return this.thresholdLowValue;
    }

    public void handleAlarmClock(AlarmClockEvent alarmClockEvent) {
        block64: {
            Object object = null;
            Number number = this.derivedGauge;
            try {
                if (!this.administrativeStateOnOff.booleanValue()) break block64;
                try {
                    object = this.cmf.getValue(this.observedObject, this.observedProperty);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if ((this.already_notified & 2) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 2;
                    this.already_notified |= 2;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Observed object must be registered in CMF");
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    if ((this.already_notified & 4) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 3;
                    this.already_notified |= 4;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Observed property not found in observed object");
                }
                if (object instanceof Integer) {
                    this.type = 1;
                } else if (object instanceof Float) {
                    this.type = 0;
                } else {
                    if ((this.already_notified & 8) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 4;
                    this.already_notified |= 8;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Observed property type must be either <Integer> or <Float>");
                }
                if (this.type == 1) {
                    if (!(this.thresholdHighValue instanceof Integer) || !(this.thresholdLowValue instanceof Integer)) {
                        if ((this.already_notified & 0x10) != 0) {
                            this.alarmClock.performStart();
                            return;
                        }
                        this.event_type = 9;
                        this.already_notified |= 0x10;
                        throw new InvalidPropertyValueException("MONITOR EVENT: Threshold high and threshold low must be of the same type as the gauge");
                    }
                } else if (!(this.thresholdHighValue instanceof Float) || !(this.thresholdLowValue instanceof Float)) {
                    if ((this.already_notified & 0x10) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 9;
                    this.already_notified |= 0x10;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Threshold high and threshold low must be of the same type as the gauge");
                }
                if (this.type == 1) {
                    if (this.thresholdHighValue.intValue() < this.thresholdLowValue.intValue()) {
                        if ((this.already_notified & 0x20) != 0) {
                            this.alarmClock.performStart();
                            return;
                        }
                        this.event_type = 10;
                        this.already_notified |= 0x20;
                        throw new InvalidPropertyValueException("MONITOR EVENT: Threshold high value must be greater than or equal to threshold low value");
                    }
                } else if (this.thresholdHighValue.floatValue() < this.thresholdLowValue.floatValue()) {
                    if ((this.already_notified & 0x20) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 10;
                    this.already_notified |= 0x20;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Threshold high value must be greater than or equal to threshold low value");
                }
                if (this.granularityPeriod <= 0L) {
                    if ((this.already_notified & 1) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 1;
                    this.already_notified |= 1;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Granularity period must be greater than zero");
                }
                this.event_type = 0;
                this.already_notified = 0;
                if (this.gaugeDifferenceOnOff.booleanValue()) {
                    if (this.previousScanGaugeInitialisedOnOff.booleanValue()) {
                        this.derivedGaugeTimestamp = new Date();
                        this.derivedGaugeValid = true;
                        if (this.type == 1) {
                            this.derivedGauge = new Integer((Integer)object - this.previousScanGauge.intValue());
                            this.previousScanGauge = (Integer)object;
                        } else {
                            this.derivedGauge = new Float(((Float)object).floatValue() - this.previousScanGauge.floatValue());
                            this.previousScanGauge = (Float)object;
                        }
                    } else {
                        this.derivedGaugeTimestamp = new Date();
                        this.derivedGaugeValid = false;
                        this.previousScanGaugeInitialisedOnOff = new Boolean(true);
                        if (this.type == 1) {
                            this.derivedGauge = new Integer(-1);
                            this.previousScanGauge = (Integer)object;
                        } else {
                            this.derivedGauge = new Float(-1.0);
                            this.previousScanGauge = (Float)object;
                        }
                    }
                } else {
                    this.derivedGaugeTimestamp = new Date();
                    this.derivedGaugeValid = true;
                    this.derivedGauge = this.type == 1 ? (Number)((Integer)object) : (Number)((Float)object);
                }
                Debug.print((int)128, (Object)"");
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: instance = " + this));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: ObservedObject = " + this.observedObject));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: ObservedProperty = " + this.observedProperty));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: GranularityPeriod = " + this.granularityPeriod));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: DerivedGauge = " + this.derivedGauge));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: DerivedGaugeTimestamp = " + this.derivedGaugeTimestamp));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: AdministrativeStateOnOff = " + this.administrativeStateOnOff));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: ThresholdHighValue = " + this.thresholdHighValue));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: NotifyHighOnOff = " + this.notifyHighOnOff));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: ThresholdLowValue = " + this.thresholdLowValue));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: NotifyLowOnOff = " + this.notifyLowOnOff));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: GaugeDifferenceOnOff = " + this.gaugeDifferenceOnOff));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: PreviousScanGauge = " + this.previousScanGauge));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: PreviousScanGaugeInitialisedOnOff = " + this.previousScanGaugeInitialisedOnOff));
                Debug.print((int)128, (Object)"");
                if (this.derivedGaugeValid) {
                    if (this.type == 1) {
                        if (this.status == 2) {
                            if (this.derivedGauge.intValue() >= this.thresholdHighValue.intValue()) {
                                if (this.notifyHighOnOff.booleanValue()) {
                                    this.notifyMonitor(new Integer(11), "MONITOR EVENT: Threshold high exceeded", this.observedObject, this.observedProperty, this.derivedGauge);
                                }
                                this.status = 1;
                            } else if (this.derivedGauge.intValue() <= this.thresholdLowValue.intValue()) {
                                if (this.notifyLowOnOff.booleanValue()) {
                                    this.notifyMonitor(new Integer(12), "MONITOR EVENT: Threshold low exceeded", this.observedObject, this.observedProperty, this.derivedGauge);
                                }
                                this.status = 0;
                            }
                        } else if (this.status == 0) {
                            if (this.derivedGauge.intValue() - number.intValue() > 0 && this.derivedGauge.intValue() >= this.thresholdHighValue.intValue()) {
                                if (this.notifyHighOnOff.booleanValue()) {
                                    this.notifyMonitor(new Integer(11), "MONITOR EVENT: Threshold high exceeded", this.observedObject, this.observedProperty, this.derivedGauge);
                                }
                                this.status = 1;
                            }
                        } else if (this.status == 1 && this.derivedGauge.intValue() - number.intValue() < 0 && this.derivedGauge.intValue() <= this.thresholdLowValue.intValue()) {
                            if (this.notifyLowOnOff.booleanValue()) {
                                this.notifyMonitor(new Integer(12), "MONITOR EVENT: Threshold low exceeded", this.observedObject, this.observedProperty, this.derivedGauge);
                            }
                            this.status = 0;
                        }
                    } else if (this.status == 2) {
                        if (this.derivedGauge.floatValue() >= this.thresholdHighValue.floatValue()) {
                            if (this.notifyHighOnOff.booleanValue()) {
                                this.notifyMonitor(new Integer(11), "MONITOR EVENT: Threshold high exceeded", this.observedObject, this.observedProperty, this.derivedGauge);
                            }
                            this.status = 1;
                        } else if (this.derivedGauge.floatValue() <= this.thresholdLowValue.floatValue()) {
                            if (this.notifyLowOnOff.booleanValue()) {
                                this.notifyMonitor(new Integer(12), "MONITOR EVENT: Threshold low exceeded", this.observedObject, this.observedProperty, this.derivedGauge);
                            }
                            this.status = 0;
                        }
                    } else if (this.status == 0) {
                        if (this.derivedGauge.floatValue() - number.floatValue() > 0.0f && this.derivedGauge.floatValue() >= this.thresholdHighValue.floatValue()) {
                            if (this.notifyHighOnOff.booleanValue()) {
                                this.notifyMonitor(new Integer(11), "MONITOR EVENT: Threshold high exceeded", this.observedObject, this.observedProperty, this.derivedGauge);
                            }
                            this.status = 1;
                        }
                    } else if (this.status == 1 && this.derivedGauge.floatValue() - number.floatValue() < 0.0f && this.derivedGauge.floatValue() <= this.thresholdLowValue.floatValue()) {
                        if (this.notifyLowOnOff.booleanValue()) {
                            this.notifyMonitor(new Integer(12), "MONITOR EVENT: Threshold low exceeded", this.observedObject, this.observedProperty, this.derivedGauge);
                        }
                        this.status = 0;
                    }
                }
                this.alarmClock.performStart();
            }
            catch (InvalidPropertyValueException invalidPropertyValueException) {
                this.notifyMonitor(new Integer(this.event_type), invalidPropertyValueException.getMessage(), this.observedObject, this.observedProperty, this.derivedGauge);
                this.status = 2;
                this.previousScanGauge = new Integer(-1);
                this.previousScanGaugeInitialisedOnOff = new Boolean(false);
                this.alarmClock.performStart();
            }
            catch (Exception exception) {
                System.err.println("Monitor::handleAlarmClock: Exception in MONITOR: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public synchronized void performStart() {
        if (!this.administrativeStateOnOff.booleanValue()) {
            super.performStart();
            this.status = 2;
        } else {
            Debug.print((int)128, (Object)"Monitor::performStart: The Monitor service is already activated.");
        }
    }

    public synchronized void performStop() {
        if (this.administrativeStateOnOff.booleanValue()) {
            super.performStop();
            this.previousScanGauge = new Integer(-1);
            this.previousScanGaugeInitialisedOnOff = new Boolean(false);
        } else {
            Debug.print((int)128, (Object)"Monitor::performStop: The Monitor service is already deactivated.");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.previousScanGauge = new Integer(-1);
        this.previousScanGaugeInitialisedOnOff = new Boolean(false);
    }

    public void setGaugeDifferenceOnOff(Boolean bl) {
        Debug.print((int)128, (Object)("Monitor::setGaugeDifferenceOnOff: GaugeDifferenceOnOff = " + bl));
        this.gaugeDifferenceOnOff = bl;
        if (this.gaugeDifferenceOnOff.booleanValue()) {
            this.status = 2;
        } else {
            this.previousScanGauge = new Integer(-1);
            this.previousScanGaugeInitialisedOnOff = new Boolean(false);
        }
    }

    public void setNotifyHighOnOff(Boolean bl) {
        Debug.print((int)128, (Object)("Monitor::setNotifyHighOnOff: NotifyHighOnOff = " + bl));
        this.notifyHighOnOff = bl;
    }

    public void setNotifyLowOnOff(Boolean bl) {
        Debug.print((int)128, (Object)("Monitor::setNotifyLowOnOff: NotifyLowOnOff = " + bl));
        this.notifyLowOnOff = bl;
    }

    public void setThresholdHighValue(Number number) {
        Debug.print((int)128, (Object)("Monitor::setThresholdHighValue: ThresholdHighValue = " + number));
        this.thresholdHighValue = number;
        this.already_notified &= 0xFFFFFFEF;
        this.already_notified &= 0xFFFFFFDF;
    }

    public void setThresholdLowValue(Number number) {
        Debug.print((int)128, (Object)("Monitor::setThresholdLowValue: ThresholdLowValue = " + number));
        this.thresholdLowValue = number;
        this.already_notified &= 0xFFFFFFEF;
        this.already_notified &= 0xFFFFFFDF;
    }
}

