/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.monitor;

import com.sun.jaw.impl.agent.services.alarm.AlarmClock;
import com.sun.jaw.impl.agent.services.alarm.AlarmClockEvent;
import com.sun.jaw.impl.agent.services.alarm.AlarmClockListener;
import com.sun.jaw.impl.agent.services.monitor.MonitorEvent;
import com.sun.jaw.impl.agent.services.monitor.MonitorListener;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.ActivatableIf;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.InvalidPropertyValueException;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.common.PropertyNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class Monitor
implements AlarmClockListener,
Serializable,
ActivatableIf {
    protected ObjectName observedObject = new ObjectName("defaultDomain:dummy");
    protected String observedProperty = "";
    protected Long granularityPeriod = new Long(10000L);
    protected transient Number derivedGauge = new Integer(-1);
    protected transient Date derivedGaugeTimestamp = new Date();
    protected transient Boolean administrativeStateOnOff = new Boolean(false);
    protected AlarmClock alarmClock = new AlarmClock();
    protected transient Vector listeners = new Vector();
    protected Framework cmf = null;
    protected int already_notified = 0;
    protected static final int ALREADY_NOTIFIED_FLAGS_CLEARED = 0;
    protected static final int GRANULARITY_PERIOD_ALREADY_NOTIFIED = 1;
    protected static final int OBSERVED_OBJECT_ALREADY_NOTIFIED = 2;
    protected static final int OBSERVED_PROPERTY_ALREADY_NOTIFIED = 4;
    protected static final int OBSERVED_PROPERTY_TYPE_ALREADY_NOTIFIED = 8;
    protected int event_type = 0;
    private static final String sccs_id = "@(#)Monitor.java 3.3 03/10/99 SMI";

    public void addMonitorListener(MonitorListener monitorListener) {
        this.listeners.addElement(monitorListener);
    }

    public void deleteCmf() {
        this.performStop();
        this.alarmClock = null;
    }

    public static String getClassVersion() {
        return sccs_id;
    }

    public Number getDerivedGauge() {
        Debug.print((int)128, (Object)("Monitor::getDerivedGauge: DerivedGauge = " + this.derivedGauge));
        return this.derivedGauge;
    }

    public Date getDerivedGaugeTimestamp() {
        Debug.print((int)128, (Object)("Monitor::getDerivedGaugeTimestamp: DerivedGaugeTimestamp = " + this.derivedGaugeTimestamp));
        return this.derivedGaugeTimestamp;
    }

    public Integer getGranularityPeriod() {
        Debug.print((int)128, (Object)("Monitor::getGranularityPeriod: GranularityPeriod = " + this.granularityPeriod));
        return new Integer(this.granularityPeriod.intValue());
    }

    public Long getGranularityPeriodAsLong() {
        Debug.print((int)128, (Object)("Monitor::getGranularityPeriod: GranularityPeriod = " + this.granularityPeriod));
        return this.granularityPeriod;
    }

    public ObjectName getObservedObject() {
        Debug.print((int)128, (Object)("Monitor::getObservedObject: ObservedObject = " + this.observedObject));
        return this.observedObject;
    }

    public String getObservedProperty() {
        Debug.print((int)128, (Object)("Monitor::getObservedProperty: ObservedProperty = " + this.observedProperty));
        return this.observedProperty;
    }

    public void handleAlarmClock(AlarmClockEvent alarmClockEvent) {
        block15: {
            Object object = null;
            try {
                if (!this.administrativeStateOnOff.booleanValue()) break block15;
                if (this.granularityPeriod <= 0L) {
                    if ((this.already_notified & 1) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 1;
                    this.already_notified |= 1;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Granularity period must be greater than zero");
                }
                try {
                    object = this.cmf.getValue(this.observedObject, this.observedProperty);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if ((this.already_notified & 2) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 2;
                    this.already_notified |= 2;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Observed object must be registered in CMF");
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    if ((this.already_notified & 4) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 3;
                    this.already_notified |= 4;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Observed property not found in observed object");
                }
                if (object instanceof Integer) {
                    this.derivedGauge = (Integer)object;
                    this.derivedGaugeTimestamp = new Date();
                } else if (object instanceof Float) {
                    this.derivedGauge = (Float)object;
                    this.derivedGaugeTimestamp = new Date();
                } else {
                    if ((this.already_notified & 8) != 0) {
                        this.alarmClock.performStart();
                        return;
                    }
                    this.event_type = 4;
                    this.already_notified |= 8;
                    throw new InvalidPropertyValueException("MONITOR EVENT: Observed property type must be either <Integer> or <Float>");
                }
                this.event_type = 0;
                this.already_notified = 0;
                Debug.print((int)128, (Object)"");
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: instance = " + this));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: ObservedObject = " + this.observedObject));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: ObservedProperty = " + this.observedProperty));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: GranularityPeriod = " + this.granularityPeriod));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: DerivedGauge = " + this.derivedGauge));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: DerivedGaugeTimestamp = " + this.derivedGaugeTimestamp));
                Debug.print((int)128, (Object)("Monitor::handleAlarmClock: AdministrativeStateOnOff = " + this.administrativeStateOnOff));
                Debug.print((int)128, (Object)"");
                this.alarmClock.performStart();
            }
            catch (InvalidPropertyValueException invalidPropertyValueException) {
                this.notifyMonitor(new Integer(this.event_type), invalidPropertyValueException.getMessage(), this.observedObject, this.observedProperty, this.derivedGauge);
                this.alarmClock.performStart();
            }
            catch (Exception exception) {
                System.err.println("Monitor::handleAlarmClock: Exception in MONITOR: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public void initCmf(Framework framework, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException {
        this.cmf = framework;
        if (bl) {
            framework.addDBObject(this, objectName);
        } else {
            framework.addObject(this, objectName);
        }
    }

    public boolean isActive() {
        return this.administrativeStateOnOff;
    }

    protected void notifyMonitor(Integer n, String string, Object object, String string2, Number number) {
        Vector vector;
        MonitorEvent monitorEvent = new MonitorEvent(this, n, string, object, string2, number);
        Monitor monitor = this;
        synchronized (monitor) {
            vector = (Vector)this.listeners.clone();
        }
        Debug.print((int)128, (Object)"");
        Debug.print((int)128, (Object)("Monitor::notifyMonitor: instance = " + this));
        Debug.print((int)128, (Object)("Monitor::notifyMonitor: Event Message = " + string));
        Debug.print((int)128, (Object)("Monitor::notifyMonitor: Event Observed Object = " + object));
        Debug.print((int)128, (Object)("Monitor::notifyMonitor: Event Observed Property = " + string2));
        Debug.print((int)128, (Object)("Monitor::notifyMonitor: Event Derived Gauge = " + number));
        Debug.print((int)128, (Object)"");
        int n2 = 0;
        while (n2 < vector.size()) {
            ((MonitorListener)vector.elementAt(n2)).handleMonitor(monitorEvent);
            ++n2;
        }
    }

    public synchronized void performStart() {
        Debug.print((int)128, (Object)"Monitor::performStart: Start the Monitor service.");
        if (!this.administrativeStateOnOff.booleanValue()) {
            this.alarmClock.addAlarmClockListener((AlarmClockListener)this);
            this.alarmClock.performStart();
            this.administrativeStateOnOff = new Boolean(true);
        } else {
            Debug.print((int)128, (Object)"Monitor::performStart: The Monitor service is already activated.");
        }
    }

    public synchronized void performStop() {
        Debug.print((int)128, (Object)"Monitor::performStop: Stop the Monitor service.");
        if (this.administrativeStateOnOff.booleanValue()) {
            this.alarmClock.performStop();
            this.alarmClock.removeAlarmClockListener((AlarmClockListener)this);
            this.administrativeStateOnOff = new Boolean(false);
        } else {
            Debug.print((int)128, (Object)"Monitor::performStop: The Monitor service is already deactivated.");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new Vector();
        this.administrativeStateOnOff = new Boolean(false);
        this.derivedGauge = new Integer(-1);
        this.derivedGaugeTimestamp = new Date();
    }

    public void removeMonitorListener(MonitorListener monitorListener) {
        this.listeners.removeElement(monitorListener);
    }

    public void setGranularityPeriod(Integer n) {
        this.setGranularityPeriodAsLong(new Long(n.longValue()));
    }

    public void setGranularityPeriodAsLong(Long l) {
        Debug.print((int)128, (Object)("Monitor::setGranularityPeriod: GranularityPeriod = " + l));
        this.granularityPeriod = l;
        if (this.granularityPeriod >= 0L) {
            this.alarmClock.setTimeoutAsLong(this.granularityPeriod);
        }
        this.already_notified &= 0xFFFFFFFE;
    }

    public void setObservedObject(ObjectName objectName) {
        Debug.print((int)128, (Object)("Monitor::setObservedObject: ObservedObject = " + objectName));
        this.observedObject = objectName;
        this.already_notified &= 0xFFFFFFFD;
        this.already_notified &= 0xFFFFFFF7;
    }

    public void setObservedProperty(String string) {
        Debug.print((int)128, (Object)("Monitor::setObservedProperty: ObservedProperty = " + string));
        this.observedProperty = string;
        this.already_notified &= 0xFFFFFFFB;
        this.already_notified &= 0xFFFFFFF7;
    }
}

