/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.persistent;

import com.sun.jaw.impl.agent.services.light.RepositorySrv;
import com.sun.jaw.impl.agent.services.persistent.PersistentRepositoryException;
import com.sun.jaw.impl.agent.services.persistent.internal.FlatFileFactory;
import com.sun.jaw.impl.agent.services.persistent.internal.ResolveLoaderIf;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.agent.services.MoRepSrvIf;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.NamedObject;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.query.QueryExp;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Vector;

public class PersistentRepSrv
extends RepositorySrv
implements MoRepSrvIf,
ResolveLoaderIf {
    private transient boolean online = false;
    protected String domain = "defaultDomain";
    private transient FlatFileFactory ffFactory = null;
    private String dbRoot = null;
    private String dbName = null;
    protected transient Framework cmf = null;

    public boolean contains(ObjectName objectName) {
        Debug.print((int)4, (Object)("\nPersistentRepSrv::contains: >>> name=" + objectName));
        boolean bl = true;
        if (super.retrieve(objectName) == null) {
            bl = this.containsDB(objectName);
        }
        Debug.println((int)4, (Object)("PersistentRepSrv::contains: ok ! found=" + bl));
        return bl;
    }

    public boolean contains(Object object) {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(this.domain, object.getClass().getName());
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
        }
        return this.contains(objectName);
    }

    protected boolean containsDB(ObjectName objectName) {
        Debug.print((int)4, (Object)("PersistentRepSrv::containsDB: >>> name=" + objectName));
        this.start();
        try {
            return this.ffFactory.contains(objectName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PersistentRepositoryException(String.valueOf(fileNotFoundException.getClass().getName()) + ": " + fileNotFoundException.getMessage());
        }
    }

    protected void enableSync(Framework framework) {
        Debug.print((int)4, (Object)"PersistentRepSrv::enableSync: >>> found the framework, synchronization enabled !");
        this.cmf = framework;
        if (this.online) {
            this.ffFactory.setFramework(framework);
        }
    }

    private void enableSyncDB() {
        NamedObject namedObject;
        Object object;
        Debug.print((int)4, (Object)"PersistentRepSrv::enableSyncDB: >>> Look for the framework in the database.");
        Vector vector = this.getDBObject(new ObjectName(String.valueOf(this.domain) + ":" + "com.sun.jaw.reference.client.mo.FrameworkMO"), null);
        if (!vector.isEmpty() && this.isFramework(object = (namedObject = (NamedObject)vector.firstElement()).getObject())) {
            this.enableSync((Framework)object);
        }
        Debug.print((int)4, (Object)"PersistentRepSrv::enableSyncDB: ok ! ");
    }

    protected Vector getDBObject(ObjectName objectName, QueryExp queryExp) {
        Debug.print((int)4, (Object)("PersistentRepSrv::getDBObject: >>> name=" + objectName));
        this.start();
        Vector vector = null;
        try {
            vector = this.ffFactory.get(objectName);
        }
        catch (Exception exception) {
            throw new PersistentRepositoryException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
        }
        Debug.print((int)4, (Object)("PersistentRepSrv::getDBObject: ok ! persistent objects=" + vector.size()));
        return vector;
    }

    public String getDomain() {
        return this.domain;
    }

    public Integer getNbElements() {
        if (!this.online) {
            return new Integer(0);
        }
        return new Integer(this.ffFactory.getNbElements() + super.getNbElements());
    }

    public Vector getObject(ObjectName objectName, QueryExp queryExp) {
        Vector vector;
        Debug.print((int)4, (Object)("\nPersistentRepSrv::getObject: >>> name=" + objectName));
        Vector vector2 = super.getObject(objectName, queryExp);
        Debug.print((int)4, (Object)("PersistentRepSrv::getObject: >>> non-persistent objects=" + vector2.size()));
        Vector vector3 = vector = this.getDBObject(objectName, queryExp);
        Vector vector4 = vector2;
        if (vector.size() < vector2.size()) {
            vector3 = vector2;
            vector4 = vector;
        }
        int n = 0;
        while (n < vector4.size()) {
            vector3.addElement(vector4.elementAt(n));
            ++n;
        }
        Debug.println((int)4, (Object)("PersistentRepSrv::getObject: ok ! objects=" + vector3.size()));
        return vector3;
    }

    protected boolean isFramework(Object object) {
        return object instanceof Framework;
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean isQuerySrv() {
        return false;
    }

    public void register(Object object, ObjectName objectName) throws InstanceAlreadyExistException {
        if (this.contains(objectName)) {
            throw new InstanceAlreadyExistException(objectName.toString());
        }
        if (!this.validateRegistration(objectName)) {
            throw new IllegalArgumentException("Invalid registration: Singelton of this className exists or this m-bean is a singleton with instances of the className already exsisting=" + objectName);
        }
        super.register(object, objectName);
        if (this.isFramework(object)) {
            this.enableSync((Framework)object);
        }
    }

    public void registerDB(Object object, ObjectName objectName) throws InstanceAlreadyExistException {
        Debug.print((int)4, (Object)("\nPersistentRepSrv::registerDB: >>> name=" + objectName));
        Debug.print((int)4, (Object)("PersistentRepSrv::registerDB: >>> object=" + object));
        this.start();
        if (!objectName.validNameForObject()) {
            throw new IllegalArgumentException("Invalid object name: " + objectName);
        }
        if (this.contains(objectName)) {
            throw new InstanceAlreadyExistException(objectName.toString());
        }
        if (!this.validateRegistration(objectName)) {
            throw new IllegalArgumentException("Invalid registration: Singelton of this className exists or this m-bean is a singleton with instances of the className already exsisting=" + objectName);
        }
        ClassLoader classLoader = object.getClass().getClassLoader();
        Debug.print((int)4, (Object)("PersistentRepSrv::registerDB: >>> loader=" + classLoader));
        try {
            this.ffFactory.store(object, objectName, this.retrieveClassLoaderName(classLoader));
        }
        catch (InstanceAlreadyExistException instanceAlreadyExistException) {
            throw instanceAlreadyExistException;
        }
        catch (Exception exception) {
            throw new PersistentRepositoryException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
        }
        if (this.isFramework(object)) {
            this.enableSync((Framework)object);
        }
        Debug.println((int)4, (Object)"PersistentRepSrv::registerDB: ok !");
    }

    public ClassLoader resolveClassLoader(ObjectName objectName) {
        Debug.print((int)4, (Object)("PersistentRepSrv::resolveClassLoader: loader=" + objectName));
        if (objectName == null) {
            return null;
        }
        ClassLoader classLoader = null;
        try {
            classLoader = (ClassLoader)this.retrieve(objectName);
        }
        catch (Exception exception) {}
        Debug.print((int)4, (Object)("PersistentRepSrv::resolveClassLoader: found loader=" + classLoader));
        return classLoader;
    }

    public Object retrieve(ObjectName objectName) {
        Debug.print((int)4, (Object)("\nPersistentRepSrv::retrieve: >>> name=" + objectName));
        Object object = null;
        object = super.retrieve(objectName);
        if (object == null) {
            object = this.retrieveDB(objectName);
        }
        Debug.println((int)4, (Object)"PersistentRepSrv::retrieve: ok !");
        return object;
    }

    public ObjectName retrieveClassLoaderName(ClassLoader classLoader) {
        if (classLoader == null) {
            Debug.print((int)4, (Object)"PersistentRepSrv::retrieveClassLoaderName: >>> loader name=null");
            return null;
        }
        Class<?> clazz = classLoader.getClass();
        ObjectName objectName = null;
        try {
            Method method = clazz.getMethod("getLoaderName", null);
            objectName = (ObjectName)method.invoke((Object)classLoader, null);
        }
        catch (Exception exception) {}
        Debug.print((int)4, (Object)("PersistentRepSrv::retrieveClassLoaderName: >>> loader name=" + objectName));
        return objectName;
    }

    protected Object retrieveDB(ObjectName objectName) {
        Debug.print((int)4, (Object)("PersistentRepSrv::retrieveDB: >>> name=" + objectName));
        this.start();
        Object object = null;
        try {
            object = this.ffFactory.restore(objectName);
        }
        catch (Exception exception) {
            throw new PersistentRepositoryException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
        }
        Debug.print((int)4, (Object)"PersistentRepSrv::retrieveDB: ok !");
        return object;
    }

    public void setConfig(Vector vector) {
        Debug.print((Object)"\nPersistentRepSrv::setConfig: *** Start repository initialization ! ***");
        if (vector != null) {
            if (vector.size() > 0) {
                this.dbRoot = (String)vector.elementAt(0);
            }
            if (vector.size() > 1) {
                this.dbName = (String)vector.elementAt(1);
            }
        }
        this.stop();
        this.ffFactory = null;
        this.start();
        Debug.println((Object)"PersistentRepSrv::setConfig: *** Repository initialization ok ! ***");
    }

    public void setDomain(String string) {
        this.domain = string;
        super.setDomain(string);
        if (this.online) {
            this.ffFactory.setDomain(string);
        }
    }

    private void start() {
        if (!this.online) {
            try {
                if (this.ffFactory == null) {
                    this.ffFactory = new FlatFileFactory(this.dbRoot, this.dbName, this);
                }
                this.ffFactory.start();
            }
            catch (Exception exception) {
                throw new PersistentRepositoryException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
            }
            this.online = true;
            this.enableSyncDB();
        }
    }

    public void stop() {
        if (this.online) {
            Debug.print((int)4, (Object)"\nPersistentRepSrv::stop: shutdown the repository !");
            try {
                this.ffFactory.stop();
            }
            catch (IOException iOException) {
                throw new PersistentRepositoryException(String.valueOf(iOException.getClass().getName()) + ": " + iOException.getMessage());
            }
            this.online = false;
            Debug.println((int)4, (Object)"PersistentRepSrv::stop: ok !");
        }
    }

    public void unregister(ObjectName objectName) throws InstanceNotFoundException {
        Debug.println((int)4, (Object)("\nPersistentRepSrv::unregister: >>> name=" + objectName));
        try {
            super.unregister(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            this.unregisterDB(objectName);
        }
        Debug.println((int)4, (Object)"PersistentRepSrv::unregister: ok !");
    }

    public void unregister(Object object) throws InstanceNotFoundException {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(this.domain, object.getClass().getName());
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
        }
        this.unregister(objectName);
    }

    protected void unregisterDB(ObjectName objectName) throws InstanceNotFoundException {
        Debug.print((int)4, (Object)("PersistentRepSrv::unregisterDB: >>> name=" + objectName));
        this.start();
        if (!objectName.validNameForObject()) {
            throw new IllegalArgumentException("Invalid ObjectName: " + objectName.toString());
        }
        try {
            this.ffFactory.remove(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            throw new PersistentRepositoryException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
        }
        Debug.print((int)4, (Object)"PersistentRepSrv::unregisterDB: ok !");
    }

    public void update(Object object, ObjectName objectName) throws InstanceNotFoundException {
        Debug.print((int)4, (Object)("\nPersistentRepSrv::update: >>> name=" + objectName));
        Debug.print((int)4, (Object)("PersistentRepSrv::update: >>> object=" + object));
        if (super.retrieve(objectName) == null) {
            this.updateDB(object, objectName);
        }
        Debug.println((int)4, (Object)"PersistentRepSrv::update: ok !");
    }

    protected void updateDB(Object object, ObjectName objectName) throws InstanceNotFoundException {
        Debug.print((int)4, (Object)("PersistentRepSrv::updateDB: >>> name=" + objectName));
        Debug.print((int)4, (Object)("PersistentRepSrv::updateDB: >>> object=" + objectName));
        this.start();
        if (!objectName.validNameForObject()) {
            throw new IllegalArgumentException("Invalid ObjectName: " + objectName.toString());
        }
        try {
            this.ffFactory.update(object, objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            throw new PersistentRepositoryException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
        }
        Debug.print((int)4, (Object)"PersistentRepSrv::updateDB: ok !");
    }

    protected boolean validateRegistration(ObjectName objectName) {
        Debug.print((int)4, (Object)("PersistentRepSrv::validateRegistration: >>> validate the registration of name=" + objectName));
        if (objectName.isPropertyListEmpty()) {
            if (this.getObject(objectName, null).size() != 0) {
                Debug.print((int)4, (Object)"PersistentRepSrv::validateRegistration: >>> invalid registration !");
                return false;
            }
            Debug.print((int)4, (Object)"PersistentRepSrv::validateRegistration: >>> valid registration !");
            return true;
        }
        ObjectName objectName2 = new ObjectName(objectName.getDomain(), objectName.getClassName());
        if (this.contains(objectName2)) {
            Debug.print((int)4, (Object)"PersistentRepSrv::validateRegistration: >>> invalid registration !");
            return false;
        }
        Debug.print((int)4, (Object)"PersistentRepSrv::validateRegistration: >>> valid registration !");
        return true;
    }
}

