/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.persistent.internal;

import com.sun.jaw.impl.agent.services.persistent.internal.FlatFileBlockInActiveException;
import com.sun.jaw.impl.agent.services.persistent.internal.FlatFileBlockTooShortException;
import com.sun.jaw.impl.agent.services.persistent.internal.FlatFileConstants;
import com.sun.jaw.impl.agent.services.persistent.internal.FlatFileCorruptedException;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

class FlatFileBlock
implements FlatFileConstants {
    RandomAccessFile raf;

    FlatFileBlock(RandomAccessFile randomAccessFile) {
        this.raf = randomAccessFile;
    }

    void freeBlock(long l, int n) throws IOException, EOFException, FlatFileCorruptedException, FlatFileBlockInActiveException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(l);
            if (this.raf.readByte() != 112) {
                throw new FlatFileCorruptedException("Corrupt at: " + l);
            }
            if (n != this.raf.readInt()) {
                throw new FlatFileCorruptedException("Corrupt at: " + l);
            }
            long l2 = this.raf.getFilePointer();
            if (this.raf.readBoolean()) {
                throw new FlatFileBlockInActiveException("File block already deleted.");
            }
            this.raf.seek(l2);
            this.raf.writeBoolean(true);
            this.raf.writeInt(0);
        }
    }

    long insertBlock(byte[] byArray, long l, int n) throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            if (l == -1L || l > this.raf.length()) {
                l = this.raf.length();
            }
            this.raf.seek(l);
            this.raf.writeByte(112);
            this.raf.writeInt(n);
            this.raf.writeBoolean(false);
            this.raf.writeInt(byArray.length);
            this.raf.write(byArray);
        }
        return l;
    }

    void insertHeader() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(0L);
            this.raf.writeShort(2989);
        }
    }

    byte[] readBlock(long l, int n) throws FlatFileCorruptedException, EOFException, IOException, FlatFileBlockInActiveException {
        byte[] byArray;
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(l);
            if (this.raf.readByte() != 112) {
                throw new FlatFileCorruptedException("Corrupt at: " + l);
            }
            if (n != this.raf.readInt()) {
                throw new FlatFileCorruptedException("Corrupt at: " + l);
            }
            if (this.raf.readBoolean()) {
                throw new FlatFileBlockInActiveException();
            }
            n = this.raf.readInt();
            byArray = new byte[n];
            this.raf.readFully(byArray);
        }
        return byArray;
    }

    void readHeader() throws FlatFileCorruptedException, IOException, EOFException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(0L);
            if (this.raf.readShort() != 2989) {
                throw new FlatFileCorruptedException("Invalid flat file.");
            }
        }
    }

    void updateBlock(byte[] byArray, long l) throws FlatFileCorruptedException, FlatFileBlockTooShortException, FlatFileBlockInActiveException, IOException, EOFException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(l);
            if (this.raf.readByte() != 112) {
                throw new FlatFileCorruptedException("Corrupt at: " + l);
            }
            if (this.raf.readInt() < byArray.length) {
                throw new FlatFileBlockTooShortException("File block too short.");
            }
            if (this.raf.readBoolean()) {
                throw new FlatFileBlockInActiveException("File block deleted.");
            }
            this.raf.writeInt(byArray.length);
            this.raf.write(byArray);
        }
    }
}

