/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.persistent.internal;

import com.sun.jaw.impl.agent.services.persistent.internal.AvailableList;
import com.sun.jaw.impl.agent.services.persistent.internal.BufferedByteArrayInputStream;
import com.sun.jaw.impl.agent.services.persistent.internal.BufferedByteArrayOutputStream;
import com.sun.jaw.impl.agent.services.persistent.internal.FlatFileBlock;
import com.sun.jaw.impl.agent.services.persistent.internal.FlatFileBlockInActiveException;
import com.sun.jaw.impl.agent.services.persistent.internal.FlatFileBlockTooShortException;
import com.sun.jaw.impl.agent.services.persistent.internal.FlatFileConstants;
import com.sun.jaw.impl.agent.services.persistent.internal.FlatFileCorruptedException;
import com.sun.jaw.impl.agent.services.persistent.internal.FlatFileIndex;
import com.sun.jaw.impl.agent.services.persistent.internal.IndexEntry;
import com.sun.jaw.impl.agent.services.persistent.internal.ObjectStore;
import com.sun.jaw.impl.agent.services.persistent.internal.ResolveLoaderIf;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.NamedObject;
import com.sun.jaw.reference.common.ObjectName;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Vector;

public class FlatFileFactory
implements FlatFileConstants {
    private long eof = -1L;
    private File registry = null;
    private ResolveLoaderIf resolver = null;
    private ObjectStore os = null;
    private RandomAccessFile fid = null;
    FlatFileIndex ffi = null;
    private FlatFileBlock ffb = null;
    private AvailableList al = new AvailableList();
    private boolean online = false;

    public FlatFileFactory(String string, String string2, ResolveLoaderIf resolveLoaderIf) {
        File file;
        this.resolver = resolveLoaderIf;
        if (string2 != null) {
            if (!string2.endsWith(".db")) {
                string2 = String.valueOf(string2) + ".db";
            }
        } else {
            string2 = "default.db";
        }
        if (!this.validPath(file = new File(string, string2))) {
            Debug.print((Object)("FlatFileFactory::FlatFileFactory: Invalid path=" + file));
            throw new IllegalArgumentException("Invalid file destination: " + file);
        }
        this.registry = new File(file, "REGISTRY.BDF");
    }

    private void close() throws IOException {
        Debug.print((int)4, (Object)("FlatFileFactory::close: Close the registry file=" + this.registry));
        if (this.fid != null) {
            this.fid.close();
            this.fid = null;
        }
    }

    public synchronized boolean contains(ObjectName objectName) throws FileNotFoundException {
        if (!this.online) {
            Debug.print((int)4, (Object)"FlatFileFactory::contains: Registry is offline.");
            throw new IllegalStateException("Registry not started.");
        }
        if (!this.registryExists()) {
            throw new FileNotFoundException("Registry file not found: " + this.registry);
        }
        IndexEntry indexEntry = (IndexEntry)this.ffi.findEntry(objectName);
        return indexEntry != null;
    }

    private void deactivateRecord(IndexEntry indexEntry) throws IOException, FlatFileBlockInActiveException, EOFException, FlatFileCorruptedException {
        Debug.print((int)4, (Object)"\nFlatFileFactory::deactivateRecord: >>> RECORD ...");
        Debug.print((int)4, (Object)("FlatFileFactory::deactivateRecord: >>> id=" + indexEntry.getPosition()));
        Debug.println((int)4, (Object)("FlatFileFactory::deactivateRecord: >>> length=" + indexEntry.getSize() + " bytes."));
        try {
            this.ffb.readHeader();
            this.ffb.freeBlock(indexEntry.getPosition(), indexEntry.getSize());
        }
        catch (EOFException eOFException) {
            this.setEOF(indexEntry.getPosition());
            throw eOFException;
        }
        this.al.markAvailable(indexEntry);
    }

    protected void finalize() throws Throwable {
        if (this.online) {
            this.close();
        }
    }

    public synchronized Vector get(ObjectName objectName) throws FileNotFoundException {
        if (!this.online) {
            Debug.print((int)4, (Object)"FlatFileFactory::get: Registry is offline.");
            throw new IllegalStateException("Registry not started.");
        }
        if (!this.registryExists()) {
            throw new FileNotFoundException("Registry file not found: " + this.registry);
        }
        Vector vector = this.ffi.getEntry(objectName);
        Vector<NamedObject> vector2 = new Vector<NamedObject>();
        int n = 0;
        while (n < vector.size()) {
            ObjectName objectName2 = null;
            IndexEntry indexEntry = null;
            try {
                NamedObject namedObject = (NamedObject)vector.elementAt(n);
                objectName2 = namedObject.getName();
                indexEntry = (IndexEntry)namedObject.getObject();
                Object object = null;
                object = indexEntry.getObject();
                if (object == null) {
                    object = this.getObject(indexEntry);
                    indexEntry.setObject(object);
                }
                if (object != null) {
                    vector2.addElement(new NamedObject(objectName2, object));
                    Debug.print((int)4, (Object)("FlatFileFactory::get: >>> object=" + object));
                }
            }
            catch (FlatFileBlockInActiveException flatFileBlockInActiveException) {
                try {
                    this.ffi.removeEntry(objectName2);
                    this.al.markAvailable(indexEntry);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    Debug.printException((Exception)((Object)instanceNotFoundException));
                }
                Debug.printException((Exception)flatFileBlockInActiveException);
            }
            catch (FlatFileCorruptedException flatFileCorruptedException) {
                this.removeCorruptedEntry(objectName2);
                System.err.println("WARNING: Couldn't restore the object <" + objectName2 + ">");
                Debug.printException((Exception)flatFileCorruptedException);
            }
            catch (EOFException eOFException) {
                this.removeCorruptedEntry(objectName2);
                System.err.println("WARNING: Couldn't restore the object <" + objectName2 + ">");
            }
            catch (Exception exception) {
                System.err.println("WARNING: Couldn't restore the object <" + objectName2 + ">");
                Debug.printException((Exception)exception);
            }
            ++n;
        }
        return vector2;
    }

    private long getEOF() {
        return this.eof;
    }

    public Integer getNbElements() {
        if (!this.online) {
            Debug.print((int)4, (Object)"FlatFileFactory::getNbElements: Registry is offline.");
            throw new IllegalStateException("Registry not started.");
        }
        if (this.ffi == null) {
            return new Integer(0);
        }
        return this.ffi.getNbElements();
    }

    private Object getObject(IndexEntry indexEntry) throws IOException, ClassNotFoundException, FlatFileCorruptedException, EOFException, FlatFileBlockInActiveException {
        Debug.print((int)4, (Object)"\nFlatFileFactory::getObject: >>> ... RECORD ...");
        Debug.print((int)4, (Object)("FlatFileFactory::getObject: >>> id=" + indexEntry.getPosition()));
        Debug.println((int)4, (Object)("FlatFileFactory::getObject: >>> length=" + indexEntry.getSize() + " bytes."));
        byte[] byArray = this.readRecord(indexEntry);
        BufferedByteArrayInputStream bufferedByteArrayInputStream = new BufferedByteArrayInputStream(byArray);
        bufferedByteArrayInputStream.skipBytes(bufferedByteArrayInputStream.readUnsignedShort());
        String string = bufferedByteArrayInputStream.readUTF();
        byte[] byArray2 = bufferedByteArrayInputStream.readXBytes();
        ObjectName objectName = null;
        ClassLoader classLoader = null;
        if (!string.equals("NULL")) {
            objectName = this.newObjectName(string);
        }
        if (objectName != null && this.resolver != null) {
            classLoader = this.resolver.resolveClassLoader(objectName);
        }
        return this.os.deserialObject(byArray2, classLoader);
    }

    private ObjectName newObjectName(String string) {
        ObjectName objectName = null;
        if (string.length() == 0) {
            return objectName;
        }
        try {
            objectName = new ObjectName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Debug.printException((Exception)illegalArgumentException);
        }
        return objectName;
    }

    private void newstart() throws IOException {
        Debug.print((int)4, (Object)"FlatFileFactory::newstart: Create a new registry.");
        this.open();
        this.ffb.insertHeader();
    }

    private void open() throws IOException {
        Debug.print((int)4, (Object)("FlatFileFactory::open: Open the registry file=" + this.registry));
        this.fid = new RandomAccessFile(this.registry, "rw");
        this.ffb = new FlatFileBlock(this.fid);
    }

    private byte[] readRecord(IndexEntry indexEntry) throws IOException, FlatFileBlockInActiveException, EOFException, FlatFileCorruptedException {
        Debug.print((int)4, (Object)"\nFlatFileFactory::readRecord: >>> ... RECORD ...");
        Debug.print((int)4, (Object)("FlatFileFactory::readRecord: >>> id=" + indexEntry.getPosition()));
        Debug.print((int)4, (Object)("FlatFileFactory::readRecord: >>> length=" + indexEntry.getSize() + " bytes."));
        byte[] byArray = null;
        try {
            this.ffb.readHeader();
            byArray = this.ffb.readBlock(indexEntry.getPosition(), indexEntry.getSize());
        }
        catch (EOFException eOFException) {
            this.setEOF(indexEntry.getPosition());
            throw eOFException;
        }
        Debug.println((int)4, (Object)("FlatFileFactory::readRecord: >>> bytes read=" + byArray.length + " bytes."));
        return byArray;
    }

    private boolean registryExists() {
        if (this.registry != null) {
            return this.registry.exists();
        }
        return false;
    }

    public synchronized void remove(ObjectName objectName) throws IOException, InstanceNotFoundException, FlatFileCorruptedException, FileNotFoundException {
        if (!this.online) {
            Debug.print((int)4, (Object)"FlatFileFactory::remove: Registry is offline.");
            throw new IllegalStateException("Registry not started.");
        }
        if (!this.registryExists()) {
            throw new FileNotFoundException("Registry file not found: " + this.registry);
        }
        IndexEntry indexEntry = (IndexEntry)this.ffi.removeEntry(objectName);
        try {
            this.deactivateRecord(indexEntry);
        }
        catch (FlatFileCorruptedException flatFileCorruptedException) {
            throw flatFileCorruptedException;
        }
        catch (IOException iOException) {
            try {
                this.ffi.insertEntry(objectName, indexEntry);
            }
            catch (InstanceAlreadyExistException instanceAlreadyExistException) {
                Debug.printException((Exception)((Object)instanceAlreadyExistException));
            }
            throw iOException;
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
        }
    }

    private void removeCorruptedEntry(ObjectName objectName) {
        try {
            this.ffi.removeEntry(objectName);
            System.err.println("WARNING: Remove invalid index entry.");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Debug.printException((Exception)((Object)instanceNotFoundException));
        }
    }

    private void resetEOF() {
        this.eof = -1L;
    }

    private void restart() throws IOException, FlatFileCorruptedException {
        Debug.print((int)4, (Object)"FlatFileFactory::restart: Restart the old registry.");
        this.open();
        long l = 0L;
        try {
            this.fid.seek(l);
            if (this.fid.readShort() != 2989) {
                throw new FlatFileCorruptedException("Invalid registry file: " + this.registry);
            }
            l = this.fid.getFilePointer();
            while (l != this.fid.length()) {
                BufferedByteArrayInputStream bufferedByteArrayInputStream;
                Object object;
                Debug.print((int)4, (Object)"\nFlatFileFactory::restart: >>> ... RECORD ...");
                Debug.print((int)4, (Object)("FlatFileFactory::restart: >>> id=" + l));
                if (this.fid.readByte() != 112) {
                    throw new FlatFileCorruptedException("Corrupted record. No block identifier. Record id=" + l);
                }
                int n = this.fid.readInt();
                Debug.print((int)4, (Object)("FlatFileFactory::restart: >>> record length=" + n + " bytes."));
                boolean bl = this.fid.readBoolean();
                Debug.print((int)4, (Object)("FlatFileFactory::restart: >>> deleted=" + bl));
                int n2 = this.fid.readInt();
                Debug.print((int)4, (Object)("FlatFileFactory::restart: >>> used record length=" + n2 + " bytes."));
                String string = null;
                if (bl) {
                    this.fid.skipBytes(n);
                } else {
                    object = new byte[n2];
                    this.fid.readFully((byte[])object);
                    if (n2 < n) {
                        this.fid.skipBytes(n - n2);
                    }
                    try {
                        bufferedByteArrayInputStream = new BufferedByteArrayInputStream((byte[])object);
                        string = bufferedByteArrayInputStream.readUTF();
                    }
                    catch (Exception exception) {
                        bl = true;
                        System.err.println("WARNING: Could not restore the record data. Record id=" + l);
                        System.err.println("WARNING: The record will be removed.");
                        Debug.printException((Exception)exception);
                    }
                }
                object = new IndexEntry(l, n);
                if (bl) {
                    this.al.markAvailable((IndexEntry)object);
                } else {
                    try {
                        bufferedByteArrayInputStream = this.newObjectName(string);
                        Debug.print((int)4, (Object)("FlatFileFactory::restart: >>> name=" + bufferedByteArrayInputStream));
                        this.ffi.insertEntry((ObjectName)bufferedByteArrayInputStream, object);
                    }
                    catch (InstanceAlreadyExistException instanceAlreadyExistException) {
                        Debug.printException((Exception)((Object)instanceAlreadyExistException));
                    }
                }
                l = this.fid.getFilePointer();
            }
        }
        catch (FlatFileCorruptedException flatFileCorruptedException) {
            this.setEOF(l);
            System.err.println("WARNING: The file is corrupted: " + this.registry);
            System.err.println(String.valueOf(flatFileCorruptedException.getClass().getName()) + ": " + flatFileCorruptedException.getMessage());
        }
        catch (EOFException eOFException) {
            this.setEOF(l);
            System.err.println("WARNING: The file ended prematurly: " + this.registry);
            System.err.println(String.valueOf(eOFException.getClass().getName()) + ": " + eOFException.getMessage());
        }
    }

    public synchronized Object restore(ObjectName objectName) throws FlatFileCorruptedException, IOException, ClassNotFoundException, FileNotFoundException {
        if (!this.online) {
            Debug.print((int)4, (Object)"FlatFileFactory::restore: Registry is offline.");
            throw new IllegalStateException("Registry not started.");
        }
        if (!this.registryExists()) {
            throw new FileNotFoundException("Registry file not found: " + this.registry);
        }
        IndexEntry indexEntry = (IndexEntry)this.ffi.findEntry(objectName);
        if (indexEntry == null) {
            return null;
        }
        Object object = null;
        object = indexEntry.getObject();
        if (object == null) {
            try {
                object = this.getObject(indexEntry);
                indexEntry.setObject(object);
            }
            catch (FlatFileBlockInActiveException flatFileBlockInActiveException) {
                try {
                    this.ffi.removeEntry(objectName);
                    this.al.markAvailable(indexEntry);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    Debug.printException((Exception)((Object)instanceNotFoundException));
                }
                Debug.printException((Exception)flatFileBlockInActiveException);
            }
            catch (FlatFileCorruptedException flatFileCorruptedException) {
                this.removeCorruptedEntry(objectName);
                throw flatFileCorruptedException;
            }
            catch (EOFException eOFException) {
                this.removeCorruptedEntry(objectName);
                Debug.printException((Exception)eOFException);
            }
        }
        Debug.print((Object)("FlatFileFactory::restore: >>> object=" + object));
        return object;
    }

    public void setDomain(String string) {
        if (!this.online) {
            Debug.print((int)4, (Object)"FlatFileFactory::setDomain: Registry is offline.");
            throw new IllegalStateException("Registry not started.");
        }
        if (this.ffi != null) {
            this.ffi.setDomain(string);
        }
    }

    private void setEOF(long l) {
        if (this.eof == -1L || l < this.eof) {
            this.eof = l;
        }
    }

    public void setFramework(Framework framework) {
        if (!this.online) {
            Debug.print((int)4, (Object)"FlatFileFactory::setFramework: Registry is offline.");
            throw new IllegalStateException("Registry not started.");
        }
        if (this.os != null) {
            this.os.setFramework(framework);
        }
    }

    public synchronized void start() throws IOException, FlatFileCorruptedException {
        Debug.print((int)4, (Object)"\nFlatFileFactory::start: --- Start the registry ---");
        if (this.online) {
            Debug.print((int)4, (Object)"FlatFileFactory::start: Registry already started.");
            throw new IllegalStateException("Registry already started.");
        }
        this.ffi = new FlatFileIndex();
        if (this.os == null) {
            this.os = new ObjectStore();
        }
        if (this.registryExists()) {
            this.restart();
        } else {
            this.newstart();
        }
        this.online = true;
    }

    public synchronized void stop() throws IOException {
        Debug.print((int)4, (Object)"\nFlatFileFactory::stop: --- Stop the registry ---");
        if (!this.online) {
            Debug.print((int)4, (Object)"FlatFileFactory::stop: Registry already stoped.");
            throw new IllegalStateException("Registry already stoped.");
        }
        this.ffi = null;
        this.ffb = null;
        this.close();
        this.online = false;
        System.gc();
    }

    public synchronized void store(Object object, ObjectName objectName, ObjectName objectName2) throws IOException, InstanceAlreadyExistException, FileNotFoundException {
        if (!this.online) {
            Debug.print((int)4, (Object)"FlatFileFactory::store: Registry is offline.");
            throw new IllegalStateException("Registry not started.");
        }
        if (!(object instanceof Serializable)) {
            Debug.print((Object)("FlatFileFactory::store: Object is not serializable=" + object));
            throw new IllegalArgumentException("Only Serializable objects are stored.");
        }
        if (!this.registryExists()) {
            throw new FileNotFoundException("Registry file not found: " + this.registry);
        }
        IndexEntry indexEntry = new IndexEntry(object);
        this.ffi.insertEntry(objectName, indexEntry);
        try {
            String string = "NULL";
            if (objectName2 != null) {
                string = objectName2.toString();
            }
            BufferedByteArrayOutputStream bufferedByteArrayOutputStream = new BufferedByteArrayOutputStream();
            bufferedByteArrayOutputStream.writeUTF(objectName.toString());
            bufferedByteArrayOutputStream.writeUTF(string);
            bufferedByteArrayOutputStream.writeXBytes(this.os.serialObject(object));
            bufferedByteArrayOutputStream.flush();
            byte[] byArray = bufferedByteArrayOutputStream.toByteArray();
            bufferedByteArrayOutputStream.close();
            this.storeRecord(byArray, indexEntry);
        }
        catch (SecurityException securityException) {
            this.removeCorruptedEntry(objectName);
            throw securityException;
        }
        catch (IOException iOException) {
            this.removeCorruptedEntry(objectName);
            throw iOException;
        }
    }

    private void storeRecord(byte[] byArray, IndexEntry indexEntry) throws FileNotFoundException, IOException {
        Debug.print((int)4, (Object)"\nFlatFileFactory::storeRecord: >>> ... RECORD ...");
        IndexEntry indexEntry2 = null;
        int n = byArray.length;
        long l = -1L;
        indexEntry.setSize(n);
        try {
            long l2 = -1L;
            indexEntry2 = this.al.seekAvailable(indexEntry);
            if (indexEntry2 != null) {
                n = indexEntry2.getSize();
                l = indexEntry2.getPosition();
                Debug.print((int)4, (Object)("FlatFileFactory::storeRecord: >>> available block size=" + n + " bytes."));
                Debug.print((int)4, (Object)("FlatFileFactory::storeRecord: >>> available block position=" + l));
                Debug.print((int)4, (Object)("FlatFileFactory::storeRecord: >>> available block used=" + byArray.length + " bytes."));
            } else {
                l2 = this.getEOF();
                if (l2 != -1L) {
                    Debug.print((int)4, (Object)("FlatFileFactory::storeRecord: >>> file end prematurly=" + l2));
                    l = l2;
                }
            }
            l = this.ffb.insertBlock(byArray, l, n);
            if (l2 != -1L) {
                this.resetEOF();
            }
        }
        catch (IOException iOException) {
            if (indexEntry2 != null) {
                this.al.markAvailable(indexEntry2);
            }
            throw iOException;
        }
        indexEntry.setSize(n);
        indexEntry.setPosition(l);
        Debug.print((int)4, (Object)("FlatFileFactory::storeRecord: >>> id=" + indexEntry.getPosition()));
        Debug.println((int)4, (Object)("FlatFileFactory::storeRecord: >>> length=" + indexEntry.getSize() + " bytes."));
    }

    public synchronized void update(Object object, ObjectName objectName) throws FlatFileCorruptedException, InstanceNotFoundException, IOException, FileNotFoundException {
        if (!this.online) {
            Debug.print((int)4, (Object)"FlatFileFactory::update: Registry is offline.");
            throw new IllegalStateException("Registry not started.");
        }
        if (!(object instanceof Serializable)) {
            Debug.print((Object)("FlatFileFactory::update: Object is not serializable=" + object));
            throw new IllegalArgumentException("Only Serializable objects are updated");
        }
        if (!this.registryExists()) {
            throw new FileNotFoundException("Registry file not found: " + this.registry);
        }
        IndexEntry indexEntry = (IndexEntry)this.ffi.findEntry(objectName);
        if (indexEntry == null) {
            throw new InstanceNotFoundException("Instance not found: " + objectName);
        }
        if (indexEntry.getObject() != object) {
            Debug.print((Object)("FlatFileFactory::update: Object reference doesn't correspond with object reference in object cache=" + object));
            throw new InstanceNotFoundException("Invalid object reference: " + object);
        }
        try {
            this.updateRecord(object, indexEntry);
        }
        catch (FlatFileBlockInActiveException flatFileBlockInActiveException) {
            try {
                this.ffi.removeEntry(objectName);
                this.al.markAvailable(indexEntry);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                Debug.printException((Exception)((Object)instanceNotFoundException));
            }
            throw new InstanceNotFoundException(String.valueOf(flatFileBlockInActiveException.getClass().getName()) + ": " + flatFileBlockInActiveException.getMessage());
        }
        catch (FlatFileCorruptedException flatFileCorruptedException) {
            this.removeCorruptedEntry(objectName);
            throw flatFileCorruptedException;
        }
        catch (EOFException eOFException) {
            this.removeCorruptedEntry(objectName);
            throw new InstanceNotFoundException(String.valueOf(eOFException.getClass().getName()) + ": " + eOFException.getMessage());
        }
    }

    private void updateRecord(Object object, IndexEntry indexEntry) throws IOException, FlatFileBlockInActiveException, EOFException, FlatFileCorruptedException {
        Debug.print((int)4, (Object)"\nFlatFileFactory::updateRecord: >>> ... OLD RECORD ...");
        Debug.print((int)4, (Object)("FlatFileFactory::updateRecord: >>> id=" + indexEntry.getPosition()));
        Debug.print((int)4, (Object)("FlatFileFactory::updateRecord: >>> length=" + indexEntry.getSize() + " bytes."));
        byte[] byArray = this.readRecord(indexEntry);
        BufferedByteArrayInputStream bufferedByteArrayInputStream = new BufferedByteArrayInputStream(byArray);
        BufferedByteArrayOutputStream bufferedByteArrayOutputStream = new BufferedByteArrayOutputStream();
        bufferedByteArrayOutputStream.writeUTF(bufferedByteArrayInputStream.readUTF());
        bufferedByteArrayOutputStream.writeUTF(bufferedByteArrayInputStream.readUTF());
        bufferedByteArrayOutputStream.writeXBytes(this.os.serialObject(object));
        bufferedByteArrayOutputStream.flush();
        byte[] byArray2 = bufferedByteArrayOutputStream.toByteArray();
        bufferedByteArrayOutputStream.close();
        Debug.print((int)4, (Object)("FlatFileFactory::updateRecord: >>> new length=" + byArray2.length + " bytes."));
        try {
            this.ffb.readHeader();
            this.ffb.updateBlock(byArray2, indexEntry.getPosition());
        }
        catch (FlatFileBlockTooShortException flatFileBlockTooShortException) {
            IndexEntry indexEntry2 = new IndexEntry(indexEntry.getPosition(), indexEntry.getSize());
            this.storeRecord(byArray2, indexEntry);
            try {
                this.deactivateRecord(indexEntry2);
            }
            catch (Exception exception) {
                Debug.printException((Exception)flatFileBlockTooShortException);
            }
        }
        Debug.print((int)4, (Object)"\nFlatFileFactory::updateRecord: >>> ... NEW RECORD ...");
        Debug.print((int)4, (Object)("FlatFileFactory::updateRecord: >>> id=" + indexEntry.getPosition()));
        Debug.println((int)4, (Object)("FlatFileFactory::updateRecord: >>> length=" + indexEntry.getSize() + " bytes."));
    }

    private boolean validPath(File file) {
        return !(file.exists() ? !file.isDirectory() || !file.canWrite() || !file.canRead() : !file.mkdirs());
    }
}

