/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.persistent.internal;

import com.sun.jaw.impl.agent.services.persistent.internal.Marker;
import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.LoaderRepository;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;

public class ObjectStoreInputStream
extends ObjectInputStream
implements Serializable {
    private transient ClassLoader loader = null;
    private transient Framework cmf = null;

    public ObjectStoreInputStream(InputStream inputStream, ClassLoader classLoader, Framework framework) throws IOException, StreamCorruptedException {
        super(inputStream);
        try {
            super.enableResolveObject(true);
            Debug.print((int)4, (Object)"ObjectStoreInputStream::ObjectStoreInputStream: Framework synchronization enabled.");
        }
        catch (SecurityException securityException) {
            System.err.println("ERROR: Framework synchronization disabled !!");
            Debug.printException((Exception)securityException);
        }
        this.loader = classLoader;
        this.cmf = framework;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (this.loader != null) {
            try {
                return this.loader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        ClassLoader classLoader = null;
        if (this.cmf != null && (classLoader = this.cmf.getClassLoader()) != null) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        try {
            return super.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return LoaderRepository.loadClass((String)string);
        }
    }

    protected Object resolveObject(Object object) throws IOException {
        if (object instanceof Marker) {
            return this.cmf;
        }
        return object;
    }
}

