/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.agent.services.persistent.internal;

import com.sun.jaw.impl.agent.services.persistent.internal.PropertyTypes;
import com.sun.jaw.reference.common.Debug;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class PropertyInsp
implements PropertyTypes,
Serializable {
    public Properties allocateProperties(Object object) {
        PropertyDescriptor[] propertyDescriptorArray = this.filterProperties(this.extractProperties(object));
        Debug.print((int)128, (Object)"\nPropertyInsp:: - PROPERTIES -");
        Properties properties = new Properties();
        if (propertyDescriptorArray != null) {
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                Method method = propertyDescriptorArray[n].getReadMethod();
                String string = propertyDescriptorArray[n].getName();
                Object object2 = null;
                try {
                    object2 = method.invoke(object, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Debug.printException((Exception)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Debug.printException((Exception)invocationTargetException);
                }
                if (object2 != null) {
                    Debug.print((int)128, (Object)("PropertyInsp:: Property name=" + string));
                    Debug.print((int)128, (Object)("PropertyInsp:: Property value=" + object2.toString()));
                    ((Hashtable)properties).put(string, object2.toString());
                }
                ++n;
            }
        }
        Debug.print((int)128, (Object)"");
        return properties;
    }

    protected int allowedPropertyType(Class clazz) {
        if (clazz == null) {
            return -1;
        }
        if (clazz.getName().equals("java.lang.Boolean") || clazz == Boolean.TYPE) {
            return 1;
        }
        if (clazz.getName().equals("java.lang.Byte") || clazz == Byte.TYPE) {
            return 2;
        }
        if (clazz.getName().equals("java.lang.Character") || clazz == Character.TYPE) {
            return 3;
        }
        if (clazz.getName().equals("java.lang.Double") || clazz == Double.TYPE) {
            return 4;
        }
        if (clazz.getName().equals("java.lang.Float") || clazz == Float.TYPE) {
            return 5;
        }
        if (clazz.getName().equals("java.lang.Integer") || clazz == Integer.TYPE) {
            return 6;
        }
        if (clazz.getName().equals("java.lang.Long") || clazz == Long.TYPE) {
            return 7;
        }
        if (clazz.getName().equals("java.lang.Short") || clazz == Short.TYPE) {
            return 8;
        }
        if (clazz.getName().equals("java.lang.String")) {
            return 9;
        }
        return -1;
    }

    public void applyProperties(Properties properties, Object object) {
        PropertyDescriptor[] propertyDescriptorArray = this.filterProperties(this.extractProperties(object));
        Debug.print((int)128, (Object)"\nPropertyInsp:: - PROPERTIES -");
        if (propertyDescriptorArray != null) {
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                String string = (String)((Hashtable)properties).get(propertyDescriptorArray[n].getName());
                if (string != null) {
                    Method method = propertyDescriptorArray[n].getWriteMethod();
                    Class<?> clazz = propertyDescriptorArray[n].getPropertyType();
                    Object[] objectArray = new Object[]{this.translateToObject(clazz, string)};
                    if (method != null && clazz != null && objectArray[0] != null) {
                        try {
                            Debug.print((int)128, (Object)("PropertyInsp:: Property name=" + propertyDescriptorArray[n].getName()));
                            Debug.print((int)128, (Object)("PropertyInsp:: Property value=" + string));
                            method.invoke(object, objectArray);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            Debug.printException((Exception)illegalAccessException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Debug.printException((Exception)invocationTargetException);
                        }
                    }
                }
                ++n;
            }
        }
        Debug.print((int)128, (Object)"");
    }

    protected PropertyDescriptor[] autoAnalysis(Class clazz) {
        int n;
        PropertyDescriptor[] propertyDescriptorArray;
        Method[] methodArray = clazz.getDeclaredMethods();
        Vector<PropertyDescriptor> vector = new Vector<PropertyDescriptor>();
        int n2 = 0;
        while (n2 < methodArray.length) {
            propertyDescriptorArray = methodArray[n2];
            n = propertyDescriptorArray.getModifiers();
            if (!Modifier.isStatic(n) && Modifier.isPublic(n)) {
                String string = propertyDescriptorArray.getName();
                Class<?>[] classArray = propertyDescriptorArray.getParameterTypes();
                Class<?> clazz2 = propertyDescriptorArray.getReturnType();
                int n3 = classArray.length;
                PropertyDescriptor propertyDescriptor = null;
                try {
                    if (n3 == 0) {
                        if (string.startsWith("get")) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), (Method)propertyDescriptorArray, null);
                        } else if (clazz2 == Boolean.TYPE && string.startsWith("is")) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(2)), (Method)propertyDescriptorArray, null);
                        }
                    } else if (n3 == 1) {
                        if (classArray[0] == Integer.TYPE && string.startsWith("get")) {
                            propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, (Method)propertyDescriptorArray, null);
                        } else if (clazz2 == Void.TYPE && string.startsWith("set")) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, (Method)propertyDescriptorArray);
                        }
                    } else if (n3 == 2 && classArray[0] == Integer.TYPE && string.startsWith("set")) {
                        propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, null, (Method)propertyDescriptorArray);
                    }
                }
                catch (IntrospectionException introspectionException) {
                    propertyDescriptor = null;
                }
                if (propertyDescriptor != null) {
                    vector.addElement(propertyDescriptor);
                }
            }
            ++n2;
        }
        propertyDescriptorArray = null;
        if (!vector.isEmpty()) {
            propertyDescriptorArray = new PropertyDescriptor[vector.size()];
            n = 0;
            while (n < vector.size()) {
                propertyDescriptorArray[n] = (PropertyDescriptor)vector.elementAt(n);
                ++n;
            }
        }
        return propertyDescriptorArray;
    }

    protected PropertyDescriptor[] extractProperties(Object object) {
        Class<?> clazz = object.getClass();
        PropertyDescriptor[] propertyDescriptorArray = null;
        try {
            propertyDescriptorArray = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            Debug.printException((Exception)introspectionException);
        }
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = this.autoAnalysis(clazz);
        }
        return propertyDescriptorArray;
    }

    protected PropertyDescriptor[] filterProperties(PropertyDescriptor[] propertyDescriptorArray) {
        Vector<PropertyDescriptor> vector = new Vector<PropertyDescriptor>();
        PropertyDescriptor[] propertyDescriptorArray2 = null;
        if (propertyDescriptorArray == null) {
            return propertyDescriptorArray2;
        }
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
            if (this.validPropertyType(propertyDescriptor)) {
                vector.addElement(propertyDescriptor);
            }
            ++n;
        }
        if (!vector.isEmpty()) {
            propertyDescriptorArray2 = new PropertyDescriptor[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                propertyDescriptorArray2[n2] = (PropertyDescriptor)vector.elementAt(n2);
                ++n2;
            }
        }
        return propertyDescriptorArray2;
    }

    protected Object translateToObject(Class clazz, String string) {
        Object object = null;
        switch (this.allowedPropertyType(clazz)) {
            case 1: {
                object = Boolean.valueOf(string);
                break;
            }
            case 2: {
                object = Byte.valueOf(string);
                break;
            }
            case 3: {
                object = new Character(string.charAt(0));
                break;
            }
            case 4: {
                object = Double.valueOf(string);
                break;
            }
            case 5: {
                object = Float.valueOf(string);
                break;
            }
            case 6: {
                object = Integer.valueOf(string);
                break;
            }
            case 7: {
                object = Long.valueOf(string);
                break;
            }
            case 8: {
                object = Short.valueOf(string);
                break;
            }
            case 9: {
                object = string;
                break;
            }
            case -1: {
                object = null;
                break;
            }
        }
        return object;
    }

    protected boolean validPropertyType(PropertyDescriptor propertyDescriptor) {
        boolean bl = false;
        Method method = propertyDescriptor.getWriteMethod();
        Method method2 = propertyDescriptor.getReadMethod();
        if (method != null && method2 != null && !propertyDescriptor.isHidden() && this.allowedPropertyType(propertyDescriptor.getPropertyType()) != -1) {
            bl = true;
        }
        return bl;
    }
}

