/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.reference.agent.cmf;

import com.sun.jaw.impl.agent.services.light.RepositorySrv;
import com.sun.jaw.impl.agent.services.light.ThreadAllocatorSrv;
import com.sun.jaw.reference.agent.cmf.CheckFrameworkPermission;
import com.sun.jaw.reference.agent.cmf.FrameworkEvent;
import com.sun.jaw.reference.agent.cmf.FrameworkListener;
import com.sun.jaw.reference.agent.services.EventHandlerIf;
import com.sun.jaw.reference.agent.services.FilterSrvIf;
import com.sun.jaw.reference.agent.services.MetaDataSrvIf;
import com.sun.jaw.reference.agent.services.MoRepSrvIf;
import com.sun.jaw.reference.agent.services.OperatorSrvIf;
import com.sun.jaw.reference.agent.services.RelationSrvIf;
import com.sun.jaw.reference.agent.services.ThreadAllocatorSrvIf;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.InvalidPropertyValueException;
import com.sun.jaw.reference.common.LoaderRepository;
import com.sun.jaw.reference.common.Modification;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.NamedObject;
import com.sun.jaw.reference.common.ObjectInputStreamWithLoader;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.common.Property;
import com.sun.jaw.reference.common.PropertyList;
import com.sun.jaw.reference.common.PropertyName;
import com.sun.jaw.reference.common.PropertyNotFoundException;
import com.sun.jaw.reference.common.RelationIf;
import com.sun.jaw.reference.common.ServiceNotFoundException;
import com.sun.jaw.reference.query.QueryExp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;

public class Framework {
    protected Vector Listeners = new Vector();
    protected transient MoRepSrvIf repository = null;
    protected boolean queryByRepo;
    protected ClassLoader loader = null;
    protected transient FilterSrvIf filtering = null;
    protected transient ThreadAllocatorSrvIf threading = null;
    protected transient MetaDataSrvIf meta = null;
    protected transient RelationSrvIf relator = null;
    protected String domain;
    private static final String sccs_id = "@(#)Framework.java 3.21 03/30/99 SMI";
    private ObjectName frameworkObjetName = null;
    static /* synthetic */ Class class$com$sun$jaw$reference$agent$cmf$Framework;
    static /* synthetic */ Class class$com$sun$jaw$reference$common$ObjectName;
    static /* synthetic */ Class class$com$sun$jaw$reference$common$ModificationList;

    public Framework() {
        this.initialize(new RepositorySrv(), new ThreadAllocatorSrv(), null);
    }

    public Framework(MoRepSrvIf moRepSrvIf, ThreadAllocatorSrvIf threadAllocatorSrvIf, String string) {
        this.initialize(moRepSrvIf, threadAllocatorSrvIf, string);
    }

    public Framework(MoRepSrvIf moRepSrvIf, String string) {
        this.initialize(moRepSrvIf, new ThreadAllocatorSrv(), string);
    }

    public Framework(String string) {
        this.initialize(new RepositorySrv(), new ThreadAllocatorSrv(), string);
    }

    public void addDBObject(Object object, ObjectName objectName) throws InstanceAlreadyExistException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        this.internal_addDBObject(object, objectName);
    }

    public synchronized void addFrameworkListener(FrameworkListener frameworkListener) {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)"cmf::addFrameworkListener: Register a listener");
        }
        this.Listeners.addElement(frameworkListener);
    }

    public Vector addListener(ObjectName objectName, Object object, String string) throws InstanceNotFoundException, IllegalAccessException, ServiceNotFoundException, ClassNotFoundException, InstantiationException, InvocationTargetException {
        Method method;
        int n;
        Class clazz = this.getClass(object, string);
        int n2 = string.lastIndexOf(".");
        String string2 = n2 == -1 ? string : string.substring(n2 + 1);
        MetaDataSrvIf metaDataSrvIf = this.giveMetaDataSrv();
        Class[] classArray = new Class[]{class$com$sun$jaw$reference$agent$cmf$Framework != null ? class$com$sun$jaw$reference$agent$cmf$Framework : (class$com$sun$jaw$reference$agent$cmf$Framework = Framework.class$("com.sun.jaw.reference.agent.cmf.Framework")), class$com$sun$jaw$reference$common$ObjectName != null ? class$com$sun$jaw$reference$common$ObjectName : (class$com$sun$jaw$reference$common$ObjectName = Framework.class$("com.sun.jaw.reference.common.ObjectName"))};
        Constructor constructor = metaDataSrvIf.findConstructor(clazz, classArray);
        if (constructor == null) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::addListener: Can not get constructor for " + clazz));
            }
            throw new InstantiationException("Can not get constructor for " + clazz);
        }
        Object[] objectArray = new Object[]{this, objectName};
        Object t = constructor.newInstance(objectArray);
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::addListener: Instantiated " + clazz));
        }
        string = (n = string.lastIndexOf("Stub")) == -1 ? string : string.substring(0, n);
        Class clazz2 = this.getClass(object, string);
        n2 = string2.lastIndexOf("Stub");
        string2 = n2 == -1 ? string2 : string2.substring(0, n2);
        Class[] classArray2 = new Class[]{clazz2};
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::addListener: identify add" + string2 + "(" + clazz2 + ")" + " on " + object.getClass().getName()));
        }
        if ((method = metaDataSrvIf.findMethod(object.getClass(), "add" + string2, classArray2)) == null) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::addListener: can't find add" + string2));
            }
            throw new ServiceNotFoundException("Cannot find add" + string2);
        }
        objectArray = new Object[]{t};
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::addAListener: call add" + string2));
        }
        method.invoke(object, objectArray);
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(t);
        vector.addElement(string2);
        vector.addElement(clazz2);
        return vector;
    }

    public ObjectName addObject(Object object) throws InstanceAlreadyExistException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        return this.internal_addObject(object);
    }

    public void addObject(Object object, ObjectName objectName) throws InstanceAlreadyExistException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        this.internal_addObject(object, objectName);
    }

    public ObjectName addRelation(RelationIf relationIf, ObjectName objectName) throws InstanceAlreadyExistException, InstanceNotFoundException {
        CheckFrameworkPermission.checkPermission("accessRelationMethods");
        return this.internal_addRelation(relationIf, objectName);
    }

    private Object checkUpdateContext(Object object, Object object2) {
        if (object2 == null) {
            return null;
        }
        ClassLoader classLoader = object.getClass().getClassLoader();
        if (classLoader == null) {
            return object2;
        }
        ClassLoader classLoader2 = object2.getClass().getClassLoader();
        if (classLoader2 == null) {
            return object2;
        }
        if (classLoader.equals(classLoader2)) {
            return object2;
        }
        return this.transferObject(object2, classLoader);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean contains(ObjectName objectName) {
        CheckFrameworkPermission.checkPermission("accessObjects");
        return this.internal_contains(objectName);
    }

    public boolean contains(Object object) {
        CheckFrameworkPermission.checkPermission("accessObjects");
        return this.internal_contains(object);
    }

    public void delObject(ObjectName objectName) throws InstanceNotFoundException, InvocationTargetException {
        CheckFrameworkPermission.checkPermission("unregisterObjects");
        this.internal_delObject(objectName);
    }

    public void delObject(Object object) throws InstanceNotFoundException, InvocationTargetException {
        CheckFrameworkPermission.checkPermission("unregisterObjects");
        this.internal_delObject(object);
    }

    public void fastDelObject(ObjectName objectName) throws InstanceNotFoundException, InvocationTargetException {
        CheckFrameworkPermission.checkPermission("unregisterObjects");
        this.internal_fastDelObject(objectName);
    }

    protected Vector filterListOfObjects(Vector vector, QueryExp queryExp) {
        FilterSrvIf filterSrvIf = this.internal_getFilterSrvIf();
        if (filterSrvIf == null) {
            throw new ServiceNotFoundException("Service com.sun.jaw.reference.agent.services.FilterSrvIfMO not supported");
        }
        Vector<NamedObject> vector2 = new Vector<NamedObject>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            NamedObject namedObject = (NamedObject)enumeration.nextElement();
            Object object = namedObject.getObject();
            if (!filterSrvIf.eval(queryExp, object)) continue;
            vector2.addElement(namedObject);
        }
        return vector2;
    }

    private Class getClass(Object object, String string) throws ClassNotFoundException {
        ClassLoader classLoader = object.getClass().getClassLoader();
        if (classLoader == null) {
            return this.internal_getClass(string);
        }
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return LoaderRepository.loadClassWithout((ClassLoader)classLoader, (String)string);
        }
    }

    public Class getClass(String string) throws ClassNotFoundException {
        CheckFrameworkPermission.checkPermission("accessObjects");
        return this.internal_getClass(string);
    }

    public Class getClass(String string, ObjectName objectName) throws ClassNotFoundException {
        CheckFrameworkPermission.checkPermission("accessObjects");
        return this.internal_getClass(string, objectName);
    }

    public ClassLoader getClassLoader() {
        CheckFrameworkPermission.checkPermission("accessCoreMethods");
        return this.internal_getClassLoader();
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public String getDomain() {
        return this.domain;
    }

    public FilterSrvIf getFilterSrvIf() {
        CheckFrameworkPermission.checkPermission("accessCoreMethods");
        return this.internal_getFilterSrvIf();
    }

    public Object getIndexedValue(ObjectName objectName, String string, int n) throws InvocationTargetException, PropertyNotFoundException, InstanceNotFoundException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::getIndexedValue: Prop= " + string + ", obj= " + objectName));
        }
        return this.getIndexedValue(this.internal_retrieveObject(objectName), string, n);
    }

    public Object getIndexedValue(Object object, String string, int n) throws InvocationTargetException, PropertyNotFoundException {
        MetaDataSrvIf metaDataSrvIf = this.giveMetaDataSrv();
        Method method = metaDataSrvIf.findIndexedGetter(object.getClass(), string);
        if (method == null) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)"cmf::getIndexedValue: Can not find indexed getter");
            }
            throw new PropertyNotFoundException(String.valueOf(string) + " not accessible");
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::getIndexedValue: " + string + "(" + n + ")"));
        }
        Object object2 = null;
        try {
            object2 = method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            throw new PropertyNotFoundException(String.valueOf(string) + "[" + n + "]" + " not accessible");
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::getIndexedValue: " + string + "(" + n + ") = " + object2 + "\n"));
        }
        return object2;
    }

    public String getJdmkVersion() {
        return "JDMK/3.2";
    }

    public MetaDataSrvIf getMetaDataSrvIf() {
        CheckFrameworkPermission.checkPermission("accessCoreMethods");
        return this.internal_getMetaDataSrvIf();
    }

    public MoRepSrvIf getMoRepSrvIf() {
        CheckFrameworkPermission.checkPermission("accessCoreMethods");
        return this.internal_getMoRepSrvIf();
    }

    public Integer getNbElements() {
        return this.repository.getNbElements();
    }

    public Vector getObject(ObjectName objectName, QueryExp queryExp) throws InstanceNotFoundException {
        CheckFrameworkPermission.checkPermission("accessObjects");
        return this.internal_getObject(objectName, queryExp);
    }

    public RelationSrvIf getRelationSrvIf() {
        CheckFrameworkPermission.checkPermission("accessCoreMethods");
        return this.internal_getRelationSrvIf();
    }

    public Vector getRelations(ObjectName objectName, ObjectName objectName2, int n) throws InstanceNotFoundException {
        CheckFrameworkPermission.checkPermission("accessRelationMethods");
        return this.internal_getRelations(objectName, objectName2, n);
    }

    protected Object getServiceFromRepository(String string) {
        Vector vector;
        ObjectName objectName = null;
        objectName = new ObjectName(this.domain, string);
        Framework framework = this;
        synchronized (framework) {
            vector = this.repository.getObject(objectName, null);
        }
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        return ((NamedObject)vector.firstElement()).getObject();
    }

    public ThreadAllocatorSrvIf getThreadAllocatorSrvIf() {
        CheckFrameworkPermission.checkPermission("accessCoreMethods");
        return this.internal_getThreadAllocatorSrvIf();
    }

    public Object getValue(ObjectName objectName, String string) throws InvocationTargetException, PropertyNotFoundException, InstanceNotFoundException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::getValue: Prop= " + string + ", obj= " + objectName));
        }
        return this.getValue(this.internal_retrieveObject(objectName), string);
    }

    public Object getValue(Object object, String string) throws InvocationTargetException, PropertyNotFoundException {
        MetaDataSrvIf metaDataSrvIf = this.giveMetaDataSrv();
        Method method = metaDataSrvIf.findGetter(object.getClass(), string);
        if (method == null) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::getValue: Can not find getter for " + string));
            }
            throw new PropertyNotFoundException(String.valueOf(string) + " not accessible");
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)"cmf::getValue: Invoke callback");
        }
        Object object2 = null;
        try {
            object2 = method.invoke(object, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PropertyNotFoundException(String.valueOf(string) + " not accessible");
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::getValue: " + string + "= " + object2 + "\n"));
        }
        return object2;
    }

    public PropertyList getValues(ObjectName objectName, Vector vector) throws InstanceNotFoundException {
        PropertyList propertyList = new PropertyList();
        if (vector.isEmpty()) {
            return propertyList;
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::getValues: Object= " + objectName));
        }
        Object object = this.internal_retrieveObject(objectName);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            try {
                Object object2;
                if (e instanceof String) {
                    object2 = this.getValue(object, (String)e);
                    propertyList.addElement(new Property((String)e, object2));
                } else if (e instanceof PropertyName) {
                    String string = ((PropertyName)e).getName();
                    int n3 = ((PropertyName)e).getPosition();
                    object2 = n3 == -1 ? this.getValue(object, string) : this.getIndexedValue(object, string, n3);
                    propertyList.addElement(new Property(string, object2, n3));
                }
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
            }
            ++n2;
        }
        return propertyList;
    }

    private MetaDataSrvIf giveMetaDataSrv() {
        MetaDataSrvIf metaDataSrvIf = this.internal_getMetaDataSrvIf();
        if (metaDataSrvIf == null) {
            throw new ServiceNotFoundException("Service com.sun.jaw.impl.agent.services.light.MetaDataSrvMO not supported");
        }
        return metaDataSrvIf;
    }

    public void initCmfInvoker(Object object, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException, InvocationTargetException, IllegalAccessException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        this.internal_initCmfInvoker(object, objectName, bl, modificationList);
    }

    private void initialize(MoRepSrvIf moRepSrvIf, ThreadAllocatorSrvIf threadAllocatorSrvIf, String string) {
        block7: {
            this.domain = string == null || string.equals("") ? "defaultDomain" : string;
            if (moRepSrvIf == null) {
                throw new IllegalArgumentException("Repository service can't be null");
            }
            if (threadAllocatorSrvIf == null) {
                throw new IllegalArgumentException("Thread allocator service can't be null");
            }
            this.repository = moRepSrvIf;
            this.threading = threadAllocatorSrvIf;
            moRepSrvIf.setDomain(this.domain);
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::new: Initializing domain " + this.domain));
            }
            try {
                this.queryByRepo = moRepSrvIf.isQuerySrv();
            }
            catch (Exception exception) {
                this.queryByRepo = false;
            }
            this.frameworkObjetName = new ObjectName(String.valueOf(this.domain) + ":" + "com.sun.jaw.reference.client.mo.FrameworkMO");
            try {
                this.internal_addObject(this, this.frameworkObjetName);
            }
            catch (Exception exception) {
                if (!Debug.isLevelSet((int)1)) break block7;
                Debug.printFormatted((Object)"cmf::new: Fails to register framework.");
            }
        }
    }

    protected void internDelObject(ObjectName objectName, boolean bl, String string) throws InstanceNotFoundException, InvocationTargetException {
        Object object;
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)(String.valueOf(string) + ": Name = " + objectName));
        }
        Vector vector = null;
        Vector<ObjectName> vector2 = new Vector<ObjectName>();
        Framework framework = this;
        synchronized (framework) {
            vector = this.repository.getObject(objectName, null);
        }
        if (vector.size() == 0) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)(String.valueOf(string) + ": Found no object"));
            }
            throw new InstanceNotFoundException(objectName.toString());
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            object = (NamedObject)vector.elementAt(n2);
            Object object2 = object.getObject();
            ObjectName objectName2 = object.getName();
            Framework framework2 = this;
            synchronized (framework2) {
                this.repository.unregister(objectName2);
            }
            vector2.addElement(objectName2);
            if (bl) {
                this.invokeMethodWithNoArg(object2, "deleteCmf");
            }
            ++n2;
        }
        this.notifyChange(vector2, 2);
        object = this.internal_getRelationSrvIf();
        if (object != null) {
            object.purgeRelations();
        }
    }

    private void internal_addDBObject(Object object, ObjectName objectName) throws InstanceAlreadyExistException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::addDBObject: Name= " + objectName.toString()));
        }
        Framework framework = this;
        synchronized (framework) {
            this.repository.registerDB(object, objectName);
        }
        this.notifyChange(objectName, 1);
    }

    private ObjectName internal_addObject(Object object) throws InstanceAlreadyExistException {
        if (object == null) {
            throw new IllegalArgumentException("cmf::addObject: Cannot add null object");
        }
        ObjectName objectName = new ObjectName(this.domain, object.getClass().getName());
        this.internal_addObject(object, objectName);
        return objectName;
    }

    private void internal_addObject(Object object, ObjectName objectName) throws InstanceAlreadyExistException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::addObject: Name= " + objectName));
        }
        Framework framework = this;
        synchronized (framework) {
            this.repository.register(object, objectName);
        }
        this.notifyChange(objectName, 1);
    }

    private ObjectName internal_addRelation(RelationIf relationIf, ObjectName objectName) throws InstanceAlreadyExistException, InstanceNotFoundException {
        RelationSrvIf relationSrvIf = this.internal_getRelationSrvIf();
        if (relationSrvIf == null) {
            throw new ServiceNotFoundException("Service com.sun.jaw.impl.agent.services.light.RelationSrvMO not supported");
        }
        if (objectName == null) {
            String string = relationIf.getClass().getName();
            objectName = relationSrvIf.getRelationName(string);
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::addRelation: Name= " + objectName));
        }
        return relationSrvIf.performAddRelation(relationIf, objectName);
    }

    private boolean internal_contains(ObjectName objectName) {
        Framework framework = this;
        synchronized (framework) {
            boolean bl = this.repository.contains(objectName);
            Object var4_4 = null;
            return bl;
        }
    }

    private boolean internal_contains(Object object) {
        Framework framework = this;
        synchronized (framework) {
            boolean bl = this.repository.contains(object);
            Object var4_4 = null;
            return bl;
        }
    }

    private void internal_delObject(ObjectName objectName) throws InstanceNotFoundException, InvocationTargetException {
        this.internDelObject(objectName, true, "cmf::delObject");
    }

    private void internal_delObject(Object object) throws InstanceNotFoundException, InvocationTargetException {
        Object object2 = this;
        synchronized (object2) {
            this.repository.unregister(object);
        }
        this.invokeMethodWithNoArg(object, "deleteCmf");
        object2 = this.internal_getRelationSrvIf();
        if (object2 != null) {
            object2.purgeRelations();
        }
        this.notifyChange(new ObjectName(this.domain, object.getClass().getName()), 2);
    }

    private void internal_fastDelObject(ObjectName objectName) throws InstanceNotFoundException, InvocationTargetException {
        this.internDelObject(objectName, false, "cmf:fastDelObject");
    }

    private Class internal_getClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            if (this.loader == null) {
                if (Debug.isLevelSet((int)1)) {
                    Debug.printFormatted((Object)("cmf::getClass: Use default loader for loading " + string));
                }
                clazz = Class.forName(string);
                if (Debug.isLevelSet((int)1)) {
                    Debug.printFormatted((Object)("cmf::getClass: Was able to load " + string));
                }
            } else {
                if (Debug.isLevelSet((int)1)) {
                    Debug.printFormatted((Object)("cmf::getClass: Use specific loader for loading " + string));
                }
                clazz = this.loader.loadClass(string);
                if (Debug.isLevelSet((int)1)) {
                    Debug.printFormatted((Object)("cmf::getClass: Was able to load " + string));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::getClass: Use loader repository for loading " + string));
            }
            clazz = LoaderRepository.loadClassWithout((ClassLoader)this.loader, (String)string);
        }
        return clazz;
    }

    private Class internal_getClass(String string, ObjectName objectName) throws ClassNotFoundException {
        Vector vector;
        if (objectName == null) {
            return this.internal_getClass(string);
        }
        Framework framework = this;
        synchronized (framework) {
            vector = this.repository.getObject(objectName, null);
        }
        if (vector == null || vector.isEmpty()) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::getClass: Class loader " + objectName.toString() + " not found"));
            }
            return this.internal_getClass(string);
        }
        framework = (NamedObject)vector.firstElement();
        ClassLoader classLoader = null;
        try {
            classLoader = (ClassLoader)framework.getObject();
        }
        catch (Exception exception) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::getClass: " + objectName + " does not implement ClassLoader"));
            }
            throw new ServiceNotFoundException(String.valueOf(objectName.toString()) + " is not a ClassLoader");
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::getClass: Identified loader " + objectName.toString() + "\ncmf::getClass: Use specific loader for loading " + string));
        }
        Class<?> clazz = classLoader.loadClass(string);
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::getClass: Was able to load " + string));
        }
        return clazz;
    }

    private ClassLoader internal_getClassLoader() {
        return this.loader;
    }

    private FilterSrvIf internal_getFilterSrvIf() {
        if (this.filtering != null) {
            return this.filtering;
        }
        return (FilterSrvIf)this.getServiceFromRepository("com.sun.jaw.reference.agent.services.FilterSrvIfMO");
    }

    private MetaDataSrvIf internal_getMetaDataSrvIf() {
        if (this.meta != null) {
            return this.meta;
        }
        return (MetaDataSrvIf)this.getServiceFromRepository("com.sun.jaw.impl.agent.services.light.MetaDataSrvMO");
    }

    private MoRepSrvIf internal_getMoRepSrvIf() {
        return this.repository;
    }

    private Vector internal_getObject(ObjectName objectName, QueryExp queryExp) throws InstanceNotFoundException {
        Vector vector;
        Framework framework = this;
        synchronized (framework) {
            vector = this.repository.getObject(objectName, queryExp);
        }
        if (queryExp == null || this.queryByRepo) {
            return vector;
        }
        return this.filterListOfObjects(vector, queryExp);
    }

    private RelationSrvIf internal_getRelationSrvIf() {
        if (this.relator != null) {
            return this.relator;
        }
        return (RelationSrvIf)this.getServiceFromRepository("com.sun.jaw.impl.agent.services.light.RelationSrvMO");
    }

    private Vector internal_getRelations(ObjectName objectName, ObjectName objectName2, int n) throws InstanceNotFoundException {
        RelationSrvIf relationSrvIf = this.internal_getRelationSrvIf();
        if (relationSrvIf == null) {
            throw new ServiceNotFoundException("Service com.sun.jaw.impl.agent.services.light.RelationSrvMO not supported");
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)"cmf::getRelations:");
            Debug.printFormatted((Object)("\tRelation class name= " + objectName));
            Debug.printFormatted((Object)("\tRole name= " + objectName2));
        }
        return relationSrvIf.performGetRelations(objectName, objectName2, new Integer(n));
    }

    private ThreadAllocatorSrvIf internal_getThreadAllocatorSrvIf() {
        if (this.threading != null) {
            return this.threading;
        }
        return (ThreadAllocatorSrvIf)this.getServiceFromRepository("com.sun.jaw.impl.agent.services.light.ThreadAllocatorSrvMO");
    }

    private void internal_initCmfInvoker(Object object, ObjectName objectName, boolean bl, ModificationList modificationList) throws InstanceAlreadyExistException, InvocationTargetException, IllegalAccessException {
        MetaDataSrvIf metaDataSrvIf = this.internal_getMetaDataSrvIf();
        if (metaDataSrvIf == null) {
            if (objectName == null) {
                return;
            }
            if (bl) {
                this.internal_addDBObject(object, objectName);
            } else {
                this.internal_addObject(object, objectName);
            }
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::initCmfInvoker: Creation completed for name=" + objectName + "\n"));
            }
            return;
        }
        Class[] classArray = new Class[]{class$com$sun$jaw$reference$agent$cmf$Framework != null ? class$com$sun$jaw$reference$agent$cmf$Framework : (class$com$sun$jaw$reference$agent$cmf$Framework = Framework.class$("com.sun.jaw.reference.agent.cmf.Framework")), class$com$sun$jaw$reference$common$ObjectName != null ? class$com$sun$jaw$reference$common$ObjectName : (class$com$sun$jaw$reference$common$ObjectName = Framework.class$("com.sun.jaw.reference.common.ObjectName")), Boolean.TYPE, class$com$sun$jaw$reference$common$ModificationList != null ? class$com$sun$jaw$reference$common$ModificationList : (class$com$sun$jaw$reference$common$ModificationList = Framework.class$("com.sun.jaw.reference.common.ModificationList"))};
        Method method = metaDataSrvIf.findMethod(object.getClass(), "initCmf", classArray);
        if (method != null) {
            Object[] objectArray = new Object[]{this, objectName, new Boolean(bl), modificationList};
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::initCmfInvoker: Call init method for  name=" + objectName));
            }
            method.invoke(object, objectArray);
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::initCmfInvoker: Creation completed for name=" + objectName + "\n"));
            }
            return;
        }
        Class[] classArray2 = new Class[]{class$com$sun$jaw$reference$agent$cmf$Framework != null ? class$com$sun$jaw$reference$agent$cmf$Framework : (class$com$sun$jaw$reference$agent$cmf$Framework = Framework.class$("com.sun.jaw.reference.agent.cmf.Framework")), class$com$sun$jaw$reference$common$ObjectName != null ? class$com$sun$jaw$reference$common$ObjectName : (class$com$sun$jaw$reference$common$ObjectName = Framework.class$("com.sun.jaw.reference.common.ObjectName"))};
        method = metaDataSrvIf.findMethod(object.getClass(), "initCmf", classArray2);
        if (method == null) {
            if (objectName == null) {
                return;
            }
            if (bl) {
                this.internal_addDBObject(object, objectName);
            } else {
                this.internal_addObject(object, objectName);
            }
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::initCmfInvoker: Creation completed for name=" + objectName + "\n"));
            }
            return;
        }
        Object[] objectArray = new Object[]{this, objectName};
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::initCmfInvoker: Call init method for  name=" + objectName));
        }
        method.invoke(object, objectArray);
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::initCmfInvoker: Creation completed for name=" + objectName + "\n"));
        }
    }

    private Object internal_newDBObject(String string, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::newDBObject: Load " + string + ", name= " + objectName));
        }
        return this.newObject(string, objectName, true, null, modificationList);
    }

    private Object internal_newDBObject(String string, ObjectName objectName, ObjectName objectName2, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::newDBObject: Load " + string + ", name= " + objectName + "\n\twith loader= " + objectName2));
        }
        return this.newObject(string, objectName, true, objectName2, modificationList);
    }

    private Object internal_newDBObject(String string, String string2, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        return this.internal_newDBObject(string, new ObjectName(string2), modificationList);
    }

    private Object internal_newDBObject(String string, String string2, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        return this.internal_newDBObject(string, new ObjectName(string2), objectName, modificationList);
    }

    private Object internal_newObj(String string) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::newObj: Load " + string));
        }
        Class clazz = this.internal_getClass(string);
        try {
            return clazz.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new IllegalAccessException("No constructor");
        }
    }

    private Object internal_newObj(String string, ObjectName objectName) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::newObj: Load " + string + " with loader= " + objectName));
        }
        Class clazz = this.internal_getClass(string, objectName);
        try {
            return clazz.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new IllegalAccessException("No constructor");
        }
    }

    private Object internal_newObject(String string, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::newObject: Load " + string + ", name= " + objectName));
        }
        return this.newObject(string, objectName, false, null, modificationList);
    }

    private Object internal_newObject(String string, ObjectName objectName, ObjectName objectName2, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::newObject: Load " + string + ", name= " + objectName + "\n\twith loader= " + objectName2));
        }
        return this.newObject(string, objectName, false, objectName2, modificationList);
    }

    private Object internal_newObject(String string, String string2, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        return this.internal_newObject(string, new ObjectName(string2), modificationList);
    }

    private Object internal_newObject(String string, String string2, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        return this.internal_newObject(string, new ObjectName(string2), objectName, modificationList);
    }

    private ObjectName internal_newRelation(String string, ObjectName objectName, ObjectName[] objectNameArray, ObjectName objectName2) throws IllegalAccessException, InstantiationException, InstanceAlreadyExistException, ClassNotFoundException, InstanceNotFoundException, InvalidPropertyValueException {
        RelationSrvIf relationSrvIf = this.internal_getRelationSrvIf();
        if (relationSrvIf == null) {
            throw new ServiceNotFoundException("Service com.sun.jaw.impl.agent.services.light.RelationSrvMO not supported");
        }
        if (objectName == null) {
            objectName = relationSrvIf.getRelationName(string);
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::newRelation: Name= " + objectName));
        }
        return relationSrvIf.performNewRelation(string, objectName, objectNameArray, objectName2);
    }

    private Object internal_retrieveObject(ObjectName objectName) throws InstanceNotFoundException {
        Object object;
        Framework framework = this;
        synchronized (framework) {
            object = this.repository.retrieve(objectName);
        }
        if (object == null) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)"cmf::retrieveObject: Object not found");
            }
            throw new InstanceNotFoundException(objectName.toString());
        }
        return object;
    }

    private void internal_setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    private void internal_setFilterSrvIf(FilterSrvIf filterSrvIf) {
        this.filtering = filterSrvIf;
    }

    private void internal_setMetaDataSrvIf(MetaDataSrvIf metaDataSrvIf) {
        if (metaDataSrvIf == null) {
            throw new IllegalArgumentException("Metadata service can't be null");
        }
        this.meta = metaDataSrvIf;
    }

    private void internal_setRelationSrvIf(RelationSrvIf relationSrvIf) {
        this.relator = relationSrvIf;
    }

    private void internal_setThreadAllocatorSrvIf(ThreadAllocatorSrvIf threadAllocatorSrvIf) {
        if (threadAllocatorSrvIf == null) {
            throw new IllegalArgumentException("Thread allocator service can't be null");
        }
        this.threading = threadAllocatorSrvIf;
    }

    protected void invokeMethodWithNoArg(Object object, String string) throws InvocationTargetException {
        MetaDataSrvIf metaDataSrvIf = this.internal_getMetaDataSrvIf();
        if (metaDataSrvIf == null) {
            return;
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::invokeMeth: Invoke " + string));
        }
        try {
            Method method = metaDataSrvIf.findMethod(object.getClass(), string, null);
            if (method == null) {
                return;
            }
            method.invoke(object, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {}
    }

    private Object invokeOperator(String string, Object object, ObjectName objectName, String string2, Object object2, int n) throws ClassNotFoundException, InstantiationException, IllegalAccessException, PropertyNotFoundException, InvalidPropertyValueException, InstanceNotFoundException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::invokeOp: Invoke " + string + " on object=" + objectName));
        }
        Class clazz = this.getClass(object, string);
        OperatorSrvIf operatorSrvIf = null;
        try {
            operatorSrvIf = (OperatorSrvIf)clazz.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new IllegalAccessException("No constructor");
        }
        Object object3 = operatorSrvIf.perform(this, objectName, object, string2, object2, n);
        Framework framework = this;
        synchronized (framework) {
            this.repository.update(object, objectName);
        }
        return object3;
    }

    public Object invokePerform(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InvocationTargetException, NoSuchMethodException, InstanceNotFoundException, IllegalAccessException {
        Object object = this.internal_retrieveObject(objectName);
        return this.invokePerform(object, string, objectArray, stringArray);
    }

    public Object invokePerform(Object object, String string, Object[] objectArray, String[] stringArray) throws InvocationTargetException, NoSuchMethodException, InstanceNotFoundException, IllegalAccessException {
        Object object2;
        Object object3;
        Class[] classArray;
        MetaDataSrvIf metaDataSrvIf = this.giveMetaDataSrv();
        if (stringArray == null) {
            classArray = null;
        } else {
            object3 = object.getClass().getClassLoader();
            int n = stringArray.length;
            classArray = new Class[n];
            try {
                int n2 = 0;
                while (n2 < n) {
                    Class clazz = MetaDataSrvIf.Util.findClassForPrim(stringArray[n2]);
                    if (clazz != null) {
                        classArray[n2] = clazz;
                    } else if (object3 != null) {
                        classArray[n2] = ((ClassLoader)object3).loadClass(stringArray[n2]);
                        object2 = classArray[n2].getClassLoader();
                        if (objectArray[n2] != null && object2 != null && !object2.equals(objectArray[n2].getClass().getClassLoader())) {
                            objectArray[n2] = this.transferObject(objectArray[n2], (ClassLoader)object3);
                        }
                    } else {
                        classArray[n2] = this.internal_getClass(stringArray[n2]);
                    }
                    ++n2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InvocationTargetException(classNotFoundException);
            }
        }
        object3 = metaDataSrvIf.findPerform(object.getClass(), string, classArray);
        if (object3 == null) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf:invokePerform: " + string + " not found"));
            }
            throw new NoSuchMethodException(string);
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::invokePerform: Invoking " + string));
        }
        object2 = ((Method)object3).invoke(object, objectArray);
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)"cmf::invokePerform: Send the result");
        }
        return object2;
    }

    public Object newDBObject(String string, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        return this.internal_newDBObject(string, objectName, modificationList);
    }

    public Object newDBObject(String string, ObjectName objectName, ObjectName objectName2, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        return this.internal_newDBObject(string, objectName, objectName2, modificationList);
    }

    public Object newDBObject(String string, String string2, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        return this.internal_newDBObject(string, string2, modificationList);
    }

    public Object newDBObject(String string, String string2, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        return this.internal_newDBObject(string, string2, objectName, modificationList);
    }

    public Object newObj(String string) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        return this.internal_newObj(string);
    }

    public Object newObj(String string, ObjectName objectName) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        return this.internal_newObj(string, objectName);
    }

    public Object newObject(String string, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        return this.internal_newObject(string, objectName, modificationList);
    }

    public Object newObject(String string, ObjectName objectName, ObjectName objectName2, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        return this.internal_newObject(string, objectName, objectName2, modificationList);
    }

    protected Object newObject(String string, ObjectName objectName, boolean bl, ObjectName objectName2, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        if (!objectName.validNameForObject()) {
            throw new InstantiationException("invalid name->" + objectName.toString());
        }
        Class clazz = objectName2 == null ? this.internal_getClass(string) : this.internal_getClass(string, objectName2);
        Object var7_7 = null;
        try {
            var7_7 = clazz.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new IllegalAccessException("No constructor");
        }
        this.internal_initCmfInvoker(var7_7, objectName, bl, modificationList);
        return var7_7;
    }

    public Object newObject(String string, String string2, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        return this.internal_newObject(string, string2, modificationList);
    }

    public Object newObject(String string, String string2, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InstanceAlreadyExistException, InvocationTargetException {
        CheckFrameworkPermission.checkPermission("registerObjects");
        return this.internal_newObject(string, string2, objectName, modificationList);
    }

    public ObjectName newRelation(String string, ObjectName objectName, ObjectName[] objectNameArray, ObjectName objectName2) throws IllegalAccessException, InstantiationException, InstanceAlreadyExistException, ClassNotFoundException, InstanceNotFoundException, InvalidPropertyValueException {
        CheckFrameworkPermission.checkPermission("accessRelationMethods");
        return this.internal_newRelation(string, objectName, objectNameArray, objectName2);
    }

    protected void notifyChange(ObjectName objectName, int n) {
        Vector<ObjectName> vector = new Vector<ObjectName>();
        vector.addElement(objectName);
        this.notifyChange(vector, n);
    }

    protected void notifyChange(Vector vector, int n) {
        FrameworkEvent frameworkEvent = new FrameworkEvent(this, vector, n);
        Enumeration enumeration = this.Listeners.elements();
        while (enumeration.hasMoreElements()) {
            FrameworkListener frameworkListener = (FrameworkListener)enumeration.nextElement();
            frameworkListener.handleFrameworkEvent(frameworkEvent);
        }
    }

    public synchronized void removeFrameworkListener(FrameworkListener frameworkListener) {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)"cmf::removeFrameworkListener: Unregister a listener");
        }
        this.Listeners.removeElement(frameworkListener);
    }

    public void removeListener(Object object, Object object2, String string, Class clazz) throws InvocationTargetException, IllegalAccessException {
        MetaDataSrvIf metaDataSrvIf = this.giveMetaDataSrv();
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::removeListener: " + object2 + " from " + object));
        }
        Class[] classArray = new Class[]{clazz};
        Method method = metaDataSrvIf.findMethod(object.getClass(), "remove" + string, classArray);
        if (method == null) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::removeListener: Can't find remove" + string));
            }
            return;
        }
        Object[] objectArray = new Object[]{object2};
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::removeListener: Call remove" + string));
        }
        method.invoke(object, objectArray);
    }

    public Object retrieveObject(ObjectName objectName) throws InstanceNotFoundException {
        CheckFrameworkPermission.checkPermission("accessObjects");
        return this.internal_retrieveObject(objectName);
    }

    public void sendEvent(EventObject eventObject, ObjectName objectName) throws ServiceNotFoundException {
        Vector vector;
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::sendEvent:: dispatch event from " + objectName));
        }
        ObjectName objectName2 = null;
        objectName2 = new ObjectName("", "com.sun.jaw.reference.agent.services.EventHandlerIfMO");
        Object object = this;
        synchronized (object) {
            vector = this.repository.getObject(objectName2, null);
        }
        object = eventObject;
        ObjectName objectName3 = objectName;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            NamedObject namedObject = (NamedObject)vector.elementAt(n2);
            final EventHandlerIf eventHandlerIf = (EventHandlerIf)namedObject.getObject();
            Runnable runnable = new Runnable((EventObject)object, objectName3){
                private final /* synthetic */ ObjectName val$theName;
                private final /* synthetic */ EventObject val$theEvent;
                {
                    this.val$theEvent = eventObject;
                    this.val$theName = objectName;
                }

                public void run() {
                    block4: {
                        try {
                            if (Debug.isLevelSet((int)1)) {
                                Debug.printFormatted((Object)("cmf::sendEvent (" + this + "):: Starts sending event"));
                            }
                            eventHandlerIf.handleEvent(this.val$theEvent, this.val$theName);
                            if (Debug.isLevelSet((int)1)) {
                                Debug.printFormatted((Object)("cmf::sendEvent (" + this + "):: Finished sending event"));
                            }
                        }
                        catch (Exception exception) {
                            if (!Debug.isLevelSet((int)1)) break block4;
                            Debug.printFormatted((Object)("cmf::sendEvent (" + this + "):: Could not send event"));
                        }
                    }
                }
            };
            this.internal_getThreadAllocatorSrvIf().obtainThread((Object)this.frameworkObjetName, runnable, "Event Dispatching").start();
            ++n2;
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        CheckFrameworkPermission.checkPermission("accessCoreMethods");
        this.internal_setClassLoader(classLoader);
    }

    public void setFilterSrvIf(FilterSrvIf filterSrvIf) {
        CheckFrameworkPermission.checkPermission("accessCoreMethods");
        this.internal_setFilterSrvIf(filterSrvIf);
    }

    public Object setIndexedValue(ObjectName objectName, String string, Object object, String string2, int n) throws IllegalAccessException, InvocationTargetException, PropertyNotFoundException, InstanceNotFoundException, InvalidPropertyValueException, InstantiationException, ClassNotFoundException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::setIndexedValue: Object= " + objectName + ", property=" + string + "(" + n + ")"));
        }
        Object object2 = this.internal_retrieveObject(objectName);
        if (string2 != null && string2.length() != 0) {
            return this.invokeOperator(string2, object2, objectName, string, object, n);
        }
        Object object3 = this.setIndexedValue(object2, string, object, n);
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)"cmf::setValue: Updating the repository\n");
        }
        Framework framework = this;
        synchronized (framework) {
            this.repository.update(object2, objectName);
        }
        return object3;
    }

    public Object setIndexedValue(Object object, String string, Object object2, int n) throws IllegalAccessException, InvocationTargetException, ServiceNotFoundException, PropertyNotFoundException, InvalidPropertyValueException {
        Object[] objectArray;
        MetaDataSrvIf metaDataSrvIf = this.giveMetaDataSrv();
        object2 = this.checkUpdateContext(object, object2);
        Method method = metaDataSrvIf.findIndexedSetter(object.getClass(), string, object2.getClass());
        if (method == null && (objectArray = MetaDataSrvIf.Util.findPrimForClass(object2)) != null) {
            method = metaDataSrvIf.findIndexedSetter(object.getClass(), string, (Class)objectArray);
        }
        if (method == null) {
            method = metaDataSrvIf.findSetter(object.getClass(), string);
            if (method == null) {
                throw new PropertyNotFoundException(String.valueOf(string) + " not accessible");
            }
            throw new InvalidPropertyValueException("property= " + string + " value= " + object2);
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::setValue: Invoking the set method for " + string));
        }
        objectArray = new Object[]{new Integer(n), object2};
        Object object3 = method.invoke(object, objectArray);
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::setIndexedValue: " + string + "(" + n + ")= " + object3));
        }
        return object3;
    }

    public void setMetaDataSrvIf(MetaDataSrvIf metaDataSrvIf) {
        CheckFrameworkPermission.checkPermission("accessCoreMethods");
        this.internal_setMetaDataSrvIf(metaDataSrvIf);
    }

    public void setRelationSrvIf(RelationSrvIf relationSrvIf) {
        CheckFrameworkPermission.checkPermission("accessCoreMethods");
        this.internal_setRelationSrvIf(relationSrvIf);
    }

    public void setThreadAllocatorSrvIf(ThreadAllocatorSrvIf threadAllocatorSrvIf) {
        CheckFrameworkPermission.checkPermission("accessCoreMethods");
        this.internal_setThreadAllocatorSrvIf(threadAllocatorSrvIf);
    }

    public Object setValue(ObjectName objectName, String string, Object object, String string2) throws InvocationTargetException, InstanceNotFoundException, PropertyNotFoundException, InvalidPropertyValueException, InstantiationException, ClassNotFoundException, IllegalAccessException {
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::setValue: Object= " + objectName + ", property=" + string));
        }
        Object object2 = this.internal_retrieveObject(objectName);
        if (string2 != null && string2.length() != 0) {
            return this.invokeOperator(string2, object2, objectName, string, object, -1);
        }
        Object object3 = this.setValue(object2, string, object);
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)"cmf::setValue: Updating the repository\n");
        }
        Framework framework = this;
        synchronized (framework) {
            this.repository.update(object2, objectName);
        }
        return object3;
    }

    public Object setValue(Object object, String string, Object object2) throws InvocationTargetException, PropertyNotFoundException, InvalidPropertyValueException {
        Object[] objectArray;
        MetaDataSrvIf metaDataSrvIf = this.giveMetaDataSrv();
        object2 = this.checkUpdateContext(object, object2);
        Method method = metaDataSrvIf.findSetter(object.getClass(), string, object2.getClass());
        if (method == null && (objectArray = MetaDataSrvIf.Util.findPrimForClass(object2)) != null) {
            method = metaDataSrvIf.findSetter(object.getClass(), string, (Class)objectArray);
        }
        if (method == null) {
            method = metaDataSrvIf.findSetter(object.getClass(), string);
            if (method == null) {
                throw new PropertyNotFoundException(String.valueOf(string) + " not accessible");
            }
            throw new InvalidPropertyValueException("property= " + string + " value= " + object2);
        }
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::setValue: Invoking the set method for " + string));
        }
        objectArray = new Object[]{object2};
        Object object3 = null;
        try {
            object3 = method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvocationTargetException(illegalAccessException);
        }
        return object3;
    }

    public PropertyList setValues(ObjectName objectName, ModificationList modificationList) throws InstanceNotFoundException {
        PropertyList propertyList = new PropertyList();
        if (Debug.isLevelSet((int)1)) {
            Debug.printFormatted((Object)("cmf::setValues: Object= " + objectName));
        }
        if (modificationList == null || modificationList.isEmpty()) {
            return propertyList;
        }
        return this.setValues(objectName, modificationList, this.internal_retrieveObject(objectName));
    }

    public PropertyList setValues(ObjectName objectName, ModificationList modificationList, Object object) throws InstanceNotFoundException {
        PropertyList propertyList = new PropertyList();
        if (modificationList == null || modificationList.isEmpty()) {
            return propertyList;
        }
        Enumeration enumeration = modificationList.elements();
        while (enumeration.hasMoreElements()) {
            Modification modification = (Modification)enumeration.nextElement();
            String string = modification.getProperty();
            Object object2 = modification.getValue();
            String string2 = modification.getOperator();
            int n = modification.getPosition();
            try {
                Object object3 = null;
                if (string2 != null && string2.length() != 0) {
                    object3 = this.invokeOperator(string2, object, objectName, string, object2, n);
                } else {
                    object3 = n == -1 ? this.setValue(object, string, object2) : this.setIndexedValue(object, string, object2, n);
                    if (Debug.isLevelSet((int)1)) {
                        Debug.printFormatted((Object)"cmf::setValues: Updating the repository\n");
                    }
                    Framework framework = this;
                    synchronized (framework) {
                        this.repository.update(object, objectName);
                    }
                }
                propertyList.addElement(new Property(string, object3, n));
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
            }
        }
        return propertyList;
    }

    private Object transferObject(Object object, ClassLoader classLoader) {
        Closeable closeable;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            closeable = new ObjectOutputStream(byteArrayOutputStream);
            closeable.writeObject(object);
            closeable.flush();
        }
        catch (Exception exception) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::transferObject: Fails to serialize " + object));
            }
            return object;
        }
        try {
            closeable = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader((InputStream)closeable, classLoader);
            return objectInputStreamWithLoader.readObject();
        }
        catch (Exception exception) {
            if (Debug.isLevelSet((int)1)) {
                Debug.printFormatted((Object)("cmf::transferObject:Fails to deserialize " + object));
            }
            return object;
        }
    }
}

