/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.agent;

import com.sun.jaw.snmp.common.SnmpOid;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpIndex
implements Serializable {
    private Vector oids = new Vector();
    private int size = 0;

    public SnmpIndex(SnmpOid snmpOid) {
        this.oids.addElement(snmpOid);
        this.size = 1;
    }

    public SnmpIndex(SnmpOid[] snmpOidArray) {
        this.size = snmpOidArray.length;
        int n = 0;
        while (n < this.size) {
            this.oids.addElement(snmpOidArray[n]);
            ++n;
        }
    }

    public int compareTo(SnmpIndex snmpIndex) {
        int n = snmpIndex.getNbComponents();
        Vector vector = snmpIndex.getComponents();
        int n2 = 0;
        while (n2 < this.size) {
            SnmpOid snmpOid;
            if (n2 > n) {
                return 1;
            }
            SnmpOid snmpOid2 = (SnmpOid)this.oids.elementAt(n2);
            int n3 = snmpOid2.compareTo(snmpOid = (SnmpOid)vector.elementAt(n2));
            if (n3 != 0) {
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    public boolean equals(SnmpIndex snmpIndex) {
        if (this.size != snmpIndex.getNbComponents()) {
            return false;
        }
        Vector vector = snmpIndex.getComponents();
        int n = 0;
        while (n < this.size) {
            SnmpOid snmpOid;
            SnmpOid snmpOid2 = (SnmpOid)this.oids.elementAt(n);
            if (!snmpOid2.equals((Object)(snmpOid = (SnmpOid)vector.elementAt(n)))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Vector getComponents() {
        return this.oids;
    }

    public int getNbComponents() {
        return this.size;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.oids.elements();
        while (enumeration.hasMoreElements()) {
            SnmpOid snmpOid = (SnmpOid)enumeration.nextElement();
            stringBuffer.append("//" + snmpOid.toString());
        }
        return stringBuffer.toString();
    }
}

