/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.agent;

import com.sun.jaw.reference.agent.cmf.Framework;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.NamedObject;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.common.ServiceNotFoundException;
import com.sun.jaw.snmp.agent.SnmpMibHandlerSrvIf;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.common.SnmpVarBind;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class SnmpMibAgent
implements Serializable {
    protected String mibName;
    protected Framework cmf;
    private transient SnmpMibHandlerSrvIf adaptor;
    private String adaptorName = "";

    public abstract void check(Vector var1) throws SnmpStatusException;

    private void concatVector(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            vector.addElement(new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value));
        }
    }

    public abstract void get(Vector var1, int var2) throws SnmpStatusException;

    public Boolean getBindingState() {
        if (this.adaptor == null) {
            return new Boolean(false);
        }
        return new Boolean(true);
    }

    public abstract void getBulk(Vector var1, int var2, int var3, int var4) throws SnmpStatusException;

    public void getBulkWithGetNext(Vector vector, int n, int n2, int n3) throws SnmpStatusException {
        int n4 = vector.size();
        int n5 = Math.max(Math.min(n, n4), 0);
        int n6 = Math.max(n2, 0);
        int n7 = n4 - n5;
        boolean bl = false;
        boolean bl2 = false;
        if (n4 != 0) {
            this.getNext(vector, 1);
            Vector vector2 = this.splitFrom(vector, n5);
            int n8 = 2;
            while (n8 <= n6) {
                this.getNext(vector2, 1);
                this.concatVector(vector, vector2);
                ++n8;
            }
        }
    }

    public Framework getFramework() {
        return this.cmf;
    }

    public String getMibName() {
        return this.mibName;
    }

    public abstract void getNext(Vector var1, int var2) throws SnmpStatusException;

    public abstract long[] getRootOid();

    public SnmpMibHandlerSrvIf getSnmpAdaptor() {
        return this.adaptor;
    }

    public String getSnmpAdaptorName() {
        return this.adaptorName;
    }

    public abstract void init() throws IllegalAccessException;

    public abstract void initCmf(Framework var1, ObjectName var2) throws IllegalAccessException, ServiceNotFoundException, InstanceAlreadyExistException;

    public abstract void set(Vector var1, int var2) throws SnmpStatusException;

    public void setSnmpAdaptor(SnmpMibHandlerSrvIf snmpMibHandlerSrvIf) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        this.adaptor = snmpMibHandlerSrvIf;
        if (this.adaptor != null) {
            this.adaptor.addMib(this);
        }
    }

    public void setSnmpAdaptorName(String string) throws InstanceNotFoundException, IllegalAccessException, ServiceNotFoundException {
        ObjectName objectName = new ObjectName(string);
        if (this.cmf == null) {
            throw new ServiceNotFoundException(objectName.toString());
        }
        Vector vector = this.cmf.getObject(objectName, null);
        if (vector.size() != 1) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        try {
            Object object = ((NamedObject)vector.firstElement()).getObject();
            this.setSnmpAdaptor((SnmpMibHandlerSrvIf)object);
            this.adaptorName = objectName.toString();
        }
        catch (ClassCastException classCastException) {
            throw new ServiceNotFoundException(objectName.toString());
        }
    }

    private Vector splitFrom(Vector vector, int n) {
        int n2 = vector.size();
        Vector<SnmpVarBind> vector2 = new Vector<SnmpVarBind>(n2 - n);
        int n3 = n;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            if (n3 <= 0) {
                vector2.addElement(new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value));
            }
            --n3;
        }
        return vector2;
    }
}

