/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.agent;

import com.sun.jaw.snmp.agent.SnmpIndex;
import com.sun.jaw.snmp.agent.SnmpMib;
import com.sun.jaw.snmp.agent.SnmpTableEntryEvent;
import com.sun.jaw.snmp.agent.SnmpTableEntryListener;
import com.sun.jaw.snmp.agent.internal.SnmpMibNode;
import com.sun.jaw.snmp.common.SnmpOid;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.common.SnmpValue;
import com.sun.jaw.snmp.common.SnmpVarBind;
import java.io.Serializable;
import java.util.Vector;

public abstract class SnmpMibTable
extends SnmpMibNode
implements Serializable {
    private int size = 0;
    private Vector indexes = new Vector();
    private Vector entries = new Vector();
    private Vector listeners = new Vector();
    protected int nodeId = 1;
    protected SnmpMib theMib;

    public SnmpMibTable(SnmpMib snmpMib) {
        this.theMib = snmpMib;
    }

    protected synchronized void addEntry(SnmpIndex snmpIndex, Object object) throws SnmpStatusException {
        if (this.size == 0) {
            this.indexes.addElement(snmpIndex);
            this.entries.addElement(object);
            ++this.size;
            this.notifyCreation(object);
            return;
        }
        int n = 0;
        n = this.getInsertionPoint(snmpIndex);
        if (n == this.size) {
            this.indexes.addElement(snmpIndex);
            this.entries.addElement(object);
            ++this.size;
        } else {
            try {
                this.indexes.insertElementAt(snmpIndex, n);
                this.entries.insertElementAt(object, n);
                ++this.size;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        this.notifyCreation(object);
    }

    public void addSnmpTableEntryListener(SnmpTableEntryListener snmpTableEntryListener) {
        this.listeners.addElement(snmpTableEntryListener);
    }

    protected abstract SnmpOid buildOidFromIndex(SnmpIndex var1) throws SnmpStatusException;

    protected abstract SnmpIndex buildSnmpIndex(long[] var1, int var2) throws SnmpStatusException;

    public void check(SnmpValue snmpValue, long[] lArray, int n) throws SnmpStatusException {
        this.validateOid(lArray, n);
        SnmpIndex snmpIndex = this.buildSnmpIndex(lArray, n + 2);
        Object object = this.getEntry(snmpIndex);
        this.checkValueOfEntry(snmpValue, object, lArray[n + 1]);
    }

    protected abstract void checkValueOfEntry(SnmpValue var1, Object var2, long var3) throws SnmpStatusException;

    private int findObject(SnmpIndex snmpIndex) {
        int n = 0;
        int n2 = this.size - 1;
        int n3 = n + (n2 - n) / 2;
        while (n <= n2) {
            SnmpIndex snmpIndex2 = (SnmpIndex)this.indexes.elementAt(n3);
            int n4 = snmpIndex.compareTo(snmpIndex2);
            if (n4 == 0) {
                return n3;
            }
            if (snmpIndex.equals(snmpIndex2)) {
                return n3;
            }
            if (n4 > 0) {
                n = n3 + 1;
            } else {
                n2 = n3 - 1;
            }
            n3 = n + (n2 - n) / 2;
        }
        return -1;
    }

    public SnmpValue get(long[] lArray, int n) throws SnmpStatusException {
        this.validateOid(lArray, n);
        SnmpIndex snmpIndex = this.buildSnmpIndex(lArray, n + 2);
        return this.getValueOfEntry(snmpIndex, lArray[n + 1]);
    }

    protected Object[] getBasicEntries() {
        Object[] objectArray = new Object[this.size];
        this.entries.copyInto(objectArray);
        return objectArray;
    }

    protected synchronized Object getEntry(SnmpIndex snmpIndex) throws SnmpStatusException {
        int n = this.findObject(snmpIndex);
        if (n == -1) {
            throw new SnmpStatusException(224);
        }
        return this.entries.elementAt(n);
    }

    private int getInsertionPoint(SnmpIndex snmpIndex) throws SnmpStatusException {
        int n = 0;
        int n2 = this.size - 1;
        int n3 = n + (n2 - n) / 2;
        while (n <= n2) {
            SnmpIndex snmpIndex2 = (SnmpIndex)this.indexes.elementAt(n3);
            int n4 = snmpIndex.compareTo(snmpIndex2);
            if (n4 == 0) {
                throw new SnmpStatusException(n3);
            }
            if (n4 > 0) {
                n = n3 + 1;
            } else {
                n2 = n3 - 1;
            }
            n3 = n + (n2 - n) / 2;
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    public SnmpVarBind getNext(long[] var1_1, int var2_2) throws SnmpStatusException {
        block10: {
            var3_3 = var1_1.length;
            if (var3_3 <= var2_2) {
                var1_1 = new long[1];
                var2_2 = 0;
                var1_1[0] = this.nodeId;
                return this.getNext(var1_1, 0);
            }
            if (var1_1[var2_2] != (long)this.nodeId) {
                throw new SnmpStatusException(2);
            }
            var4_4 = -1L;
            var4_4 = var2_2 + 1 < var3_3 ? var1_1[var2_2 + 1] : -1L;
            var6_5 = null;
            if (var2_2 > var3_3 - 2) break block10;
            if (var2_2 == var3_3 - 2) {
                var6_5 = this.getNextIndex(null);
                var7_6 = this.getValueOfEntry(var6_5, var4_4);
                var8_8 = this.buildOidFromIndex(var6_5);
                var8_8.insert(var4_4);
                var8_8.insert(this.nodeId);
                return new SnmpVarBind(var8_8, var7_6);
            }
            var6_5 = this.buildSnmpIndex(var1_1, var2_2 + 2);
            try {
                var6_5 = this.getNextIndex(var6_5);
                if (true) ** GOTO lbl41
            }
            catch (SnmpStatusException v0) {
                var6_5 = this.getNextIndex(null);
                return this.getNextVarEntry(var6_5, var4_4);
            }
            do {
                try {
                    var7_7 = this.getValueOfEntry(var6_5, var4_4);
                    var8_9 = this.buildOidFromIndex(var6_5);
                    var8_9.insert(var4_4);
                    var8_9.insert(this.nodeId);
                    return new SnmpVarBind(var8_9, var7_7);
                }
                catch (SnmpStatusException v1) {
                    try {
                        var6_5 = this.getNextIndex(var6_5);
                    }
                    catch (SnmpStatusException v2) {
                        var6_5 = this.getNextIndex(null);
                        return this.getNextVarEntry(var6_5, var4_4);
                    }
                }
lbl41:
                // 2 sources

            } while (var6_5 != null);
        }
        var6_5 = this.getNextIndex(null);
        return this.getNextVarEntry(var6_5, var4_4);
    }

    protected SnmpIndex getNextIndex(SnmpIndex snmpIndex) throws SnmpStatusException {
        if (this.size == 0) {
            throw new SnmpStatusException(2);
        }
        if (snmpIndex == null) {
            return (SnmpIndex)this.indexes.firstElement();
        }
        SnmpIndex snmpIndex2 = (SnmpIndex)this.indexes.lastElement();
        if (snmpIndex2.equals(snmpIndex)) {
            throw new SnmpStatusException(2);
        }
        int n = this.findObject(snmpIndex);
        if (n == -1) {
            n = this.getInsertionPoint(snmpIndex);
            try {
                snmpIndex2 = (SnmpIndex)this.indexes.elementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new SnmpStatusException(2);
            }
        }
        if (n == this.size) {
            throw new SnmpStatusException(2);
        }
        try {
            snmpIndex2 = (SnmpIndex)this.indexes.elementAt(n + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
        return snmpIndex2;
    }

    protected abstract SnmpVarBind getNextVarEntry(SnmpIndex var1, long var2) throws SnmpStatusException;

    protected int getSize() {
        return this.size;
    }

    protected abstract SnmpValue getValueOfEntry(SnmpIndex var1, long var2) throws SnmpStatusException;

    private void notifyCreation(Object object) {
        Vector vector = (Vector)this.listeners.clone();
        SnmpTableEntryEvent snmpTableEntryEvent = new SnmpTableEntryEvent(this, object);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((SnmpTableEntryListener)vector.elementAt(n2)).entryAdded(snmpTableEntryEvent);
            ++n2;
        }
    }

    private void notifyDeletion(Object object) {
        Vector vector = (Vector)this.listeners.clone();
        SnmpTableEntryEvent snmpTableEntryEvent = new SnmpTableEntryEvent(this, object);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((SnmpTableEntryListener)vector.elementAt(n2)).entryRemoved(snmpTableEntryEvent);
            ++n2;
        }
    }

    protected synchronized void removeEntry(Object object) {
        int n = this.entries.indexOf(object);
        if (n == -1) {
            return;
        }
        this.entries.removeElementAt(n);
        this.indexes.removeElementAt(n);
        --this.size;
        this.notifyDeletion(object);
    }

    public void removeSnmpTableEntryListener(SnmpTableEntryListener snmpTableEntryListener) {
        this.listeners.removeElement(snmpTableEntryListener);
    }

    public SnmpValue set(SnmpValue snmpValue, long[] lArray, int n) throws SnmpStatusException {
        this.validateOid(lArray, n);
        SnmpIndex snmpIndex = this.buildSnmpIndex(lArray, n + 2);
        return this.setValueOfEntry(snmpValue, snmpIndex, lArray[n + 1]);
    }

    protected abstract SnmpValue setValueOfEntry(SnmpValue var1, SnmpIndex var2, long var3) throws SnmpStatusException;

    protected void validateOid(long[] lArray, int n) throws SnmpStatusException {
        int n2 = lArray.length;
        if (n + 2 >= n2) {
            throw new SnmpStatusException(6);
        }
        if (lArray[n] != (long)this.nodeId) {
            throw new SnmpStatusException(6);
        }
    }
}

