/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.snmp.agent.internal;

import com.sun.jaw.snmp.agent.internal.SnmpMibNode;
import com.sun.jaw.snmp.common.SnmpOid;
import com.sun.jaw.snmp.common.SnmpStatusException;
import com.sun.jaw.snmp.common.SnmpValue;
import com.sun.jaw.snmp.common.SnmpVarBind;
import java.io.Serializable;
import java.util.Vector;

public final class SnmpMibOid
extends SnmpMibNode
implements Serializable {
    private NonSyncVector children = new NonSyncVector(1);
    private int nbChildren = 0;

    public void check(SnmpValue snmpValue, long[] lArray, int n) throws SnmpStatusException {
        if (n >= lArray.length) {
            throw SnmpMibNode.noSuchNameException;
        }
        SnmpMibNode snmpMibNode = this.getChild(lArray[n]);
        snmpMibNode.check(snmpValue, lArray, n + 1);
    }

    public SnmpValue get(long[] lArray, int n) throws SnmpStatusException {
        if (n >= lArray.length) {
            throw SnmpMibNode.noSuchNameException;
        }
        SnmpMibNode snmpMibNode = this.getChild(lArray[n]);
        return snmpMibNode.get(lArray, n + 1);
    }

    private SnmpMibNode getChild(long l) throws SnmpStatusException {
        int n = this.getInsertAt(l);
        if (n == this.nbChildren) {
            throw SnmpMibNode.noSuchNameException;
        }
        if (this.varList[n] != (int)l) {
            throw SnmpMibNode.noSuchNameException;
        }
        try {
            return (SnmpMibNode)this.children.elementAtNonSync(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw SnmpMibNode.noSuchNameException;
        }
    }

    private int getInsertAt(long l) {
        int n = 0;
        int n2 = (int)l;
        if (this.varList == null) {
            return -1;
        }
        int n3 = this.varList.length - 1;
        int n4 = 0;
        int n5 = n + (n3 - n) / 2;
        while (n <= n3) {
            n4 = this.varList[n5];
            if (n2 == n4) {
                return n5;
            }
            if (n4 < n2) {
                n = n5 + 1;
            } else {
                n3 = n5 - 1;
            }
            n5 = n + (n3 - n) / 2;
        }
        return n5;
    }

    public SnmpVarBind getNext(long[] lArray, int n) throws SnmpStatusException {
        if (n >= lArray.length) {
            long[] lArray2 = new long[]{this.varList[0]};
            return this.getNext(lArray2, 0);
        }
        long[] lArray3 = new long[1];
        long l = lArray[n];
        while (true) {
            try {
                SnmpMibNode snmpMibNode = this.getChild(l);
                SnmpVarBind snmpVarBind = snmpMibNode.getNext(lArray, n + 1);
                snmpVarBind.insertInOid((int)l);
                return snmpVarBind;
            }
            catch (SnmpStatusException snmpStatusException) {
                lArray3[0] = l = (long)SnmpMibNode.getNextIdentifier(this.varList, l);
                n = lArray3.length;
                lArray = lArray3;
                continue;
            }
            break;
        }
    }

    public void getRootOid(Vector vector) {
        if (this.nbChildren != 1) {
            return;
        }
        vector.addElement(new Integer(this.varList[0]));
        ((SnmpMibNode)this.children.firstElement()).getRootOid(vector);
    }

    public void registerNode(String string, SnmpMibNode snmpMibNode) throws IllegalAccessException {
        SnmpOid snmpOid = new SnmpOid(string);
        this.registerNode(snmpOid.longValue(), 0, snmpMibNode);
    }

    protected void registerNode(long[] lArray, int n, SnmpMibNode snmpMibNode) throws IllegalAccessException {
        if (n >= lArray.length) {
            throw new IllegalAccessException();
        }
        long l = lArray[n];
        int n2 = this.retrieveIndex(l);
        if (n2 == this.nbChildren) {
            ++this.nbChildren;
            this.varList = new int[this.nbChildren];
            this.varList[0] = (int)l;
            n2 = 0;
            if (n + 1 == lArray.length) {
                this.children.insertElementAt(snmpMibNode, n2);
                return;
            }
            SnmpMibOid snmpMibOid = new SnmpMibOid();
            this.children.insertElementAt(snmpMibOid, n2);
            snmpMibOid.registerNode(lArray, n + 1, snmpMibNode);
            return;
        }
        if (n2 == -1) {
            int[] nArray = new int[this.nbChildren + 1];
            nArray[this.nbChildren] = (int)l;
            System.arraycopy(this.varList, 0, nArray, 0, this.nbChildren);
            this.varList = nArray;
            ++this.nbChildren;
            SnmpMibNode.sort(this.varList);
            int n3 = this.retrieveIndex(l);
            this.varList[n3] = (int)l;
            if (n + 1 == lArray.length) {
                this.children.insertElementAt(snmpMibNode, n3);
                return;
            }
            SnmpMibOid snmpMibOid = new SnmpMibOid();
            this.children.insertElementAt(snmpMibOid, n3);
            snmpMibOid.registerNode(lArray, n + 1, snmpMibNode);
            return;
        }
        SnmpMibNode snmpMibNode2 = (SnmpMibNode)this.children.elementAt(n2);
        if (n + 1 == lArray.length) {
            return;
        }
        ((SnmpMibOid)snmpMibNode2).registerNode(lArray, n + 1, snmpMibNode);
    }

    private int retrieveIndex(long l) {
        int n = 0;
        int n2 = (int)l;
        if (this.varList == null) {
            return this.nbChildren;
        }
        int n3 = this.varList.length - 1;
        int n4 = n + (n3 - n) / 2;
        int n5 = 0;
        while (n <= n3) {
            n5 = this.varList[n4];
            if (n2 == n5) {
                return n4;
            }
            if (n5 < n2) {
                n = n4 + 1;
            } else {
                n3 = n4 - 1;
            }
            n4 = n + (n3 - n) / 2;
        }
        return -1;
    }

    public SnmpValue set(SnmpValue snmpValue, long[] lArray, int n) throws SnmpStatusException {
        if (n >= lArray.length) {
            throw SnmpMibNode.noSuchNameException;
        }
        SnmpMibNode snmpMibNode = this.getChild(lArray[n]);
        return snmpMibNode.set(snmpValue, lArray, n + 1);
    }

    class NonSyncVector
    extends Vector {
        public NonSyncVector(int n) {
            super(n);
        }

        final void addNonSyncElement(Object object) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = object;
        }

        final Object elementAtNonSync(int n) {
            return this.elementData[n];
        }
    }
}

