/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.comm.internal;

import com.sun.jaw.impl.adaptor.comm.AdaptorClient;
import com.sun.jaw.impl.adaptor.comm.AdaptorSocket;
import com.sun.jaw.reference.client.mo.ManagedObject;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.ObjectInputStreamWithLoader;
import com.sun.jaw.reference.common.ObjectName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class EvtRcvClientImpl
extends Thread {
    private final String CRLF = "\r\n";
    private static final String sccs_id = "@(#)EvtRcvClientImpl.java 3.3 03/26/99 SMI";
    private transient AdaptorClient myClient = null;
    private String serviceName;
    private int localPort = 0;
    private String localHost = "localhost";
    private transient AdaptorSocket evtRcvSock;
    private transient boolean stopRequested = false;
    private transient boolean running = false;

    public EvtRcvClientImpl(AdaptorClient adaptorClient, AdaptorSocket adaptorSocket, InetAddress inetAddress) throws CommunicationException {
        this.myClient = adaptorClient;
        this.evtRcvSock = adaptorSocket;
        try {
            String string = new Long(new Date().getTime()).toString();
            String string2 = new String("EvtRcvClient." + string);
            this.evtRcvSock.doBind();
            this.localPort = this.evtRcvSock.getLocalPort();
            this.localHost = inetAddress.getHostName();
            this.serviceName = new String("http://" + inetAddress.getHostAddress() + ":" + this.evtRcvSock.getLocalPort() + "/" + string2);
            Debug.print((int)2, (Object)("EvtRcvClientImpl:register " + this.serviceName));
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            throw new CommunicationException("Fails to register " + this.serviceName);
        }
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void handleEvent(EventObject eventObject, ObjectName objectName, String string, ObjectName objectName2) {
        Object object;
        Debug.print((int)2, (Object)"EvtRcvClientImpl.handleEvent:start event dispatching");
        if (eventObject == null) {
            return;
        }
        ManagedObject managedObject = this.myClient.getObjectFromCache(objectName);
        EventListener eventListener = this.myClient.giveListener(objectName, objectName2);
        if (eventListener == null) {
            Debug.print((int)2, (Object)("EvtRcvClientImpl.handleEvent: no listener on " + objectName.toString()));
            return;
        }
        ClassLoader classLoader = eventListener.getClass().getClassLoader();
        EventObject eventObject2 = this.translateEvent(eventObject, classLoader, managedObject);
        if (eventObject2 == null) {
            Debug.print((int)2, (Object)("EvtRcvClientImpl.handleEvent: Fails to translate  " + eventObject));
            return;
        }
        Class<?> clazz = eventListener.getClass();
        Class[] classArray = new Class[]{eventObject2.getClass()};
        if (classLoader != null) {
            object = eventObject2.getClass().getName();
            try {
                classArray[0] = classLoader.loadClass((String)object);
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
                Debug.print((int)2, (Object)("EvtRcvClientImpl::handleEvent: Can not find event class " + (String)object));
                Debug.print((int)2, (Object)("\tThe loader is: " + classLoader));
                return;
            }
        }
        try {
            object = clazz.getDeclaredMethod(string, classArray);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            Debug.print((int)2, (Object)("EvtRcvClientImpl.handleEvent: can not find  " + string + " in class " + clazz));
            return;
        }
        Debug.print((int)2, (Object)"EvtRcvClientImpl.handleEvent: about to invoke listener");
        Object[] objectArray = new Object[]{eventObject2};
        try {
            ((Method)object).invoke((Object)eventListener, objectArray);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            Debug.print((int)2, (Object)("EvtRcvClientImpl.handleEvent: fails when invoking  " + string));
            return;
        }
    }

    private String httpGetMimeValue(String string, String string2) {
        String string3;
        if (string2 == null || string == null) {
            return null;
        }
        String string4 = string.toLowerCase();
        int n = string4.indexOf(string3 = "\r\n" + string2.toLowerCase());
        if (n < 0) {
            return null;
        }
        String string5 = string.substring(n);
        n = string5.indexOf(58);
        string5 = string5.substring(n + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string5, "\r\n");
        try {
            if (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        string5 = string5.substring(1);
        return string5;
    }

    private void httpReplyError(String string, String string2) {
    }

    private int httpRequestType(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return -1;
        }
        String string = stringBuffer.toString();
        if (string.startsWith("GET")) {
            return 1;
        }
        if (string.startsWith("POST")) {
            return 2;
        }
        return -1;
    }

    public void run() {
        while (!this.stopRequested) {
            InputStream inputStream = null;
            try {
                inputStream = this.evtRcvSock.doReceive();
            }
            catch (Throwable throwable) {
                Debug.print((int)2, (Object)"comm.EvtRcvClientImpl::run: doReceive was interrupted");
                break;
            }
            StringBuffer stringBuffer = null;
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            int n2 = -2;
            byte[] byArray = null;
            boolean bl3 = false;
            try {
                while (!bl2 && !this.stopRequested) {
                    Integer n3;
                    String string;
                    String string2;
                    char c;
                    n2 = inputStream.read();
                    this.running = true;
                    if (n2 < 0) {
                        Debug.print((int)2, (Object)"comm.EvtRcvClientImpl::run: End of read, closing connection");
                        bl2 = true;
                    }
                    if (n == 0) {
                        stringBuffer = new StringBuffer();
                        ++n;
                    }
                    if (n2 == 10 && (c = stringBuffer.charAt(stringBuffer.length() - 2)) == '\n') {
                        string2 = null;
                        string = stringBuffer.toString();
                        string2 = this.httpGetMimeValue(string, "Content-Length: ");
                        if (string2 != null) {
                            Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: Content-Length = [" + string2.toString() + "]"));
                            try {
                                n3 = new Integer(string2.toString());
                                if (n3 != null) {
                                    int n4 = n3;
                                    int n5 = 0;
                                    Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: Reading " + n4 + " bytes for Entity-body"));
                                    byArray = new byte[n4];
                                    while (n5 < n4) {
                                        int n6 = inputStream.read(byArray, n5, n4 - n5);
                                        if (n6 < 0) {
                                            Debug.print((int)2, (Object)"comm.EvtRcvClientImpl::run: EOT detected before  reading the number of bytes specified by Content-Length");
                                            break;
                                        }
                                        n5 += n6;
                                    }
                                    Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: Content to read " + n4 + " bytes, effectively read " + n5 + " bytes."));
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                Debug.print((int)2, (Object)("NumberFormatException " + numberFormatException));
                                Debug.printException((Exception)numberFormatException);
                            }
                        }
                        if ((string2 = this.httpGetMimeValue(string, "Connection: ")) == null) {
                            Debug.print((int)2, (Object)"comm.EvtRcvClientImpl::run: Connection: NOT FOUND");
                            bl3 = false;
                        } else {
                            Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: Found [" + string2 + "] for Connection"));
                            bl3 = string2.equals("Keep-Alive");
                        }
                        Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: Keep-Alive is " + (bl3 ? "true" : "false")));
                        bl = true;
                    }
                    stringBuffer.append((char)n2);
                    if (bl) {
                        n = 0;
                        bl = false;
                        Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: Process HTTP Request:\n\n---\n" + stringBuffer.toString() + "---\n"));
                        String string3 = stringBuffer.toString();
                        string2 = new String();
                        switch (this.httpRequestType(stringBuffer)) {
                            case 2: {
                                string2 = string3.substring(5, string3.indexOf(32, 6));
                                Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: Posting [" + string2 + "]"));
                                if (!string2.startsWith("/Request/")) break;
                                string3 = string2.substring(9);
                                string = null;
                                n3 = null;
                                ObjectName objectName = null;
                                Object var14_19 = null;
                                EventObject eventObject = null;
                                String string4 = null;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                ByteArrayInputStream byteArrayInputStream = null;
                                ObjectInputStream objectInputStream = null;
                                int n7 = string3.indexOf(63);
                                if (n7 < 0) {
                                    string = string3;
                                    bl4 = true;
                                } else {
                                    string = string3.substring(0, n7);
                                    string3 = string3.substring(n7 + 1);
                                    if (byArray == null) {
                                        this.httpReplyError(string2, "400 Bad Request");
                                        bl2 = true;
                                        break;
                                    }
                                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                                    objectInputStream = new ObjectInputStream(byteArrayInputStream);
                                }
                                Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: Start parsing: req = [" + string3 + "]"));
                                int n8 = 0;
                                while (!bl4) {
                                    String string5;
                                    n7 = string3.indexOf(38);
                                    if (n7 < 0) {
                                        string5 = string3;
                                        bl4 = true;
                                    } else {
                                        string5 = string3.substring(0, n7);
                                        string3 = string3.substring(n7 + 1);
                                    }
                                    Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: Iteration " + n8 + " typeName = [" + string5 + "] req = [" + string3 + "]"));
                                    ++n8;
                                    try {
                                        String string6 = (String)objectInputStream.readObject();
                                        Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: typeIn = [" + string6 + "]"));
                                        if (!string5.equals(string6)) {
                                            Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: " + string6 + " expected instead of " + string5));
                                            bl5 = true;
                                            break;
                                        }
                                        if (string5.equals("ObjectName")) {
                                            n3 = (ObjectName)objectInputStream.readObject();
                                            continue;
                                        }
                                        if (string5.equals("Method")) {
                                            string4 = (String)objectInputStream.readObject();
                                            continue;
                                        }
                                        if (string5.equals("EventListener")) {
                                            objectName = (ObjectName)objectInputStream.readObject();
                                            continue;
                                        }
                                        if (!string5.equals("EventObject")) continue;
                                        eventObject = (EventObject)objectInputStream.readObject();
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: Cannot read " + string5));
                                        Debug.printException((Exception)classNotFoundException);
                                        bl5 = true;
                                        break;
                                    }
                                }
                                if (bl5) {
                                    this.httpReplyError(string2, "400 Bad Request");
                                    bl2 = true;
                                    break;
                                }
                                Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: Have to manage [" + string + "]"));
                                try {
                                    if (!string.equals("sendEvent")) break;
                                    this.handleEvent(eventObject, (ObjectName)n3, string4, objectName);
                                }
                                catch (Exception exception) {
                                    Debug.print((int)2, (Object)("comm.EvtRcvClientImpl::run: " + string));
                                    Debug.printException((Exception)exception);
                                    bl2 = true;
                                }
                                break;
                            }
                            default: {
                                Debug.print((int)2, (Object)"comm.EvtRcvClientImpl::run: Sending Bad Request error");
                                this.httpReplyError(string2, "400 Bad Request");
                                bl2 = true;
                            }
                            case 3: 
                        }
                        byArray = null;
                    }
                    this.running = false;
                }
                if (this.stopRequested) {
                    this.evtRcvSock.doUnbind();
                    continue;
                }
                this.evtRcvSock.doDisconnect();
            }
            catch (IOException iOException) {
                Debug.printException((Exception)iOException);
            }
        }
    }

    public void stopListening() {
        ThreadDeath threadDeath = null;
        this.stopRequested = true;
        if (this.running) {
            return;
        }
        try {
            this.interrupt();
            this.stop();
        }
        catch (ThreadDeath threadDeath2) {
            Debug.print((int)2, (Object)"ThreadDeath caught");
            threadDeath = threadDeath2;
        }
        try {
            this.evtRcvSock.doUnbind();
        }
        catch (Exception exception) {
            Debug.print((int)2, (Object)("Fails to unregister " + this.serviceName));
            Debug.printException((Exception)exception);
        }
        if (threadDeath != null) {
            throw threadDeath;
        }
    }

    private Object transferObject(Object object, ClassLoader classLoader) {
        Closeable closeable;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            closeable = new ObjectOutputStream(byteArrayOutputStream);
            closeable.writeObject(object);
            closeable.flush();
        }
        catch (Exception exception) {
            Debug.println((int)1, (Object)("EvtRcvClientImpl::EventDispatcher: Fails to serialize " + object));
            return object;
        }
        try {
            closeable = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader((InputStream)closeable, classLoader);
            return objectInputStreamWithLoader.readObject();
        }
        catch (Exception exception) {
            Debug.println((int)1, (Object)("EvtRcvClientImpl::EventDispatcher:Fails to deserialize " + object));
            return object;
        }
    }

    private EventObject translateEvent(EventObject eventObject, ClassLoader classLoader, ManagedObject managedObject) {
        Debug.print((int)2, (Object)"EvtRcvClientImpl$EventDispatcher::translateEvent: Start event translation.");
        Class[] classArray = new Class[2];
        ClassLoader classLoader2 = eventObject.getClass().getClassLoader();
        EventObject eventObject2 = null;
        if (classLoader != null && classLoader2 != null) {
            eventObject2 = (EventObject)this.transferObject(eventObject, classLoader);
            Debug.print((int)2, (Object)"EvtRcvClientImpl::translateEvent: transfer done.");
            try {
                classArray[1] = classLoader.loadClass("com.sun.jaw.reference.client.mo.ManagedObject");
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
                Debug.print((int)2, (Object)"EvtRcvClientImpl::translateEvent: Can not find ManagedObject");
                return null;
            }
        }
        eventObject2 = eventObject;
        try {
            classArray[1] = Class.forName("com.sun.jaw.reference.client.mo.ManagedObject");
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            Debug.print((int)2, (Object)"EvtRcvClientImpl::EventDispatcher: can not find ManagedObject");
            return null;
        }
        classArray[0] = eventObject2.getClass();
        Constructor constructor = null;
        try {
            constructor = classArray[0].getDeclaredConstructor(classArray);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            Debug.print((int)2, (Object)"EvtRcvClientImpl::EventDispatcher: Can not find constructor");
            return null;
        }
        Object[] objectArray = new Object[]{eventObject2, managedObject};
        try {
            return (EventObject)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            Debug.print((int)2, (Object)"EvtRcvClientImpl::EventDispatcher: Fails to create new event");
            return null;
        }
    }
}

