/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.rmi;

import com.sun.jaw.impl.adaptor.rmi.AdaptorServerRmi;
import com.sun.jaw.impl.adaptor.rmi.internal.EvtRcvClientImpl;
import com.sun.jaw.impl.mapper.DefaultMapper;
import com.sun.jaw.reference.client.adaptor.AdaptorMO;
import com.sun.jaw.reference.client.mo.ManagedObject;
import com.sun.jaw.reference.client.mo.internal.MOIf;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.InstanceAlreadyExistException;
import com.sun.jaw.reference.common.InstanceNotFoundException;
import com.sun.jaw.reference.common.InvalidPropertyValueException;
import com.sun.jaw.reference.common.LocalException;
import com.sun.jaw.reference.common.ModificationList;
import com.sun.jaw.reference.common.ObjectName;
import com.sun.jaw.reference.common.PropertyList;
import com.sun.jaw.reference.common.PropertyNotFoundException;
import com.sun.jaw.reference.mapper.MapperSrvIf;
import com.sun.jaw.reference.mapper.MappingException;
import com.sun.jaw.reference.query.QueryExp;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.rmi.ServerRuntimeException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;

public class AdaptorClient
implements AdaptorMO {
    protected transient Hashtable handles = new Hashtable();
    protected String serverHost = new String();
    protected int serverPort;
    protected String serverName = new String();
    protected transient AdaptorServerRmi factory;
    protected transient boolean isConnected = false;
    protected transient ClassLoader classLoader = null;
    protected transient MapperSrvIf mapper = null;
    protected transient EvtRcvClientImpl receiver;
    protected transient Hashtable listeners = new Hashtable();
    protected String eventReceiver = "eventReceiver";
    private static final String sccs_id = "@(#)AdaptorClient.java 3.7 03/10/99 SMI";

    public AdaptorClient() {
        this.mapper = new DefaultMapper();
    }

    public ObjectName addListener(ManagedObject managedObject, EventListener eventListener, String string) throws InstanceNotFoundException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        this.stopIfNotConnected();
        ObjectName objectName = managedObject.getObjectName();
        ManagedObject managedObject2 = (ManagedObject)this.handles.get(objectName.toString());
        if (managedObject2 == null) {
            Debug.print((int)2, (Object)"rmi.AdaptorClient.addListener: unknown MO");
            throw new InstanceNotFoundException(objectName.toString());
        }
        ObjectName objectName2 = null;
        try {
            objectName2 = this.factory.addListener(objectName, String.valueOf(string) + "Stub", this.eventReceiver);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        Hashtable<String, EventListener> hashtable = (Hashtable<String, EventListener>)this.listeners.get(objectName.toString());
        if (hashtable == null) {
            hashtable = new Hashtable<String, EventListener>();
            this.listeners.put(objectName.toString(), hashtable);
        }
        hashtable.put(objectName2.toString(), eventListener);
        return objectName2;
    }

    public void cb_connect(ManagedObject managedObject) {
        String string = managedObject.getObjectName().toString();
        MOIf mOIf = (MOIf)this.handles.get(string);
        if (mOIf != null) {
            throw new CommunicationException("C-bean already registered");
        }
        ((MOIf)managedObject).setAdaptorMO(this);
        this.handles.put(string, managedObject);
    }

    public void cb_disconnect(ManagedObject managedObject) {
        String string = managedObject.getObjectName().toString();
        this.removeAllListeners(managedObject);
        this.handles.remove(string);
        ((MOIf)managedObject).setAdaptorMO(null);
    }

    private Object cb_handleCreationNow(String string, ObjectName objectName, ModificationList modificationList, boolean bl, ObjectName objectName2) throws IllegalAccessException, ClassNotFoundException, InstanceAlreadyExistException, InstantiationException, LocalException, InvocationTargetException {
        if (string == null && objectName == null) {
            Debug.print((int)2, (Object)"comm.AdaptorClient::cb_handleCreationNow: Invalid parameters");
            throw new IllegalArgumentException("Adaptor client invalid parameters");
        }
        String string2 = string;
        if (string == null) {
            Debug.print((int)2, (Object)"iiop.AdaptorClient.cb_handleCreationNow: call mapper to get java class name");
            try {
                string2 = this.mapper.mbeanToUse(objectName);
            }
            catch (MappingException mappingException) {
                Debug.print((int)2, (Object)("iiop.AdaptorClient.cb_handleCreationNow: get exception " + mappingException.getMessage()));
                throw new ClassNotFoundException(mappingException.getMessage());
            }
        }
        ObjectName objectName3 = objectName;
        if (objectName == null) {
            Debug.print((int)2, (Object)"iiop.AdaptorClient:cb_handleCreationNow:: build default object name");
            objectName3 = new ObjectName(String.valueOf(this.getDomain()) + ":" + string2);
        }
        Debug.print((int)2, (Object)("rmi.AdaptorClient.cb_handleCreationNow for " + objectName3.toString()));
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        try {
            vector2 = objectName2 != null ? (!bl ? this.factory.newMO(string2, objectName3, modificationList, objectName2) : this.factory.newDBMO(string2, objectName3, modificationList, objectName2)) : (!bl ? this.factory.newMO(string2, objectName3, modificationList) : this.factory.newDBMO(string2, objectName3, modificationList));
            vector.addElement(vector2.firstElement());
            Debug.print((int)2, (Object)"rmi.AdaptorClient.cb_handleCreationNow : call translateObjects");
            vector3 = this.translateObjects(vector);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new InstantiationException(instanceNotFoundException.getMessage());
        }
        if (vector3.isEmpty()) {
            Debug.print((int)2, (Object)"rmi.AdaptorClient.cb_handleCreationNow :result is empty, return new Object()");
            return new Object();
        }
        Debug.print((int)2, (Object)("rmi.AdaptorClient.cb_handleCreationNow :return first element = " + vector3.firstElement().toString()));
        return vector3.firstElement();
    }

    public Object cb_newDBMO(String string, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstanceAlreadyExistException, InstantiationException, LocalException, InvocationTargetException {
        this.stopIfNotConnected();
        return this.cb_handleCreationNow(string, objectName, modificationList, true, null);
    }

    public Object cb_newDBMO(String string, ObjectName objectName, ModificationList modificationList, ObjectName objectName2) throws IllegalAccessException, ClassNotFoundException, InstanceAlreadyExistException, InstantiationException, LocalException, InvocationTargetException {
        this.stopIfNotConnected();
        return this.cb_handleCreationNow(string, objectName, modificationList, true, objectName2);
    }

    public Object cb_newMO(String string, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstanceAlreadyExistException, InstantiationException, LocalException, InvocationTargetException {
        this.stopIfNotConnected();
        return this.cb_handleCreationNow(string, objectName, modificationList, false, null);
    }

    public Object cb_newMO(String string, ObjectName objectName, ModificationList modificationList, ObjectName objectName2) throws IllegalAccessException, ClassNotFoundException, InstanceAlreadyExistException, InstantiationException, LocalException, InvocationTargetException {
        this.stopIfNotConnected();
        return this.cb_handleCreationNow(string, objectName, modificationList, false, objectName2);
    }

    public void connect(Object object, String string, int n, String string2) throws CommunicationException, SecurityException {
        AdaptorServerRmi adaptorServerRmi;
        if (this.isConnected) {
            throw new CommunicationException("Already connected to RMI management server at host " + this.serverHost + ", port " + this.serverPort + ", name " + this.serverName);
        }
        this.serverHost = string;
        this.serverPort = n;
        this.serverName = string2;
        try {
            Registry registry = LocateRegistry.getRegistry(string, n);
            adaptorServerRmi = (AdaptorServerRmi)registry.lookup(string2);
        }
        catch (Exception exception) {
            Debug.printException((Exception)exception);
            throw new CommunicationException("Can't contact RMI management server at host " + string + ", port " + n + " with name " + string2);
        }
        this.factory = adaptorServerRmi;
        if (this.receiver != null) {
            this.receiver.startListening();
        } else {
            try {
                this.receiver = new EvtRcvClientImpl(this, string, n);
            }
            catch (ServerRuntimeException serverRuntimeException) {
                AdaptorClient.handleServerRuntimeException(serverRuntimeException);
            }
            catch (RemoteException remoteException) {
                Debug.printException((Exception)remoteException);
                throw new CommunicationException(remoteException.getMessage());
            }
            this.eventReceiver = this.receiver.getServiceName();
        }
        this.isConnected = true;
    }

    public void deleteMO(ObjectName objectName) throws InstanceNotFoundException, InvocationTargetException {
        this.handles.remove(objectName.toString());
        this.stopIfNotConnected();
        try {
            this.factory.deleteMO(objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
    }

    public void disconnect() {
        if (this.receiver != null) {
            this.receiver.stopListening();
        }
        this.factory = null;
        Enumeration enumeration = this.handles.elements();
        while (enumeration.hasMoreElements()) {
            MOIf mOIf = (MOIf)enumeration.nextElement();
            mOIf.setAdaptorMO(null);
        }
        this.handles = new Hashtable();
        this.isConnected = false;
    }

    public String getAdaptorVersion() {
        return "JDMK/3.2";
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static String getClassVersion() {
        return sccs_id;
    }

    public String getDomain() throws CommunicationException {
        this.stopIfNotConnected();
        String string = null;
        try {
            string = this.factory.getDomain();
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        return string;
    }

    public Object getIndexedValue(ObjectName objectName, String string, int n) throws InstanceNotFoundException, PropertyNotFoundException, InvocationTargetException {
        this.stopIfNotConnected();
        Object object = new Object();
        try {
            object = this.factory.getIndexedValue(objectName, string, n);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        return object;
    }

    public MapperSrvIf getMapperSrv() {
        return this.mapper;
    }

    public Vector getObject(ObjectName objectName, QueryExp queryExp) throws LocalException, InstanceNotFoundException, InvocationTargetException {
        this.stopIfNotConnected();
        Vector vector = new Vector();
        try {
            vector = this.translateObjects(this.factory.getObject(objectName, queryExp));
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        return vector;
    }

    public ManagedObject getObjectFromCache(ObjectName objectName) {
        return (ManagedObject)this.handles.get(objectName.toString());
    }

    public Vector getOnlyNames(ObjectName objectName, QueryExp queryExp) throws InstanceNotFoundException {
        this.stopIfNotConnected();
        Vector vector = new Vector();
        try {
            vector = this.factory.getObject(objectName, queryExp);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        return vector;
    }

    public Object getValue(ObjectName objectName, String string) throws InstanceNotFoundException, PropertyNotFoundException, InvocationTargetException {
        this.stopIfNotConnected();
        Object object = new Object();
        try {
            object = this.factory.getValue(objectName, string);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        return object;
    }

    public PropertyList getValues(ObjectName objectName, Vector vector) throws InstanceNotFoundException {
        this.stopIfNotConnected();
        PropertyList propertyList = new PropertyList();
        try {
            propertyList = this.factory.getValues(objectName, vector);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        return propertyList;
    }

    public EventListener giveListener(ObjectName objectName, ObjectName objectName2) {
        Hashtable hashtable = (Hashtable)this.listeners.get(objectName.toString());
        if (hashtable == null) {
            return null;
        }
        return (EventListener)hashtable.get(objectName2.toString());
    }

    private void handleCreationNow(String string, ObjectName objectName, ModificationList modificationList, boolean bl, ObjectName objectName2) throws IllegalAccessException, ClassNotFoundException, InstanceAlreadyExistException, InstantiationException, InvocationTargetException {
        if (string == null && objectName == null) {
            Debug.print((int)2, (Object)"comm.AdaptorClient::cb_handleCreationNow: Invalid parameters");
            throw new IllegalArgumentException("Adaptor client invalid parameters");
        }
        String string2 = string;
        if (string == null) {
            Debug.print((int)2, (Object)"iiop.AdaptorClient.handleCreationNow: call mapper to get java class name");
            try {
                string2 = this.mapper.mbeanToUse(objectName);
            }
            catch (MappingException mappingException) {
                Debug.print((int)2, (Object)("iiop.AdaptorClient.handleCreationNow: get exception " + mappingException.getMessage()));
                throw new ClassNotFoundException(mappingException.getMessage());
            }
        }
        ObjectName objectName3 = objectName;
        if (objectName == null) {
            Debug.print((int)2, (Object)"iiop.AdaptorClient:cb_handleCreationNow:: build default object name");
            objectName3 = new ObjectName(String.valueOf(this.getDomain()) + ":" + string2);
        }
        Vector vector = new Vector();
        try {
            vector = objectName2 != null ? (!bl ? this.factory.newMO(string2, objectName3, modificationList, objectName2) : this.factory.newDBMO(string2, objectName3, modificationList, objectName2)) : (!bl ? this.factory.newMO(string2, objectName3, modificationList) : this.factory.newDBMO(string2, objectName3, modificationList));
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
    }

    private static void handleServerRuntimeException(ServerRuntimeException serverRuntimeException) throws CommunicationException {
        if (serverRuntimeException.detail instanceof RuntimeException) {
            throw (RuntimeException)serverRuntimeException.detail;
        }
        throw new CommunicationException(serverRuntimeException.getMessage());
    }

    public Object invokePerform(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (objectName == null || string == null) {
            Debug.print((int)2, (Object)"rmi.AdaptorClient.invokePerform: invalid parameters");
            throw new IllegalArgumentException("rmi.AdaptorClient.invokePerform: invalid parameters");
        }
        this.stopIfNotConnected();
        Object object = null;
        try {
            object = this.factory.invokePerform(objectName, string, objectArray, stringArray);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        return object;
    }

    public Boolean isConnected() {
        return new Boolean(this.isConnected);
    }

    public void newDBMO(String string, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstanceAlreadyExistException, InstantiationException, InvocationTargetException {
        this.stopIfNotConnected();
        this.handleCreationNow(string, objectName, modificationList, true, null);
    }

    public void newDBMO(String string, ObjectName objectName, ModificationList modificationList, ObjectName objectName2) throws IllegalAccessException, ClassNotFoundException, InstanceAlreadyExistException, InstantiationException, InvocationTargetException {
        this.stopIfNotConnected();
        this.handleCreationNow(string, objectName, modificationList, true, objectName2);
    }

    public void newMO(String string, ObjectName objectName, ModificationList modificationList) throws IllegalAccessException, ClassNotFoundException, InstanceAlreadyExistException, InstantiationException, InvocationTargetException {
        this.stopIfNotConnected();
        this.handleCreationNow(string, objectName, modificationList, false, null);
    }

    public void newMO(String string, ObjectName objectName, ModificationList modificationList, ObjectName objectName2) throws IllegalAccessException, ClassNotFoundException, InstanceAlreadyExistException, InstantiationException, InvocationTargetException {
        this.stopIfNotConnected();
        this.handleCreationNow(string, objectName, modificationList, false, objectName2);
    }

    public void newObj(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, InvocationTargetException {
        this.stopIfNotConnected();
        try {
            this.factory.newObj(string);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
    }

    public void newObj(String string, ObjectName objectName) throws IllegalAccessException, InstantiationException, ClassNotFoundException, InvocationTargetException {
        this.stopIfNotConnected();
        try {
            this.factory.newObj(string, objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
    }

    private void removeAllListeners(ManagedObject managedObject) {
        String string = managedObject.getObjectName().toString();
        Hashtable hashtable = (Hashtable)this.listeners.get(string);
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ObjectName objectName = new ObjectName((String)enumeration.nextElement());
            this.removeListener(managedObject, objectName);
        }
    }

    public void removeListener(ManagedObject managedObject, ObjectName objectName) {
        Debug.print((int)2, (Object)("rmi.AdaptorClient.removeListener: " + objectName.toString()));
        try {
            this.stopIfNotConnected();
        }
        catch (CommunicationException communicationException) {
            Debug.printException((Exception)((Object)communicationException));
            return;
        }
        ObjectName objectName2 = managedObject.getObjectName();
        ManagedObject managedObject2 = (ManagedObject)this.handles.get(objectName2.toString());
        if (managedObject2 == null) {
            return;
        }
        try {
            this.factory.removeListener(objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            Debug.printException((Exception)remoteException);
        }
        Hashtable hashtable = (Hashtable)this.listeners.get(objectName2.toString());
        if (hashtable == null) {
            return;
        }
        hashtable.remove(objectName.toString());
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object setIndexedValue(ObjectName objectName, String string, Object object, String string2, int n) throws InstanceNotFoundException, IllegalAccessException, PropertyNotFoundException, InvalidPropertyValueException, ClassNotFoundException, InstantiationException, InvocationTargetException {
        this.stopIfNotConnected();
        Object object2 = new Object();
        try {
            object2 = this.factory.SetIndexedValue(objectName, string, object, string2, n);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        return object2;
    }

    public void setMapperSrv(MapperSrvIf mapperSrvIf) {
        this.mapper = mapperSrvIf;
    }

    public Object setValue(ObjectName objectName, String string, Object object, String string2) throws InstanceNotFoundException, IllegalAccessException, PropertyNotFoundException, InvalidPropertyValueException, ClassNotFoundException, InstantiationException, InvocationTargetException {
        this.stopIfNotConnected();
        Object object2 = new Object();
        try {
            object2 = this.factory.SetValue(objectName, string, object, string2);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        return object2;
    }

    public PropertyList setValues(ObjectName objectName, ModificationList modificationList) throws InstanceNotFoundException, IllegalAccessException, InvocationTargetException {
        this.stopIfNotConnected();
        PropertyList propertyList = new PropertyList();
        try {
            propertyList = this.factory.setValues(objectName, modificationList);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
        return propertyList;
    }

    public int setup(Object object) {
        return 0;
    }

    private void stopIfNotConnected() throws CommunicationException {
        if (!this.isConnected) {
            throw new CommunicationException("Not connected to RMI management server at host " + this.serverHost + ", port " + this.serverPort + ", name " + this.serverName);
        }
    }

    public void transferObject(Object object, ObjectName objectName) throws InstanceAlreadyExistException {
        if (object == null || objectName == null) {
            Debug.print((int)2, (Object)"rmi.AdaptorClient.addObject: invalid parameters");
            throw new IllegalArgumentException("rmi.AdaptorClient.addObject: invalid parameters");
        }
        this.stopIfNotConnected();
        try {
            this.factory.addObject(object, objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            AdaptorClient.handleServerRuntimeException(serverRuntimeException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.getMessage());
        }
    }

    private Vector translateObjects(Vector vector) throws LocalException, InstanceNotFoundException {
        Vector<Object> vector2 = new Vector<Object>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            ObjectName objectName = (ObjectName)enumeration.nextElement();
            Debug.print((int)2, (Object)("rmi.AdaptorClient: Got object= " + objectName.toString()));
            Object object = this.handles.get(objectName.toString());
            if (object != null) {
                Debug.print((int)2, (Object)"rmi.AdaptorClient: Object already in cache");
                vector2.addElement(object);
                continue;
            }
            try {
                string = this.mapper.cbeanToUse(objectName);
            }
            catch (MappingException mappingException) {
                throw new LocalException((Throwable)mappingException);
            }
            Debug.print((int)2, (Object)("rmi.AdaptorClient: has to create object with class " + string));
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.classLoader == null) {
                    throw new LocalException((Throwable)classNotFoundException);
                }
                try {
                    clazz = this.classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw new LocalException((Throwable)classNotFoundException2);
                }
            }
            Debug.print((int)2, (Object)("rmi.AdaptorClient: translateObjects : " + clazz.toString() + " loaded"));
            try {
                object = clazz.newInstance();
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
                throw new LocalException((Throwable)exception);
            }
            this.handles.put(objectName.toString(), object);
            ((MOIf)object).setAdaptorMO(this);
            ((MOIf)object).setObjectName(objectName);
            vector2.addElement(object);
            Debug.print((int)2, (Object)("rmi.AdaptorClient: translateObjects " + object.toString() + " added to result"));
        }
        return vector2;
    }
}

