/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaw.impl.adaptor.rmi.internal;

import com.sun.jaw.impl.adaptor.rmi.AdaptorClient;
import com.sun.jaw.impl.adaptor.rmi.internal.EvtRcvClient;
import com.sun.jaw.reference.client.mo.ManagedObject;
import com.sun.jaw.reference.common.CommunicationException;
import com.sun.jaw.reference.common.Debug;
import com.sun.jaw.reference.common.ObjectInputStreamWithLoader;
import com.sun.jaw.reference.common.ObjectName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;

public class EvtRcvClientImpl
extends UnicastRemoteObject
implements EvtRcvClient {
    private static final String sccs_id = "@(#)EvtRcvClientImpl.java 3.2 03/10/99 SMI";
    private transient AdaptorClient myClient = null;
    private String serviceName;
    private String localHost = "localhost";
    private String host;
    private int port;
    private ThreadGroup group;
    private boolean offline = false;

    public EvtRcvClientImpl(AdaptorClient adaptorClient, String string, int n) throws RemoteException, CommunicationException {
        this.myClient = adaptorClient;
        this.host = string;
        this.port = n;
        this.offline = false;
        this.group = new ThreadGroup("rmi dispatcher");
        Registry registry = null;
        try {
            this.localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {}
        try {
            String string2 = new Long(new Date().getTime()).toString();
            String string3 = new String("EvtRcvClient." + string2);
            this.serviceName = new String("rmi://" + this.localHost + ":" + n + "/" + string3);
            Debug.print((int)2, (Object)("EvtRcvClientImpl::new: register " + this.serviceName));
            Naming.bind(this.serviceName, this);
        }
        catch (AlreadyBoundException alreadyBoundException) {
            Debug.print((int)2, (Object)"EvtRcvClientImpl::new: Attempt was made to bind an object in the registry to a name that already had an associated binding.");
            throw new CommunicationException("Fails to register " + this.serviceName);
        }
        catch (MalformedURLException malformedURLException) {
            Debug.print((int)2, (Object)("EvtRcvClientImpl::new: " + this.serviceName + " is not an appropriately formatted URL."));
            throw new CommunicationException("Fails to register " + this.serviceName);
        }
        catch (AccessException accessException) {
            Debug.print((int)2, (Object)"EvtRcvClientImpl::new: Permission to perform a binding in the registry has been denied.");
            throw new CommunicationException("Fails to register " + this.serviceName);
        }
        catch (RemoteException remoteException) {
            Debug.print((int)2, (Object)("EvtRcvClientImpl::new: Try to start a local registry on port " + n));
            registry = LocateRegistry.createRegistry(n);
            try {
                Naming.bind(this.serviceName, this);
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
                throw new CommunicationException("Fails to register " + this.serviceName);
            }
        }
    }

    public String getClassVersion() {
        return sccs_id;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void handleEvent(EventObject eventObject, ObjectName objectName, String string, ObjectName objectName2) {
        if (this.offline) {
            return;
        }
        Debug.print((int)2, (Object)"EvtRcvClientImpl::handleEvent: Start event dispatching");
        if (eventObject == null) {
            return;
        }
        ManagedObject managedObject = this.myClient.getObjectFromCache(objectName);
        EventListener eventListener = this.myClient.giveListener(objectName, objectName2);
        if (eventListener == null) {
            Debug.print((int)2, (Object)("EvtRcvClientImpl::receiveEvent: No listener on " + objectName.toString()));
            return;
        }
        EventDispatcher eventDispatcher = new EventDispatcher(eventListener, managedObject, eventObject, string);
        Thread thread = new Thread(this.group, eventDispatcher);
        thread.start();
    }

    public void startListening() {
        try {
            Naming.bind(this.serviceName, this);
        }
        catch (Exception exception) {
            Debug.print((int)2, (Object)("EvtRcvClientImpl::startListening: Fails to register " + this.serviceName));
            Debug.printException((Exception)exception);
            throw new CommunicationException("Fails to register " + this.serviceName);
        }
        this.offline = false;
    }

    public void stopListening() {
        this.offline = true;
        try {
            Naming.unbind(this.serviceName);
        }
        catch (Exception exception) {
            Debug.print((int)2, (Object)("EvtRcvClientImpl::stopListening: Fails to unregister " + this.serviceName));
            Debug.printException((Exception)exception);
        }
    }

    class EventDispatcher
    implements Runnable {
        private EventListener listener;
        private EventObject evt;
        private ManagedObject mo;
        private String methName;

        EventDispatcher(EventListener eventListener, ManagedObject managedObject, EventObject eventObject, String string) {
            this.listener = eventListener;
            this.mo = managedObject;
            this.methName = string;
            this.evt = eventObject;
        }

        public void run() {
            Object object;
            Debug.print((int)2, (Object)("rmi.EvtRcvClientImpl::EventDispatcher: STARTED in " + Thread.currentThread()));
            ClassLoader classLoader = this.listener.getClass().getClassLoader();
            EventObject eventObject = this.translateEvent(this.evt, classLoader, this.mo);
            if (eventObject == null) {
                Debug.print((int)2, (Object)("rmi.EvtRcvClientImpl::EventDispatcher: Fails to translate  " + this.evt));
                return;
            }
            Class<?> clazz = this.listener.getClass();
            Class[] classArray = new Class[]{eventObject.getClass()};
            if (classLoader != null) {
                object = eventObject.getClass().getName();
                try {
                    classArray[0] = classLoader.loadClass((String)object);
                }
                catch (Exception exception) {
                    Debug.printException((Exception)exception);
                    Debug.print((int)2, (Object)("rmi.EvtRcvClientImpl::EventDispatcher: Can not find event class " + (String)object));
                    Debug.print((int)2, (Object)("\tThe loader is: " + classLoader));
                    return;
                }
            }
            try {
                object = clazz.getDeclaredMethod(this.methName, classArray);
            }
            catch (Exception exception) {
                Debug.print((int)2, (Object)("rmi.EvtRcvClientImpl::EventDispatcher: Can not find  " + this.methName + " in class " + clazz));
                return;
            }
            Debug.print((int)2, (Object)"rmi.EvtRcvClientImpl::EventDispatcher: About to invoke listener");
            Object[] objectArray = new Object[]{eventObject};
            try {
                ((Method)object).invoke((Object)this.listener, objectArray);
            }
            catch (Exception exception) {
                Debug.print((int)2, (Object)("rmi.EvtRcvClientImpl::EventDispatcher: Fails when invoking  " + this.methName));
                Debug.printException((Exception)exception);
                return;
            }
        }

        private Object transferObject(Object object, ClassLoader classLoader) {
            Closeable closeable;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                closeable = new ObjectOutputStream(byteArrayOutputStream);
                closeable.writeObject(object);
                closeable.flush();
            }
            catch (Exception exception) {
                Debug.println((int)1, (Object)("rmi.EvtRcvClientImpl::EventDispatcher: Fails to serialize " + object));
                return object;
            }
            try {
                closeable = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader((InputStream)closeable, classLoader);
                return objectInputStreamWithLoader.readObject();
            }
            catch (Exception exception) {
                Debug.println((int)1, (Object)("rmi.EvtRcvClientImpl::EventDispatcher:Fails to deserialize " + object));
                return object;
            }
        }

        private EventObject translateEvent(EventObject eventObject, ClassLoader classLoader, ManagedObject managedObject) {
            Debug.print((int)2, (Object)"rmi.EvtRcvClientImpl$EventDispatcher::translateEvent: Start event translation.");
            Class[] classArray = new Class[2];
            ClassLoader classLoader2 = eventObject.getClass().getClassLoader();
            EventObject eventObject2 = null;
            if (classLoader != null && classLoader2 != null) {
                eventObject2 = (EventObject)this.transferObject(eventObject, classLoader);
                Debug.print((int)2, (Object)"EvtRcvClientImpl::translateEvent: transfer done.");
                try {
                    classArray[1] = classLoader.loadClass("com.sun.jaw.reference.client.mo.ManagedObject");
                }
                catch (Exception exception) {
                    Debug.printException((Exception)exception);
                    Debug.print((int)2, (Object)"EvtRcvClientImpl::translateEvent: Can not find ManagedObject");
                    return null;
                }
            }
            eventObject2 = eventObject;
            try {
                classArray[1] = Class.forName("com.sun.jaw.reference.client.mo.ManagedObject");
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
                Debug.print((int)2, (Object)"rmi.EvtRcvClientImpl::EventDispatcher: can not find ManagedObject");
                return null;
            }
            classArray[0] = eventObject2.getClass();
            Constructor constructor = null;
            try {
                constructor = classArray[0].getDeclaredConstructor(classArray);
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
                Debug.print((int)2, (Object)"rmi.EvtRcvClientImpl::EventDispatcher: Can not find constructor");
                return null;
            }
            Object[] objectArray = new Object[]{eventObject2, managedObject};
            try {
                return (EventObject)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                Debug.printException((Exception)exception);
                Debug.print((int)2, (Object)"rmi.EvtRcvClientImpl::EventDispatcher: Fails to create new event");
                return null;
            }
        }
    }
}

